/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.query;

import ca.infodata.CacheService;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.query.IBaseXQuery;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.util.JoinList;
import ca.infodata.syra.util.ValidRamq;
import ca.infodata.syra.xsd.valid.InfoEtab;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.basex.core.Context;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;

public class InfoEtablissement
extends IBaseXQuery {
    protected static final Logger logger = Logger.getLogger(InfoEtablissement.class.getName());

    @Override
    public String getDescription(QueryCriteria criteria) {
        String description = "";
        try {
            String forHash = String.valueOf(criteria.getStringForHashcode()) + "DT" + IBaseXQuery.DataType.DESCRIPTION.ordinal();
            Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ETABLISSEMENT, (Object)forHash, true);
            if (fromCache != null) {
                try {
                    return (String)fromCache;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Context contexte = ValidRamq.getInstance().getContext();
            String code = new XQuery(String.valueOf(criteria.node) + "/id_lieu_phys/text()").execute(contexte).toString();
            String desc = new XQuery(String.valueOf(criteria.node) + "/../../nom_etab/text()").execute(contexte).toString();
            description = String.valueOf(code) + ":" + desc;
            CacheService.getServiceInstance().put(CacheService.ETABLISSEMENT, (Object)forHash, (Object)description);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "getDescription " + criteria, e);
        }
        return description;
    }

    @Override
    public String getDescriptionLong(QueryCriteria criteria) {
        return this.getDescription(criteria);
    }

    @Override
    public List<String> getDataByCriteria(QueryCriteria criteria, IBaseXQuery.DataType dataType) throws QueryException, IOException {
        ArrayList<String> lstNode = new ArrayList<String>();
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "DBCDT" + dataType.ordinal();
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ETABLISSEMENT, (Object)forHash, true);
        if (fromCache != null) {
            try {
                return (List)fromCache;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String query = this.getQueryString(criteria, dataType);
        Context contexte = ValidRamq.getInstance().getContext();
        Throwable throwable = null;
        Object var9_11 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte).toString();
                lstNode.add(node);
            }
            CacheService.getServiceInstance().put(CacheService.ETABLISSEMENT, (Object)forHash, lstNode);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lstNode;
    }

    @Override
    public List<String[]> getCodeDescription(QueryCriteria criteria) throws QueryException, IOException {
        ArrayList<String[]> lstNode = new ArrayList<String[]>();
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "DTA" + IBaseXQuery.DataType.CODE_DESCR.ordinal();
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ETABLISSEMENT, (Object)forHash, true);
        if (fromCache != null) {
            try {
                return (List)fromCache;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String query = this.getQueryString(criteria, IBaseXQuery.DataType.CODE_DESCR);
        Context contexte = ValidRamq.getInstance().getContext();
        Throwable throwable = null;
        Object var8_10 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte).toString();
                String[] data = node.split(":");
                String code = data[0];
                String nom = data[1];
                String typ = data[2];
                String catg = data[3];
                String adrCity = "";
                if (data.length > 4) {
                    adrCity = ", " + data[4];
                    if (data.length > 5) {
                        adrCity = String.valueOf(adrCity) + ", " + data[5];
                    }
                }
                lstNode.add(new String[]{code, String.valueOf(nom) + " (" + typ + "-" + catg + ") " + adrCity});
            }
            CacheService.getServiceInstance().put(CacheService.ETABLISSEMENT, (Object)forHash, lstNode);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lstNode;
    }

    public List<String[]> getCodesDescription(QueryCriteria criteria) throws QueryException, IOException {
        ArrayList<String[]> lstNode = new ArrayList<String[]>();
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "DTAS" + IBaseXQuery.DataType.CODE_DESCR.ordinal();
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ETABLISSEMENT, (Object)forHash, true);
        if (fromCache != null) {
            try {
                return (List)fromCache;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String query = this.getQueryString(criteria, IBaseXQuery.DataType.NODE);
        Context contexte = ValidRamq.getInstance().getContext();
        Throwable throwable = null;
        Object var8_10 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte).toString();
                String code = new XQuery(String.valueOf(node) + "/liste_no_etab/no_etab/id_lieu_phys/text()").execute(contexte).toString();
                String nom = new XQuery(String.valueOf(node) + "/nom_etab/text()").execute(contexte).toString();
                String typ = new XQuery(String.valueOf(node) + "/typ_etab/text()").execute(contexte).toString();
                String catg = new XQuery(String.valueOf(node) + "/catg_etab/text()").execute(contexte).toString();
                String adrs = new XQuery(String.valueOf(node) + "/adresse/text()").execute(contexte).toString();
                String city = new XQuery(String.valueOf(node) + "/municipalite/text()").execute(contexte).toString();
                String desc = new JoinList(", ", nom, adrs, city).toString();
                lstNode.add(new String[]{code, "[" + typ + "-" + catg + "] " + desc});
            }
            CacheService.getServiceInstance().put(CacheService.ETABLISSEMENT, (Object)forHash, lstNode);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lstNode;
    }

    public String getJourFerie(Integer entente, String node, String date) throws QueryException, IOException {
        String description = "";
        try {
            Context contexte = ValidRamq.getInstance().getContext();
            String string = new XQuery(String.valueOf(node) + "/../../calen_jour_ferie/liste_jour_ferie/jr_ferie[dt_jr_ferie='" + date + "']").execute(contexte);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "getJourFerie " + entente + ", " + node + ", " + date, e);
        }
        return description;
    }

    @Override
    protected String getQueryString(QueryCriteria criteria, IBaseXQuery.DataType dataType) {
        String nn = "";
        String type = "";
        if (IBaseXQuery.DataType.CODE.equals((Object)dataType)) {
            type = "/id_lieu_phys/text()";
        } else if (IBaseXQuery.DataType.DESCRIPTION.equals((Object)dataType)) {
            type = "/nom_etab/text()";
        } else if (IBaseXQuery.DataType.CODE_DESCR.equals((Object)dataType)) {
            type = "/fn:string-join((id_lieu_phys/text(),../../nom_etab/text(),../../typ_etab/text(),../../catg_etab/text(),../../adresse/text(),../../municipalite/text()), ':')";
        } else if (IBaseXQuery.DataType.NODE.equals((Object)dataType)) {
            type = "/../..";
        }
        if (criteria.names != null) {
            nn = this.getNamesWithWildcards(criteria.names);
            String q = "/info_etab/val_etab[nom_etab contains text {" + nn + "} all using wildcards]";
            if (type.length() == 0) {
                return q;
            }
            return String.valueOf(q) + "/liste_no_etab/no_etab" + type;
        }
        if (criteria.codes.size() > 0) {
            String names = "'" + new JoinList("','", criteria.codes).toString() + "'";
            return "/info_etab/val_etab/liste_no_etab/no_etab[id_lieu_phys contains text {" + names + "} any using wildcards]" + type;
        }
        if (type.length() == 0) {
            return "/info_etab/val_etab";
        }
        return "/info_etab/val_etab/liste_no_etab/no_etab" + type;
    }

    public InfoEtab.ValEtab[] getJavaObjects(QueryCriteria criteria) {
        InfoEtab.ValEtab[] jos = new InfoEtab.ValEtab[]{};
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "JO";
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ETABLISSEMENT, (Object)forHash, false);
        if (fromCache != null) {
            try {
                return (InfoEtab.ValEtab[])InfoEtablissement.deserialize((byte[])fromCache, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            List<String> dataByCriteria = this.getDataByCriteria(criteria, IBaseXQuery.DataType.NODE);
            XStream xs = this.getXstream();
            jos = new InfoEtab.ValEtab[dataByCriteria.size()];
            int i = 0;
            for (String node : dataByCriteria) {
                InfoEtab.ValEtab act = this.getJavaObjectFromNode(null, node, xs);
                jos[i++] = act;
            }
            CacheService.getServiceInstance().put(CacheService.ETABLISSEMENT, (Object)forHash, (Object)jos);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getJavaObjects " + criteria, e);
        }
        return jos;
    }

    @Override
    public InfoEtab.ValEtab getJavaObjectFromNode(CProfessionnal.Entente entente, String node, XStream xs) {
        InfoEtab.ValEtab valEtab = null;
        String forHash = node;
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ETABLISSEMENT, (Object)forHash, false);
        if (fromCache != null) {
            try {
                return (InfoEtab.ValEtab)InfoEtablissement.deserialize((byte[])fromCache, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (xs == null) {
                xs = this.getXstream();
            }
            xs.alias("val_etab", InfoEtab.ValEtab.class);
            xs.alias("liste_no_etab", InfoEtab.ValEtab.ListeNoEtab.class);
            xs.aliasField("liste_no_etab", InfoEtab.ValEtab.class, "listeNoEtab");
            xs.addImplicitCollection(InfoEtab.ValEtab.ListeNoEtab.class, "content", "no_etab", InfoEtab.ValEtab.ListeNoEtab.NoEtab.class);
            xs.alias("calen_jour_ferie", InfoEtab.ValEtab.CalenJourFerie.class);
            xs.aliasField("calen_jour_ferie", InfoEtab.ValEtab.class, "calenJourFerie");
            xs.aliasField("liste_jour_ferie", InfoEtab.ValEtab.CalenJourFerie.class, "listeJourFerie");
            xs.addImplicitCollection(InfoEtab.ValEtab.CalenJourFerie.ListeJourFerie.class, "content", "jr_ferie", InfoEtab.ValEtab.CalenJourFerie.ListeJourFerie.JrFerie.class);
            xs.alias("nom_etab", String.class);
            xs.aliasField("nom_etab", InfoEtab.ValEtab.class, "nomEtab");
            xs.alias("catg_etab", String.class);
            xs.aliasField("catg_etab", InfoEtab.ValEtab.class, "catgEtab");
            xs.alias("typ_etab", String.class);
            xs.aliasField("typ_etab", InfoEtab.ValEtab.class, "typEtab");
            xs.alias("cod_rss", String.class);
            xs.aliasField("cod_rss", InfoEtab.ValEtab.class, "codRss");
            xs.alias("nom_rss", String.class);
            xs.aliasField("nom_rss", InfoEtab.ValEtab.class, "nomRss");
            xs.alias("adresse", String.class);
            xs.aliasField("adresse", InfoEtab.ValEtab.class, "adresse");
            xs.alias("municipalite", String.class);
            xs.aliasField("municipalite", InfoEtab.ValEtab.class, "municipalite");
            xs.alias("cod_pos", String.class);
            xs.aliasField("cod_pos", InfoEtab.ValEtab.class, "codPos");
            xs.alias("dt_jr_ferie", Date.class);
            xs.aliasField("dt_jr_ferie", InfoEtab.ValEtab.CalenJourFerie.ListeJourFerie.JrFerie.class, "dtJrFerie");
            xs.alias("typ_jr_ferie", BigInteger.class);
            xs.aliasField("typ_jr_ferie", InfoEtab.ValEtab.CalenJourFerie.ListeJourFerie.JrFerie.class, "typJrFerie");
            xs.alias("dat_creat_calen", XMLGregorianCalendar.class);
            xs.aliasField("dat_creat_calen", InfoEtab.ValEtab.CalenJourFerie.class, "datCreatCalen");
            xs.alias("id_lieu_phys", String.class);
            xs.aliasField("id_lieu_phys", InfoEtab.ValEtab.ListeNoEtab.NoEtab.class, "idLieuPhys");
            valEtab = (InfoEtab.ValEtab)xs.fromXML(node);
            CacheService.getServiceInstance().put(CacheService.ETABLISSEMENT, (Object)forHash, (Object)valEtab);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getJavaObjectFromNode " + node, e);
        }
        return valEtab;
    }
}

