/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.query;

import ca.infodata.CacheService;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.query.IBaseXQuery;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.util.JoinList;
import ca.infodata.syra.util.ValidRamq;
import ca.infodata.syra.xsd.valid.omni.ElmContx;
import ca.infodata.syra.xsd.valid.spec.ElmContx;
import ca.infodata.util1.StringUtils;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.basex.core.Context;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;

public class ElementContext
extends IBaseXQuery {
    static String queryListElementContextNoDate = "/liste_util_elm_contx/util_elm_contx";
    static String queryListElementContextDate = "/liste_util_elm_contx/util_elm_contx[dd_util_elm_contx<='_DATE_' and (not(df_util_elm_contx) or df_util_elm_contx>'_DATE_')]";
    static String queryContextNoDateEffect = "";
    static String queryContextDateEffect = "dd_effec_elm_contx<='_DATE_' and (not(df_effec_elm_contx) or df_effec_elm_contx>'_DATE_')";
    static String queryListElementContextCodeFact = "/liste_util_elm_contx/util_elm_contx[dd_util_elm_contx<='_DATE_' and (not(df_util_elm_contx) or df_util_elm_contx>'_DATE_')]";

    @Override
    public String getDescription(QueryCriteria criteria) {
        String desc = "";
        try {
            String forHash = String.valueOf(criteria.getStringForHashcode()) + "DT" + IBaseXQuery.DataType.DESCRIPTION.ordinal();
            Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ELEMENT_CONTEXT, (Object)forHash, true);
            if (fromCache != null) {
                try {
                    return (String)fromCache;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (criteria.node == null) {
                Context contexte = ValidRamq.getInstance().getContext();
                String query = this.getQueryString(criteria, IBaseXQuery.DataType.DESCRIPTION);
                try {
                    Throwable throwable = null;
                    Object var8_12 = null;
                    try (QueryProcessor proc = new QueryProcessor(query, contexte);){
                        Iter iter = proc.iter();
                        Item item = iter.next();
                        if (item != null) {
                            desc = new XQuery(item.toString()).execute(contexte).toString();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (QueryException e) {
                    logger.log(Level.SEVERE, "getDescription - Query=" + query + "\n + criteria=" + criteria, e);
                }
            } else {
                desc = new XQuery(String.valueOf(criteria.node) + "/txt_elm_contx/text()").execute(ValidRamq.getInstance().getContext()).toString();
            }
            CacheService.getServiceInstance().put(CacheService.ELEMENT_CONTEXT, (Object)forHash, (Object)desc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return desc;
    }

    @Override
    public String getDescriptionLong(QueryCriteria criteria) {
        return this.getDescription(criteria);
    }

    @Override
    public List<String> getDataByCriteria(QueryCriteria criteria, IBaseXQuery.DataType dataType) throws QueryException, IOException {
        ArrayList<String> lstNode = new ArrayList<String>();
        if (criteria == null) {
            throw new NullPointerException("entente");
        }
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "DBCDT" + dataType.ordinal();
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ELEMENT_CONTEXT, (Object)forHash, true);
        if (fromCache != null) {
            try {
                return (List)fromCache;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (criteria.names == null && criteria.codes.size() == 0 && criteria.getCodeFact() == null && criteria.getCodNiv() != null) {
            QueryCriteria.CodNiveau.NONE.equals((Object)criteria.getCodNiv());
        }
        String query = this.getQueryString(criteria, dataType);
        Context contexte = ValidRamq.getInstance().getContext();
        Throwable throwable = null;
        Object var9_11 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte);
                if (IBaseXQuery.DataType.NODE.equals((Object)dataType)) {
                    lstNode.add(node);
                    continue;
                }
                String code = new XQuery(String.valueOf(node) + "/cod_elm_contx/text()").execute(contexte);
                String desc = new XQuery(String.valueOf(node) + "/txt_elm_contx/text()").execute(contexte);
                lstNode.add(String.valueOf(code) + ":" + desc);
            }
            CacheService.getServiceInstance().put(CacheService.ELEMENT_CONTEXT, (Object)forHash, lstNode);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lstNode;
    }

    @Override
    public List<String[]> getCodeDescription(QueryCriteria criteria) throws QueryException, IOException {
        ArrayList<String[]> lstNode = new ArrayList<String[]>();
        if (criteria.getEntente() == null) {
            throw new NullPointerException("entente");
        }
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "DT" + IBaseXQuery.DataType.CODE_DESCR.ordinal();
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ELEMENT_CONTEXT, (Object)forHash, true);
        if (fromCache != null) {
            try {
                return (List)fromCache;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String query = this.getQueryString(criteria, IBaseXQuery.DataType.CODE_DESCR);
        Context contexte = ValidRamq.getInstance().getContext();
        Throwable throwable = null;
        Object var8_10 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte).toString();
                int i = node.indexOf(58);
                String code = node.substring(0, i);
                String desc = node.substring(i + 1, node.length());
                lstNode.add(new String[]{code, desc});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Collections.sort(lstNode, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                Integer i1 = Integer.valueOf(o1[0]);
                Integer i2 = Integer.valueOf(o2[0]);
                return i1.compareTo(i2);
            }
        });
        CacheService.getServiceInstance().put(CacheService.ELEMENT_CONTEXT, (Object)forHash, lstNode);
        return lstNode;
    }

    @Override
    protected String getQueryString(QueryCriteria criteria, IBaseXQuery.DataType dataType) {
        String elm_list_context;
        String elm_context;
        String nn = "";
        String query = "";
        String codNiv = "";
        String date = criteria.getDate();
        if (criteria.getCodNiv() != null && !QueryCriteria.CodNiveau.NONE.equals((Object)criteria.getCodNiv())) {
            codNiv = "cod_niv='" + criteria.getCodNiv().getCode() + "'";
        }
        boolean hasCodeNiv = codNiv.length() > 0;
        String postCodNivAnd = "";
        if (hasCodeNiv) {
            postCodNivAnd = " and ";
        }
        String type = "";
        if (IBaseXQuery.DataType.CODE.equals((Object)dataType)) {
            type = "/cod_elm_contx/text()";
        } else if (IBaseXQuery.DataType.DESCRIPTION.equals((Object)dataType)) {
            type = "/txt_elm_contx/text()";
        } else if (IBaseXQuery.DataType.CODE_DESCR.equals((Object)dataType)) {
            type = "/fn:string-join((cod_elm_contx/text(),txt_elm_contx/text()),':')";
        } else if (IBaseXQuery.DataType.NODE.equals((Object)dataType)) {
            type = "";
        }
        if (date != null) {
            elm_context = StringUtils.replace((String)queryContextDateEffect, (String)"_DATE_", (String)date);
            elm_list_context = StringUtils.replace((String)queryListElementContextDate, (String)"_DATE_", (String)date);
        } else {
            elm_context = queryContextNoDateEffect;
            elm_list_context = queryListElementContextNoDate;
        }
        boolean hasElmContx = elm_context.length() > 0;
        String codNiv_contx_and = "";
        if (hasCodeNiv && hasElmContx) {
            codNiv_contx_and = " and ";
        }
        String elm_contx_and = "";
        if (hasElmContx) {
            elm_contx_and = " and ";
        }
        String sCodFact = "";
        if (criteria.codeFact != null) {
            sCodFact = " and (not(liste_cod_fact) or (./liste_cod_fact/val_cod_fact[cod_fact=" + criteria.getCodeFact() + " and " + "dd_effec_cod_fact<='" + criteria.date + "' and " + "(not(df_effec_cod_fact) or df_effec_cod_fact > '" + criteria.date + "')]))";
        }
        if (criteria.names != null) {
            nn = this.getNamesWithWildcards(criteria.names);
            query = "/elm_contx[no_enten=" + criteria.getEntente() + "]/" + "val_elm_contx[" + codNiv + postCodNivAnd + "txt_elm_contx contains text {" + nn + "} all using wildcards " + elm_contx_and + elm_context + sCodFact + "]" + type;
        } else if (criteria.codes.size() > 0) {
            String names = "'" + new JoinList("','", criteria.codes).toString() + "'";
            query = "/elm_contx[no_enten=" + criteria.getEntente() + "]/" + "val_elm_contx[" + codNiv + postCodNivAnd + "cod_elm_contx contains text {" + names + "} any " + elm_contx_and + elm_context + sCodFact + "]" + elm_list_context + "/../.." + type;
        } else {
            query = hasCodeNiv || hasElmContx ? "/elm_contx[no_enten=" + criteria.getEntente() + "]/val_elm_contx[" + codNiv + codNiv_contx_and + elm_context + sCodFact + "]" + elm_list_context + "/../.." + type : "/elm_contx[no_enten=" + criteria.getEntente() + "]/val_elm_contx" + elm_list_context + "/../.." + type;
        }
        return query;
    }

    @Override
    public Object[] getJavaObjects(QueryCriteria criteria) {
        Object[] jos = new Object[]{};
        if (criteria == null || criteria.getEntente() == null) {
            return jos;
        }
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "JO";
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ELEMENT_CONTEXT, (Object)forHash, false);
        if (fromCache != null) {
            try {
                return (Object[])ElementContext.deserialize((byte[])fromCache, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CProfessionnal.Entente entente = CProfessionnal.Entente.valueOf(criteria.entente);
        try {
            List<String> dataByCriteria = this.getDataByCriteria(criteria, IBaseXQuery.DataType.DESCRIPTION);
            XStream xs = this.getXstream();
            jos = new Object[dataByCriteria.size()];
            int i = 0;
            for (String node : dataByCriteria) {
                Object act = this.getJavaObjectFromNode(entente, node, xs);
                jos[i++] = act;
            }
            CacheService.getServiceInstance().put(CacheService.ELEMENT_CONTEXT, (Object)forHash, (Object)jos);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getJavaObjects " + criteria, e);
        }
        return jos;
    }

    @Override
    public Object getJavaObjectFromNode(CProfessionnal.Entente entente, String node, XStream xs) {
        Object jo = null;
        String forHash = node;
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.ELEMENT_CONTEXT, (Object)forHash, false);
        if (fromCache != null) {
            try {
                return ElementContext.deserialize((byte[])fromCache, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (xs == null) {
                xs = this.getXstream();
            }
            Class clazzValElm = null;
            Class clazzListeUtil = null;
            Class clazzUtilElm = null;
            Class clazzListeCode = null;
            Class clazzValCod = null;
            if (CProfessionnal.Entente.OMNI.equals((Object)entente)) {
                clazzValElm = ElmContx.ValElmContx.class;
                clazzListeUtil = ElmContx.ValElmContx.ListeUtilElmContx.class;
                clazzUtilElm = ElmContx.ValElmContx.ListeUtilElmContx.UtilElmContx.class;
                clazzListeCode = ElmContx.ValElmContx.ListeUtilElmContx.UtilElmContx.ListeCodFact.class;
                clazzValCod = ElmContx.ValElmContx.ListeUtilElmContx.UtilElmContx.ListeCodFact.ValCodFact.class;
            } else if (CProfessionnal.Entente.SPEC.equals((Object)entente)) {
                clazzValElm = ElmContx.ValElmContx.class;
                clazzListeUtil = ElmContx.ValElmContx.ListeUtilElmContx.class;
                clazzUtilElm = ElmContx.ValElmContx.ListeUtilElmContx.UtilElmContx.class;
                clazzListeCode = ElmContx.ValElmContx.ListeUtilElmContx.UtilElmContx.ListeCodFact.class;
                clazzValCod = ElmContx.ValElmContx.ListeUtilElmContx.UtilElmContx.ListeCodFact.ValCodFact.class;
            }
            xs.alias("val_elm_contx", clazzValElm);
            xs.alias("cod_elm_contx", String.class);
            xs.aliasField("cod_elm_contx", clazzValElm, "codElmContx");
            xs.alias("txt_elm_contx", String.class);
            xs.aliasField("txt_elm_contx", clazzValElm, "txtElmContx");
            xs.alias("cod_niv", String.class);
            xs.aliasField("cod_niv", clazzValElm, "codNiv");
            xs.alias("dd_effec_elm_contx", Date.class);
            xs.aliasField("dd_effec_elm_contx", clazzValElm, "ddEffecElmContx");
            xs.alias("df_effec_elm_contx", Date.class);
            xs.aliasField("df_effec_elm_contx", clazzValElm, "dfEffecElmContx");
            xs.aliasField("liste_util_elm_contx", clazzValElm, "listeUtilElmContx");
            xs.addImplicitCollection(clazzListeUtil, "utilElmContx", "util_elm_contx", clazzUtilElm);
            xs.alias("typ_fact", Byte.class);
            xs.aliasField("typ_fact", clazzUtilElm, "typFact");
            xs.alias("cod_fact_lie_elm_contx", String.class);
            xs.aliasField("cod_fact_lie_elm_contx", clazzUtilElm, "codFactLieElmContx");
            xs.alias("dd_util_elm_contx", Date.class);
            xs.aliasField("dd_util_elm_contx", clazzUtilElm, "ddUtilElmContx");
            xs.alias("df_util_elm_contx", Date.class);
            xs.aliasField("df_util_elm_contx", clazzUtilElm, "dfUtilElmContx");
            xs.aliasField("liste_cod_fact", clazzUtilElm, "listeCodFact");
            xs.addImplicitCollection(clazzListeCode, "content", "val_cod_fact", clazzValCod);
            xs.alias("cod_fact", Long.class);
            xs.aliasField("cod_fact", clazzValCod, "codFact");
            xs.alias("dd_effec_cod_fact", Date.class);
            xs.aliasField("dd_effec_cod_fact", clazzValCod, "ddEffecCodFact");
            xs.alias("df_effec_cod_fact", Date.class);
            xs.aliasField("df_effec_cod_fact", clazzValCod, "dfEffecCodFact");
            jo = xs.fromXML(node);
            CacheService.getServiceInstance().put(CacheService.ELEMENT_CONTEXT, (Object)forHash, jo);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getJavaObjectFromNode " + node, e);
        }
        return jo;
    }
}

