/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.query;

import ca.infodata.CacheService;
import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.query.IBaseXQuery;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.util.JoinList;
import ca.infodata.syra.util.ValidRamq;
import ca.infodata.syra.xsd.valid.omni.CodFact;
import ca.infodata.syra.xsd.valid.omni.ObjectFactory;
import ca.infodata.syra.xsd.valid.omni.TypDatAttr;
import ca.infodata.syra.xsd.valid.spec.CodFact;
import ca.infodata.util1.StringUtils;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.basex.core.Context;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.eclipse.core.runtime.Platform;

public class CodeFacturation
extends IBaseXQuery {
    private static final Logger logger = Logger.getLogger(CodeFacturation.class.getName());
    static String queryListNotCabSlm = "(not(en_cab_seulm) or (en_cab_seulm[dd_effec_attri>'_DATE_' and (not(df_effec_attri) or df_effec_attri<'_DATE_')]))";
    static String queryListNotEtaSlm = "(not(en_etab_seulm) or (en_etab_seulm[dd_effec_attri>'_DATE_' and (not(df_effec_attri) or df_effec_attri<'_DATE_')]))";
    static String queryListRole = "(fn:empty(liste_role_SPEC_) or (liste_role_SPEC_/role_SPEC_[(not(cod_role) or cod_role=_ROLE_) and dd_effec_role<='_DATE_' and (not(df_effec_role) or df_effec_role>'_DATE_')_CODSPEC_]))";
    static String queryListAge = "(not(fn:exists(liste_per_age)) or (liste_per_age/per_age[( (typ_unit_mes_age='J' and age_limit_infe<=_AGEJR_ and age_limit_sup>=_AGEJR_) or (typ_unit_mes_age='M' and age_limit_infe<=_AGEMS_ and age_limit_sup>=_AGEMS_) or (typ_unit_mes_age='A' and age_limit_infe<=_AGEAN_ and age_limit_sup>=_AGEAN_) ) and dd_effec_per_age<='_DATE_' and (not(df_effec_per_age) or df_effec_per_age > '_DATE_')]))";
    ca.infodata.syra.xsd.valid.spec.ObjectFactory ofspec = new ca.infodata.syra.xsd.valid.spec.ObjectFactory();
    ObjectFactory ofomni = new ObjectFactory();

    @Override
    public String getDescription(QueryCriteria criteria) {
        String desc;
        block18: {
            desc = "";
            try {
                if (criteria.node == null) {
                    String forHash = String.valueOf(criteria.getStringForHashcode()) + "DT" + IBaseXQuery.DataType.DESCRIPTION.ordinal();
                    Object fromCache = CacheService.getServiceInstance().getValue(CacheService.CODE_FACTURATION, (Object)forHash, true);
                    if (fromCache != null) {
                        try {
                            return (String)fromCache;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Context contexte = ValidRamq.getInstance().getContext();
                    String query = this.getQueryString(criteria, IBaseXQuery.DataType.DESCRIPTION);
                    try {
                        Throwable throwable = null;
                        Object var8_12 = null;
                        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
                            Iter iter = proc.iter();
                            Item item = iter.next();
                            if (item != null) {
                                desc = new XQuery(item.toString()).execute(contexte).toString();
                            }
                            CacheService.getServiceInstance().put(CacheService.CODE_FACTURATION, (Object)forHash, (Object)desc);
                            break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (QueryException e) {
                        logger.log(Level.SEVERE, "getDescription - Query=" + query + "\n + criteria=" + criteria, e);
                    }
                    break block18;
                }
                desc = new XQuery(String.valueOf(criteria.node) + "/des_cod_fact/text()").execute(ValidRamq.getInstance().getContext()).toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return desc;
    }

    @Override
    public String getDescriptionLong(QueryCriteria criteria) {
        return this.getDescription(criteria);
    }

    @Override
    public List<String> getDataByCriteria(QueryCriteria criteria, IBaseXQuery.DataType dataType) throws QueryException, IOException {
        ArrayList<String> lstNode = new ArrayList<String>();
        if (criteria == null) {
            throw new NullPointerException("entente");
        }
        if (criteria.names == null) {
            criteria.codes.size();
        }
        long t0 = 0L;
        long t1 = 0L;
        if (LibPlugin.isInfodata) {
            t0 = System.currentTimeMillis();
        }
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "DBCDT" + dataType.ordinal();
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.CODE_FACTURATION, (Object)forHash, true);
        if (fromCache != null) {
            if (LibPlugin.isInfodata) {
                t1 = System.currentTimeMillis();
            }
            try {
                return (List)fromCache;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String query = this.getQueryString(criteria, dataType);
        Context contexte = ValidRamq.getInstance().getContext();
        Throwable throwable = null;
        Object var13_13 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte).toString();
                lstNode.add(node);
            }
            CacheService.getServiceInstance().put(CacheService.CODE_FACTURATION, (Object)forHash, lstNode);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (LibPlugin.isInfodata) {
            t1 = System.currentTimeMillis();
        }
        return lstNode;
    }

    @Override
    public List<String[]> getCodeDescription(QueryCriteria criteria) throws QueryException, IOException {
        ArrayList<String[]> lstNode = new ArrayList<String[]>();
        if (criteria.getEntente() == null) {
            throw new NullPointerException("entente");
        }
        String query = this.getQueryString(criteria, IBaseXQuery.DataType.CODE_DESCR);
        Platform.inDebugMode();
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "DT" + IBaseXQuery.DataType.CODE_DESCR.ordinal();
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.CODE_FACTURATION, (Object)forHash, true);
        if (fromCache != null) {
            try {
                return (List)fromCache;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Context contexte = ValidRamq.getInstance().getContext();
        Throwable throwable = null;
        Object var8_10 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte).toString();
                int i = node.indexOf(58);
                String code = node.substring(0, i);
                String desc = node.substring(i + 1, node.length());
                lstNode.add(new String[]{code, desc});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Collections.sort(lstNode, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                Integer i1 = Integer.valueOf(o1[0]);
                Integer i2 = Integer.valueOf(o2[0]);
                return i1.compareTo(i2);
            }
        });
        CacheService.getServiceInstance().put(CacheService.CODE_FACTURATION, (Object)forHash, lstNode);
        return lstNode;
    }

    @Override
    protected String getQueryString(QueryCriteria criteria, IBaseXQuery.DataType dataType) {
        String nn = "";
        String query = "";
        String type = "";
        if (IBaseXQuery.DataType.CODE.equals((Object)dataType)) {
            type = "/cod_fact/text()";
        } else if (IBaseXQuery.DataType.DESCRIPTION.equals((Object)dataType)) {
            type = "/des_cod_fact/text()";
        } else if (IBaseXQuery.DataType.CODE_DESCR.equals((Object)dataType)) {
            type = "/fn:string-join((cod_fact/text(),des_cod_fact/text()),':')";
        } else if (IBaseXQuery.DataType.NODE.equals((Object)dataType)) {
            type = "";
        }
        boolean normalSearch = criteria.getCodePlusLibre() == null ? true : criteria.getCodePlusLibre() == false;
        boolean cab = normalSearch && QueryCriteria.EtablType.CABINET.equals((Object)criteria.etablType);
        boolean etabl = normalSearch && QueryCriteria.EtablType.ETABLISSEMENT.equals((Object)criteria.etablType);
        String site_restriction = "";
        if (cab) {
            site_restriction = queryListNotEtaSlm;
        } else if (etabl) {
            site_restriction = queryListNotCabSlm;
        }
        String date = criteria.getDate();
        String spec = "";
        String codeSpec = "";
        if (normalSearch && new Integer(2).equals(criteria.getEntente())) {
            spec = "_spec";
            if (StringUtils.isNotEmpty((String)criteria.getCodeSpec())) {
                String cs = StringUtils.leftPad((String)criteria.getCodeSpec(), (int)3, (char)'0');
                codeSpec = " and (not(cod_spec) or cod_spec='" + cs + "')";
            }
        }
        String role_restriction = "";
        if (normalSearch && criteria.getRole() != null) {
            role_restriction = queryListRole;
        }
        String per_age = "";
        String ageJr = null;
        String ageMs = null;
        String ageAn = null;
        if (normalSearch) {
            if (criteria.getAgeJours() != null) {
                ageJr = String.valueOf(criteria.getAgeJours());
            }
            if (criteria.getAgeMonths() != null) {
                ageMs = String.valueOf(criteria.getAgeMonths());
            }
            if (criteria.getAgeYears() != null) {
                ageAn = String.valueOf(criteria.getAgeYears());
            }
        }
        site_restriction = StringUtils.replace((String)site_restriction, (String)"_DATE_", (String)date);
        if (role_restriction.length() > 0) {
            role_restriction = StringUtils.replace((String)role_restriction, (String)"_DATE_", (String)date);
            role_restriction = StringUtils.replace((String)role_restriction, (String)"_SPEC_", (String)spec);
            role_restriction = StringUtils.replace((String)role_restriction, (String)"_ROLE_", (String)criteria.getRole().toString());
            role_restriction = StringUtils.replace((String)role_restriction, (String)"_CODSPEC_", (String)codeSpec);
        }
        if (ageJr != null || ageMs != null || ageAn != null) {
            per_age = StringUtils.replace((String)queryListAge, (String)"_DATE_", (String)date);
            per_age = StringUtils.replace((String)per_age, (String)"_AGEJR_", (String)ageJr);
            per_age = StringUtils.replace((String)per_age, (String)"_AGEMS_", (String)ageMs);
            per_age = StringUtils.replace((String)per_age, (String)"_AGEAN_", (String)ageAn);
        }
        boolean hasSite = site_restriction.length() > 0;
        boolean hasRole = role_restriction.trim().length() > 0;
        boolean hasAge = per_age.trim().length() > 0;
        String site_role_and = "";
        if (hasSite && (hasRole || hasAge)) {
            site_role_and = " and ";
        }
        String role_age_and = "";
        if ((hasSite || hasRole) && hasAge) {
            role_age_and = " and ";
        }
        String liste_attr_criteria_open = "";
        String liste_attr_criteria_close = "";
        if (hasSite || hasRole || hasAge) {
            liste_attr_criteria_open = "/liste_attri[";
            liste_attr_criteria_close = "]/..";
        }
        String filterDescr = "";
        if (StringUtils.isNotEmpty((String)criteria.filterDescr)) {
            filterDescr = " and not(contains(des_cod_fact/text(),'" + criteria.filterDescr + "'))";
        }
        if (criteria.names != null) {
            nn = this.getNamesWithWildcards(criteria.names);
            query = "/cod_fact[no_enten=" + criteria.getEntente() + "]/" + "val_cod_fact[des_cod_fact contains text {" + nn + "} all using wildcards" + filterDescr + "]" + liste_attr_criteria_open + site_restriction + site_role_and + role_restriction + role_age_and + per_age + liste_attr_criteria_close + type;
        } else if (criteria.codes.size() > 0) {
            String names = "'" + new JoinList("','", criteria.codes).toString() + "'";
            query = "/cod_fact[no_enten=" + criteria.getEntente() + "]/" + "val_cod_fact[cod_fact contains text {" + names + "} any" + filterDescr + "]" + liste_attr_criteria_open + site_restriction + site_role_and + role_restriction + role_age_and + per_age + liste_attr_criteria_close + type;
        } else {
            query = "/cod_fact[no_enten=" + criteria.getEntente() + "]/" + "val_cod_fact" + liste_attr_criteria_open + site_restriction + site_role_and + role_restriction + role_age_and + per_age + liste_attr_criteria_close + type;
        }
        return query;
    }

    @Override
    public Object[] getJavaObjects(QueryCriteria criteria) {
        Object[] jos = new Object[]{};
        if (criteria == null || criteria.getEntente() == null) {
            return new Object[0];
        }
        String forHash = String.valueOf(criteria.getStringForHashcode()) + "JO";
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.CODE_FACTURATION, (Object)forHash, false);
        if (fromCache != null) {
            return (Object[])CodeFacturation.deserialize((byte[])fromCache, true);
        }
        CProfessionnal.Entente entente = CProfessionnal.Entente.valueOf(criteria.entente);
        try {
            List<String> dataByCriteria = this.getDataByCriteria(criteria, IBaseXQuery.DataType.NODE);
            XStream xs = this.getXstream();
            jos = new Object[dataByCriteria.size()];
            int i = 0;
            for (String node : dataByCriteria) {
                Object act = this.getJavaObjectFromNode(entente, node, xs);
                jos[i++] = act;
            }
            CacheService.getServiceInstance().put(CacheService.CODE_FACTURATION, (Object)forHash, (Object)jos);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getJavaObjects " + criteria, e);
        }
        return jos;
    }

    @Override
    public Object getJavaObjectFromNode(CProfessionnal.Entente entente, String node, XStream xs) {
        Object jo = null;
        String forHash = node;
        Object fromCache = CacheService.getServiceInstance().getValue(CacheService.CODE_FACTURATION, (Object)forHash, false);
        if (fromCache != null) {
            try {
                return CodeFacturation.deserialize((byte[])fromCache, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            boolean hasAttr;
            boolean hasMedAdmCsst = false;
            boolean hasNoAutor = false;
            boolean hasEnCabSeulm = false;
            boolean hasEnEtabSeul = false;
            String csst = null;
            try {
                csst = new XQuery(String.valueOf(node) + "/liste_attri/med_admn_csst/dd_effec_attri/text()").execute(ValidRamq.getInstance().getContext()).toString();
                hasMedAdmCsst = StringUtils.isNotEmpty((String)csst);
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Erreur hasMedAdmCsse ", e);
            }
            String autor = null;
            try {
                autor = new XQuery(String.valueOf(node) + "/liste_attri/no_autor/dd_effec_attri/text()").execute(ValidRamq.getInstance().getContext()).toString();
                hasNoAutor = StringUtils.isNotEmpty((String)autor);
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Erreur hasMedAdmCsse ", e);
            }
            String enCab = null;
            try {
                enCab = new XQuery(String.valueOf(node) + "/liste_attri/en_cab_seulm/dd_effec_attri/text()").execute(ValidRamq.getInstance().getContext()).toString();
                hasEnCabSeulm = StringUtils.isNotEmpty((String)enCab);
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Erreur hasMedAdmCsse ", e);
            }
            String enEtab = null;
            try {
                enEtab = new XQuery(String.valueOf(node) + "/liste_attri/en_etab_seulm/dd_effec_attri/text()").execute(ValidRamq.getInstance().getContext()).toString();
                hasEnEtabSeul = StringUtils.isNotEmpty((String)enEtab);
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Erreur hasMedAdmCsse ", e);
            }
            if (!Platform.inDebugMode()) {
            }
            if (xs == null) {
                xs = this.getXstream();
            }
            xs.autodetectAnnotations(true);
            Class clazzValCod = null;
            Class clazzListeAttr = null;
            Class clazzListeElmMes = null;
            Class clazzElmMes = null;
            Class clazzListePerAge = null;
            Class clazzPerAge = null;
            Class clazzListeRole = null;
            Class clazzRole = null;
            Class clazzTypDatAttr = null;
            String[] role = null;
            String[] listRole = null;
            String[] nomSpec = null;
            String[] codSpec = null;
            if (CProfessionnal.Entente.OMNI.equals((Object)entente)) {
                role = new String[]{"role", "role"};
                listRole = new String[]{"liste_role", "listeRole"};
                nomSpec = new String[]{"nom", "nom"};
                clazzValCod = CodFact.ValCodFact.class;
                clazzListeAttr = CodFact.ValCodFact.ListeAttri.class;
                clazzListeElmMes = CodFact.ValCodFact.ListeAttri.ListeElmMesur.class;
                clazzElmMes = CodFact.ValCodFact.ListeAttri.ListeElmMesur.ElmMesur.class;
                clazzListePerAge = CodFact.ValCodFact.ListeAttri.ListePerAge.class;
                clazzPerAge = CodFact.ValCodFact.ListeAttri.ListePerAge.PerAge.class;
                clazzListeRole = CodFact.ValCodFact.ListeAttri.ListeRole.class;
                clazzRole = CodFact.ValCodFact.ListeAttri.ListeRole.Role.class;
                clazzTypDatAttr = TypDatAttr.class;
            } else if (CProfessionnal.Entente.SPEC.equals((Object)entente)) {
                role = new String[]{"role_spec", "roleSpec"};
                listRole = new String[]{"liste_role_spec", "listeRoleSpec"};
                nomSpec = new String[]{"nom_spec", "nomSpec"};
                codSpec = new String[]{"cod_spec", "codSpec"};
                clazzValCod = CodFact.ValCodFact.class;
                clazzListeAttr = CodFact.ValCodFact.ListeAttri.class;
                clazzListeElmMes = CodFact.ValCodFact.ListeAttri.ListeElmMesur.class;
                clazzElmMes = CodFact.ValCodFact.ListeAttri.ListeElmMesur.ElmMesur.class;
                clazzListeRole = CodFact.ValCodFact.ListeAttri.ListeRoleSpec.class;
                clazzRole = CodFact.ValCodFact.ListeAttri.ListeRoleSpec.RoleSpec.class;
                clazzListePerAge = CodFact.ValCodFact.ListeAttri.ListePerAge.class;
                clazzPerAge = CodFact.ValCodFact.ListeAttri.ListePerAge.PerAge.class;
                clazzTypDatAttr = ca.infodata.syra.xsd.valid.spec.TypDatAttr.class;
            } else {
                return jo;
            }
            xs.ignoreUnknownElements();
            xs.alias("val_cod_fact", clazzValCod);
            xs.alias("cod_fact", String.class);
            xs.aliasField("cod_fact", clazzValCod, "codFact");
            xs.alias("des_cod_fact", String.class);
            xs.aliasField("des_cod_fact", clazzValCod, "desCodFact");
            xs.alias("typ_cod_fact", String.class);
            xs.aliasField("typ_cod_fact", clazzValCod, "typCodFact");
            xs.alias("dd_effec_cod_fact", Date.class);
            xs.aliasField("dd_effec_cod_fact", clazzValCod, "ddEffecCodFact");
            xs.alias("df_effec_cod_fact", Date.class);
            xs.aliasField("df_effec_cod_fact", clazzValCod, "dfEffecCodFact");
            xs.aliasField("liste_attri", clazzValCod, "listeAttri");
            xs.addImplicitCollection(clazzListeAttr, "content");
            xs.alias("dd_effec_attri", Date.class);
            xs.aliasField("dd_effec_attri", clazzTypDatAttr, "ddEffecAttri");
            xs.alias("df_effec_attri", Date.class);
            xs.aliasField("df_effec_attri", clazzTypDatAttr, "dfEffecAttri");
            xs.addImplicitCollection(clazzListeAttr, "content", "liste_elm_mesur", clazzListeElmMes);
            xs.addImplicitCollection(clazzListeElmMes, "content", "elm_mesur", clazzElmMes);
            xs.aliasField("elm_mesur", clazzListeElmMes, "elmMesur");
            xs.alias("elm_mesur", clazzElmMes);
            xs.alias("cod_elm_mesur", Integer.class);
            xs.aliasField("cod_elm_mesur", clazzElmMes, "codElmMesur");
            xs.alias("nom_elm_mesur", String.class);
            xs.aliasField("nom_elm_mesur", clazzElmMes, "nomElmMesur");
            xs.alias("typ_unit_mes", String.class);
            xs.aliasField("typ_unit_mes", clazzElmMes, "typUnitMes");
            xs.alias("dd_effec_elm_mesur", Date.class);
            xs.aliasField("dd_effec_elm_mesur", clazzElmMes, "ddEffecElmMesur");
            xs.alias("df_effec_elm_mesur", Date.class);
            xs.aliasField("df_effec_elm_mesur", clazzElmMes, "dfEffecElmMesur");
            xs.addImplicitCollection(clazzListeAttr, "content", listRole[0], clazzListeRole);
            xs.addImplicitCollection(clazzListeRole, "content", role[0], clazzRole);
            xs.aliasField(role[0], clazzListeRole, "content");
            xs.alias("cod_role", BigInteger.class);
            xs.aliasField("cod_role", clazzRole, "codRole");
            xs.alias("nom_role", String.class);
            xs.aliasField("nom_role", clazzRole, "nomRole");
            xs.alias("cod_fact_lie_elm_contx", String.class);
            xs.aliasField("cod_fact_lie_elm_contx", clazzRole, "codFactLieElmContx");
            xs.alias("dd_effec_role", Date.class);
            xs.aliasField("dd_effec_role", clazzRole, "ddEffecRole");
            xs.alias("df_effec_role", Date.class);
            xs.aliasField("df_effec_role", clazzRole, "dfEffecRole");
            if (CProfessionnal.Entente.SPEC.equals((Object)entente)) {
                xs.alias(codSpec[0], BigInteger.class);
                xs.aliasField(codSpec[0], clazzRole, codSpec[1]);
                xs.alias(nomSpec[0], String.class);
                xs.aliasField(nomSpec[0], clazzRole, nomSpec[1]);
            }
            xs.addImplicitCollection(clazzListeAttr, "content", "liste_per_age", clazzListePerAge);
            xs.addImplicitCollection(clazzListePerAge, "content", "per_age", clazzPerAge);
            xs.aliasField("per_age", clazzListePerAge, "content");
            xs.alias("typ_unit_mes_age", String.class);
            xs.aliasField("typ_unit_mes_age", clazzPerAge, "typUnitMesAge");
            xs.alias("age_limit_infe", Integer.class);
            xs.aliasField("age_limit_infe", clazzPerAge, "ageLimitInfe");
            xs.alias("age_limit_sup", Integer.class);
            xs.aliasField("age_limit_sup", clazzPerAge, "ageLimitSup");
            xs.alias("dd_effec_per_age", Date.class);
            xs.aliasField("dd_effec_per_age", clazzPerAge, "ddEffecPerAge");
            xs.alias("df_effec_per_age", Date.class);
            xs.aliasField("df_effec_per_age", clazzPerAge, "dfEffecPerAge");
            jo = xs.fromXML(node);
            boolean bl = hasAttr = hasMedAdmCsst || hasNoAutor || hasEnCabSeulm || hasEnEtabSeul;
            if (hasAttr) {
                if (CProfessionnal.Entente.OMNI.equals((Object)entente)) {
                    TypDatAttr typDat;
                    if (((CodFact.ValCodFact)jo).getListeAttri() == null) {
                        CodFact.ValCodFact.ListeAttri listeAttri = this.ofomni.createCodFactValCodFactListeAttri();
                        ((CodFact.ValCodFact)jo).setListeAttri(listeAttri);
                    }
                    if (hasMedAdmCsst) {
                        typDat = this.ofomni.createTypDatAttr();
                        typDat.setDdEffecAttri(dataFactory.newXMLGregorianCalendar(csst));
                        ((CodFact.ValCodFact)jo).getListeAttri().getContent().add((Serializable)this.ofomni.createCodFactValCodFactListeAttriMedAdmnCsst(typDat));
                    }
                    if (hasNoAutor) {
                        typDat = this.ofomni.createTypDatAttr();
                        typDat.setDdEffecAttri(dataFactory.newXMLGregorianCalendar(autor));
                        ((CodFact.ValCodFact)jo).getListeAttri().getContent().add((Serializable)this.ofomni.createCodFactValCodFactListeAttriNoAutor(typDat));
                    }
                    if (hasEnCabSeulm) {
                        typDat = this.ofomni.createTypDatAttr();
                        typDat.setDdEffecAttri(dataFactory.newXMLGregorianCalendar(enCab));
                        ((CodFact.ValCodFact)jo).getListeAttri().getContent().add((Serializable)this.ofomni.createCodFactValCodFactListeAttriEnCabSeulm(typDat));
                    }
                    if (hasEnEtabSeul) {
                        typDat = this.ofomni.createTypDatAttr();
                        typDat.setDdEffecAttri(dataFactory.newXMLGregorianCalendar(enEtab));
                        ((CodFact.ValCodFact)jo).getListeAttri().getContent().add((Serializable)this.ofomni.createCodFactValCodFactListeAttriEnEtabSeulm(typDat));
                    }
                } else if (CProfessionnal.Entente.SPEC.equals((Object)entente)) {
                    ca.infodata.syra.xsd.valid.spec.TypDatAttr typDat;
                    if (((CodFact.ValCodFact)jo).getListeAttri() == null) {
                        CodFact.ValCodFact.ListeAttri listeAttri = this.ofspec.createCodFactValCodFactListeAttri();
                        ((CodFact.ValCodFact)jo).setListeAttri(listeAttri);
                    }
                    if (hasMedAdmCsst) {
                        typDat = this.ofspec.createTypDatAttr();
                        typDat.setDdEffecAttri(dataFactory.newXMLGregorianCalendar(csst));
                        ((CodFact.ValCodFact)jo).getListeAttri().getContent().add((Serializable)this.ofspec.createCodFactValCodFactListeAttriMedAdmnCsst(typDat));
                    }
                    if (hasNoAutor) {
                        typDat = this.ofspec.createTypDatAttr();
                        typDat.setDdEffecAttri(dataFactory.newXMLGregorianCalendar(autor));
                        ((CodFact.ValCodFact)jo).getListeAttri().getContent().add((Serializable)this.ofspec.createCodFactValCodFactListeAttriNoAutor(typDat));
                    }
                    if (hasEnCabSeulm) {
                        typDat = this.ofspec.createTypDatAttr();
                        typDat.setDdEffecAttri(dataFactory.newXMLGregorianCalendar(enCab));
                        ((CodFact.ValCodFact)jo).getListeAttri().getContent().add((Serializable)this.ofspec.createCodFactValCodFactListeAttriEnCabSeulm(typDat));
                    }
                    if (hasEnEtabSeul) {
                        typDat = this.ofspec.createTypDatAttr();
                        typDat.setDdEffecAttri(dataFactory.newXMLGregorianCalendar(enEtab));
                        ((CodFact.ValCodFact)jo).getListeAttri().getContent().add((Serializable)this.ofspec.createCodFactValCodFactListeAttriEnEtabSeulm(typDat));
                    }
                }
            }
            CacheService.getServiceInstance().put(CacheService.CODE_FACTURATION, (Object)forHash, jo);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getJavaObjectFromNode " + node, e);
            System.exit(0);
        }
        return jo;
    }
}

