/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.dossier.hibernate.fmedx.base.BaseArchive_dpacteDAO;
import ca.infodata.dossier.hibernate.fmedx.dao.Archive_dpacteDAO;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.ofys.util.date.DateUtil;
import ca.infodata.syra.SyraAccessorClient;
import ca.infodata.syra.SyraPlugin;
import ca.infodata.syra.controller.SyraPrefAndXmlDataController;
import ca.infodata.syra.controller.ValidReglePlafException;
import ca.infodata.syra.models.CDemAnnu;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CDemForListe;
import ca.infodata.syra.models.CDemModif;
import ca.infodata.syra.models.CDemPaimtFactFraisDepl;
import ca.infodata.syra.models.CDemPaimtFactServMdcal;
import ca.infodata.syra.models.CDemPaimtFactServMdcalOmni;
import ca.infodata.syra.models.CDemPaimtFactServMdcalSpec;
import ca.infodata.syra.models.CDemPaimtRecev;
import ca.infodata.syra.models.CDemdr;
import ca.infodata.syra.models.CFactExplPmt;
import ca.infodata.syra.models.CLieu;
import ca.infodata.syra.models.CLigneForfaDepla;
import ca.infodata.syra.models.CLigneFraisSej;
import ca.infodata.syra.models.CLigneFraisTranp;
import ca.infodata.syra.models.CLigneTempsDepla;
import ca.infodata.syra.models.CLigneTypServMdcal;
import ca.infodata.syra.models.CModaPaimt;
import ca.infodata.syra.models.CObjectUtils;
import ca.infodata.syra.models.CPatient;
import ca.infodata.syra.models.CTypDiagnMdcal;
import ca.infodata.syra.models.CodeBigIntCodFact;
import ca.infodata.syra.models.CodeDesc;
import ca.infodata.syra.models.CtxFact;
import ca.infodata.syra.models.ICode;
import ca.infodata.syra.models.IDem;
import ca.infodata.syra.models.INoLigne;
import ca.infodata.syra.models.ReglePlafonnement;
import ca.infodata.syra.models.ReglePlafonnementReponse;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.infodata.syra.util.JoinList;
import ca.infodata.util1.StringUtils;
import ca.qc.gouv.ramq.rfp.DemPaimt;
import ca.qc.gouv.ramq.rfp.FactFraisDepla;
import ca.qc.gouv.ramq.rfp.FactServMdcalOmni;
import ca.qc.gouv.ramq.rfp.FactServMdcalSpec;
import ca.qc.gouv.ramq.rfp.LigneForfaDepla;
import ca.qc.gouv.ramq.rfp.LigneFraisSej;
import ca.qc.gouv.ramq.rfp.LigneFraisTranp;
import ca.qc.gouv.ramq.rfp.LigneTempsDepla;
import ca.qc.gouv.ramq.rfp.ObjectFactory;
import ca.qc.gouv.ramq.rfp.TypAdr;
import ca.qc.gouv.ramq.rfp.TypDem;
import ca.qc.gouv.ramq.rfp.TypDemPaimt;
import ca.qc.gouv.ramq.rfp.TypDiagnMdcal;
import ca.qc.gouv.ramq.rfp.TypElmContx;
import ca.qc.gouv.ramq.rfp.TypElmMesur;
import ca.qc.gouv.ramq.rfp.TypEvenePersObjetFact;
import ca.qc.gouv.ramq.rfp.TypFact;
import ca.qc.gouv.ramq.rfp.TypFraisSej;
import ca.qc.gouv.ramq.rfp.TypIdLieuGeo;
import ca.qc.gouv.ramq.rfp.TypIdLieuPhys;
import ca.qc.gouv.ramq.rfp.TypIdPersAutre;
import ca.qc.gouv.ramq.rfp.TypInfoMdcalPers;
import ca.qc.gouv.ramq.rfp.TypInfoPers;
import ca.qc.gouv.ramq.rfp.TypLieuGeoOmni;
import ca.qc.gouv.ramq.rfp.TypLieuGeoSpec;
import ca.qc.gouv.ramq.rfp.TypLieuPhysOmni;
import ca.qc.gouv.ramq.rfp.TypLieuPhysSpec;
import ca.qc.gouv.ramq.rfp.TypLieuRefreOmni;
import ca.qc.gouv.ramq.rfp.TypLieuRefreSpec;
import ca.qc.gouv.ramq.rfp.TypLigne;
import ca.qc.gouv.ramq.rfp.TypPers;
import ca.qc.gouv.ramq.rfp.TypPersPatntSansIdt;
import ca.qc.gouv.ramq.rfp.TypPersRepdn;
import ca.qc.gouv.ramq.rfp.TypProf;
import ca.qc.gouv.ramq.rfp.TypProfNonConnu;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.math.NumberUtils;

public class CDemPaimt
extends IDem {
    public static final Integer TYPE_SERV = new Integer(1);
    public static final Integer TYPE_DEPL = new Integer(2);
    public String cNoDemExt;
    public CDemdr cDemdr;
    public CModaPaimt cModaPaimt;
    public CDemForListe demForListe;
    public CDemPaimtRecev recev;
    public CDemModif demModif;
    public CDemModif lastAcceptedDemModif;
    public CDemAnnu demAnnu;
    public CFactExplPmt explPmt;
    public Map<BigInteger, Integer> validRP = new HashMap<BigInteger, Integer>();
    public static Comparator<INoLigne> compNoLigneAbsAsc = new Comparator<INoLigne>(){

        @Override
        public int compare(INoLigne o1, INoLigne o2) {
            int i2;
            int i1 = Math.abs(o1.getNoLigne());
            if (i1 == (i2 = Math.abs(o2.getNoLigne()))) {
                return 0;
            }
            if (i1 < i2) {
                return -1;
            }
            return 1;
        }
    };
    public transient int servNextNoLigne = 0;
    public static Comparator<INoLigne> compNoLigne = new Comparator<INoLigne>(){

        @Override
        public int compare(INoLigne o1, INoLigne o2) {
            return o1.getNoLigne() > o2.getNoLigne() ? 1 : (o1.getNoLigne() < o2.getNoLigne() ? -1 : 0);
        }
    };
    public static Comparator<ICode> compCode = new Comparator<ICode>(){

        @Override
        public int compare(ICode o1, ICode o2) {
            return o2.getCode().compareTo(o1.getCode());
        }
    };
    private static /* synthetic */ int[] $SWITCH_TABLE$ca$infodata$syra$enumitems$UnitDuree;

    public static int getNextNoLigne(List<Integer> lstNo) {
        int[] n = new int[lstNo.size()];
        int k = 0;
        for (Integer i : lstNo) {
            n[k++] = i;
        }
        return NumberUtils.max((int[])n);
    }

    public CDemPaimt() {
    }

    public CDemPaimt(CDemContainer c, boolean copyCurrent, boolean withPtDxDate) {
        this.cNoDemExt = SyraAccessorClient.getInstance().getNextNoDemExt();
        if (copyCurrent) {
            CDemPaimt currDemPaimt = c.getCurrentDemPaimt();
            this.cModaPaimt = currDemPaimt.cModaPaimt;
            this.cDemdr = currDemPaimt.cDemdr;
            this.depl = currDemPaimt.depl;
            this.serv = currDemPaimt.serv;
            if (this.serv != null && !withPtDxDate) {
                this.serv.mapTempPatients.clear();
                this.setCurrPatientvide(c);
            }
            this.type = currDemPaimt.type;
        } else {
            this.cDemdr = new CDemdr("1", c.getCurrentProf() == null ? null : c.getCurrentProf().getNoProf());
            this.type = c.getSyraSettings(ConnectionFactory.connectionLabel).getInt("demPaimtType");
            if (this.type == null) {
                this.type = TYPE_SERV;
            }
            this.serv = new CDemPaimtFactServMdcal();
            this.serv.prof = c.getCurrentProf();
            this.serv.lieu = c.getCurrentLieu(this.serv.prof);
            Integer noGrAdmin = null;
            CodeDesc currGroup = null;
            if (this.serv.prof != null && StringUtils.isNotEmpty((String)this.serv.prof.getNoGroup()) && (noGrAdmin = new Integer(this.serv.prof.getNoGroup().trim())) > 0) {
                currGroup = CObjectUtils.getGroupe(this.serv.prof.getNoGroup().trim());
            }
            if (noGrAdmin == null && (currGroup = c.getCurrentGroupe()) != null) {
                try {
                    noGrAdmin = Integer.valueOf(currGroup.c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.setCurrPatientvide(c);
            this.serv.groupe = currGroup;
            this.depl = new CDemPaimtFactFraisDepl();
            this.depl.prof = c.getCurrentProf();
            this.depl.groupe = currGroup;
            this.depl.lieuDep = new CLieu(true);
            this.depl.lieuDep.typLocEtab = "C";
            this.depl.lieuArr = new CLieu(true);
            this.depl.lieuArr.typLocEtab = "C";
            this.cModaPaimt = new CModaPaimt(noGrAdmin == null || noGrAdmin == 0 ? new Integer(1) : new Integer(2), noGrAdmin, currGroup);
        }
    }

    private void setCurrPatientvide(CDemContainer c) {
        this.patient = new CPatient();
        this.patient.setTag(CPatient.getTempId());
        this.patient.setTypePerson(1);
        this.patient.setTypSituConsi(1);
        this.patient.setTypIdPerson(new Integer(1));
        TypDiagnMdcal mdcal = new TypDiagnMdcal();
        mdcal.setNoSeqSysCla(12);
        mdcal.setCodDiagnMdcal("");
        this.patient.addCTypDiagnMdcal(new CTypDiagnMdcal("", "", mdcal));
        this.serv.mapTempPatients.put(this.patient.getTag(), this.patient);
        c.setCurrentValue("currentPatient", this.patient);
    }

    public CDemPaimt(DemPaimt dem, CDemContainer cDemContainer, boolean withDetail, boolean forPrint) {
        this.cNoDemExt = dem.getNoDemExt();
        this.cDemdr = new CDemdr(dem.getDemdr(), withDetail);
        this.cModaPaimt = new CModaPaimt(dem.getModaPaimt(), withDetail);
        String noCpteAdmin = this.cModaPaimt.no == null ? null : StringUtils.padLeft((String)this.cModaPaimt.no.toString(), (int)5, (char)'0');
        CodeDesc groupe = null;
        if (noCpteAdmin != null && withDetail) {
            groupe = CObjectUtils.getGroupe(noCpteAdmin);
        }
        this.cModaPaimt.setGroupe(groupe);
        if (cDemContainer != null && !forPrint) {
            cDemContainer.setCurrentValue("currentGroupe", groupe);
            cDemContainer.setCurrentValue("currentDemPaimt", this);
        }
        if (dem.getListeFact() != null && dem.getListeFact().getFactBase() != null) {
            TypFact typFact = (TypFact)dem.getListeFact().getFactBase().getValue();
            CDemPaimt.setTypFact(cDemContainer, withDetail, forPrint, typFact, this);
        }
    }

    public static void setTypFact(CDemContainer cDemContainer, boolean withDetail, boolean forPrint, TypFact typFact, IDem i) {
        if (typFact instanceof FactFraisDepla) {
            i.type = TYPE_DEPL;
            i.depl = new CDemPaimtFactFraisDepl(cDemContainer, (FactFraisDepla)typFact, withDetail);
            if (cDemContainer != null && !forPrint) {
                cDemContainer.setCurrentValue("currentPatient", null);
                cDemContainer.setCurrentValue("currentProf", i.depl.prof);
            }
        } else if (typFact instanceof FactServMdcalOmni) {
            i.type = TYPE_SERV;
            i.serv = new CDemPaimtFactServMdcalOmni((FactServMdcalOmni)typFact, cDemContainer, withDetail);
            if (i.serv.mapTempPatients.size() > 0) {
                i.patient = i.serv.mapTempPatients.get(i.serv.mapTempPatients.keySet().iterator().next());
            }
            if (cDemContainer != null && !forPrint) {
                cDemContainer.setCurrentValue("currentPatient", i.patient);
                cDemContainer.setCurrentValue("currentProf", i.serv.prof);
                cDemContainer.setCurrentValue("currentLieu", i.serv.lieu);
            }
        } else if (typFact instanceof FactServMdcalSpec) {
            i.type = TYPE_SERV;
            i.serv = new CDemPaimtFactServMdcalSpec((FactServMdcalSpec)typFact, cDemContainer, withDetail);
            if (i.serv.mapTempPatients.size() > 0) {
                i.patient = i.serv.mapTempPatients.get(i.serv.mapTempPatients.keySet().iterator().next());
            }
            if (cDemContainer != null && !forPrint) {
                cDemContainer.setCurrentValue("currentPatient", i.patient);
                cDemContainer.setCurrentValue("currentProf", i.serv.prof);
                cDemContainer.setCurrentValue("currentLieu", i.serv.lieu);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public DemPaimt convert2Dem(CDemContainer cDemContainer) throws Exception {
        ObjectFactory of = ConvertJavaToFromArray.of;
        DatatypeFactory dataFactory = ConvertJavaToFromArray.dataFactory;
        boolean ready = cDemContainer.getCurrentCDemForListe().getReady();
        DemPaimt pmt = of.createDemPaimt();
        pmt.setNoDemExt(this.cNoDemExt);
        pmt.setLogclFact(ConvertJavaToFromArray.getLoglFact());
        TypDem.Demdr demdr = of.createTypDemDemdr();
        demdr.setIdIntvn(this.cDemdr.idIntvn);
        demdr.setTypIdIntvn(this.cDemdr.typIdIntvn);
        pmt.setDemdr(demdr);
        TypDem.ExpedDifrnDemdr expDemdr = of.createTypDemExpedDifrnDemdr();
        expDemdr.setIdIntvn(SyraGlobalSettings.getInstance((String)(String.valueOf(ConnectionFactory.connectionLabel) + "/")).get("syra_noAgence"));
        expDemdr.setTypIdIntvn("3");
        pmt.setExpedDifrnDemdr(expDemdr);
        TypDemPaimt.ModaPaimt modPmt = of.createTypDemPaimtModaPaimt();
        if (this.cModaPaimt != null && this.cModaPaimt.no != null && this.cModaPaimt.no != 0) {
            modPmt.setNoCpteAdmin(of.createTypDemPaimtModaPaimtNoCpteAdmin(this.cModaPaimt.no));
            modPmt.setTypModaPaimt(2);
        } else {
            modPmt.setTypModaPaimt(1);
        }
        pmt.setModaPaimt(modPmt);
        if (this.serv != null) {
            boolean isSalleUrgence = false;
            if (this.serv.lieu != null && this.serv.lieu.etab != null && this.serv.lieu.etab.valSect != null && "35".equals(this.serv.lieu.etab.valSect.noSectActiv)) {
                isSalleUrgence = true;
            }
            if (this.serv.prof != null && this.serv.prof.getType() != null) {
                DemPaimt.ListeFact lFact;
                TypIdLieuGeo lg;
                TypIdLieuPhys lp;
                TypElmContx listeElmContxElmContx;
                Object prof;
                Object infoProfRefre;
                Object lieu;
                Object listLieuRefre;
                XMLGregorianCalendar df;
                XMLGregorianCalendar dh;
                Object lstElmMesur;
                Object lf;
                List<ReglePlafonnement> listReglePlafonnement;
                Set<String> setSpec;
                BigInteger rpCode;
                TypElmContx elmC;
                Object lstEmlC;
                HashSet<Integer> rpSetElmCtx;
                XMLGregorianCalendar cal;
                Object line;
                Object listeLignes;
                TypFact fact;
                int rpPtHash = -1;
                TreeMap<Object, List<ReglePlafonnement>> rpMapCodePlaf = new TreeMap<Object, List<ReglePlafonnement>>();
                TypProf p = new TypProf();
                p.setIdProf(this.serv.prof.getNoProf());
                p.setTypIdProf(1);
                FactServMdcalOmni.ListePersObjetFact listePersObjetFactOmni = of.createFactServMdcalOmniListePersObjetFact();
                FactServMdcalSpec.ListePersObjetFact listePersObjetFactSpec = of.createFactServMdcalSpecListePersObjetFact();
                if (this.serv.lstPatients != null) {
                    for (CPatient pt : this.serv.lstPatients) {
                        Integer iGender;
                        TypInfoPers autreSansId;
                        TypIdPersAutre autreAvecId;
                        Integer iGender2;
                        TypInfoPers repdnSansIdt;
                        TypPersRepdn repdnAvecIdt;
                        Object patntSansIdtPersRepdn;
                        TypPersPatntSansIdt.InfoPersPatnt infoPersPatnt;
                        TypPersPatntSansIdt patnSansId;
                        TypPers patnAvecId;
                        String typSituConsi;
                        Object personPatient;
                        int n;
                        List<CodeDesc> lstDx = pt.lstDx;
                        TypInfoMdcalPers typInfoMedCal = of.createTypInfoMdcalPers();
                        if (lstDx.size() > 0) {
                            this.addDxToTypeInfoMdcalPers(of, typInfoMedCal, lstDx);
                        }
                        if ((n = ConvertJavaToFromArray.parseInt(pt.typEvenePers)) != 0) {
                            TypEvenePersObjetFact typEvenePersFact = of.createTypEvenePersObjetFact();
                            typEvenePersFact.setTypEvenePers(pt.typEvenePers);
                            if (ready && (pt.datEvenePers == null || pt.datEvenePers.length() < 10)) {
                                throw new Exception("Date de l'\u00e9v\u00e9nement non valide.");
                            }
                            typEvenePersFact.setDatEvenePers(dataFactory.newXMLGregorianCalendar(pt.datEvenePers));
                            typInfoMedCal.setEvenePersObjetFact(typEvenePersFact);
                        }
                        if (StringUtils.isNotEmpty((String)pt.datEntree) && pt.datEntree.length() >= 10) {
                            TypInfoMdcalPers.PerSejPersLieu perSejPersLieu = of.createTypInfoMdcalPersPerSejPersLieu();
                            perSejPersLieu.setDatEntrePersLieu(of.createTypInfoMdcalPersPerSejPersLieuDatEntrePersLieu(dataFactory.newXMLGregorianCalendar(pt.datEntree)));
                            if (StringUtils.isNotEmpty((String)pt.datSortie) && pt.datSortie.length() >= 10) {
                                perSejPersLieu.setDatSortiPersLieu(of.createTypInfoMdcalPersPerSejPersLieuDatSortiPersLieu(dataFactory.newXMLGregorianCalendar(pt.datSortie)));
                            }
                            typInfoMedCal.setPerSejPersLieu(perSejPersLieu);
                        }
                        if (this.serv.prof.getType() == 1) {
                            int typePerson = pt.getTypePerson();
                            personPatient = null;
                            typSituConsi = String.valueOf(pt.getTypSituConsi());
                            if (typePerson == ConvertJavaToFromArray.ArrPersType.AVEC_ID.getVal()) {
                                rpPtHash = CPatient.getStringToHashCode(pt.getStringForHash(1));
                                patnAvecId = of.createFactServMdcalOmniListePersObjetFactPersPatntAvecIdt();
                                patnAvecId.setIdPers(pt.getHealthInsuranceNumber());
                                patnAvecId.setTypIdPers(pt.getTypIdPerson());
                                patnAvecId.setTypSituConsi(ConvertJavaToFromArray.parseInt(typSituConsi));
                                ((FactServMdcalOmni.ListePersObjetFact.PersPatntAvecIdt)patnAvecId).setInfoMdcalPers(typInfoMedCal);
                                personPatient = patnAvecId;
                                listePersObjetFactOmni.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(personPatient);
                                continue;
                            }
                            if (typePerson == ConvertJavaToFromArray.ArrPersType.SANS_ID.getVal()) {
                                Integer iGender3;
                                rpPtHash = CPatient.getStringToHashCode(pt.getStringForHash(1));
                                patnSansId = of.createFactServMdcalOmniListePersObjetFactPersPatntSansIdt();
                                infoPersPatnt = of.createTypPersPatntSansIdtInfoPersPatnt();
                                infoPersPatnt.setNomPers(pt.getLastName());
                                if (StringUtils.isNotEmpty((String)pt.getFirstName())) {
                                    infoPersPatnt.setPrePers(of.createTypInfoPersPatntPrePers(pt.getFirstName()));
                                }
                                if (StringUtils.isNotEmpty((String)pt.bds) && pt.bds.length() >= 10) {
                                    infoPersPatnt.setDatNaissPers(dataFactory.newXMLGregorianCalendar(pt.bds));
                                }
                                if ((iGender3 = this.getIntegerGenderFromGender(pt.getGender())) != null) {
                                    infoPersPatnt.setCodSexePers(iGender3);
                                }
                                if (pt.getNaissanceOrder() != null) {
                                    infoPersPatnt.setNoOrdreNaissPers(of.createTypPersPatntSansIdtInfoPersPatntNoOrdreNaissPers(pt.getNaissanceOrder()));
                                }
                                if (pt.getNas() != null && pt.getNas().matches("[0-9]{9}")) {
                                    infoPersPatnt.setNas(of.createTypPersPatntSansIdtInfoPersPatntNas(new BigInteger(pt.getNas())));
                                    if (pt.getNaissanceOrder() != null) {
                                        infoPersPatnt.setNoOrdreNaissPers(of.createTypPersPatntSansIdtInfoPersPatntNoOrdreNaissPers(pt.getNaissanceOrder()));
                                    }
                                }
                                patnSansId.setInfoPersPatnt(infoPersPatnt);
                                if (pt.getAdresse() != null) {
                                    TypAdr typAdr = of.createTypAdr();
                                    if (StringUtils.isNotEmpty((String)pt.getAdresse().getStreet())) {
                                        typAdr.setAdrLigne1(pt.getAdresse().getStreet());
                                    }
                                    if (pt.getAdresse().getCity() != null && StringUtils.isNotEmpty((String)pt.getAdresse().getCity().getName())) {
                                        typAdr.setAdrLigne2(of.createTypAdrAdrLigne2(pt.getAdresse().getCity().getName()));
                                    }
                                    if (pt.getAdresse().getProvince() != null && StringUtils.isNotEmpty((String)pt.getAdresse().getProvince().getName())) {
                                        typAdr.setAdrLigne3(of.createTypAdrAdrLigne3(pt.getAdresse().getProvince().getName()));
                                    }
                                    if (StringUtils.isNotEmpty((String)pt.getAdresse().getPostalCode())) {
                                        typAdr.setCodPostl(pt.getAdresse().getPostalCode());
                                    }
                                    patnSansId.setAdrPersPatnt(of.createTypPersPatntSansIdtAdrPersPatnt(typAdr));
                                } else {
                                    patnSansId.setAdrPersPatnt(null);
                                }
                                if (pt.getPersRepdn() != null) {
                                    CPatient cPatient = pt.getPersRepdn();
                                    patntSansIdtPersRepdn = of.createFactServMdcalOmniListePersObjetFactPersPatntSansIdtPersRepdn();
                                    if (StringUtils.isNotEmpty((String)cPatient.getIdPersAutre())) {
                                        repdnAvecIdt = of.createTypPersRepdn();
                                        repdnAvecIdt.setTypIdPers(cPatient.getTypIdPersAutre());
                                        repdnAvecIdt.setIdPers(cPatient.getIdPersAutre());
                                        ((FactServMdcalOmni.ListePersObjetFact.PersPatntSansIdt.PersRepdn)patntSansIdtPersRepdn).setRepdnAvecIdt(repdnAvecIdt);
                                        ((FactServMdcalOmni.ListePersObjetFact.PersPatntSansIdt)patnSansId).setPersRepdn((FactServMdcalOmni.ListePersObjetFact.PersPatntSansIdt.PersRepdn)patntSansIdtPersRepdn);
                                    } else if (StringUtils.isNotEmpty((String)cPatient.getLastName()) && StringUtils.isNotEmpty((String)cPatient.getFirstName())) {
                                        repdnSansIdt = of.createFactServMdcalOmniListePersObjetFactPersPatntSansIdtPersRepdnRepdnSansIdt();
                                        repdnSansIdt.setNomPers(cPatient.getLastName());
                                        repdnSansIdt.setPrePers(cPatient.getFirstName());
                                        if (StringUtils.isNotEmpty((String)cPatient.bds)) {
                                            repdnSansIdt.setDatNaissPers(of.createTypInfoPersDatNaissPers(dataFactory.newXMLGregorianCalendar(cPatient.bds)));
                                        }
                                        if ((iGender2 = this.getIntegerGenderFromGender(cPatient.getGender())) != null) {
                                            repdnSansIdt.setCodSexePers(of.createTypInfoPersCodSexePers(iGender2));
                                        }
                                        ((FactServMdcalOmni.ListePersObjetFact.PersPatntSansIdt.PersRepdn)patntSansIdtPersRepdn).setRepdnSansIdt((FactServMdcalOmni.ListePersObjetFact.PersPatntSansIdt.PersRepdn.RepdnSansIdt)repdnSansIdt);
                                        ((FactServMdcalOmni.ListePersObjetFact.PersPatntSansIdt)patnSansId).setPersRepdn((FactServMdcalOmni.ListePersObjetFact.PersPatntSansIdt.PersRepdn)patntSansIdtPersRepdn);
                                    }
                                }
                                patnSansId.setTypSituConsi(ConvertJavaToFromArray.parseInt(typSituConsi));
                                ((FactServMdcalOmni.ListePersObjetFact.PersPatntSansIdt)patnSansId).setInfoMdcalPers(typInfoMedCal);
                                personPatient = patnSansId;
                                listePersObjetFactOmni.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(personPatient);
                                continue;
                            }
                            if (typePerson == ConvertJavaToFromArray.ArrPersType.AUTRE_AVEC_ID.getVal()) {
                                autreAvecId = of.createFactServMdcalOmniListePersObjetFactPersAutreAvecIdt();
                                ((FactServMdcalOmni.ListePersObjetFact.PersAutreAvecIdt)autreAvecId).setTypPersAutre(of.createFactServMdcalOmniListePersObjetFactPersAutreAvecIdtTypPersAutre(pt.getTypPersAutre()));
                                if (pt.getTypIdPersAutre() != null) {
                                    autreAvecId.setTypIdPersAutre(pt.getTypIdPersAutre());
                                }
                                autreAvecId.setIdPersAutre(pt.getIdPersAutre());
                                personPatient = autreAvecId;
                                listePersObjetFactOmni.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(personPatient);
                                continue;
                            }
                            if (typePerson != ConvertJavaToFromArray.ArrPersType.AUTRE_SANS_ID.getVal()) continue;
                            autreSansId = of.createFactServMdcalOmniListePersObjetFactPersAutreSansIdt();
                            autreSansId.setNomPers(pt.getLastName());
                            autreSansId.setPrePers(pt.getFirstName());
                            if (pt.getLdbirthDate() != null) {
                                autreSansId.setDatNaissPers(of.createTypInfoPersDatNaissPers(dataFactory.newXMLGregorianCalendar(pt.getLdbirthDate().formatHyphen())));
                            }
                            if ((iGender = this.getIntegerGenderFromGender(pt.getGender())) != null) {
                                autreSansId.setCodSexePers(of.createTypInfoPersCodSexePers(iGender));
                            }
                            ((FactServMdcalOmni.ListePersObjetFact.PersAutreSansIdt)autreSansId).setTypPersAutre(of.createFactServMdcalOmniListePersObjetFactPersAutreSansIdtTypPersAutre(ConvertJavaToFromArray.getInt("1")));
                            personPatient = autreSansId;
                            listePersObjetFactOmni.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(personPatient);
                            continue;
                        }
                        if (this.serv.prof.getType() != 2) continue;
                        int typePerson = pt.getTypePerson();
                        personPatient = null;
                        typSituConsi = String.valueOf(pt.getTypSituConsi());
                        if (typePerson == ConvertJavaToFromArray.ArrPersType.AVEC_ID.getVal()) {
                            rpPtHash = CPatient.getStringToHashCode(pt.getStringForHash(1));
                            patnAvecId = of.createFactServMdcalSpecListePersObjetFactPersPatntAvecIdt();
                            patnAvecId.setIdPers(pt.getHealthInsuranceNumber());
                            patnAvecId.setTypIdPers(pt.getTypIdPerson());
                            patnAvecId.setTypSituConsi(ConvertJavaToFromArray.parseInt(typSituConsi));
                            ((FactServMdcalSpec.ListePersObjetFact.PersPatntAvecIdt)patnAvecId).setInfoMdcalPers(typInfoMedCal);
                            if (pt.getImc() != null) {
                                ((FactServMdcalSpec.ListePersObjetFact.PersPatntAvecIdt)patnAvecId).setValImcPatnt(of.createFactServMdcalSpecListePersObjetFactPersPatntAvecIdtValImcPatnt(pt.getImc()));
                            }
                            personPatient = patnAvecId;
                            listePersObjetFactSpec.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(personPatient);
                            continue;
                        }
                        if (typePerson == ConvertJavaToFromArray.ArrPersType.SANS_ID.getVal()) {
                            Integer iGender3;
                            rpPtHash = CPatient.getStringToHashCode(pt.getStringForHash(1));
                            patnSansId = of.createFactServMdcalSpecListePersObjetFactPersPatntSansIdt();
                            infoPersPatnt = of.createTypPersPatntSansIdtInfoPersPatnt();
                            infoPersPatnt.setNomPers(pt.getLastName());
                            if (StringUtils.isNotEmpty((String)pt.getFirstName())) {
                                infoPersPatnt.setPrePers(of.createTypInfoPersPatntPrePers(pt.getFirstName()));
                            }
                            if (StringUtils.isNotEmpty((String)pt.bds) && pt.bds.length() >= 10) {
                                infoPersPatnt.setDatNaissPers(dataFactory.newXMLGregorianCalendar(pt.bds));
                            }
                            if ((iGender3 = this.getIntegerGenderFromGender(pt.getGender())) != null) {
                                infoPersPatnt.setCodSexePers(iGender3);
                            }
                            if (pt.getNaissanceOrder() != null) {
                                infoPersPatnt.setNoOrdreNaissPers(of.createTypPersPatntSansIdtInfoPersPatntNoOrdreNaissPers(pt.getNaissanceOrder()));
                            }
                            if (pt.getNas() != null && pt.getNas().matches("[0-9]{9}")) {
                                infoPersPatnt.setNas(of.createTypPersPatntSansIdtInfoPersPatntNas(new BigInteger(pt.getNas())));
                                if (pt.getNaissanceOrder() != null) {
                                    infoPersPatnt.setNoOrdreNaissPers(of.createTypPersPatntSansIdtInfoPersPatntNoOrdreNaissPers(pt.getNaissanceOrder()));
                                }
                            }
                            patnSansId.setInfoPersPatnt(infoPersPatnt);
                            if (pt.getImc() != null) {
                                ((FactServMdcalSpec.ListePersObjetFact.PersPatntSansIdt)patnSansId).setValImcPatnt(of.createFactServMdcalSpecListePersObjetFactPersPatntSansIdtValImcPatnt(pt.getImc()));
                            }
                            if (pt.getAdresse() != null) {
                                TypAdr typAdr = of.createTypAdr();
                                if (StringUtils.isNotEmpty((String)pt.getAdresse().getStreet())) {
                                    typAdr.setAdrLigne1(pt.getAdresse().getStreet());
                                }
                                if (pt.getAdresse().getCity() != null && StringUtils.isNotEmpty((String)pt.getAdresse().getCity().getName())) {
                                    typAdr.setAdrLigne2(of.createTypAdrAdrLigne2(pt.getAdresse().getCity().getName()));
                                }
                                if (pt.getAdresse().getProvince() != null && StringUtils.isNotEmpty((String)pt.getAdresse().getProvince().getName())) {
                                    typAdr.setAdrLigne3(of.createTypAdrAdrLigne3(pt.getAdresse().getProvince().getName()));
                                }
                                if (StringUtils.isNotEmpty((String)pt.getAdresse().getPostalCode())) {
                                    typAdr.setCodPostl(pt.getAdresse().getPostalCode());
                                }
                                patnSansId.setAdrPersPatnt(of.createTypPersPatntSansIdtAdrPersPatnt(typAdr));
                            } else {
                                patnSansId.setAdrPersPatnt(null);
                            }
                            if (pt.getPersRepdn() != null) {
                                CPatient cPatient = pt.getPersRepdn();
                                patntSansIdtPersRepdn = of.createFactServMdcalSpecListePersObjetFactPersPatntSansIdtPersRepdn();
                                if (StringUtils.isNotEmpty((String)cPatient.getIdPersAutre())) {
                                    repdnAvecIdt = of.createTypPersRepdn();
                                    repdnAvecIdt.setTypIdPers(cPatient.getTypIdPersAutre());
                                    repdnAvecIdt.setIdPers(cPatient.getIdPersAutre());
                                    ((FactServMdcalSpec.ListePersObjetFact.PersPatntSansIdt.PersRepdn)patntSansIdtPersRepdn).setRepdnAvecIdt(repdnAvecIdt);
                                } else if (StringUtils.isNotEmpty((String)cPatient.getLastName()) && StringUtils.isNotEmpty((String)cPatient.getFirstName())) {
                                    repdnSansIdt = of.createFactServMdcalSpecListePersObjetFactPersPatntSansIdtPersRepdnRepdnSansIdt();
                                    repdnSansIdt.setNomPers(cPatient.getLastName());
                                    repdnSansIdt.setPrePers(cPatient.getFirstName());
                                    if (StringUtils.isNotEmpty((String)cPatient.bds)) {
                                        repdnSansIdt.setDatNaissPers(of.createTypInfoPersDatNaissPers(dataFactory.newXMLGregorianCalendar(cPatient.bds)));
                                    }
                                    if ((iGender2 = this.getIntegerGenderFromGender(cPatient.getGender())) != null) {
                                        repdnSansIdt.setCodSexePers(of.createTypInfoPersCodSexePers(iGender2));
                                    }
                                    ((FactServMdcalSpec.ListePersObjetFact.PersPatntSansIdt.PersRepdn)patntSansIdtPersRepdn).setRepdnSansIdt((FactServMdcalSpec.ListePersObjetFact.PersPatntSansIdt.PersRepdn.RepdnSansIdt)repdnSansIdt);
                                }
                                ((FactServMdcalSpec.ListePersObjetFact.PersPatntSansIdt)patnSansId).setPersRepdn((FactServMdcalSpec.ListePersObjetFact.PersPatntSansIdt.PersRepdn)patntSansIdtPersRepdn);
                            }
                            patnSansId.setTypSituConsi(ConvertJavaToFromArray.parseInt(typSituConsi));
                            ((FactServMdcalSpec.ListePersObjetFact.PersPatntSansIdt)patnSansId).setInfoMdcalPers(typInfoMedCal);
                            personPatient = patnSansId;
                            listePersObjetFactSpec.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(personPatient);
                            continue;
                        }
                        if (typePerson == ConvertJavaToFromArray.ArrPersType.AUTRE_AVEC_ID.getVal()) {
                            autreAvecId = of.createFactServMdcalSpecListePersObjetFactPersAutreAvecIdt();
                            ((FactServMdcalSpec.ListePersObjetFact.PersAutreAvecIdt)autreAvecId).setTypPersAutre(of.createFactServMdcalSpecListePersObjetFactPersAutreAvecIdtTypPersAutre(pt.getTypPersAutre()));
                            autreAvecId.setTypIdPersAutre(pt.getTypIdPersAutre());
                            autreAvecId.setIdPersAutre(pt.getIdPersAutre());
                            personPatient = autreAvecId;
                            listePersObjetFactSpec.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(personPatient);
                            continue;
                        }
                        if (typePerson != ConvertJavaToFromArray.ArrPersType.AUTRE_SANS_ID.getVal()) continue;
                        autreSansId = of.createFactServMdcalSpecListePersObjetFactPersAutreSansIdt();
                        autreSansId.setNomPers(pt.getLastName());
                        autreSansId.setPrePers(pt.getFirstName());
                        if (pt.getLdbirthDate() != null) {
                            autreSansId.setDatNaissPers(of.createTypInfoPersDatNaissPers(dataFactory.newXMLGregorianCalendar(pt.getLdbirthDate().formatHyphen())));
                        }
                        if ((iGender = this.getIntegerGenderFromGender(pt.getGender())) != null) {
                            autreSansId.setCodSexePers(of.createTypInfoPersCodSexePers(iGender));
                        }
                        ((FactServMdcalSpec.ListePersObjetFact.PersAutreSansIdt)autreSansId).setTypPersAutre(of.createFactServMdcalSpecListePersObjetFactPersAutreSansIdtTypPersAutre(ConvertJavaToFromArray.getInt("1")));
                        personPatient = autreSansId;
                        listePersObjetFactSpec.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(personPatient);
                    }
                }
                int noLigneServ = 1;
                int nbCodeFact = 0;
                if (this.serv.prof.getType() == 1) {
                    fact = of.createFactServMdcalOmni();
                    ((FactServMdcalOmni)fact).setListePersObjetFact(listePersObjetFactOmni);
                    fact.setNoFactExt(this.cNoDemExt);
                    fact.setProf(p);
                    listeLignes = of.createFactServMdcalOmniListeLigneFactServMdcalOmni();
                    if (this.serv.lstLigneFact != null && this.serv.lstLigneFact.size() > 0) {
                        Collections.sort(this.serv.lstLigneFact, compNoLigne);
                        for (CLigneTypServMdcal cLigneTypServMdcal : this.serv.lstLigneFact) {
                            if (cLigneTypServMdcal.codFact != null && cLigneTypServMdcal.codFact.c != null) {
                                line = of.createFactServMdcalOmniListeLigneFactServMdcalOmniLigneFactServMdcalOmni();
                                ((TypLigne)line).setNoLigneFact(this.demForListe.getNoRfp() == null ? noLigneServ++ : cLigneTypServMdcal.noLigne);
                                cal = dataFactory.newXMLGregorianCalendar(cLigneTypServMdcal.dateServ);
                                ((TypLigne)line).setDatServElmFact(cal);
                                if (cLigneTypServMdcal.codFact != null && cLigneTypServMdcal.codFact.c != null) {
                                    ((TypLigne)line).setIdElmFact(cLigneTypServMdcal.codFact.c);
                                    ++nbCodeFact;
                                }
                                ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setCodRole(String.valueOf(cLigneTypServMdcal.codRole));
                                ((TypLigne)line).setTypIdElmFact("1");
                                rpSetElmCtx = new HashSet<Integer>();
                                if (cLigneTypServMdcal.lstElmCx != null && !cLigneTypServMdcal.lstElmCx.isEmpty()) {
                                    lstEmlC = of.createFactServMdcalOmniListeLigneFactServMdcalOmniLigneFactServMdcalOmniListeElmContx();
                                    for (CodeDesc elmCx : cLigneTypServMdcal.lstElmCx) {
                                        int cx = ConvertJavaToFromArray.parseInt(elmCx.c);
                                        if (cx <= 0) continue;
                                        rpSetElmCtx.add(cx);
                                        elmC = of.createFactServMdcalOmniListeLigneFactServMdcalOmniLigneFactServMdcalOmniListeElmContxElmContx();
                                        elmC.setCodElmContx(cx);
                                        ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx)lstEmlC).getElmContx().add((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx.ElmContx)elmC);
                                    }
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setListeElmContx((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx)lstEmlC);
                                }
                                if (!(isSalleUrgence || this.validRP.containsKey(((TypLigne)line).getIdElmFact()) && this.validRP.get(((TypLigne)line).getIdElmFact()) != 1 || rpPtHash == -1)) {
                                    rpCode = ((TypLigne)line).getIdElmFact();
                                    setSpec = SyraPrefAndXmlDataController.getSetSpec(this.serv.prof.getCodSpec());
                                    if (setSpec != null) {
                                        for (String string : setSpec) {
                                            listReglePlafonnement = SyraPrefAndXmlDataController.getListReglePlafonnement(String.valueOf(string) + "~" + rpCode.toString());
                                            if (listReglePlafonnement == null) continue;
                                            lf = new ReglePlafonnementReponse.LigneFact(cal.toGregorianCalendar(), rpCode, rpSetElmCtx);
                                            rpMapCodePlaf.put(lf, listReglePlafonnement);
                                        }
                                    }
                                }
                                if (cLigneTypServMdcal.lstMesur != null && !cLigneTypServMdcal.lstMesur.isEmpty()) {
                                    lstElmMesur = of.createFactServMdcalOmniListeLigneFactServMdcalOmniLigneFactServMdcalOmniListeElmMesur();
                                    for (CLigneTypServMdcal.Mesur mesur : cLigneTypServMdcal.lstMesur) {
                                        TypElmMesur typelmMesur = of.createTypElmMesur();
                                        typelmMesur.setCodElmMesur(mesur.code);
                                        typelmMesur.setValMes(mesur.val);
                                        ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmMesur)lstElmMesur).getElmMesur().add(typelmMesur);
                                    }
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setListeElmMesur((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmMesur)lstElmMesur);
                                }
                                if (cLigneTypServMdcal.dhdElmFact != null && cLigneTypServMdcal.dhdElmFact.length() == 16) {
                                    dh = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(cLigneTypServMdcal.dhdElmFact));
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setDhdElmFact(of.createFactServMdcalOmniListeLigneFactServMdcalOmniLigneFactServMdcalOmniDhdElmFact(dh));
                                }
                                if (cLigneTypServMdcal.dhfElmFact != null && cLigneTypServMdcal.dhfElmFact.length() == 16) {
                                    df = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(cLigneTypServMdcal.dhfElmFact));
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setDhfElmFact(of.createFactServMdcalOmniListeLigneFactServMdcalOmniLigneFactServMdcalOmniDhdElmFact(df));
                                }
                                if (cLigneTypServMdcal.mntPrcuPatnt != null) {
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setMntPrcuPatnt(of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecMntPrcuPatnt(cLigneTypServMdcal.mntPrcuPatnt));
                                }
                                if (cLigneTypServMdcal.codRefreSituSpeci != null) {
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setCodRefreSituSpeci(of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecCodRefreSituSpeci(cLigneTypServMdcal.codRefreSituSpeci));
                                }
                                TypLieuRefreOmni lieuRefOmni = of.createTypLieuRefreOmni();
                                lieuRefOmni.setTypRefreLieu(cLigneTypServMdcal.typRefreLieu);
                                listLieuRefre = of.createTypLieuRefreOmniListeLieuRefre();
                                if (cLigneTypServMdcal.lstLieuEnRef != null && !cLigneTypServMdcal.lstLieuEnRef.isEmpty()) {
                                    for (CLieu cLieu : cLigneTypServMdcal.lstLieuEnRef) {
                                        lieu = null;
                                        if ("N".equals(cLieu.typLocEtab)) {
                                            if (cLieu.local != null && cLieu.local.valCodLocal != null && cLieu.local.valCodLocal.getCodLocal() != null) {
                                                lieu = ConvertJavaToFromArray.getTypIdLieuRefreGeo(ConvertJavaToFromArray.Entente.OMNI, cLieu.local.valCodLocal.getCodLocal(), cLieu.local.typIdLieuGeo, cLieu.local.typLieuGeo == null ? "" : cLieu.local.typLieuGeo, cLieu.local.codPreciLieu == null ? "" : cLieu.local.codPreciLieu);
                                            }
                                        } else if ("C".equals(cLieu.typLocEtab) && cLieu.etab != null && cLieu.etab.noSelectedEtab != null) {
                                            lieu = ConvertJavaToFromArray.getTypIdLieuRefrePhys(ConvertJavaToFromArray.Entente.OMNI, cLieu.etab.noSelectedEtab, "1", cLieu.etab.codPreciLieu == null ? "" : cLieu.etab.codPreciLieu, cLieu.etab.codPreciSectActiv == null ? "" : cLieu.etab.codPreciSectActiv.toString(), cLieu.etab.valSect == null || cLieu.etab.valSect.getNoSectActiv() == null ? "" : cLieu.etab.valSect.getNoSectActiv());
                                        }
                                        if (lieu == null) continue;
                                        ((TypLieuRefreOmni.ListeLieuRefre)listLieuRefre).getLieuRefrePhysOrLieuRefreGeo().add(lieu);
                                    }
                                }
                                if (((TypLieuRefreOmni.ListeLieuRefre)listLieuRefre).getLieuRefrePhysOrLieuRefreGeo().size() > 0) {
                                    lieuRefOmni.setListeLieuRefre((TypLieuRefreOmni.ListeLieuRefre)listLieuRefre);
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setLieuEnRefre(lieuRefOmni);
                                }
                                FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf refreAutreProf = of.createFactServMdcalOmniListeLigneFactServMdcalOmniLigneFactServMdcalOmniRefreAutreProf();
                                refreAutreProf.setTypRefreAutreProf(cLigneTypServMdcal.typRefreAutreProf);
                                infoProfRefre = of.createFactServMdcalOmniListeLigneFactServMdcalOmniLigneFactServMdcalOmniRefreAutreProfInfoProfRefre();
                                if (StringUtils.isNotEmpty((String)cLigneTypServMdcal.idProfRefConnu)) {
                                    prof = of.createTypProf();
                                    ((TypProf)prof).setIdProf(cLigneTypServMdcal.idProfRefConnu);
                                    ((TypProf)prof).setTypIdProf(cLigneTypServMdcal.typIdProfRefreConnu);
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf.InfoProfRefre)infoProfRefre).setProfRefreConnu((TypProf)prof);
                                    refreAutreProf.setInfoProfRefre((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf.InfoProfRefre)infoProfRefre);
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setRefreAutreProf(refreAutreProf);
                                } else if (StringUtils.isNotEmpty((String)cLigneTypServMdcal.nomProfRefre)) {
                                    prof = of.createTypProfNonConnu();
                                    ((TypProfNonConnu)prof).setCodTerriProfRefre(cLigneTypServMdcal.codTerriProfRefre);
                                    ((TypProfNonConnu)prof).setTypPrfsnProf(cLigneTypServMdcal.typPrfsnProfRefre);
                                    ((TypProfNonConnu)prof).setPreProf(cLigneTypServMdcal.preProfRefre);
                                    ((TypProfNonConnu)prof).setNomProf(cLigneTypServMdcal.nomProfRefre);
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf.InfoProfRefre)infoProfRefre).setProfRefreNonConnu((TypProfNonConnu)prof);
                                    refreAutreProf.setInfoProfRefre((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf.InfoProfRefre)infoProfRefre);
                                    ((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line).setRefreAutreProf(refreAutreProf);
                                }
                                ((FactServMdcalOmni.ListeLigneFactServMdcalOmni)listeLignes).getLigneFactServMdcalOmni().add((FactServMdcalOmni.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)line);
                            }
                            ((FactServMdcalOmni)fact).setListeLigneFactServMdcalOmni((FactServMdcalOmni.ListeLigneFactServMdcalOmni)listeLignes);
                        }
                    } else if (ready) {
                        throw new Exception("Une facture doit avoir au moins une ligne de service.");
                    }
                    FactServMdcalOmni.ListeElmContx listeElmContx = of.createFactServMdcalOmniListeElmContx();
                    if (this.serv.lstElmCx != null) {
                        for (CtxFact cxFact : this.serv.lstElmCx) {
                            listeElmContxElmContx = of.createFactServMdcalOmniListeElmContxElmContx();
                            int code = ConvertJavaToFromArray.parseInt(cxFact.codeCtx.c);
                            if (code == 0) continue;
                            listeElmContxElmContx.setCodElmContx(code);
                            if (cxFact.codeLie != null) {
                                ((FactServMdcalOmni.ListeElmContx.ElmContx)listeElmContxElmContx).setCodFactLieElmContx(of.createFactServMdcalOmniListeElmContxElmContxCodFactLieElmContx(cxFact.codeLie));
                            }
                            listeElmContx.getElmContx().add((FactServMdcalOmni.ListeElmContx.ElmContx)listeElmContxElmContx);
                        }
                    }
                    if (listeElmContx.getElmContx().size() > 0) {
                        ((FactServMdcalOmni)fact).setListeElmContx(listeElmContx);
                    }
                    if (this.serv.indFactAssDr != null && this.serv.indFactAssDr.booleanValue()) {
                        ((FactServMdcalOmni)fact).setIndFactAssocDr(of.createFactServMdcalOmniIndFactAssocDr(this.serv.indFactAssDr));
                    }
                    if (StringUtils.isNotEmpty((String)this.serv.dhdInterAutreMd)) {
                        if (this.serv.dhdInterAutreMd.length() == 16) {
                            XMLGregorianCalendar dh2 = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(this.serv.dhdInterAutreMd));
                            ((FactServMdcalOmni)fact).setDhdInterAutreMd(of.createFactServMdcalOmniDhdInterAutreMd(dh2));
                        } else if (ready) {
                            throw new Exception("Erreur Date-Heure D\u00e9but autre Med: " + this.serv.dhdInterAutreMd);
                        }
                    }
                    if (StringUtils.isNotEmpty((String)this.serv.dhdPerTravProf)) {
                        if (this.serv.dhdPerTravProf.length() == 16) {
                            XMLGregorianCalendar dh3 = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(this.serv.dhdPerTravProf));
                            ((FactServMdcalOmni)fact).setDhdPerTravProf(of.createFactServMdcalOmniDhdPerTravProf(dh3));
                        } else if (ready) {
                            throw new Exception("Erreur Date-Heure Per Trav Prof: " + this.serv.dhdPerTravProf);
                        }
                    }
                    if (StringUtils.isNotEmpty((String)this.serv.noAutor)) {
                        ((FactServMdcalOmni)fact).setNoAutor(of.createFactServMdcalOmniNoAutor(this.serv.noAutor));
                    }
                    FactServMdcalOmni.LieuConsi lieu2 = of.createFactServMdcalOmniLieuConsi();
                    if ("C".equals(this.serv.lieu.typLocEtab) && this.serv.lieu.etab != null) {
                        lp = of.createTypLieuPhysOmni();
                        if (StringUtils.isNotEmpty((String)this.serv.lieu.etab.codPreciLieu) && !"0".equals(this.serv.lieu.etab.codPreciLieu) && this.serv.lieu.etab.codPreciLieu.length() == 1) {
                            ((TypLieuPhysOmni)lp).setCodPreciLieu(of.createTypLieuPhysOmniCodPreciLieu(this.serv.lieu.etab.codPreciLieu));
                        }
                        if (StringUtils.isNotEmpty((String)this.serv.lieu.etab.getNoSelectedEtab())) {
                            lp.setIdLieuPhys(this.serv.lieu.etab.getNoSelectedEtab());
                            lp.setTypIdLieuPhys("1");
                            if (this.serv.lieu.etab.codPreciSectActiv != null && !"0".equals(this.serv.lieu.etab.codPreciSectActiv)) {
                                ((TypLieuPhysOmni)lp).setCodPreciSectActiv(of.createTypLieuPhysOmniCodPreciSectActiv(this.serv.lieu.etab.codPreciSectActiv));
                            }
                            if (this.serv.lieu.etab.valSect != null && StringUtils.isNotEmpty((String)this.serv.lieu.etab.valSect.getNoSectActiv())) {
                                ((TypLieuPhysOmni)lp).setNoSectActiv(of.createTypLieuPhysOmniNoSectActiv(Integer.valueOf(this.serv.lieu.etab.valSect.getNoSectActiv())));
                            }
                            lieu2.setLieuPhys((TypLieuPhysOmni)lp);
                        }
                    } else if ("N".equals(this.serv.lieu.typLocEtab) && this.serv.lieu.local != null) {
                        lg = of.createTypLieuGeoOmni();
                        if (StringUtils.isNotEmpty((String)this.serv.lieu.local.codPreciLieu) && !"0".equals(this.serv.lieu.local.codPreciLieu) && this.serv.lieu.local.codPreciLieu.length() == 1) {
                            ((TypLieuGeoOmni)lg).setCodPreciLieu(of.createTypLieuPhysOmniCodPreciLieu(this.serv.lieu.local.codPreciLieu));
                        }
                        lg.setTypIdLieuGeo(this.serv.lieu.local.typIdLieuGeo);
                        if (this.serv.lieu.local.typLieuGeo != null) {
                            ((TypLieuGeoOmni)lg).setTypLieuGeo(this.serv.lieu.local.typLieuGeo);
                        }
                        if (StringUtils.isNotEmpty((String)this.serv.lieu.local.valCodLocal.getCodLocal())) {
                            lg.setIdLieuGeo(this.serv.lieu.local.valCodLocal.getCodLocal());
                            lieu2.setLieuGeo((TypLieuGeoOmni)lg);
                        }
                    }
                    if (lieu2.getLieuGeo() == null && lieu2.getLieuPhys() == null) {
                        throw new Exception("Absence du lieu de dispensation du service.");
                    }
                    ((FactServMdcalOmni)fact).setLieuConsi(lieu2);
                    lFact = new DemPaimt.ListeFact();
                    lFact.setFactBase(of.createFactServMdcalOmni((FactServMdcalOmni)fact));
                    pmt.setListeFact(lFact);
                } else if (this.serv.prof.getType() == 2) {
                    fact = of.createFactServMdcalSpec();
                    ((FactServMdcalSpec)fact).setListePersObjetFact(listePersObjetFactSpec);
                    fact.setNoFactExt(this.cNoDemExt);
                    fact.setProf(p);
                    listeLignes = of.createFactServMdcalSpecListeLigneFactServMdcalSpec();
                    if (this.serv.lstLigneFact != null) {
                        Collections.sort(this.serv.lstLigneFact, compNoLigneAbsAsc);
                        for (CLigneTypServMdcal cLigneTypServMdcal : this.serv.lstLigneFact) {
                            if (cLigneTypServMdcal.codFact != null && cLigneTypServMdcal.codFact.c != null) {
                                line = of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpec();
                                ((TypLigne)line).setNoLigneFact(this.demForListe.getNoRfp() == null ? noLigneServ++ : cLigneTypServMdcal.noLigne);
                                cal = dataFactory.newXMLGregorianCalendar(cLigneTypServMdcal.dateServ);
                                ((TypLigne)line).setDatServElmFact(cal);
                                if (cLigneTypServMdcal.codFact != null && cLigneTypServMdcal.codFact.c != null) {
                                    ((TypLigne)line).setIdElmFact(cLigneTypServMdcal.codFact.c);
                                    ++nbCodeFact;
                                }
                                ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setCodRole(String.valueOf(cLigneTypServMdcal.codRole));
                                ((TypLigne)line).setTypIdElmFact("1");
                                rpSetElmCtx = new HashSet();
                                if (cLigneTypServMdcal.lstElmCx != null && !cLigneTypServMdcal.lstElmCx.isEmpty()) {
                                    lstEmlC = of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecListeElmContx();
                                    for (CodeDesc elmCx : cLigneTypServMdcal.lstElmCx) {
                                        int cx = ConvertJavaToFromArray.parseInt(elmCx.c);
                                        if (cx <= 0) continue;
                                        rpSetElmCtx.add(cx);
                                        elmC = of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecListeElmContxElmContx();
                                        elmC.setCodElmContx(cx);
                                        ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx)lstEmlC).getElmContx().add((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx.ElmContx)elmC);
                                    }
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setListeElmContx((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx)lstEmlC);
                                }
                                if (!(isSalleUrgence || this.validRP.containsKey(((TypLigne)line).getIdElmFact()) && this.validRP.get(((TypLigne)line).getIdElmFact()) != 1 || rpPtHash == -1)) {
                                    rpCode = ((TypLigne)line).getIdElmFact();
                                    setSpec = SyraPrefAndXmlDataController.getSetSpec(this.serv.prof.getCodSpec());
                                    if (setSpec != null) {
                                        for (String string : setSpec) {
                                            listReglePlafonnement = SyraPrefAndXmlDataController.getListReglePlafonnement(String.valueOf(string) + "~" + rpCode.toString());
                                            if (listReglePlafonnement == null) continue;
                                            lf = new ReglePlafonnementReponse.LigneFact(cal.toGregorianCalendar(), rpCode, rpSetElmCtx);
                                            rpMapCodePlaf.put(lf, listReglePlafonnement);
                                        }
                                    }
                                }
                                if (cLigneTypServMdcal.lstMesur != null && !cLigneTypServMdcal.lstMesur.isEmpty()) {
                                    lstElmMesur = of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecListeElmMesur();
                                    for (CLigneTypServMdcal.Mesur mesur : cLigneTypServMdcal.lstMesur) {
                                        TypElmMesur typelmMesur = of.createTypElmMesur();
                                        typelmMesur.setCodElmMesur(mesur.code);
                                        typelmMesur.setValMes(mesur.val);
                                        ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmMesur)lstElmMesur).getElmMesur().add(typelmMesur);
                                    }
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setListeElmMesur((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmMesur)lstElmMesur);
                                }
                                if (cLigneTypServMdcal.dhdElmFact != null && cLigneTypServMdcal.dhdElmFact.length() == 16) {
                                    dh = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(cLigneTypServMdcal.dhdElmFact));
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setDhdElmFact(of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecDhdElmFact(dh));
                                }
                                if (cLigneTypServMdcal.dhfElmFact != null && cLigneTypServMdcal.dhfElmFact.length() == 16) {
                                    df = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(cLigneTypServMdcal.dhfElmFact));
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setDhfElmFact(of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecDhdElmFact(df));
                                }
                                if (cLigneTypServMdcal.mntPrcuPatnt != null) {
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setMntPrcuPatnt(of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecMntPrcuPatnt(cLigneTypServMdcal.mntPrcuPatnt));
                                }
                                if (cLigneTypServMdcal.codRefreSituSpeci != null) {
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setCodRefreSituSpeci(of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecCodRefreSituSpeci(cLigneTypServMdcal.codRefreSituSpeci));
                                }
                                if (cLigneTypServMdcal.codOmim != null) {
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setCodOmim(of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecCodOmim(cLigneTypServMdcal.codOmim));
                                }
                                TypLieuRefreSpec lieuRefSpec = of.createTypLieuRefreSpec();
                                lieuRefSpec.setTypRefreLieu(cLigneTypServMdcal.typRefreLieu);
                                listLieuRefre = of.createTypLieuRefreSpecListeLieuRefre();
                                if (cLigneTypServMdcal.lstLieuEnRef != null && !cLigneTypServMdcal.lstLieuEnRef.isEmpty()) {
                                    for (CLieu cLieu : cLigneTypServMdcal.lstLieuEnRef) {
                                        lieu = null;
                                        if ("N".equals(cLieu.typLocEtab)) {
                                            if (cLieu.local != null && cLieu.local.valCodLocal != null && cLieu.local.valCodLocal.getCodLocal() != null) {
                                                lieu = ConvertJavaToFromArray.getTypIdLieuRefreGeo(ConvertJavaToFromArray.Entente.SPEC, cLieu.local.valCodLocal.getCodLocal(), cLieu.local.typIdLieuGeo, cLieu.local.typLieuGeo == null ? "" : cLieu.local.typLieuGeo, cLieu.local.codPreciLieu == null ? "" : cLieu.local.codPreciLieu);
                                            }
                                        } else if ("C".equals(cLieu.typLocEtab) && cLieu.etab != null && cLieu.etab.noSelectedEtab != null) {
                                            lieu = ConvertJavaToFromArray.getTypIdLieuRefrePhys(ConvertJavaToFromArray.Entente.SPEC, cLieu.etab.noSelectedEtab, "1", cLieu.etab.codPreciLieu == null ? "" : cLieu.etab.codPreciLieu, cLieu.etab.codPreciSectActiv == null ? "" : cLieu.etab.codPreciSectActiv.toString(), cLieu.etab.valSect == null || cLieu.etab.valSect.getNoSectActiv() == null ? "" : cLieu.etab.valSect.getNoSectActiv());
                                        }
                                        if (lieu == null) continue;
                                        ((TypLieuRefreSpec.ListeLieuRefre)listLieuRefre).getLieuRefrePhysOrLieuRefreGeo().add(lieu);
                                    }
                                }
                                if (((TypLieuRefreSpec.ListeLieuRefre)listLieuRefre).getLieuRefrePhysOrLieuRefreGeo().size() > 0) {
                                    lieuRefSpec.setListeLieuRefre((TypLieuRefreSpec.ListeLieuRefre)listLieuRefre);
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setLieuEnRefre(lieuRefSpec);
                                }
                                FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf refreAutreProf = of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecRefreAutreProf();
                                refreAutreProf.setTypRefreAutreProf(cLigneTypServMdcal.typRefreAutreProf);
                                infoProfRefre = of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecRefreAutreProfInfoProfRefre();
                                if (StringUtils.isNotEmpty((String)cLigneTypServMdcal.idProfRefConnu)) {
                                    prof = of.createTypProf();
                                    ((TypProf)prof).setIdProf(cLigneTypServMdcal.idProfRefConnu);
                                    ((TypProf)prof).setTypIdProf(cLigneTypServMdcal.typIdProfRefreConnu);
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf.InfoProfRefre)infoProfRefre).setProfRefreConnu((TypProf)prof);
                                    refreAutreProf.setInfoProfRefre((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf.InfoProfRefre)infoProfRefre);
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setRefreAutreProf(refreAutreProf);
                                } else if (StringUtils.isNotEmpty((String)cLigneTypServMdcal.nomProfRefre)) {
                                    prof = of.createTypProfNonConnu();
                                    ((TypProfNonConnu)prof).setCodTerriProfRefre(cLigneTypServMdcal.codTerriProfRefre);
                                    ((TypProfNonConnu)prof).setTypPrfsnProf(cLigneTypServMdcal.typPrfsnProfRefre);
                                    ((TypProfNonConnu)prof).setPreProf(cLigneTypServMdcal.preProfRefre);
                                    ((TypProfNonConnu)prof).setNomProf(cLigneTypServMdcal.nomProfRefre);
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf.InfoProfRefre)infoProfRefre).setProfRefreNonConnu((TypProfNonConnu)prof);
                                    refreAutreProf.setInfoProfRefre((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf.InfoProfRefre)infoProfRefre);
                                    ((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line).setRefreAutreProf(refreAutreProf);
                                }
                                if (StringUtils.isNotEmpty((String)cLigneTypServMdcal.dhDemConsult)) {
                                    XMLGregorianCalendar df2 = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(cLigneTypServMdcal.dhDemConsult));
                                    refreAutreProf.setDhDemCnsul(of.createFactServMdcalSpecListeLigneFactServMdcalSpecLigneFactServMdcalSpecRefreAutreProfDhDemCnsul(df2));
                                }
                                ((FactServMdcalSpec.ListeLigneFactServMdcalSpec)listeLignes).getLigneFactServMdcalSpec().add((FactServMdcalSpec.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)line);
                            }
                            ((FactServMdcalSpec)fact).setListeLigneFactServMdcalSpec((FactServMdcalSpec.ListeLigneFactServMdcalSpec)listeLignes);
                        }
                    }
                    FactServMdcalSpec.ListeElmContx listeElmContx = of.createFactServMdcalSpecListeElmContx();
                    if (this.serv.lstElmCx != null) {
                        for (CtxFact cxFact : this.serv.lstElmCx) {
                            listeElmContxElmContx = of.createFactServMdcalSpecListeElmContxElmContx();
                            int code = ConvertJavaToFromArray.parseInt(cxFact.codeCtx.c);
                            if (code == 0) continue;
                            listeElmContxElmContx.setCodElmContx(code);
                            if (cxFact.codeLie != null) {
                                ((FactServMdcalSpec.ListeElmContx.ElmContx)listeElmContxElmContx).setCodFactLieElmContx(of.createFactServMdcalSpecListeElmContxElmContxCodFactLieElmContx(cxFact.codeLie));
                            }
                            listeElmContx.getElmContx().add((FactServMdcalSpec.ListeElmContx.ElmContx)listeElmContxElmContx);
                        }
                    }
                    if (listeElmContx.getElmContx().size() > 0) {
                        ((FactServMdcalSpec)fact).setListeElmContx(listeElmContx);
                    }
                    if (this.serv.indFactAssDr != null && this.serv.indFactAssDr.booleanValue()) {
                        ((FactServMdcalSpec)fact).setIndFactAssocDr(of.createFactServMdcalSpecIndFactAssocDr(this.serv.indFactAssDr));
                    }
                    if (StringUtils.isNotEmpty((String)this.serv.dhdInterAutreMd)) {
                        if (this.serv.dhdInterAutreMd.length() == 16) {
                            XMLGregorianCalendar dh4 = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(this.serv.dhdInterAutreMd));
                            ((FactServMdcalSpec)fact).setDhdInterAutreMd(of.createFactServMdcalSpecDhdInterAutreMd(dh4));
                        } else if (ready) {
                            throw new Exception("Erreur Date-Heure D\u00e9but autre Med: " + this.serv.dhdInterAutreMd);
                        }
                    }
                    if (StringUtils.isNotEmpty((String)this.serv.dhdPerTravProf)) {
                        if (this.serv.dhdPerTravProf.length() == 16) {
                            XMLGregorianCalendar dh5 = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(this.serv.dhdPerTravProf));
                            ((FactServMdcalSpec)fact).setDhdPerTravProf(of.createFactServMdcalSpecDhdPerTravProf(dh5));
                        } else if (ready) {
                            throw new Exception("Erreur Date-Heure Per Trav Prof: " + this.serv.dhdPerTravProf);
                        }
                    }
                    if (this.serv.noAutor != null) {
                        ((FactServMdcalSpec)fact).setNoAutor(of.createFactServMdcalSpecNoAutor(this.serv.noAutor));
                    }
                    FactServMdcalSpec.LieuConsi lieu3 = of.createFactServMdcalSpecLieuConsi();
                    if ("C".equals(this.serv.lieu.typLocEtab) && this.serv.lieu.etab != null) {
                        lp = of.createTypLieuPhysSpec();
                        if (StringUtils.isNotEmpty((String)this.serv.lieu.etab.codPreciLieu) && !"0".equals(this.serv.lieu.etab.codPreciLieu) && this.serv.lieu.etab.codPreciLieu.length() == 1) {
                            ((TypLieuPhysSpec)lp).setCodPreciLieu(of.createTypLieuPhysSpecCodPreciLieu(this.serv.lieu.etab.codPreciLieu));
                        }
                        if (StringUtils.isNotEmpty((String)this.serv.lieu.etab.getNoSelectedEtab())) {
                            lp.setIdLieuPhys(this.serv.lieu.etab.getNoSelectedEtab());
                            lp.setTypIdLieuPhys("1");
                            if (this.serv.lieu.etab.codPreciSectActiv != null && !"0".equals(this.serv.lieu.etab.codPreciSectActiv)) {
                                ((TypLieuPhysSpec)lp).setCodPreciSectActiv(of.createTypLieuPhysSpecCodPreciSectActiv(this.serv.lieu.etab.codPreciSectActiv));
                            }
                            if (this.serv.lieu.etab.valSect != null && StringUtils.isNotEmpty((String)this.serv.lieu.etab.valSect.getNoSectActiv())) {
                                ((TypLieuPhysSpec)lp).setNoSectActiv(of.createTypLieuPhysSpecNoSectActiv(Integer.valueOf(this.serv.lieu.etab.valSect.getNoSectActiv())));
                            }
                            lieu3.setLieuPhys((TypLieuPhysSpec)lp);
                        }
                    } else if ("N".equals(this.serv.lieu.typLocEtab) && this.serv.lieu.local != null) {
                        lg = of.createTypLieuGeoSpec();
                        if (StringUtils.isNotEmpty((String)this.serv.lieu.local.codPreciLieu) && !"0".equals(this.serv.lieu.local.codPreciLieu) && this.serv.lieu.local.codPreciLieu.length() == 1) {
                            ((TypLieuGeoSpec)lg).setCodPreciLieu(of.createTypLieuPhysSpecCodPreciLieu(this.serv.lieu.local.codPreciLieu));
                        }
                        lg.setTypIdLieuGeo(this.serv.lieu.local.typIdLieuGeo);
                        if (this.serv.lieu.local.typLieuGeo != null) {
                            ((TypLieuGeoSpec)lg).setTypLieuGeo(this.serv.lieu.local.typLieuGeo);
                        }
                        if (StringUtils.isNotEmpty((String)this.serv.lieu.local.valCodLocal.getCodLocal())) {
                            lg.setIdLieuGeo(this.serv.lieu.local.valCodLocal.getCodLocal());
                            lieu3.setLieuGeo((TypLieuGeoSpec)lg);
                        }
                    }
                    if (lieu3.getLieuGeo() == null && lieu3.getLieuPhys() == null) {
                        throw new Exception("Absence du lieu de dispensation du service.");
                    }
                    ((FactServMdcalSpec)fact).setLieuConsi(lieu3);
                    lFact = new DemPaimt.ListeFact();
                    lFact.setFactBase(of.createFactServMdcalSpec((FactServMdcalSpec)fact));
                    pmt.setListeFact(lFact);
                }
                if (nbCodeFact == 0 && ready) {
                    throw new Exception("Une facture doit avoir au moins une ligne de service.");
                }
                if (!rpMapCodePlaf.isEmpty()) {
                    Set setLF = rpMapCodePlaf.keySet();
                    ArrayList<String> archiveWhere = new ArrayList<String>();
                    for (ReglePlafonnementReponse.LigneFact ligneFact : setLF) {
                        List lstRP = (List)rpMapCodePlaf.get(ligneFact);
                        HashSet<Integer> groupeDeCode = new HashSet<Integer>();
                        Calendar dateSince = (Calendar)ligneFact.d.clone();
                        for (ReglePlafonnement rp : lstRP) {
                            this.dateSince(dateSince, rp);
                            groupeDeCode.addAll(rp.getGroupeDeCode());
                        }
                        archiveWhere.add("(a.ar_code in (" + new JoinList(",", groupeDeCode).toString() + ") and ar_cdetabl!~'([04])([0-9]{3})(7)' and a.ar_date>=to_date('" + DateUtil.dtoc((Calendar)dateSince) + "','yyyy-MM-dd'))");
                    }
                    HashMap<Integer, List<ReglePlafonnementReponse>> hashMap = new HashMap<Integer, List<ReglePlafonnementReponse>>();
                    List lstArchive = BaseArchive_dpacteDAO.getInstance().findArchiveFacturation(rpPtHash, this.serv.prof.getNoProf(), this.demForListe.getNoRfp(), new JoinList(" OR ", archiveWhere).toString());
                    HashMap<Integer, Object> mapCodeCnt = new HashMap<Integer, Object>();
                    for (Archive_dpacteDAO.ArchDpActeDateCode ar : lstArchive) {
                        Integer codeFact = null;
                        for (ReglePlafonnementReponse.LigneFact lf3 : setLF) {
                            List lstRP = (List)rpMapCodePlaf.get(lf3);
                            for (ReglePlafonnement rp : lstRP) {
                                if (!rp.getGroupeDeCode().contains(ar.getAr_code())) continue;
                                codeFact = new Integer(lf3.c.intValue());
                                break;
                            }
                            if (codeFact != null) break;
                        }
                        if (codeFact == null) continue;
                        Object cntCode = (Integer)mapCodeCnt.get(codeFact);
                        if (cntCode == null) {
                            cntCode = new Integer(1);
                            mapCodeCnt.put(codeFact, cntCode);
                            continue;
                        }
                        mapCodeCnt.put(codeFact, new Integer((Integer)cntCode + 1));
                    }
                    HashMap<Integer, CodeBigIntCodFact> mapCR = new HashMap<Integer, CodeBigIntCodFact>();
                    HashMap<Integer, CodeDesc> mapEC = new HashMap<Integer, CodeDesc>();
                    block18: for (ReglePlafonnementReponse.LigneFact lf4 : setLF) {
                        List list = (List)rpMapCodePlaf.get(lf4);
                        Integer bigCode = new Integer(lf4.c.intValue());
                        for (ReglePlafonnement rp : list) {
                            List<ReglePlafonnementReponse> lstRpr;
                            ReglePlafonnementReponse rpr;
                            Calendar arDate = null;
                            ArrayList<ReglePlafonnementReponse.LigneFact> lfps = new ArrayList<ReglePlafonnementReponse.LigneFact>();
                            int nbCode = 0;
                            for (Archive_dpacteDAO.ArchDpActeDateCode ar : lstArchive) {
                                if (!rp.groupeDeCode.contains(ar.getAr_code())) continue;
                                nbCode = (Integer)mapCodeCnt.get(new Integer(lf4.c.intValue()));
                                arDate = Calendar.getInstance();
                                arDate.set(ar.getAr_date().get(1), ar.getAr_date().get(2), ar.getAr_date().get(5), 12, 0, 0);
                                arDate.set(14, 0);
                                lfps.add(new ReglePlafonnementReponse.LigneFact(arDate, BigInteger.valueOf(ar.getAr_code().intValue()), null));
                            }
                            if (arDate == null || nbCode < rp.maxPermis) continue;
                            boolean hasEC = false;
                            Calendar dateSince = Calendar.getInstance();
                            dateSince.setTime(lf4.d.getTime());
                            this.dateSince(dateSince, rp);
                            if (!rp.elmCtx.isEmpty()) {
                                if (!lf4.ec.isEmpty()) {
                                    for (Integer ecp : lf4.ec) {
                                        for (Integer eca : rp.elmCtx) {
                                            if (!eca.equals(ecp)) continue;
                                            hasEC = true;
                                            break;
                                        }
                                        if (hasEC) break;
                                    }
                                }
                                rpr = new ReglePlafonnementReponse();
                                rpr.lf = lf4;
                                rpr.lfps = lfps;
                                rpr.rp = rp.clone();
                                if (hasEC) {
                                    if (!arDate.before(dateSince)) continue;
                                    hashMap.remove(bigCode);
                                    continue block18;
                                }
                                if (!arDate.before(dateSince)) continue;
                                lstRpr = hashMap.get(bigCode);
                                if (lstRpr == null) {
                                    lstRpr = new ArrayList<ReglePlafonnementReponse>();
                                    hashMap.put(bigCode, lstRpr);
                                }
                                lstRpr.add(rpr);
                                continue;
                            }
                            if (arDate.before(dateSince)) {
                                hashMap.remove(bigCode);
                                continue block18;
                            }
                            rpr = new ReglePlafonnementReponse();
                            rpr.lf = lf4;
                            rpr.lfps = lfps;
                            rpr.rp = rp;
                            lstRpr = hashMap.get(bigCode);
                            if (lstRpr == null) {
                                lstRpr = new ArrayList<ReglePlafonnementReponse>();
                                hashMap.put(bigCode, lstRpr);
                            }
                            lstRpr.add(rpr);
                        }
                    }
                    if (!hashMap.isEmpty()) {
                        Set keySet = hashMap.keySet();
                        HashSet<String> setLfToString = new HashSet<String>();
                        QueryCriteria.EtablType etablType = QueryCriteria.EtablType.CABINET;
                        CLieu lieu4 = cDemContainer.getCurrentLieu(null);
                        if ("C".equals(lieu4.typLocEtab) && lieu4.etab != null && lieu4.etab.getValEtab() != null && "ETAB".equals(lieu4.etab.getValEtab().getTypEtab())) {
                            QueryCriteria.EtablType etablType2 = QueryCriteria.EtablType.ETABLISSEMENT;
                        }
                        for (Integer bi : keySet) {
                            List listRPR = (List)hashMap.get(bi);
                            for (ReglePlafonnementReponse rpr : listRPR) {
                                String date = DateUtil.dtoc((Calendar)rpr.lf.d);
                                setLfToString.add(new JoinList(", ", rpr.lfps).toString());
                                rpr.rp.setDescription(rpr.rp.toString());
                                CodeBigIntCodFact codeFact = (CodeBigIntCodFact)mapCR.get(rpr.rp.codeRechange);
                                if (codeFact == null && rpr.rp.codeRechange != null) {
                                    void var26_115;
                                    Integer iRole = new Integer(1);
                                    BigInteger bCodeRC = BigInteger.valueOf(rpr.rp.codeRechange.longValue());
                                    codeFact = ConvertJavaToFromArray.Entente.OMNI.getVal() == this.serv.prof.getType().intValue() ? CLigneTypServMdcal.getCodFactOmni(cDemContainer, SyraPlugin.syraController, this.serv.prof.getId(), true, bCodeRC, null, date, iRole, (QueryCriteria.EtablType)var26_115) : CLigneTypServMdcal.getCodFactSpec(cDemContainer, SyraPlugin.syraController, this.serv.prof.getId(), true, bCodeRC, null, date, iRole, (QueryCriteria.EtablType)var26_115);
                                    mapCR.put(rpr.rp.codeRechange, codeFact);
                                }
                                rpr.rp.setCrObj(codeFact);
                                for (Integer ec : rpr.rp.elmCtx) {
                                    CodeDesc ecCD = (CodeDesc)mapEC.get(ec);
                                    if (ecCD != null) continue;
                                    String codeEC = String.valueOf(ec);
                                    ecCD = new CodeDesc(codeEC, SyraPlugin.syraController.getElmContxDesc(this.serv.prof.getId(), codeEC, date, QueryCriteria.CodNiveau.LIGNE_SERV_MDCAL));
                                    mapEC.put(ec, ecCD);
                                }
                                rpr.rp.mapEC = mapEC;
                            }
                        }
                        String lfToStr = new JoinList("; ", setLfToString).toString();
                        String s = setLfToString.size() > 1 || lfToStr.contains(",") ? "s" : "";
                        throw new ValidReglePlafException("Service" + s + " ant\u00e9rieur" + s + " factur\u00e9" + s + ": " + lfToStr, hashMap);
                    }
                }
            }
        } else if (this.depl != null && this.depl.prof != null) {
            TypElmContx elmContx;
            Object lstElmC;
            TypProf p = new TypProf();
            p.setIdProf(this.depl.prof.getNoProf());
            p.setTypIdProf(1);
            int noLigneServ = 1;
            FactFraisDepla fact = of.createFactFraisDepla();
            fact.setNoFactExt(this.cNoDemExt);
            fact.setProf(p);
            FactFraisDepla.LieuDepla lieuDepla = of.createFactFraisDeplaLieuDepla();
            FactFraisDepla.LieuDepla.LieuDeparDepla deplaLieuDeplaDep = null;
            if ("C".equals(this.depl.lieuDep.typLocEtab) && this.depl.lieuDep.etab != null) {
                TypIdLieuPhys typIdLieuPhysDep = ConvertJavaToFromArray.getTypIdLieuPhys(this.depl.lieuDep.etab.getNoSelectedEtab(), "1");
                deplaLieuDeplaDep = of.createFactFraisDeplaLieuDeplaLieuDeparDepla();
                deplaLieuDeplaDep.setLieuDeplaPhys(typIdLieuPhysDep);
            } else if ("N".equals(this.depl.lieuDep.typLocEtab) && this.depl.lieuDep.local != null && this.depl.lieuDep.local.valCodLocal != null) {
                TypIdLieuGeo typIdLieuGeoDep = ConvertJavaToFromArray.getTypIdLieuGeo(this.depl.lieuDep.local.valCodLocal.getCodLocal(), this.depl.lieuDep.local.typIdLieuGeo);
                deplaLieuDeplaDep = of.createFactFraisDeplaLieuDeplaLieuDeparDepla();
                deplaLieuDeplaDep.setLieuDeplaGeo(typIdLieuGeoDep);
            }
            if (deplaLieuDeplaDep == null) {
                throw new Exception("Absence du lieu de d\u00e9part.");
            }
            lieuDepla.setLieuDeparDepla(deplaLieuDeplaDep);
            FactFraisDepla.LieuDepla.LieuArrivDepla deplaLieuDeplaArr = null;
            if ("C".equals(this.depl.lieuArr.typLocEtab) && this.depl.lieuArr.etab != null) {
                TypIdLieuPhys typIdLieuPhysArr = ConvertJavaToFromArray.getTypIdLieuPhys(this.depl.lieuArr.etab.getNoSelectedEtab(), "1");
                deplaLieuDeplaArr = of.createFactFraisDeplaLieuDeplaLieuArrivDepla();
                deplaLieuDeplaArr.setLieuDeplaPhys(typIdLieuPhysArr);
            } else if ("N".equals(this.depl.lieuArr.typLocEtab)) {
                TypIdLieuGeo typIdLieuGeoArr = ConvertJavaToFromArray.getTypIdLieuGeo(this.depl.lieuArr.local.valCodLocal.getCodLocal(), this.depl.lieuArr.local.typIdLieuGeo);
                deplaLieuDeplaArr = of.createFactFraisDeplaLieuDeplaLieuArrivDepla();
                deplaLieuDeplaArr.setLieuDeplaGeo(typIdLieuGeoArr);
            }
            if (deplaLieuDeplaArr == null) {
                throw new Exception("Absence du lieu d'arriv\u00e9e.");
            }
            lieuDepla.setLieuArrivDepla(deplaLieuDeplaArr);
            if (this.depl.dhDepDeplaDT == null) {
                throw new Exception("Absence de la date de d\u00e9part.");
            }
            if (this.depl.dhArrDeplaDT == null) {
                throw new Exception("Absence de la date d'arriv\u00e9e.");
            }
            XMLGregorianCalendar calDepart = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(this.depl.dhDepDeplaDT));
            XMLGregorianCalendar calArriv = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(this.depl.dhArrDeplaDT));
            lieuDepla.setDhDeparDepla(calDepart);
            lieuDepla.setDhArrivDepla(calArriv);
            fact.setLieuDepla(lieuDepla);
            FactFraisDepla.ListeElmContx lstElmContx = of.createFactFraisDeplaListeElmContx();
            if (this.depl.lstElmCx != null) {
                for (CodeDesc cxFact : this.depl.lstElmCx) {
                    FactFraisDepla.ListeElmContx.ElmContx elmContx2 = of.createFactFraisDeplaListeElmContxElmContx();
                    int code = ConvertJavaToFromArray.parseInt(cxFact.c);
                    if (code == 0) continue;
                    elmContx2.setCodElmContx(code);
                    lstElmContx.getElmContx().add(elmContx2);
                }
            }
            if (lstElmContx.getElmContx().size() > 0) {
                fact.setListeElmContx(lstElmContx);
            }
            FactFraisDepla.ListeLigneFraisForfa ligneFraisF = of.createFactFraisDeplaListeLigneFraisForfa();
            if (this.depl.lstLigneFraisTranp != null && this.depl.lstLigneFraisTranp.size() > 0) {
                Collections.sort(this.depl.lstLigneFraisTranp, compNoLigneAbsAsc);
                for (CLigneFraisTranp cLigneFraisTranp : this.depl.lstLigneFraisTranp) {
                    LigneFraisTranp ll = of.createLigneFraisTranp();
                    ll.setCodMoyenTranpUtil(cLigneFraisTranp.codMoyen);
                    ll.setNbrKmAller(of.createLigneFraisTranpNbrKmAller(cLigneFraisTranp.km));
                    LigneFraisTranp.ListeFraisTranp lstFraisTranp = of.createLigneFraisTranpListeFraisTranp();
                    if (cLigneFraisTranp.lstFrais != null && cLigneFraisTranp.lstFrais.size() > 0) {
                        for (CLigneFraisTranp.Frais tranp : cLigneFraisTranp.lstFrais) {
                            LigneFraisTranp.ListeFraisTranp.FraisTranp fraisTranp = of.createLigneFraisTranpListeFraisTranpFraisTranp();
                            fraisTranp.setTypFraisTranp(tranp.type);
                            fraisTranp.setMntFrais(tranp.mnt);
                            lstFraisTranp.getFraisTranp().add(fraisTranp);
                        }
                        ll.setListeFraisTranp(lstFraisTranp);
                    }
                    ll.setNoLigneFact(this.demForListe.getNoRfp() == null ? noLigneServ++ : cLigneFraisTranp.noLigne);
                    ll.setDatServElmFact(dataFactory.newXMLGregorianCalendar(cLigneFraisTranp.dateServ));
                    ll.setIdElmFact(cLigneFraisTranp.idElmFact);
                    ll.setTypIdElmFact("1");
                    if (cLigneFraisTranp.lstElmCx != null && cLigneFraisTranp.lstElmCx.size() > 0) {
                        LigneFraisTranp.ListeElmContx lstElmC2 = of.createLigneFraisTranpListeElmContx();
                        for (Object elm : cLigneFraisTranp.lstElmCx) {
                            LigneFraisTranp.ListeElmContx.ElmContx elmContx2 = of.createLigneFraisTranpListeElmContxElmContx();
                            elmContx2.setCodElmContx(ConvertJavaToFromArray.parseInt(((CodeDesc)elm).c));
                            lstElmC2.getElmContx().add(elmContx2);
                        }
                        ll.setListeElmContx(lstElmC2);
                    }
                    ligneFraisF.getLigneFraisTranpOrLigneTempsDeplaOrLigneFraisSej().add(ll);
                }
            }
            if (this.depl.lstLigneTempsDepla != null && this.depl.lstLigneTempsDepla.size() > 0) {
                Collections.sort(this.depl.lstLigneTempsDepla, compNoLigneAbsAsc);
                for (CLigneTempsDepla cLigneTempsDepla : this.depl.lstLigneTempsDepla) {
                    LigneTempsDepla ll = of.createLigneTempsDepla();
                    ll.setCodMoyenTranpUtil(cLigneTempsDepla.codMoyen);
                    ll.setNbrKmAller(of.createLigneTempsDeplaNbrKmAller(cLigneTempsDepla.kmAller));
                    ll.setNbrKmRetou(of.createLigneTempsDeplaNbrKmRetou(cLigneTempsDepla.kmRetou));
                    ll.setNbrHreAtten(of.createLigneTempsDeplaNbrHreAtten(cLigneTempsDepla.hreAtten));
                    ll.setNbrHreDepla(of.createLigneTempsDeplaNbrHreDepla(cLigneTempsDepla.hreDepla));
                    ll.setNoLigneFact(this.demForListe.getNoRfp() == null ? noLigneServ++ : cLigneTempsDepla.noLigne);
                    ll.setDatServElmFact(dataFactory.newXMLGregorianCalendar(cLigneTempsDepla.dateServ));
                    ll.setIdElmFact(cLigneTempsDepla.idElmFact);
                    ll.setTypIdElmFact("1");
                    if (cLigneTempsDepla.lstElmCx != null && cLigneTempsDepla.lstElmCx.size() > 0) {
                        lstElmC = of.createLigneTempsDeplaListeElmContx();
                        for (CodeDesc elm : cLigneTempsDepla.lstElmCx) {
                            elmContx = of.createLigneTempsDeplaListeElmContxElmContx();
                            elmContx.setCodElmContx(ConvertJavaToFromArray.parseInt(elm.c));
                            ((LigneTempsDepla.ListeElmContx)lstElmC).getElmContx().add((LigneTempsDepla.ListeElmContx.ElmContx)elmContx);
                        }
                        ll.setListeElmContx((LigneTempsDepla.ListeElmContx)lstElmC);
                    }
                    ligneFraisF.getLigneFraisTranpOrLigneTempsDeplaOrLigneFraisSej().add(ll);
                }
            }
            if (this.depl.lstLigneFraisSej != null && this.depl.lstLigneFraisSej.size() > 0) {
                Collections.sort(this.depl.lstLigneFraisSej, compNoLigneAbsAsc);
                for (CLigneFraisSej cLigneFraisSej : this.depl.lstLigneFraisSej) {
                    LigneFraisSej ll = of.createLigneFraisSej();
                    LigneFraisSej.ListeFraisSej listeFraisSej = of.createLigneFraisSejListeFraisSej();
                    TypFraisSej typFraisSej = of.createTypFraisSej();
                    typFraisSej.setTypFraisSej(cLigneFraisSej.frais.type);
                    typFraisSej.setMntFrais(cLigneFraisSej.frais.mnt);
                    listeFraisSej.setFraisSej(typFraisSej);
                    ll.setListeFraisSej(listeFraisSej);
                    ll.setNoLigneFact(this.demForListe.getNoRfp() == null ? noLigneServ++ : cLigneFraisSej.noLigne);
                    ll.setDatServElmFact(dataFactory.newXMLGregorianCalendar(cLigneFraisSej.dateServ));
                    ll.setIdElmFact(cLigneFraisSej.idElmFact);
                    ll.setTypIdElmFact("1");
                    if (cLigneFraisSej.lstElmCx != null && cLigneFraisSej.lstElmCx.size() > 0) {
                        LigneFraisSej.ListeElmContx lstElmC3 = of.createLigneFraisSejListeElmContx();
                        for (CodeDesc elm : cLigneFraisSej.lstElmCx) {
                            LigneFraisSej.ListeElmContx.ElmContx elmContx4 = of.createLigneFraisSejListeElmContxElmContx();
                            elmContx4.setCodElmContx(ConvertJavaToFromArray.parseInt(elm.c));
                            lstElmC3.getElmContx().add(elmContx4);
                        }
                        ll.setListeElmContx(lstElmC3);
                    }
                    ligneFraisF.getLigneFraisTranpOrLigneTempsDeplaOrLigneFraisSej().add(ll);
                }
            }
            if (this.depl.lstLigneForfaDepla != null && this.depl.lstLigneForfaDepla.size() > 0) {
                Collections.sort(this.depl.lstLigneForfaDepla, compNoLigneAbsAsc);
                for (CLigneForfaDepla cLigneForfaDepla : this.depl.lstLigneForfaDepla) {
                    LigneForfaDepla ll = of.createLigneForfaDepla();
                    ll.setNoLigneFact(this.demForListe.getNoRfp() == null ? noLigneServ++ : cLigneForfaDepla.noLigne);
                    ll.setDatServElmFact(dataFactory.newXMLGregorianCalendar(cLigneForfaDepla.dateServ));
                    ll.setIdElmFact(cLigneForfaDepla.idElmFact);
                    ll.setTypIdElmFact("1");
                    if (cLigneForfaDepla.lstElmCx != null && cLigneForfaDepla.lstElmCx.size() > 0) {
                        lstElmC = of.createLigneForfaDeplaListeElmContx();
                        for (CodeDesc elm : cLigneForfaDepla.lstElmCx) {
                            elmContx = of.createLigneForfaDeplaListeElmContxElmContx();
                            elmContx.setCodElmContx(ConvertJavaToFromArray.parseInt(elm.c));
                            ((LigneForfaDepla.ListeElmContx)lstElmC).getElmContx().add((LigneForfaDepla.ListeElmContx.ElmContx)elmContx);
                        }
                        ll.setListeElmContx((LigneForfaDepla.ListeElmContx)lstElmC);
                    }
                    ligneFraisF.getLigneFraisTranpOrLigneTempsDeplaOrLigneFraisSej().add(ll);
                }
            }
            fact.setListeLigneFraisForfa(ligneFraisF);
            DemPaimt.ListeFact listeFact = new DemPaimt.ListeFact();
            listeFact.setFactBase(of.createFactBase(fact));
            pmt.setListeFact(listeFact);
        }
        return pmt;
    }

    public void dateSince(Calendar dateSince, ReglePlafonnement rp) {
        dateSince.set(10, 0);
        dateSince.set(12, 0);
        dateSince.set(13, 0);
        dateSince.set(14, 0);
        Calendar dateTemp = Calendar.getInstance();
        dateTemp.setTime(dateSince.getTime());
        int duree = rp.getDuree();
        switch (rp.getUnit()) {
            case CIVIL: {
                dateTemp.set(2, 0);
                dateTemp.set(5, 1);
                break;
            }
            case AN: {
                dateTemp.add(2, -(12 * duree));
                break;
            }
            case MOIS: {
                dateTemp.add(2, -duree);
                break;
            }
            case JOUR: {
                dateTemp.add(6, -duree);
                break;
            }
            case VIE: {
                dateTemp.add(1, -duree);
                break;
            }
        }
        if (dateTemp.before(dateSince)) {
            dateSince.setTime(dateTemp.getTime());
        }
    }

    private Integer getIntegerGenderFromGender(String g) {
        Integer iGender = 3;
        if (g != null && g.matches("[MF]")) {
            iGender = g.equals("F") ? 2 : 1;
        }
        return iGender;
    }

    private void addDxToTypeInfoMdcalPers(ObjectFactory of, TypInfoMdcalPers typInfoMedCal, List<CodeDesc> dx) {
        TypInfoMdcalPers.ListeDiagnMdcal lstDxMdcal = of.createTypInfoMdcalPersListeDiagnMdcal();
        for (CodeDesc c : dx) {
            TypDiagnMdcal dxMd = of.createTypDiagnMdcal();
            dxMd.setNoSeqSysCla(12);
            dxMd.setCodDiagnMdcal(c.c);
            lstDxMdcal.getDiagnMdcal().add(dxMd);
        }
        typInfoMedCal.setListeDiagnMdcal(lstDxMdcal);
    }
}

