/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.HibFonctions;
import ca.infodata.dossier.hibernate.DemForListe;
import ca.infodata.dossier.hibernate.base.BaseDemForListeDAO;
import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.ofys.util.date.DateUtil;
import ca.infodata.syra.SyraAccessorClient;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.infodata.syra.util.ModelUtil;
import ca.qc.gouv.ramq.rfp.DemAnnu;
import ca.qc.gouv.ramq.rfp.DemAnnuRecev;
import ca.qc.gouv.ramq.rfp.DemModif;
import ca.qc.gouv.ramq.rfp.DemModifRecev;
import ca.qc.gouv.ramq.rfp.DemPaimt;
import ca.qc.gouv.ramq.rfp.DemPaimtRecev;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CDemForListe
implements Serializable {
    private static final long serialVersionUID = 1L;
    public transient DemPaimt demPaimt = null;
    public transient int iLastDemPaimt = -1;
    private transient List<String> demPaimtArr = new ArrayList<String>();
    public transient DemModif demModif = null;
    public transient int iLastDemModif = -1;
    private transient List<String> demModifArr = new ArrayList<String>();
    public transient DemAnnu demAnnu = null;
    public transient int iLastDemAnnu = -1;
    private transient List<String> demAnnuArr = new ArrayList<String>();
    public transient DemPaimtRecev demPaimtRecev = null;
    public transient int iLastDemPaimtRecev = -1;
    private transient List<String> demPaimtRecevArr = new ArrayList<String>();
    public transient DemModifRecev demModifRecev = null;
    public transient int iLastDemModifRecev = -1;
    private transient List<String> demModifRecevArr = new ArrayList<String>();
    public transient DemAnnuRecev demAnnuRecev = null;
    public transient int iLastDemAnnuRecev = -1;
    private transient List<String> demAnnuRecevArr = new ArrayList<String>();
    public static final Integer DEM_PAIMT = new Integer(1);
    public static final Integer DEM_MODIF = new Integer(2);
    public static final Integer DEM_ANNU = new Integer(3);
    public static final Integer DEM_PAIM_RECEV = new Integer(4);
    public static final Integer DEM_MDIF_RECEV = new Integer(5);
    public static final Integer DEM_ANNU_RECEV = new Integer(6);
    private Integer iu;
    private Integer id;
    private final Integer tag;
    private String ii;
    private Integer dt;
    private String cdt;
    boolean mm;
    private String mdt;
    private String d;
    private Integer[] idpas;
    private Integer idp;
    private String pt;
    private String[] pts;
    private BigDecimal hon;
    private Integer sr = new Integer(0);
    private String em;
    private String np;
    int no = 0;
    private int prg = 0;
    private boolean ready = true;
    private int sp;
    private Double mp;
    private Long noRfp;
    private Integer noExt;
    private String[] cd;
    private String et;
    private Integer dl;

    public CDemForListe(Integer id, Integer tag, Integer idUser, String createdDT, String modifiedDT) {
        this.id = id;
        this.tag = tag;
        this.iu = idUser;
        if (createdDT == null) {
            createdDT = DateUtil.nowDT_ToString();
        }
        this.cdt = createdDT;
        this.mdt = modifiedDT;
    }

    public CDemForListe(Integer tag2) {
        this.tag = tag2;
    }

    public final boolean isNotDeleted() {
        return this.dl == null || this.dl == 0;
    }

    public final boolean isDeleted() {
        return this.dl != null && this.dl == 1;
    }

    public final Integer getIdUser() {
        return this.iu;
    }

    public final void setIdUser(Integer idUser) {
        this.iu = idUser;
    }

    public final Integer getId() {
        return this.id;
    }

    public final void setId(Integer id) {
        this.id = id;
    }

    public Integer getTag() {
        return this.tag;
    }

    public final String getIdIntvn() {
        return this.ii;
    }

    public final void setIdIntvn(String ii) {
        this.ii = ii;
    }

    public Integer getIdProf() {
        return this.idp;
    }

    public void setIdProf(Integer idp) {
        this.idp = idp;
    }

    public final String getCreatedDateTime() {
        return this.cdt;
    }

    public final void setCreatedDateTime(String cdt) {
        this.cdt = cdt;
    }

    public final boolean getManualMode() {
        return this.mm;
    }

    public final void setManualMode(boolean b) {
        this.mm = b;
    }

    public final boolean getReady() {
        return this.ready;
    }

    public final void setReady(boolean b) {
        this.ready = b;
    }

    public final String getModifiedDateTime() {
        return this.mdt;
    }

    public final void setModifiedDateTime(String mdt) {
        this.mdt = mdt;
    }

    public String getDate() {
        return this.d;
    }

    public void setDate(String d) {
        this.d = d;
    }

    public final String getPatient() {
        return this.pt;
    }

    public final void setPatient(String pt) {
        this.pt = pt;
    }

    public final BigDecimal getMntPrel() {
        return this.hon;
    }

    public final void setMntPrel(BigDecimal hon) {
        this.hon = hon;
    }

    public final Integer getStaRecev() {
        return this.sr;
    }

    public final void setStaRecev(Integer staRecev) {
        this.sr = staRecev;
    }

    public Integer getDemType() {
        return this.dt;
    }

    public void setDemType(Integer dt) {
        this.dt = dt;
    }

    public int getProgressCommunication() {
        return this.prg;
    }

    public void setProgressCommunication(int prg) {
        this.prg = prg;
    }

    public final String getErrMessage() {
        return this.em;
    }

    public final void setErrMessage(String s) {
        this.em = StringUtils.isEmpty((CharSequence)s) ? null : s;
    }

    public final String getNotePers() {
        return this.np;
    }

    public final void setNotePers(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            this.np = null;
            this.no = 0;
        } else {
            this.np = s;
            this.no = 1;
        }
    }

    public DemPaimt getLastDemPaimt() {
        if (this.demPaimtArr != null && this.demPaimtArr.size() > 0 && (this.demPaimtArr.size() > this.iLastDemPaimt + 1 || this.demPaimt == null)) {
            this.demPaimt = ConvertJavaToFromArray.ConvertDemPaimt.fromArrayString(this.demPaimtArr.get(this.demPaimtArr.size() - 1), ConvertJavaToFromArray.of.createDemPaimt(), 0);
            this.iLastDemPaimt = this.demPaimtArr.size() - 1;
        }
        return this.demPaimt;
    }

    public DemModif getLastDemModif() {
        if (this.demModifArr != null && this.demModifArr.size() > 0 && (this.demModifArr.size() > this.iLastDemModif + 1 || this.demModif == null)) {
            this.demModif = ConvertJavaToFromArray.ConvertDemModif.fromArrayString(this.demModifArr.get(this.demModifArr.size() - 1), ConvertJavaToFromArray.of.createDemModif());
            this.iLastDemModif = this.demModifArr.size() - 1;
        }
        return this.demModif;
    }

    public DemModif getDemModif(int i) {
        DemModif dm = null;
        if (this.demModifArr != null && this.demModifArr.size() > i) {
            dm = ConvertJavaToFromArray.ConvertDemModif.fromArrayString(this.demModifArr.get(i), ConvertJavaToFromArray.of.createDemModif());
        }
        return dm;
    }

    public DemAnnu getLastDemAnnu() {
        if (this.demAnnuArr != null && this.demAnnuArr.size() > 0 && (this.demAnnuArr.size() > this.iLastDemAnnu + 1 || this.demAnnu == null)) {
            this.demAnnu = ConvertJavaToFromArray.ConvertDemAnnu.fromArrayString(this.demAnnuArr.get(this.demAnnuArr.size() - 1), ConvertJavaToFromArray.of.createDemAnnu());
            this.iLastDemAnnu = this.demAnnuArr.size() - 1;
        }
        return this.demAnnu;
    }

    public DemPaimtRecev getLastDemPaimtRecev() {
        if (this.demPaimtRecevArr != null && this.demPaimtRecevArr.size() > 0 && (this.demPaimtRecevArr.size() > this.iLastDemPaimtRecev + 1 || this.demPaimtRecev == null)) {
            this.demPaimtRecev = ConvertJavaToFromArray.ConvertDemPaimtRecev.fromArrayString(this.demPaimtRecevArr.get(this.demPaimtRecevArr.size() - 1), ConvertJavaToFromArray.of.createDemPaimtRecev());
            this.iLastDemPaimtRecev = this.demPaimtRecevArr.size() - 1;
        }
        return this.demPaimtRecev;
    }

    public DemPaimtRecev getDemPaimtRecev(int i) {
        DemPaimtRecev dpr = null;
        if (this.demPaimtRecevArr != null && this.demPaimtRecevArr.size() > i) {
            dpr = ConvertJavaToFromArray.ConvertDemPaimtRecev.fromArrayString(this.demPaimtRecevArr.get(i), ConvertJavaToFromArray.of.createDemPaimtRecev());
        }
        return dpr;
    }

    public DemModifRecev getLastDemModifRecev() {
        if (this.demModifRecevArr != null && this.demModifRecevArr.size() > 0 && (this.demModifRecevArr.size() > this.iLastDemModifRecev + 1 || this.demModifRecev == null)) {
            this.demModifRecev = ConvertJavaToFromArray.ConvertDemModifRecev.fromArrayString(this.demModifRecevArr.get(this.demModifRecevArr.size() - 1), ConvertJavaToFromArray.of.createDemModifRecev(), null);
            this.iLastDemModifRecev = this.demModifRecevArr.size() - 1;
        }
        return this.demModifRecev;
    }

    public DemModifRecev getDemModifRecev(int i) {
        DemModifRecev dmr = null;
        if (this.demModifRecevArr != null && this.demModifRecevArr.size() > i) {
            dmr = ConvertJavaToFromArray.ConvertDemModifRecev.fromArrayString(this.demModifRecevArr.get(i), ConvertJavaToFromArray.of.createDemModifRecev(), null);
        }
        return dmr;
    }

    public DemAnnuRecev getLastDemAnnuRecev() {
        if (this.demAnnuRecevArr != null && this.demAnnuRecevArr.size() > 0 && (this.demAnnuRecevArr.size() > this.iLastDemAnnuRecev + 1 || this.demAnnuRecev == null)) {
            this.demAnnuRecev = ConvertJavaToFromArray.ConvertDemAnnuRecev.fromArrayString(this.demAnnuRecevArr.get(this.demAnnuRecevArr.size() - 1), ConvertJavaToFromArray.of.createDemAnnuRecev());
            this.iLastDemAnnuRecev = this.demAnnuRecevArr.size() - 1;
        }
        return this.demAnnuRecev;
    }

    public DemAnnuRecev getDemAnnuRecev(int i) {
        DemAnnuRecev dar = null;
        if (this.demAnnuRecevArr != null && this.demAnnuRecevArr.size() > i) {
            dar = ConvertJavaToFromArray.ConvertDemAnnuRecev.fromArrayString(this.demAnnuRecevArr.get(i), ConvertJavaToFromArray.of.createDemAnnuRecev());
            this.iLastDemAnnuRecev = this.demAnnuRecevArr.size() - 1;
        }
        return dar;
    }

    public int hashCode() {
        return ModelUtil.hashCodeFor(this.getTag());
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof CDemForListe)) {
            return false;
        }
        CDemForListe that = (CDemForListe)aThat;
        return HibFonctions.EqualsUtil.areEqual((Object)this.getTag(), (Object)that.getTag());
    }

    public void setDem(String[] demPaimt2, String[] demModif2, String[] demAnnu2) {
        String s;
        int n;
        int n2;
        String[] stringArray;
        if (demPaimt2 != null) {
            stringArray = demPaimt2;
            n2 = demPaimt2.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                this.demPaimtArr.add(s);
                ++this.iLastDemPaimt;
                ++n;
            }
        }
        if (demModif2 != null) {
            stringArray = demModif2;
            n2 = demModif2.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                this.demModifArr.add(s);
                ++this.iLastDemModif;
                ++n;
            }
        }
        if (demAnnu2 != null) {
            stringArray = demAnnu2;
            n2 = demAnnu2.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                this.demAnnuArr.add(s);
                ++this.iLastDemAnnu;
                ++n;
            }
        }
    }

    public void setRec(String[] demPaimtRecev2, String[] demModifRecev2, String[] demAnnuRecev2) {
        String s;
        int n;
        int n2;
        String[] stringArray;
        if (demPaimtRecev2 != null) {
            stringArray = demPaimtRecev2;
            n2 = demPaimtRecev2.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                this.demPaimtRecevArr.add(s);
                ++this.iLastDemPaimtRecev;
                ++n;
            }
        }
        if (demModifRecev2 != null) {
            stringArray = demModifRecev2;
            n2 = demModifRecev2.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                this.demModifRecevArr.add(s);
                ++this.iLastDemModifRecev;
                ++n;
            }
        }
        if (demAnnuRecev2 != null) {
            stringArray = demAnnuRecev2;
            n2 = demAnnuRecev2.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                this.demAnnuRecevArr.add(s);
                ++this.iLastDemAnnuRecev;
                ++n;
            }
        }
    }

    public void setIdPatients(Integer[] idPatients) {
        this.idpas = idPatients;
    }

    public Integer[] getIdPatients() {
        return this.idpas;
    }

    public String[] getPatientStrings() {
        return this.pts;
    }

    public void setPatientStrings(String[] patientStrings) {
        this.pts = patientStrings;
    }

    public void setNoExt(Integer noExt) {
        this.noExt = noExt;
    }

    public void setIsDeleted(Integer d) {
        this.dl = d;
    }

    public void setNoRfp(Long noRfp) {
        this.noRfp = noRfp;
    }

    public int getStatPmt() {
        return this.sp;
    }

    public void setStatPmt(int sp) {
        this.sp = sp;
    }

    public Double getMntPay() {
        return this.mp;
    }

    public void setMntPaye(Double mp) {
        this.mp = mp;
    }

    public Long getNoRfp() {
        return this.noRfp;
    }

    public Integer getNoExt() {
        return this.noExt;
    }

    public Integer getIsDeleted() {
        return this.dl;
    }

    public String[] getCodesFromArch() {
        return this.cd;
    }

    public void setCodesFromArch(String[] cd) {
        this.cd = cd;
    }

    public final String getEtab() {
        return this.et;
    }

    public final void setEtab(String etab) {
        this.et = etab;
    }

    public List<String> addOrSetDemPaimt(String arrayStringDp) {
        int size = this.demPaimtArr.size();
        int sizeRec = this.demPaimtRecevArr.size();
        if (sizeRec >= size) {
            this.demPaimtArr.add(arrayStringDp);
        } else {
            this.demPaimtArr.set(this.demPaimtArr.size() - 1, arrayStringDp);
        }
        return this.demPaimtArr;
    }

    public List<String> addOrSetDemPaimtRecev(String arrayStringDp) {
        int size = this.demPaimtArr.size();
        int sizeRec = this.demPaimtRecevArr.size();
        if (sizeRec < size) {
            this.demPaimtRecevArr.add(arrayStringDp);
        } else {
            this.demPaimtRecevArr.set(this.demPaimtArr.size() - 1, arrayStringDp);
        }
        return this.demPaimtRecevArr;
    }

    public List<String> addOrSetDemAnnu(String arrayStringDp) {
        int size = this.demAnnuArr.size();
        int sizeRec = this.demAnnuRecevArr.size();
        if (sizeRec >= size) {
            this.demAnnuArr.add(arrayStringDp);
        } else {
            this.demAnnuArr.set(this.demAnnuArr.size() - 1, arrayStringDp);
        }
        return this.demAnnuArr;
    }

    public List<String> addOrSetDemAnnuRecev(String arrayStringDp) {
        this.demAnnuRecevArr.add(arrayStringDp);
        return this.demAnnuRecevArr;
    }

    public List<String> addOrSetDemModif(String arrayStringDp) {
        int size = this.demModifArr.size();
        int sizeRec = this.demModifRecevArr.size();
        if (sizeRec >= size) {
            this.demModifArr.add(arrayStringDp);
        } else {
            this.demModifArr.set(this.demModifArr.size() - 1, arrayStringDp);
        }
        return this.demModifArr;
    }

    public List<String> addOrSetDemModifRecev(String arrayStringDp) {
        int size = this.demModifArr.size();
        int sizeRec = this.demModifRecevArr.size();
        if (sizeRec < size) {
            this.demModifRecevArr.add(arrayStringDp);
        } else {
            this.demModifRecevArr.set(this.demModifArr.size() - 1, arrayStringDp);
        }
        return this.demModifRecevArr;
    }

    public DemForListe getDemForListeAndSave(ConvertJavaToFromArray.ArrDemType whatToSave, List<String> newVal, Integer[] ptInt, String[] ptString) {
        DemForListe dfl = new DemForListe();
        if (this.getId() == null) {
            dfl.setCreatedDateTime(new Long(Calendar.getInstance().getTimeInMillis()));
            if (newVal != null && !newVal.isEmpty()) {
                dfl.setDemPaimt(this.demPaimtArr.toArray(new String[0]));
                dfl.setDemPaimtRecev(this.demPaimtRecevArr.toArray(new String[0]));
                dfl.setDemModif(this.demModifArr.toArray(new String[0]));
                dfl.setDemModifRecev(this.demModifRecevArr.toArray(new String[0]));
                dfl.setDemAnnu(this.demAnnuArr.toArray(new String[0]));
                dfl.setDemAnnuRecev(this.demAnnuRecevArr.toArray(new String[0]));
                if (whatToSave.getVal() == ConvertJavaToFromArray.ArrDemType.DEM_PAIMT.getVal()) {
                    dfl.setDemPaimt(newVal.toArray(new String[0]));
                } else if (whatToSave.getVal() == ConvertJavaToFromArray.ArrDemType.DEM_PAIMT_RECEV.getVal()) {
                    dfl.setDemPaimtRecev(newVal.toArray(new String[0]));
                } else if (whatToSave.getVal() == ConvertJavaToFromArray.ArrDemType.DEM_ANNU.getVal()) {
                    dfl.setDemAnnu(newVal.toArray(new String[0]));
                } else if (whatToSave.getVal() == ConvertJavaToFromArray.ArrDemType.DEM_ANNU_RECEV.getVal()) {
                    dfl.setDemAnnuRecev(newVal.toArray(new String[0]));
                } else if (whatToSave.getVal() == ConvertJavaToFromArray.ArrDemType.DEM_MODIF.getVal()) {
                    dfl.setDemModif(newVal.toArray(new String[0]));
                } else if (whatToSave.getVal() == ConvertJavaToFromArray.ArrDemType.DEM_MODIF_RECEV.getVal()) {
                    dfl.setDemModifRecev(newVal.toArray(new String[0]));
                }
            } else {
                dfl.setDemPaimt(this.demPaimtArr.toArray(new String[0]));
                dfl.setDemPaimtRecev(this.demPaimtRecevArr.toArray(new String[0]));
                dfl.setDemModif(this.demModifArr.toArray(new String[0]));
                dfl.setDemModifRecev(this.demModifRecevArr.toArray(new String[0]));
                dfl.setDemAnnu(this.demAnnuArr.toArray(new String[0]));
                dfl.setDemAnnuRecev(this.demAnnuRecevArr.toArray(new String[0]));
            }
            dfl.setIdIntvn(this.getIdIntvn());
            dfl.setIdUser(this.getIdUser());
            dfl.setManualMode(this.getManualMode());
            dfl.setReady(this.ready);
            dfl.setProgressComm(this.getProgressCommunication());
            dfl.setStaRecev(this.getStaRecev());
            dfl.setErrMessage(this.getErrMessage());
            dfl.setNotePers(this.getNotePers());
            dfl.setProfessionnal(SyraAccessorClient.getInstance().getBillingProfFromId(this.getIdProf()));
            dfl.setDemType(this.getDemType());
            dfl.setIdPatients(ptInt);
            dfl.setNoExt(this.getNoExt());
            dfl.setNoRfp(this.getNoRfp());
            dfl.setIsDeleted(this.getIsDeleted());
            dfl.setPatientStrings(ptString);
            BaseDemForListeDAO.getInstance().save(dfl);
            this.id = dfl.getId();
        } else if (whatToSave != null) {
            dfl.setIdUser(this.getIdUser());
            dfl.setId(this.getId());
            if (ptInt != null && ptString != null) {
                BaseDemForListeDAO.getInstance().update(dfl, whatToSave.getNameField(), newVal, ptInt, ptString);
            } else {
                BaseDemForListeDAO.getInstance().update(dfl, whatToSave.getNameField(), newVal, null, null);
            }
        }
        return dfl;
    }

    public static enum ProgressComm implements EnumWithValue
    {
        NO_INFO(0),
        IN_PROGRESS(1),
        DONE_SUCCESS(2),
        DONE_ERROR(3);

        private final int val;

        private ProgressComm(int v) {
            this.val = v;
        }

        public int getValue() {
            return this.val;
        }

        public Integer getValInteger() {
            return new Integer(this.val);
        }
    }
}

