/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.ofys.util.date.DateUtil;
import ca.infodata.ofys.util.date.LocalDate;
import ca.infodata.syra.SyraAccessorClient;
import ca.infodata.syra.controller.SyraSettings;
import ca.infodata.syra.models.CDemForListe;
import ca.infodata.syra.models.CDemPaimt;
import ca.infodata.syra.models.CDemPaimtRecev;
import ca.infodata.syra.models.CEtab;
import ca.infodata.syra.models.CFactExplPmt;
import ca.infodata.syra.models.CLieu;
import ca.infodata.syra.models.CLigneForfaDepla;
import ca.infodata.syra.models.CLigneFraisSej;
import ca.infodata.syra.models.CLigneFraisTranp;
import ca.infodata.syra.models.CLigneTempsDepla;
import ca.infodata.syra.models.CLigneTypServMdcal;
import ca.infodata.syra.models.CLocal;
import ca.infodata.syra.models.CObjectUtils;
import ca.infodata.syra.models.CPatient;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.models.CTypDiagnMdcal;
import ca.infodata.syra.models.CUser;
import ca.infodata.syra.models.CodeDesc;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.infodata.syra.util.OpenXmlDb;
import ca.infodata.syra.xsd.valid.CodLocal;
import ca.infodata.util1.StringUtils;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Platform;

public class CDemContainer {
    private static final transient AtomicInteger atomicTagInteger = new AtomicInteger(-1000000);
    private static final transient AtomicInteger atomicInteger = new AtomicInteger(10000);
    private CDemForListe currentCDemForListe;
    private Map<Integer, CDemForListe> mapCDemForListe = new ConcurrentHashMap<Integer, CDemForListe>();
    public static final String currentProf = "currentProf";
    public static final String currentGroupe = "currentGroupe";
    public static final String currentLieu = "currentLieu";
    public static final String previousProf = "previousProf";
    public static final String previousGroupe = "previousGroupe";
    public static final String previousLieu = "previousLieu";
    public static final String currentPatient = "currentPatient";
    public static final String currentUser = "currentUser";
    public static final String currentBillUser = "currentBillUser";
    public static final String currentDemPaimt = "currentDemPaimt";
    public static final String currentCTypDiagnMdcal = "currentCTypDiagnMdcal";
    public static final String currentCLigneServMdcal = "currentCLigneServMdcal";
    public static final String currentCLigneForfaDepla = "currentCLigneForfaDepla";
    public static final String currentCLigneFraisSej = "currentCLigneFraisSej";
    public static final String currentCLigneFraisTranp = "currentCLigneFraisTranp";
    public static final String currentCLigneTempsDepla = "currentCLigneTempsDepla";
    public static final String dateDefaut = "dateDefaut";
    public static final String billListDate = "billListDate";
    public static final String fichExplPaimtNew = "fichExplPaimtNew";
    public static final String currentFicheExplPaimt = "currentFicheExplPaimt";
    public static final String currentExplPaimtAllNodes = "currentExplPaimtAllNodes";
    private Map<String, Object> mapCurrents = new ConcurrentHashMap<String, Object>();
    public static Map<String, Class<?>> mapTypes = new HashMap();
    private Map<Integer, CPatient> mapCurrentPatient = new ConcurrentHashMap<Integer, CPatient>();
    private SyraSettings syraSettings;
    private static SyraGlobalSettings syraGlobalSettings;
    public final String uid;
    public OpenXmlDb openXmlDbInMemory = null;
    public int typProfRef;
    public int typRefreAutreProf;
    public int typIdProfRefreConnu;
    public String idProfRefConnu;
    public int codTerriProfRefre;
    public int typPrfsnProfRefre;
    public String nomProfRefre;
    public String preProfRefre;

    static {
        mapTypes.put(currentProf, CProfessionnal.class);
        mapTypes.put(currentGroupe, CodeDesc.class);
        mapTypes.put(currentLieu, CLieu.class);
        mapTypes.put(previousProf, CProfessionnal.class);
        mapTypes.put(previousGroupe, CodeDesc.class);
        mapTypes.put(previousLieu, CLieu.class);
        mapTypes.put(currentPatient, CPatient.class);
        mapTypes.put(currentDemPaimt, CDemPaimt.class);
        mapTypes.put(currentCTypDiagnMdcal, CTypDiagnMdcal.class);
        mapTypes.put(currentCLigneServMdcal, CLigneTypServMdcal.class);
        mapTypes.put(currentCLigneForfaDepla, CLigneForfaDepla.class);
        mapTypes.put(currentCLigneFraisSej, CLigneFraisSej.class);
        mapTypes.put(currentCLigneFraisTranp, CLigneFraisTranp.class);
        mapTypes.put(currentCLigneTempsDepla, CLigneTempsDepla.class);
        mapTypes.put(dateDefaut, LocalDate.class);
        mapTypes.put(currentUser, CUser.class);
        mapTypes.put(currentBillUser, CUser.class);
        mapTypes.put(billListDate, LocalDate.class);
        mapTypes.put(fichExplPaimtNew, String[].class);
        mapTypes.put(currentFicheExplPaimt, String.class);
        mapTypes.put(currentExplPaimtAllNodes, ConcurrentHashMap.class);
        syraGlobalSettings = SyraGlobalSettings.getInstance((String)ConnectionFactory.connectionLabel);
    }

    public static Integer getTagInteger() {
        return new Integer(atomicTagInteger.getAndDecrement());
    }

    public static Integer getTempNoLigne() {
        return new Integer(atomicInteger.getAndIncrement());
    }

    public CDemContainer(String uid) {
        this.uid = uid;
        this.syraSettings = new SyraSettings(uid, String.valueOf(ConnectionFactory.connectionLabel) + "/");
        this.mapCurrents.put(currentExplPaimtAllNodes, new ConcurrentHashMap());
    }

    public final CDemForListe getCurrentCDemForListe() {
        return this.currentCDemForListe;
    }

    public final void setCurrentCDemForListe(CDemForListe currentCDemForListe) {
        this.currentCDemForListe = currentCDemForListe;
    }

    public final void setCurrentValue(String k, Object v) {
        if (v == null) {
            if (this.mapCurrents.containsKey(k)) {
                this.mapCurrents.remove(k);
            }
        } else {
            this.mapCurrents.put(k, v);
        }
        if (k.equals(currentProf)) {
            this.setCurrentProf((CProfessionnal)v);
        } else if (k.equals(currentGroupe)) {
            this.setCurrentGroupe((CodeDesc)v);
        } else if (k.equals(currentLieu)) {
            this.setCurrentLieu((CLieu)v);
        } else if (k.equals(currentBillUser)) {
            this.setCurrentBillUser((CUser)v);
        } else if (k.equals(currentDemPaimt)) {
            this.setCurrentDemPaimt((CDemPaimt)v);
        } else if (k.equals(billListDate)) {
            this.setBillListDate((LocalDate)v);
        } else if (k.equals(dateDefaut)) {
            this.setDateDefaut((LocalDate)v);
        }
    }

    public final CProfessionnal getCurrentProf() {
        CProfessionnal cProfessionnals;
        if (!this.mapCurrents.containsKey(currentProf) && this.syraSettings.getIdProf() != null && (cProfessionnals = SyraAccessorClient.getInstance().getCProfessionnals(this.syraSettings.getIdProf())) != null) {
            this.mapCurrents.put(currentProf, cProfessionnals);
        }
        if (Platform.inDebugMode()) {
            System.out.println("**********");
            System.out.println("getCurrentProf = " + this.mapCurrents.get(currentProf));
            System.out.println("**********");
        }
        return this.mapCurrents.containsKey(currentProf) ? (CProfessionnal)this.mapCurrents.get(currentProf) : null;
    }

    private final void setCurrentProf(CProfessionnal currentProf) {
        if (Platform.inDebugMode()) {
            System.out.println("**********");
            System.out.println("currentProf = " + (currentProf == null ? null : currentProf.getNoProf()));
            System.out.println("**********");
        }
        this.syraSettings.setIdProf(currentProf == null ? null : currentProf.getId());
    }

    public final CUser getCurrentUser() {
        if (!this.mapCurrents.containsKey(currentUser)) {
            CUser user = SyraAccessorClient.getInstance().getActiveUser();
            this.mapCurrents.put(currentUser, user);
            return user;
        }
        return (CUser)this.mapCurrents.get(currentUser);
    }

    public final CUser getCurrentBillUser() {
        if (!this.mapCurrents.containsKey(currentBillUser)) {
            if (this.syraSettings.getBillUser() != null) {
                CUser user = SyraAccessorClient.getInstance().getUser(this.syraSettings.getBillUser());
                if (user != null) {
                    this.mapCurrents.put(currentBillUser, user);
                }
            } else {
                CUser user = this.getCurrentUser();
                this.mapCurrents.put(currentBillUser, user);
                this.syraSettings.setBillUser(user.id);
            }
        }
        return (CUser)this.mapCurrents.get(currentBillUser);
    }

    private void setCurrentBillUser(CUser v) {
        if (v == null) {
            if (this.mapCurrents.containsKey(currentUser)) {
                this.mapCurrents.remove(currentUser);
            }
            v = this.getCurrentUser();
        }
        this.mapCurrents.put(currentBillUser, v);
        this.syraSettings.setBillUser(v == null ? null : v.id);
    }

    public final String[] getFichExplPaimtNew() {
        return this.mapCurrents.containsKey(fichExplPaimtNew) ? (String[])this.mapCurrents.get(fichExplPaimtNew) : null;
    }

    public void setFichExplPaimtNew(String[] v) {
        this.mapCurrents.put(fichExplPaimtNew, v);
    }

    public final String getCurrentFicheExplPaimt() {
        return this.mapCurrents.containsKey(currentFicheExplPaimt) ? (String)this.mapCurrents.get(currentFicheExplPaimt) : null;
    }

    public void setCurrentFicheExplPaimt(String v) {
        this.mapCurrents.put(currentFicheExplPaimt, v);
    }

    public final CDemPaimt getCurrentDemPaimt() {
        return this.mapCurrents.containsKey(currentDemPaimt) ? (CDemPaimt)this.mapCurrents.get(currentDemPaimt) : null;
    }

    private final void setCurrentDemPaimt(CDemPaimt demPaimt) {
    }

    public CLigneTypServMdcal getCurrentCLigneServMdcal() {
        return this.mapCurrents.containsKey(currentCLigneServMdcal) ? (CLigneTypServMdcal)this.mapCurrents.get(currentCLigneServMdcal) : null;
    }

    public final CLigneForfaDepla getCurrentCLigneForfaDepla() {
        return this.mapCurrents.containsKey(currentCLigneForfaDepla) ? (CLigneForfaDepla)this.mapCurrents.get(currentCLigneForfaDepla) : null;
    }

    public final CLigneFraisSej getCurrentCLigneFraisSej() {
        return this.mapCurrents.containsKey(currentCLigneFraisSej) ? (CLigneFraisSej)this.mapCurrents.get(currentCLigneFraisSej) : null;
    }

    public final CLigneFraisTranp getCurrentCLigneFraisTranp() {
        return this.mapCurrents.containsKey(currentCLigneFraisTranp) ? (CLigneFraisTranp)this.mapCurrents.get(currentCLigneFraisTranp) : null;
    }

    public final CLigneTempsDepla getCurrentCLigneTempsDepla() {
        return this.mapCurrents.containsKey(currentCLigneTempsDepla) ? (CLigneTempsDepla)this.mapCurrents.get(currentCLigneTempsDepla) : null;
    }

    public final void setMapCDemForListe(Map<Integer, CDemForListe> mapCDemForListe) {
        this.mapCDemForListe = mapCDemForListe;
    }

    public final void setMapCurrentPatient(Map<Integer, CPatient> mapCurrentPatient) {
        this.mapCurrentPatient = mapCurrentPatient;
    }

    public final CLieu getCurrentLieu(CProfessionnal currProf) {
        CProfessionnal prof = currProf == null ? this.getCurrentProf() : currProf;
        CProfessionnal.Entente entente = null;
        if (prof != null && prof.getType() != null) {
            entente = CProfessionnal.Entente.valueOf(prof.getType());
        }
        if (entente != null && !this.mapCurrents.containsKey(currentLieu)) {
            CLieu lieu = new CLieu();
            lieu.typLocEtab = this.syraSettings.getTypLocEtab();
            String idLieuPhys = this.syraSettings.getEtab();
            String sect = this.syraSettings.getSect();
            String[] noSect = StringUtils.isEmpty((String)sect) ? new String[]{} : this.syraSettings.getSect().split("-");
            String codPreciLieu = this.syraSettings.get("codPreciLieu");
            if (codPreciLieu != null && codPreciLieu.length() > 1) {
                codPreciLieu = "0";
            }
            Integer codPreciSectActiv = this.syraSettings.getInt("codPreciSectActiv");
            String local = this.syraSettings.getLocal();
            String typLieuGeo = this.syraSettings.get("typLieuGeo");
            String typIdLieuGeo = this.syraSettings.get("typIdLieuGeo");
            this.createEtabFromValues(lieu, idLieuPhys, noSect, codPreciLieu, codPreciSectActiv, entente);
            this.createLocalFromValues(lieu, local, codPreciLieu, typLieuGeo, typIdLieuGeo);
            this.mapCurrents.put(currentLieu, lieu);
            return lieu;
        }
        if (Platform.inDebugMode()) {
            System.out.println("**********");
            System.out.println("getCcurrentLieu = " + this.mapCurrents.get(currentLieu));
            System.out.println("**********");
        }
        return (CLieu)this.mapCurrents.get(currentLieu);
    }

    private void createLocalFromValues(CLieu lieu, String local, String codPrecLieu, String typLieuGeo, String typIdLieuGeo) {
        CodLocal.ValCodLocal valLocal = null;
        if ("3".equals(typIdLieuGeo)) {
            valLocal = CObjectUtils.getLocal(local);
        }
        lieu.local = new CLocal(local, codPrecLieu, typIdLieuGeo, typLieuGeo);
        if (valLocal != null) {
            lieu.local.valCodLocal = valLocal;
        }
    }

    private void createEtabFromValues(CLieu lieu, String idLieuPhys, String[] noSect, String codPrecLieu, Integer codPreciSectActiv, CProfessionnal.Entente entente) {
        lieu.etab = new CEtab(idLieuPhys, codPrecLieu);
        lieu.etab.codPreciSectActiv = codPreciSectActiv != null ? codPreciSectActiv : new Integer(0);
        Object vs = null;
        lieu.etab.valSect = noSect.length == 2 ? CObjectUtils.getSecteur(noSect[0], Integer.parseInt(noSect[1]), null) : new CEtab.CValNoSectActiv();
        lieu.etab.valEtab = CObjectUtils.getEtab(idLieuPhys);
    }

    private final void setCurrentLieu(CLieu l) {
        CLieu current;
        if (Platform.inDebugMode()) {
            if (l == null) {
                new Exception("lieu est null!!!!").printStackTrace();
            }
            System.out.println("currentLieu = " + (l == null ? null : l.toString()));
        }
        CLieu cLieu = current = this.mapCurrents.containsKey(currentLieu) ? (CLieu)this.mapCurrents.get(currentLieu) : null;
        if (l != null && !l.equals(current)) {
            this.mapCurrents.put(previousLieu, current);
            this.mapCurrents.put(currentLieu, l);
            String typLoc = null;
            String etab = null;
            CEtab.CValNoSectActiv sect = null;
            Integer codPreciSectActiv = null;
            String local = null;
            String typLieuGeo = null;
            String typIdLieuGeo = null;
            if ("C".equals(l.typLocEtab)) {
                typLoc = "C";
                if (l.etab != null) {
                    etab = l.etab.getNoSelectedEtab();
                    codPreciSectActiv = l.etab.getCodPreciSectActiv();
                    this.syraSettings.put("etab", etab);
                    sect = l.etab.getValSect();
                    if (sect != null && sect.getEntente() != null) {
                        this.syraSettings.put("sect", String.valueOf(sect.getNoSectActiv()) + "-" + sect.getEntente().getValue());
                    }
                    if (codPreciSectActiv != null) {
                        this.syraSettings.put("codPreciSectActiv", codPreciSectActiv);
                    }
                    if (l.etab.codPreciLieu != null && l.etab.codPreciLieu.length() > 1) {
                        l.etab.codPreciLieu = "0";
                    }
                    this.syraSettings.put("codPreciLieu", l.etab.codPreciLieu);
                }
            } else {
                typLoc = "N";
                if (l.local != null) {
                    local = l.local.valCodLocal.getCodLocal();
                    typLieuGeo = l.local.typLieuGeo;
                    typIdLieuGeo = l.local.typIdLieuGeo;
                    this.syraSettings.put("local", local);
                    this.syraSettings.put("typLieuGeo", typLieuGeo);
                    this.syraSettings.put("typIdLieuGeo", typIdLieuGeo);
                    if (l.local.codPreciLieu != null && l.local.codPreciLieu.length() > 1) {
                        l.local.codPreciLieu = "0";
                    }
                    this.syraSettings.put("codPreciLieu", l.local.codPreciLieu);
                }
            }
            this.syraSettings.put("typ_loc_etab", typLoc);
        }
    }

    public final LocalDate getDateDefaut() {
        if (!this.mapCurrents.containsKey(dateDefaut)) {
            LocalDate ld = null;
            if (this.syraSettings.getDateDef() != null) {
                ld = LocalDate.fromCalendar((Calendar)DateUtil.ctod((String)this.syraSettings.getDateDef()));
            }
            if (ld == null) {
                ld = LocalDate.today();
            }
            this.mapCurrents.put(dateDefaut, ld);
        }
        return (LocalDate)this.mapCurrents.get(dateDefaut);
    }

    private final void setDateDefaut(LocalDate dateDefaut) {
        this.syraSettings.setDateDef(dateDefaut.formatHyphen());
    }

    public final LocalDate getBillListDate() {
        if (!this.mapCurrents.containsKey(billListDate)) {
            LocalDate bd = this.syraSettings.getDateLstBill() != null ? LocalDate.fromCalendar((Calendar)DateUtil.ctod((String)this.syraSettings.getDateLstBill())) : LocalDate.today();
            this.mapCurrents.put(billListDate, bd);
        }
        return (LocalDate)this.mapCurrents.get(billListDate);
    }

    private final void setBillListDate(LocalDate dateDefaut) {
        this.syraSettings.setDateLstBill(dateDefaut.formatHyphen());
    }

    public CPatient getCurrentPatient() {
        return this.mapCurrents.containsKey(currentPatient) ? (CPatient)this.mapCurrents.get(currentPatient) : null;
    }

    public final CTypDiagnMdcal getCurrentCTypDiagnMdcal() {
        return this.mapCurrents.containsKey(currentCTypDiagnMdcal) ? (CTypDiagnMdcal)this.mapCurrents.get(currentCTypDiagnMdcal) : null;
    }

    public final Map<Integer, CDemForListe> getMapCDemForListe() {
        return this.mapCDemForListe;
    }

    public final Map<Integer, CPatient> getMapCurrentPatient() {
        return this.mapCurrentPatient;
    }

    public final Map<Long, CFactExplPmt> getMapCurrentExplPaimtAllNodes() {
        return (Map)this.mapCurrents.get(currentExplPaimtAllNodes);
    }

    public final CodeDesc getCurrentGroupe() {
        return this.mapCurrents.containsKey(currentGroupe) ? (CodeDesc)this.mapCurrents.get(currentGroupe) : null;
    }

    public final void setCurrentGroupe(CodeDesc cd) {
        if (Platform.inDebugMode()) {
            System.out.println("**********");
            System.out.println("setCurrentGroupe = " + (cd == null ? null : cd.toString()));
            System.out.println("**********");
        }
        this.syraSettings.set("group", cd == null ? null : cd.c);
    }

    public final SyraSettings getSyraSettings() {
        return this.getSyraSettings(ConnectionFactory.connectionLabel);
    }

    public final SyraSettings getSyraSettings(String connLabel) {
        if (this.syraSettings == null || !this.syraSettings.addedPath.equals(connLabel)) {
            this.syraSettings = new SyraSettings(this.uid, connLabel);
        }
        return this.syraSettings;
    }

    public final SyraGlobalSettings getSyraglobalsettings() {
        return CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
    }

    public static SyraGlobalSettings getSyraglobalsettings(String connLabel) {
        if (syraGlobalSettings == null || !CDemContainer.syraGlobalSettings.addedPath.equals(connLabel)) {
            syraGlobalSettings = SyraGlobalSettings.getInstance((String)ConnectionFactory.connectionLabel);
        }
        return syraGlobalSettings;
    }

    public CLigneTypServMdcal getNewCLigneServMdcal(Map<String, String> params) {
        boolean addedCode = false;
        Integer role = null;
        BigInteger code = null;
        if (params != null) {
            addedCode = "1".equals(params.get("a"));
            role = params.get("r") != null ? new Integer(params.get("r")) : null;
            code = params.get("c") != null ? new BigInteger(params.get("c")) : null;
        }
        CLigneTypServMdcal ligneServMdcal = new CLigneTypServMdcal(this, role, code, addedCode);
        if (Boolean.TRUE.equals(this.getSyraSettings().getBoolean("copyMdRefNewFact")) && (this.typProfRef == 1 && StringUtils.isNotEmpty((String)this.idProfRefConnu) || this.typProfRef == 2 && StringUtils.isNotEmpty((String)this.nomProfRefre))) {
            ligneServMdcal.typProfRef = this.typProfRef;
            ligneServMdcal.typRefreAutreProf = this.typRefreAutreProf;
            ligneServMdcal.typIdProfRefreConnu = this.typIdProfRefreConnu;
            ligneServMdcal.idProfRefConnu = this.idProfRefConnu;
            ligneServMdcal.codTerriProfRefre = this.codTerriProfRefre;
            ligneServMdcal.typPrfsnProfRefre = this.typPrfsnProfRefre;
            ligneServMdcal.nomProfRefre = this.nomProfRefre;
            ligneServMdcal.preProfRefre = this.preProfRefre;
        }
        if (!addedCode) {
            this.mapCurrents.put(currentCLigneServMdcal, ligneServMdcal);
        }
        this.getCurrentDemPaimt().serv.mapTempLigneFact.put(new Integer(ligneServMdcal.noLigne), ligneServMdcal);
        return ligneServMdcal;
    }

    public Object getNewCDemPaimt() {
        CDemPaimt demPaimt = new CDemPaimt(this, false, false);
        demPaimt.recev = new CDemPaimtRecev();
        demPaimt.recev.staRecev = 0;
        Integer tag = CDemContainer.getTagInteger();
        this.mapCurrents.put(currentDemPaimt, demPaimt);
        CDemForListe dfl = new CDemForListe(null, tag, this.getCurrentBillUser().id, null, null);
        dfl.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT.getVal()));
        dfl.setIdProf(this.getCurrentProf() == null ? null : this.getCurrentProf().getId());
        dfl.setIdIntvn(this.getCurrentProf() == null ? null : this.getCurrentProf().getNoProf());
        dfl.setNoExt(new Integer(demPaimt.cNoDemExt));
        dfl.setIsDeleted(new Integer(0));
        dfl.setStatPmt(1);
        demPaimt.demForListe = dfl;
        this.mapCDemForListe.put(tag, dfl);
        this.setCurrentCDemForListe(dfl);
        if (demPaimt.serv != null) {
            this.getNewCLigneServMdcal(null);
        }
        return demPaimt;
    }

    public Object getCopyCDemPaimt(Map<String, String> params) {
        boolean copyPtDxDates = "1".equals(params.get("t"));
        CDemPaimt demPaimt = new CDemPaimt(this, true, copyPtDxDates);
        demPaimt.recev = new CDemPaimtRecev();
        demPaimt.recev.staRecev = 0;
        demPaimt.servNextNoLigne = this.getCurrentDemPaimt().servNextNoLigne;
        Integer tag = CDemContainer.getTagInteger();
        this.mapCurrents.put(currentDemPaimt, demPaimt);
        CDemForListe dfl = new CDemForListe(null, tag, this.getCurrentBillUser().id, null, null);
        dfl.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT.getVal()));
        dfl.setIdProf(this.getCurrentProf() == null ? null : this.getCurrentProf().getId());
        dfl.setIdIntvn(this.getCurrentProf() == null ? null : this.getCurrentProf().getNoProf());
        dfl.setNoExt(new Integer(demPaimt.cNoDemExt));
        dfl.setStatPmt(1);
        dfl.setIsDeleted(new Integer(0));
        demPaimt.demForListe = dfl;
        this.mapCDemForListe.put(tag, dfl);
        this.setCurrentCDemForListe(dfl);
        return demPaimt;
    }

    public CDemForListe getCDemForListe(Integer b) {
        this.currentCDemForListe = this.getMapCDemForListe().get(b);
        return this.currentCDemForListe;
    }
}

