/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.syra.models.CDemAllData;
import ca.infodata.util1.ConcurrentHashSet;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.LocalDate;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class CDemAllDataTable {
    private static final Logger logger = Logger.getLogger(CDemAllDataTable.class.getName());
    private SetMultimap<Pair<LocalDate, Integer>, CDemAllData> demAllDatas;
    private HashMap<Integer, CDemAllData> demAllDataById;
    private ConcurrentHashSet<CDemAllData> demAllDataSet;

    public CDemAllDataTable() {
        this.reset();
    }

    public void reset() {
        if (this.demAllDatas != null) {
            this.demAllDatas.clear();
        }
        if (this.demAllDataById != null) {
            this.demAllDataById.clear();
        }
        if (this.demAllDataSet != null) {
            this.demAllDataSet.clear();
        }
        this.demAllDatas = LinkedHashMultimap.create();
        this.demAllDataById = new HashMap(1000);
        this.demAllDataSet = new ConcurrentHashSet(1000, 8);
    }

    private void validNotCorrupted(String context, CDemAllData a) {
        if (a == null) {
            logger.severe(String.valueOf(context) + " CDemAllData.corruption demAllData is null");
        } else if (a.getId() == null) {
            logger.severe(String.valueOf(context) + " CDemAllData.corruption demAllData.id is null " + a);
        } else if (a.isDirty()) {
            logger.severe(String.valueOf(context) + " CDemAllData.corruption demAllData.isDirty == true " + a);
        }
    }

    public synchronized IEditableDataObjectList<CDemAllData> get(LocalDate localDate, Integer idUser) {
        Pair key = Pair.newPair((Object)localDate, (Object)idUser);
        Set c = this.demAllDatas.get((Object)key);
        if (c == null) {
            return EditableDataObjectList.emptyList();
        }
        EditableDataObjectList list = new EditableDataObjectList((Collection)c);
        for (CDemAllData a : list) {
            this.validNotCorrupted("getDemUser", a);
        }
        return list;
    }

    public synchronized boolean add(CDemAllData dem) {
        if (dem == null) {
            return false;
        }
        this.validNotCorrupted("add", dem);
        boolean b = this.demAllDataSet.add((Object)dem);
        if (b) {
            Integer idUser = dem.getIdUser();
            Pair key = Pair.newPair((Object)dem.getCreatedLocalDate(), (Object)idUser);
            this.demAllDatas.put((Object)key, (Object)dem);
            this.demAllDataById.put(dem.getId(), dem);
        }
        return b;
    }

    public synchronized void addAll(Collection<CDemAllData> c) {
        if (c != null) {
            for (CDemAllData a : c) {
                this.add(a);
            }
        }
    }

    public synchronized boolean replace(CDemAllData demAllData) {
        if (demAllData == null) {
            return false;
        }
        this.remove(demAllData);
        return this.add(demAllData);
    }

    private synchronized void remove(CDemAllData demAllData) {
        if (demAllData == null) {
            return;
        }
        this.demAllDataSet.remove((Object)demAllData);
        this.demAllDataById.remove(demAllData.getId());
        for (Map.Entry e : this.demAllDatas.asMap().entrySet()) {
            ((Collection)e.getValue()).remove(demAllData);
        }
    }

    public synchronized void remove(Integer idUser, LocalDate date) {
        Pair key = Pair.newPair((Object)date, (Object)idUser);
        Set c = this.demAllDatas.get((Object)key);
        this.demAllDataSet.removeAll((Collection)c);
        this.demAllDatas.asMap().remove(key);
        for (CDemAllData a : c) {
            this.demAllDataById.remove(a.getId());
        }
    }

    public synchronized Collection<CDemAllData> getAll() {
        for (CDemAllData a : this.demAllDataSet) {
            this.validNotCorrupted("getAll", a);
        }
        return this.demAllDataSet;
    }

    public synchronized CDemAllData get(Integer id) {
        for (CDemAllData a : this.demAllDataSet) {
            this.validNotCorrupted("getId", a);
        }
        return this.demAllDataById.get(id);
    }
}

