/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.handlers;

import ca.infodata.syra.handlers.AbstractFileLogHandler;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.ws.handler.Handler;

public class PrefixFileLogHandler
extends AbstractFileLogHandler {
    private final String prefix;
    private final boolean incrementStrategy;
    private final ThreadLocal<Integer> ti;
    private final AtomicInteger ai;
    private final String rootPath;

    public static List<Handler> create(String rootPath, String filename) {
        List<PrefixFileLogHandler> list = Arrays.asList(new PrefixFileLogHandler(rootPath, filename));
        return list;
    }

    public static List<Handler> create(String rootPath, String filename, boolean incrementStrategy) {
        List<PrefixFileLogHandler> list = Arrays.asList(new PrefixFileLogHandler(rootPath, filename, incrementStrategy));
        return list;
    }

    public PrefixFileLogHandler(String rootPath, String prefix) {
        this(rootPath, prefix, false);
    }

    public PrefixFileLogHandler(String rootPath, String prefix, boolean incrementStrategy) {
        this.rootPath = rootPath;
        this.prefix = prefix;
        this.incrementStrategy = incrementStrategy;
        this.ai = new AtomicInteger(0);
        this.ti = new ThreadLocal();
    }

    @Override
    protected File getRequest() {
        File file;
        if (this.incrementStrategy) {
            int i = this.ai.addAndGet(1);
            this.ti.set(i);
            file = new File(String.valueOf(this.rootPath) + "/" + this.prefix + "_" + i + "_request.xml");
        } else {
            file = new File(String.valueOf(this.rootPath) + "/" + this.prefix + "_request.xml");
        }
        PrefixFileLogHandler.makePathForFile(file);
        return file;
    }

    @Override
    protected File getResponse() {
        File file;
        if (this.incrementStrategy) {
            Integer i = this.ti.get();
            file = new File(String.valueOf(this.rootPath) + "/" + this.prefix + "_" + i + "_response.xml");
        } else {
            file = new File(String.valueOf(this.rootPath) + "/" + this.prefix + "_response.xml");
        }
        PrefixFileLogHandler.makePathForFile(file);
        return file;
    }

    protected static void makePathForFile(File file) {
        if (file == null || file.exists()) {
            return;
        }
        String absolutePath = file.getAbsolutePath();
        File dir = new File(absolutePath.substring(0, absolutePath.lastIndexOf(File.separatorChar)));
        PrefixFileLogHandler.makePathForDir(dir);
    }

    protected static void makePathForDir(File dir) {
        if (dir.exists()) {
            return;
        }
        String absolutePath = dir.getAbsolutePath();
        PrefixFileLogHandler.makePathForFile(new File(absolutePath.substring(0, absolutePath.lastIndexOf(File.separatorChar))));
        dir.mkdir();
    }
}

