/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.fich_valid;

import ca.infodata.ofys.ui.browser.sonar.ActionResult;
import ca.infodata.syra.controller.SyraController;
import ca.infodata.syra.fich_valid.BaseTest;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.query.CodeLocalite;
import ca.infodata.syra.query.IBaseXQuery;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.query.SecteurActivite;
import ca.infodata.syra.util.ValidRamq;
import ca.infodata.syra.xsd.valid.CodLocal;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.basex.core.Context;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryException;
import org.junit.Test;

public class LocalTest
extends BaseTest {
    @Test
    public void queryEtablNodeAllTest() {
        this.callPrimeService();
        CodeLocalite dx = new CodeLocalite();
        CProfessionnal.Entente entente = CProfessionnal.Entente.OMNI;
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_LOCAL, new Integer(entente.value), null, null, null, null, "2016-03-01", null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        try {
            List<String> l = dx.getNode(criteria);
            XStream xs = dx.getXstream();
            for (String s : l) {
                CodLocal.ValCodLocal act = dx.getJavaObjectFromNode(null, s, xs);
                System.out.println(String.valueOf(act.getCodLocal()) + ": " + act.getNomLocal());
            }
        }
        catch (IOException | QueryException e) {
            e.printStackTrace();
        }
    }

    public void queryEtablAllTest() {
        this.callPrimeService();
        long t0 = System.currentTimeMillis();
        SyraController controller = new SyraController();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "1");
        ActionResult action = controller.getAction("/syra/pref/etabl", params);
        long t1 = System.currentTimeMillis();
        System.out.println("--------------------------- String " + (t1 - t0) + "ms");
    }

    public void queryByNameTest() throws QueryException, IOException {
        SecteurActivite dx = new SecteurActivite();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.INFO_ETAB, new Integer(1), new Integer(1), null, "hotel", null, "2016-03-01", null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        List<String> l = dx.getDataByCriteria(criteria, IBaseXQuery.DataType.NODE);
        Context contexte = ValidRamq.getInstance().getContext();
        for (String s : l) {
            String code = new XQuery(String.valueOf(s) + "/cod_fact/text()").execute(contexte).toString();
            String desc = new XQuery(String.valueOf(s) + "/des_cod_fact/text()").execute(contexte).toString();
            System.out.println(String.valueOf(code) + ":" + desc);
        }
    }

    public void queryElementContextTest() throws QueryException, IOException {
        SecteurActivite dx = new SecteurActivite();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.INFO_ETAB, new Integer(1), null, null, null, null, null, null, null, QueryCriteria.EtablType.SO);
        List<String> l = dx.getDataByCriteria(criteria, IBaseXQuery.DataType.CODE_DESCR);
        for (String s : l) {
            System.out.println(s);
        }
    }

    public void primeService() {
        SecteurActivite dx = new SecteurActivite();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.SECT_ACTIV, new Integer(1), new Integer(1), new String[]{"190"}, null, null, "2016-03-01", null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        try {
            List<String> dataByCriteria = ((IBaseXQuery)dx).getDataByCriteria(criteria, IBaseXQuery.DataType.CODE_DESCR);
            for (String s : dataByCriteria) {
                System.out.print(".");
            }
            System.out.print(" ");
        }
        catch (IOException | QueryException e) {
            e.printStackTrace();
        }
    }
}

