/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.controller;

import ca.infodata.dossier.DemListCriteria;
import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.dossier.gmf.GmfPlugin;
import ca.infodata.dossier.hibernate.City;
import ca.infodata.dossier.hibernate.Gmf;
import ca.infodata.dossier.hibernate.Patient;
import ca.infodata.dossier.hibernate.PrefProf;
import ca.infodata.dossier.hibernate.PrefProfType;
import ca.infodata.dossier.hibernate.Professionnal;
import ca.infodata.dossier.hibernate.base.BaseDemForListeDAO;
import ca.infodata.dossier.hibernate.base.BaseGmfDAO;
import ca.infodata.dossier.hibernate.base.BasePatientDAO;
import ca.infodata.dossier.hibernate.base.BaseProfessionnalDAO;
import ca.infodata.dossier.hibernate.fmedx.Archive_dpacte;
import ca.infodata.dossier.hibernate.fmedx.Et_det;
import ca.infodata.dossier.hibernate.fmedx.Groupe;
import ca.infodata.dossier.hibernate.fmedx.base.BaseEt_detDAO;
import ca.infodata.dossier.hibernate.fmedx.dao.FmedxBaseDAO;
import ca.infodata.dossier.hibernate.login.GlobalPreference;
import ca.infodata.dossier.hibernate.login.base.BaseGlobalPreferenceDAO;
import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.dossier.version.VersionPlugin;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IProfessionnal;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.browser.Activator;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.SyraSocket;
import ca.infodata.ofys.ui.browser.sonar.ActionResult;
import ca.infodata.ofys.util.date.DateUtil;
import ca.infodata.ofys.util.date.LocalDate;
import ca.infodata.oscmd.Vnc;
import ca.infodata.ramq.b2b2.ServModifInscr.StatusReasonCode;
import ca.infodata.syra.InscriptionB2bMethods;
import ca.infodata.syra.SyraAccessorClient;
import ca.infodata.syra.SyraPlugin;
import ca.infodata.syra.controller.APIUtils;
import ca.infodata.syra.controller.NetworkUtil;
import ca.infodata.syra.controller.RunnableSendDemPaimt;
import ca.infodata.syra.controller.RunnableSendDemPaimtTpsReel;
import ca.infodata.syra.controller.SyraPrefAndXmlDataController;
import ca.infodata.syra.controller.SyraSettings;
import ca.infodata.syra.controller.ValidReglePlafException;
import ca.infodata.syra.handlers.PrefixFileLogHandler;
import ca.infodata.syra.models.B2bGetInscr;
import ca.infodata.syra.models.B2bPatientData;
import ca.infodata.syra.models.B2bSituSant;
import ca.infodata.syra.models.CArchivedBill;
import ca.infodata.syra.models.CDemAnnu;
import ca.infodata.syra.models.CDemAnnuRecev;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CDemForListe;
import ca.infodata.syra.models.CDemModif;
import ca.infodata.syra.models.CDemModifRecev;
import ca.infodata.syra.models.CDemPaimt;
import ca.infodata.syra.models.CDemPaimtRecev;
import ca.infodata.syra.models.CDemdr;
import ca.infodata.syra.models.CEtab;
import ca.infodata.syra.models.CExplPaimt;
import ca.infodata.syra.models.CFactExplPmt;
import ca.infodata.syra.models.CGmf;
import ca.infodata.syra.models.CLieu;
import ca.infodata.syra.models.CLigneTypServMdcal;
import ca.infodata.syra.models.CLocal;
import ca.infodata.syra.models.CModaPaimt;
import ca.infodata.syra.models.CObjectUtils;
import ca.infodata.syra.models.CPatient;
import ca.infodata.syra.models.CProfExplPmt;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.models.CProfessionnalPrefData;
import ca.infodata.syra.models.CSummaryBill;
import ca.infodata.syra.models.CTypDiagnMdcal;
import ca.infodata.syra.models.CTypLigneFactRecev;
import ca.infodata.syra.models.CTypeObject;
import ca.infodata.syra.models.CUidObject;
import ca.infodata.syra.models.CUser;
import ca.infodata.syra.models.CodeBigIntCodFact;
import ca.infodata.syra.models.CodeDesc;
import ca.infodata.syra.models.FichierAideData;
import ca.infodata.syra.models.IdDesc;
import ca.infodata.syra.models.IdentSyra;
import ca.infodata.syra.models.PatientData;
import ca.infodata.syra.query.FactExplPaimt;
import ca.infodata.syra.query.IBaseXExplPaimtQuery;
import ca.infodata.syra.query.IBaseXQuery;
import ca.infodata.syra.query.MsgExpl;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.query.Versions;
import ca.infodata.syra.services.EchgLotFichExplnSortantCriteria;
import ca.infodata.syra.services.EchgLotFichExplnSortantResult;
import ca.infodata.syra.services.EchgLotFichExplnSortantService;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.infodata.syra.util.DownloadValideur;
import ca.infodata.syra.util.GsonAdapters;
import ca.infodata.syra.util.JoinList;
import ca.infodata.syra.util.ValidNoProfNam;
import ca.infodata.syra.util.ValidObject;
import ca.infodata.syra.util.ValidRamq;
import ca.infodata.syra.xsd.valid.CodLocal;
import ca.infodata.syra.xsd.valid.InfoEtab;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.file.FileUtil;
import ca.qc.gouv.ramq.rfp.DemAnnu;
import ca.qc.gouv.ramq.rfp.DemAnnuRecev;
import ca.qc.gouv.ramq.rfp.DemModif;
import ca.qc.gouv.ramq.rfp.DemModifRecev;
import ca.qc.gouv.ramq.rfp.DemPaimt;
import ca.qc.gouv.ramq.rfp.DemPaimtRecev;
import ca.qc.gouv.ramq.rfp.IdFactRamqRecev;
import ca.qc.gouv.ramq.rfp.TypDem;
import ca.qc.gouv.ramq.rfp.TypFact;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.DateUtils;
import org.basex.query.QueryException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.program.Program;

public class SyraController
extends SyraPrefAndXmlDataController {
    private static final Logger logger = Logger.getLogger(SyraController.class.getName());
    ExecutorService executor = Executors.newSingleThreadExecutor();
    protected ScheduledExecutorService fScheduler = Executors.newScheduledThreadPool(1);
    protected RunnableSendDemPaimt runnableSendDemPaimt;
    protected RunnableSendDemPaimtTpsReel runnableSendDemPaimtTpsReel;
    private final IdentSyra identSyra;
    public ScheduledFuture<?> shedulerFuture;
    public static String fmedxHomeInscrClient;
    private Comparator<CDemPaimt> compCDemPaimt = new Comparator<CDemPaimt>(){

        @Override
        public int compare(CDemPaimt o1, CDemPaimt o2) {
            Integer n1 = Integer.valueOf(o1.cNoDemExt);
            Integer n2 = Integer.valueOf(o2.cNoDemExt);
            return n1.compareTo(n2);
        }
    };
    private Comparator<CSummaryBill> compCSummaryBill = new Comparator<CSummaryBill>(){

        @Override
        public int compare(CSummaryBill o1, CSummaryBill o2) {
            return o1.ds.compareTo(o2.ds);
        }
    };
    Map<String, Integer> mapFavModel = new HashMap<String, Integer>();

    static {
        try {
            fmedxHomeInscrClient = String.valueOf(LibPlugin.getFMEDX_HOME()) + "inscr_client/";
        }
        catch (Exception e) {
            fmedxHomeInscrClient = "inscr_client/";
            e.printStackTrace();
        }
    }

    public SyraController() {
        this.identSyra = new IdentSyra();
        this.runnableSendDemPaimt = new RunnableSendDemPaimt(this);
        this.runnableSendDemPaimtTpsReel = new RunnableSendDemPaimtTpsReel(this);
    }

    public void setRunnableSendDempPaimt() {
        SyraGlobalSettings globalSettings = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
        boolean envoiTpsReel = Boolean.TRUE.equals(globalSettings.getBoolean("envoi_tps_reel"));
        if (envoiTpsReel && this.runnableSendDemPaimtTpsReel.isStop()) {
            if (!this.runnableSendDemPaimt.isStop()) {
                this.runnableSendDemPaimt.setStop(true);
                if (this.shedulerFuture != null) {
                    this.shedulerFuture.cancel(false);
                    while (!this.shedulerFuture.isDone()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.fScheduler.shutdown();
            this.fScheduler = Executors.newScheduledThreadPool(1);
            this.runnableSendDemPaimtTpsReel.setStop(false);
            this.shedulerFuture = this.fScheduler.scheduleWithFixedDelay(this.runnableSendDemPaimtTpsReel, 1000L, 500L, TimeUnit.MILLISECONDS);
        } else if (!envoiTpsReel && this.runnableSendDemPaimt.isStop()) {
            if (!this.runnableSendDemPaimtTpsReel.isStop()) {
                this.runnableSendDemPaimtTpsReel.setStop(true);
                if (this.shedulerFuture != null) {
                    this.shedulerFuture.cancel(false);
                    while (!this.shedulerFuture.isDone()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.fScheduler.shutdown();
            this.fScheduler = Executors.newScheduledThreadPool(1);
            this.runnableSendDemPaimt.setStop(false);
            this.shedulerFuture = this.fScheduler.scheduleWithFixedDelay(this.runnableSendDemPaimt, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    public ActionResult index() {
        ActionResult res = new ActionResult("index.html", "/index.html");
        return res;
    }

    public ActionResult preferences() {
        String prefHtml = "Resources/views/fav.html";
        ActionResult res = new ActionResult(prefHtml, "/" + prefHtml);
        return res;
    }

    public ActionResult editPatient() {
        String prefHtml = "Resources/views/editpatient.html";
        ActionResult res = new ActionResult(prefHtml, "/" + prefHtml);
        return res;
    }

    public ActionResult editRepresentant() {
        String prefHtml = "Resources/views/editRepresentant.html";
        ActionResult res = new ActionResult(prefHtml, "/" + prefHtml);
        return res;
    }

    public void savePatient(CPatient pat) {
        IPatient p = this.getAccessor().savePatient(pat);
        pat.setId(p.getId());
    }

    public Integer saveProf(CProfessionnal prof) {
        IProfessionnal iProfessionnal = this.getAccessor().saveProfessionnal(prof);
        if (iProfessionnal != null) {
            return iProfessionnal.getId();
        }
        return null;
    }

    private CUser getActiveUser() {
        return this.getAccessor().getActiveUser();
    }

    private CUser[] getUsers() {
        return this.getAccessor().getActiveUsers().toArray(new CUser[0]);
    }

    private IPatient[] findSimplePatient(String k) {
        return this.getAccessor().findPatients(k);
    }

    private Object[] findNamFromHistoricFact(String k) {
        return this.getAccessor().findNamFromHistoricFact(k);
    }

    public CProfessionnal[] findProfessionals(String searchString) {
        if (searchString != null && searchString.trim().length() > 2) {
            List<IProfessionnal> profs = this.getAccessor().findProfessionnals(searchString, false);
            if (profs.size() == 0) {
                try {
                    profs = this.getAccessor().findProfessionnals(searchString, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ArrayList<CProfessionnal> viewProfs = new ArrayList<CProfessionnal>();
            for (IProfessionnal p : profs) {
                CProfessionnal pr = CObjectUtils.getCProfFromIProf(p);
                if (pr == null) continue;
                viewProfs.add(pr);
            }
            if (viewProfs.size() > 0) {
                return viewProfs.toArray(new CProfessionnal[viewProfs.size()]);
            }
        }
        return new CProfessionnal[0];
    }

    public CodeDesc[] searchGroup(String searchString) {
        if (searchString != null) {
            List<Groupe> profs = this.getAccessor().getGroups(searchString);
            ArrayList<CodeDesc> viewProfs = new ArrayList<CodeDesc>();
            for (Groupe p : profs) {
                CodeDesc cd = new CodeDesc(p.getNumero(), p.getDescrip());
                viewProfs.add(cd);
            }
            if (viewProfs.size() > 0) {
                return viewProfs.toArray(new CodeDesc[viewProfs.size()]);
            }
        }
        return new CodeDesc[0];
    }

    public IdDesc[] searchCity(String searchString) {
        List<City> cities;
        if (searchString != null && (cities = this.getAccessor().getCities(searchString)) != null) {
            ArrayList<IdDesc> viewProfs = new ArrayList<IdDesc>();
            for (City p : cities) {
                IdDesc cd = new IdDesc(p.getId(), p.getName());
                viewProfs.add(cd);
            }
            if (viewProfs.size() > 0) {
                return viewProfs.toArray(new IdDesc[viewProfs.size()]);
            }
        }
        return new IdDesc[0];
    }

    public ActionResult getAction(String target, Map<String, String> params) {
        Integer type;
        String debut;
        String actionName = target.substring("/syra".length() + 1);
        String uid = params.get("u");
        CUidObject cUidObject = null;
        if (actionName.equals("launch_local")) {
            String k = params.get("k");
            String url = "http://127.0.0.1:" + HtmlBrowserTools.getJettyPort() + "/syra/index";
            if ("true".equals(k)) {
                Program.launch((String)url);
            }
            String[] obj = new String[]{url, String.valueOf(HtmlBrowserTools.getJettyPort())};
            return APIUtils.toJson(obj);
        }
        if (actionName.equals("launch")) {
            String k = params.get("k");
            String url = "http://" + NetworkUtil.getCurrentEnvironmentNetworkIp() + ":" + HtmlBrowserTools.getJettyPort() + "/syra/index";
            if ("true".equals(k)) {
                Program.launch((String)url);
            }
            String[] obj = new String[]{url, String.valueOf(HtmlBrowserTools.getJettyPort())};
            return APIUtils.toJson(obj);
        }
        if (uid == null && actionName.endsWith("/post")) {
            String jData = params.get("jsonData");
            if (jData != null && !jData.startsWith("{}")) {
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                cUidObject = (CUidObject)gson.fromJson(params.get("jsonData"), CUidObject.class);
            }
            if (cUidObject != null) {
                uid = cUidObject.getUid();
            }
        }
        CDemContainer cDemContainer = null;
        if (uid != null) {
            if (this.mapDemContainer.containsKey(uid)) {
                cDemContainer = (CDemContainer)this.mapDemContainer.get(uid);
            } else {
                cDemContainer = new CDemContainer(uid);
                this.mapDemContainer.put(uid, cDemContainer);
            }
        }
        Object res = new String[]{};
        if (actionName.equals("index") || StringUtils.isEmpty((String)actionName)) {
            res = this.index();
        } else if (cDemContainer == null) {
            res = new String[]{"Erreur = cDemContainer null au backend"};
        } else if (actionName.equals("patient/search")) {
            res = this.searchPatient(params);
        } else if (actionName.equals("validNam/get")) {
            res = this.getValidNam(params, cDemContainer);
        } else if (actionName.equals("currentvalue/post")) {
            this.postCurrentValue(cUidObject, cDemContainer);
        } else if (actionName.equals("professionals")) {
            res = this.getBillingProfessionals(null);
        } else if (actionName.equals("addProfessionals/post")) {
            res = this.addProfessionnals(cUidObject, res);
        } else if (actionName.equals("professionaltypes")) {
            res = SyraAccessorClient.getInstance().getProfessionnalTypes();
        } else if (actionName.equals("professionalspeciality")) {
            res = SyraAccessorClient.getInstance().getAllSpeciality();
        } else if (actionName.equals("preferences")) {
            res = this.preferences();
        } else if (actionName.equals("editpatient")) {
            res = this.editPatient();
        } else if (actionName.equals("editRepresentant")) {
            res = this.editRepresentant();
        } else if (actionName.equals("save_patient_data/post")) {
            res = this.savePatientData(cUidObject, cDemContainer, res);
        } else if (actionName.equals("repondant/get")) {
            res = this.getRepondant(cDemContainer, uid);
        } else if (actionName.equals("editpatient/post")) {
            res = this.postEditPatient(cUidObject, cDemContainer, res);
        } else if (actionName.equals("professionals/search")) {
            res = this.getBillingProfessionals(params);
        } else if (actionName.equals("professionals/get")) {
            res = this.getProfessionals(params, res);
        } else if (actionName.equals("referant/search")) {
            res = this.searchReferant(params);
        } else if (actionName.equals("group/search")) {
            res = this.searchGroup(params.get("k"));
        } else if (actionName.equals("city/search")) {
            res = this.searchCity(params.get("k"));
        } else if (actionName.equals("lieu_typLocEtab/post")) {
            this.postLieuTypLocEtab(cUidObject, cDemContainer);
        } else if (actionName.equals("lieu_typIdLieuGeo/post")) {
            this.postLieuTypIdLieuGeo(cUidObject, cDemContainer);
        } else if (actionName.equals("lieu_typLieuGeo/post")) {
            this.postLieuTypLieuGeo(cUidObject, cDemContainer);
        } else if (actionName.equals("lieu_codLocal/post")) {
            this.postLieuCodLocal(cUidObject, cDemContainer);
        } else if (actionName.equals("lieu_noSelectedEtab/post")) {
            this.postLieuNoSelectedEtab(cUidObject, cDemContainer);
        } else if (actionName.equals("lieu_sect_c/post")) {
            this.postLieuSectC(cUidObject, cDemContainer);
        } else if (actionName.equals("lieu_codPreciSectActiv/post")) {
            this.postLieuCodPreciSectActiv(cUidObject, cDemContainer);
        } else if (actionName.equals("lieu_codPreciLieu/post")) {
            this.postLieuCodPreciLieu(cUidObject, cDemContainer);
        } else if (actionName.equals("local/post")) {
            this.postLocal(cUidObject, cDemContainer);
        } else if (actionName.equals("etabl/post")) {
            this.postEtabl(cUidObject, cDemContainer);
        } else if (actionName.equals("demListeToPrint/get")) {
            res = this.getAllDemPaimtToPrint(cDemContainer);
        } else if (actionName.equals("demListeSummaryToPrint/get")) {
            res = this.getAllSummaryDemPaimtToPrint(cDemContainer);
        } else if (actionName.equals("demPaimt/getNew")) {
            res = cDemContainer.getNewCDemPaimt();
        } else if (actionName.equals("demPaimt/getCopy")) {
            res = cDemContainer.getCopyCDemPaimt(params);
        } else if (actionName.equals("ligneServMdcal/getNew")) {
            res = cDemContainer.getNewCLigneServMdcal(params);
        } else if (actionName.equals("ligneServMdcal/post")) {
            this.postLigneServMdcal(cUidObject, cDemContainer);
        } else if (actionName.equals("ligneServMdcalDate/post")) {
            this.postLigneServMdcalDate(cUidObject, cDemContainer);
        } else if (actionName.equals("ligneServMdcalRole/post")) {
            this.postLigneServMdcalRole(cUidObject, cDemContainer);
        } else if (actionName.equals("ligneServMdcalCode/post")) {
            this.postLigneServMdcalCode(cUidObject, cDemContainer);
        } else if (actionName.equals("removeLigneServMdcalFromLst/post")) {
            this.postRemoveLigneServMdcalFromLst(cUidObject, cDemContainer);
        } else if (actionName.equals("historic_bill/post")) {
            res = this.postHistoricBill(uid, cDemContainer);
        } else if (actionName.equals("plaf_bill/post")) {
            res = this.postPlafBill(uid, cDemContainer);
        } else if (actionName.equals("bill/post")) {
            this.postBill(cUidObject, cDemContainer);
        } else if (actionName.equals("restore_bill/post")) {
            this.postRestoreBill(cUidObject, cDemContainer);
        } else if (actionName.equals("delete_bill/post")) {
            this.postDeleteBill(cUidObject, cDemContainer);
        } else if (actionName.equals("annu_bill/post")) {
            res = this.postAnnuBill(cUidObject, cDemContainer);
        } else if (actionName.equals("save_bill/post")) {
            res = this.saveBill(cUidObject, cDemContainer);
        } else if (actionName.equals("referant/search")) {
            res = this.searchReferant(params);
        } else if (actionName.equals("users")) {
            res = this.getUsersAndDefaults(uid, cDemContainer);
        } else if (actionName.equals("senddefaultsws")) {
            this.sendAllDefaultsToUi(uid, cDemContainer);
        } else if (actionName.equals("demliste/post")) {
            this.postDemListe(cUidObject, cDemContainer);
        } else if (actionName.equals("activeuser")) {
            res = this.getActiveMedofficeUser();
        } else if (actionName.equals("diagnostic/search")) {
            res = this.searchDiagnostic(params, cDemContainer);
        } else if (actionName.equals("diagnostic/get")) {
            res = this.getDiagnostic(params, cDemContainer);
        } else if (actionName.equals("codefacturation/search")) {
            res = this.searchCodeFacturation(params, cDemContainer);
        } else if (actionName.equals("contx/search")) {
            res = this.searchContx(params, cDemContainer);
        } else if (actionName.equals("local/search")) {
            res = this.searchLocal(params, cDemContainer);
        } else if (actionName.equals("etabl/search")) {
            res = this.searchEtabl(params, cDemContainer);
        } else if (actionName.equals("secteur/search")) {
            res = this.searchSecteur(params, cDemContainer);
        } else if (actionName.equals("generidmach/post")) {
            this.postGenericIdMach(cUidObject);
        } else if (actionName.equals("actividmach/post")) {
            this.postActivIdMach(cUidObject);
        } else if (actionName.equals("buildversionforhelp/get")) {
            res = VersionPlugin.getBuildVersionForHelp();
        } else if (actionName.equals("fichiersversions/newavailversion")) {
            res = this.newAvailVersionFichiersVersions();
        } else if (actionName.equals("fichiersversions/update")) {
            res = this.updateFichiersVersions(cDemContainer, uid);
        } else if (actionName.equals("fichiersversions/get")) {
            res = this.getFichiersVersions();
        } else if (actionName.equals("local/get")) {
            res = this.getLocal(params, cDemContainer, uid, res);
        } else if (actionName.equals("etabl/get")) {
            res = this.getEtabl(params, cDemContainer, uid, res);
        } else if (actionName.equals("secteur/get")) {
            res = this.getSecteur(params, cDemContainer, uid, res);
        } else if (actionName.equals("codefacturation/get")) {
            res = this.getCodeFacturation(params, cDemContainer, res);
        } else if (actionName.equals("contx/get")) {
            res = this.getContx(params, cDemContainer);
        } else if (actionName.equals("setCurrentDemForListeVal/mm")) {
            this.setCurrentDemForListeVal_mm(params, cDemContainer);
        } else if (actionName.equals("setCurrentDemForListeVal/ready")) {
            this.setCurrentDemForListeVal_ready(params, cDemContainer);
            if (Boolean.TRUE.equals(CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).getBoolean("envoi_tps_reel")) && !this.runnableSendDemPaimtTpsReel.isStop()) {
                this.runnableSendDemPaimtTpsReel.addDemPaimt(new RunnableSendDemPaimtTpsReel.DemPaimtTpsReel(cDemContainer.uid, cDemContainer, cDemContainer.getCurrentCDemForListe(), null));
            }
        } else if (actionName.equals("setCurrentDemForListeVal/prg")) {
            this.setCurrentDemForListeVal_prg(params, cDemContainer);
        } else if (actionName.equals("setCurrentDemForListeVal/dt")) {
            this.setCurrentDemForListeVal_dt(params, cDemContainer);
        } else if (actionName.equals("setCurrentDemForListeVal/sr")) {
            this.setCurrentDemForListeVal_sr(params, cDemContainer);
        } else if (actionName.equals("setCurrentDemForListeVal/np")) {
            this.setCurrentDemForListeVal_np(params, cDemContainer);
        } else if (actionName.equals("setCurrentDemForListeVal/ii")) {
            this.setCurrentDemForListeVal_ii(params, cDemContainer);
        } else if (actionName.equals("setdefaut/get")) {
            this.getSetDefaut(params, cDemContainer, uid);
        } else if (actionName.equals("jetty/restart")) {
            Activator.getDefault().restartJetty();
            SyraPlugin.getDefault().startSyraController();
        } else if (actionName.equals("setglobaldefaut/get")) {
            this.getSetGlobalDefaut(params);
        } else if (actionName.equals("fav_model/search")) {
            res = this.searchFavModel(params, cDemContainer);
        } else if (actionName.equals("fav_model/get")) {
            res = this.getFavModel(params, cDemContainer, res);
        } else if (actionName.equals("pref/save_all")) {
            res = this.prefSaveAll(params);
        } else if (actionName.equals("pref/diag")) {
            res = this.prefDiag(params, res);
        } else if (actionName.equals("pref/diag/mod")) {
            this.prefDiagMod(params);
        } else if (actionName.equals("pref/fact")) {
            res = this.prefFact(params, res);
        } else if (actionName.equals("pref/fact/mod")) {
            this.prefFactMod(params);
        } else if (actionName.equals("pref/local")) {
            res = this.prefLocal(params, res);
        } else if (actionName.equals("pref/local/mod")) {
            this.prefLocalMod(params);
        } else if (actionName.equals("pref/elmcontx")) {
            res = this.prefElmContx(params, res);
        } else if (actionName.equals("pref/elmcontx/mod")) {
            this.prefElmContxMod(params);
        } else if (actionName.equals("pref/etabl")) {
            res = this.prefEtabl(params, res);
        } else if (actionName.equals("pref/etabl/mod")) {
            this.prefEtablMod(params);
        } else if (actionName.equals("pref/sect")) {
            res = this.prefSect(params, res);
        } else if (actionName.equals("pref/sect/mod")) {
            this.prefSectMod(params);
        } else if (actionName.equals("pref/autre")) {
            res = this.prefAutre(params, res);
        } else if (actionName.equals("pref/autre/mod")) {
            this.prefAutreMod(params);
        } else if (actionName.equals("pref/copy")) {
            this.prefCopy(params);
        } else if (actionName.equals("somm_fact/get")) {
            debut = params.get("d");
            String fin = params.get("f");
            DemListCriteria criteria = new DemListCriteria(debut, fin, null, null, new Integer(1), null, null, null, null, null);
            criteria.getCodesFromArch = "1".equals(params.get("c"));
            criteria.excludeAnnulFact = Boolean.TRUE;
            criteria.getEtabFromArch = "1".equals(params.get("e"));
            criteria.andModified = "1".equals(params.get("m"));
            if (criteria.getEtabFromArch.booleanValue()) {
                CArchivedBill[] facturation = SyraAccessorClient.getInstance().getArchiveFacturationFromFactCreationDate(debut, fin, criteria.andModified);
                res = facturation;
            } else {
                List<CDemForListe> demListe = this.getDemListe(criteria);
                CDemForListe[] demLst = new CDemForListe[demListe.size()];
                demLst = demListe.toArray(demLst);
                res = demLst;
            }
        } else if (actionName.equals("somm_serv/get")) {
            CArchivedBill[] facturation;
            debut = params.get("d");
            String fin = params.get("f");
            res = facturation = SyraAccessorClient.getInstance().getArchiveFacturation(debut, fin);
        } else if (actionName.equals("somm_serv_nam/get")) {
            debut = params.get("d");
            String fin = params.get("f");
            CArchivedBill[] facturation = SyraAccessorClient.getInstance().getArchiveFacturationGroupByNam(debut, fin);
            res = facturation;
        } else if (actionName.equals("fich_expl/search")) {
            res = this.searchFichExplDejaObtenu(params, cDemContainer);
        } else if (actionName.equals("fich_expl_new/get")) {
            res = this.fichExplNew(params, cDemContainer);
        } else if (actionName.equals("fich_expl/get")) {
            res = this.getFichExplDejaObtenu(params, cDemContainer, res);
        } else if (actionName.equals("last_date_entree/get")) {
            String noEtab = params.get("e");
            res = this.getLastDateEntree(uid, cDemContainer, noEtab);
        } else if (actionName.equals("valid_plafon/get")) {
            res = this.getValidPlafon(params, cDemContainer);
        } else if (actionName.equals("b2bData/get")) {
            res = this.getB2bData(cDemContainer, uid);
        } else if (actionName.equals("gmfs/post")) {
            res = this.saveEtabIdInscrData(cUidObject, cDemContainer);
        } else if (actionName.equals("gmfs_del/post")) {
            res = this.deleteEtabIdInscrData(cUidObject, cDemContainer);
        } else if (actionName.equals("gmfs/get")) {
            res = this.getEtabIdInscrData(cDemContainer, uid);
        } else if (actionName.equals("gmfs/getNew")) {
            res = this.getNewEtabIdInscr(cDemContainer, uid);
        } else if (actionName.equals("b2b_updatePassword/post")) {
            res = this.updatePasswordB2b(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_transmettreInscription/post")) {
            res = this.transmettreInscription(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_cesserInscription/post")) {
            res = this.cesserInscription(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_supprimerInscription/post")) {
            res = this.supprimerInscription(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_changeDate/post")) {
            res = this.changeDate(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_modifRepres/post")) {
            res = this.modifRepres(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_supprimerRepres/post")) {
            res = this.supprimerRepres(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_modifResident/post")) {
            res = this.modifierResident(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_supprimerResident/post")) {
            res = this.supprimerResident(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_ajouterLieuSuivi/post")) {
            res = this.ajouterLieuSuivi(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_modifierLieuSuivi/post")) {
            res = this.corrigerLieuSuivi(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_supprimerLieuSuivi/post")) {
            res = this.supprimerLieuSuivi(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_sendModVuln/post")) {
            res = this.sendModVuln(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_getInscr/post")) {
            res = this.getB2bInscr(cUidObject, cDemContainer);
        } else if (actionName.equals("b2b_inscrClient/search")) {
            res = this.searchFichInscrClient(params, cDemContainer);
        } else if (actionName.equals("b2b_inscrClient/get")) {
            res = this.getFichierInscrClient(params, cDemContainer, res);
        } else if (actionName.equals("aide_dist/post")) {
            Vnc vnc = new Vnc();
            vnc.run(null);
        } else if (actionName.equals("share_dme_activate/post")) {
            System.out.println("pour activer sharing");
            type = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).getInt("share_dme");
            if (type != null) {
                String aType = "_";
                if (type == 1) {
                    aType = "ofys";
                }
                if (type == 2) {
                    aType = "oscar";
                }
                SyraPlugin.getDefault().activateSharing(aType, uid);
            }
        } else if (actionName.equals("share_dme_deactivate/post")) {
            System.out.println("pour d\u00e9sactiver sharing");
            type = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).getInt("share_dme");
            String aType = "_";
            if (type != null) {
                if (type == 1) {
                    aType = "ofys";
                }
                if (type == 2) {
                    aType = "oscar";
                }
                SyraPlugin.getDefault().stopSharing(aType);
            }
        }
        ActionResult ar = res == null ? null : APIUtils.toJson(res);
        return ar;
    }

    private Object getValidPlafon(Map<String, String> params, CDemContainer cDemContainer) {
        String code = params.get("c");
        String noEtab = params.get("e");
        Status res = null;
        boolean inGmf = "1".equals(params.get("g"));
        if (StringUtils.isEmpty((String)code) || StringUtils.isEmpty((String)noEtab)) {
            res = new Status(IStatus.Severity.ERROR, "");
        } else {
            boolean canDoIt = true;
            if (inGmf) {
                canDoIt = false;
                CProfessionnalPrefData prefData = SyraAccessorClient.getInstance().getPrefData(cDemContainer.getCurrentProf().getId());
                String gmfNo = prefData.getPrefAutre("gmf");
                String[] gmfNos = null;
                if (StringUtils.isNotEmpty((String)gmfNo)) {
                    String[] stringArray = gmfNos = gmfNo.split("[, ]{1,2}");
                    int n = gmfNos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ss = stringArray[n2];
                        if (noEtab.equals(ss.trim())) {
                            canDoIt = true;
                            break;
                        }
                        ++n2;
                    }
                } else {
                    res = new Status(IStatus.Severity.WARNING, "Code non permis");
                }
            }
            if (canDoIt) {
                String stringToHash = cDemContainer.getCurrentPatient().getStringForHash(1);
                int hashCode = CPatient.getStringToHashCode(stringToHash);
                String ddn = cDemContainer.getCurrentPatient().bds;
                Calendar calDdn = DateUtil.ctod((String)ddn);
                String dateServ = cDemContainer.getCurrentCLigneServMdcal().dateServ;
                Calendar calDateServ = DateUtil.ctod((String)dateServ);
                Long noRfp = cDemContainer.getCurrentCDemForListe().getNoRfp();
                System.out.println("GMF - Date du service: " + dateServ + ", stringToHash=" + stringToHash + ", noEtab=" + noEtab + ", code=" + code + ", noRfp=" + noRfp);
                res = SyraAccessorClient.getInstance().validForPlafond(hashCode, cDemContainer.getCurrentProf(), noEtab, calDdn, null, noRfp, calDateServ, Integer.valueOf(code), null);
            } else {
                res = new Status(IStatus.Severity.WARNING, "Code non permis");
            }
        }
        return res;
    }

    private void postRemoveLigneServMdcalFromLst(CUidObject cUidObject, CDemContainer cDemContainer) {
        Integer b = null;
        if (cUidObject != null && cDemContainer.getCurrentCLigneServMdcal() != null) {
            Double noLigne;
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof Double && (noLigne = (Double)cUidObject.getObject()) != null) {
                b = new Integer(noLigne.intValue());
            }
            if (b != null) {
                CLigneTypServMdcal servMdcal = cDemContainer.getCurrentDemPaimt().serv.mapTempLigneFact.remove(b);
                System.out.println("Tried to remove " + b + ", r\u00e9p. = " + (servMdcal == null ? null : String.valueOf(servMdcal.dateServ) + ", " + (servMdcal.codFact == null ? "codFact is null" : servMdcal.codFact.c)));
            }
        }
    }

    private void postLigneServMdcalCode(CUidObject cUidObject, CDemContainer cDemContainer) {
        CodeBigIntCodFact codFact = null;
        if (cUidObject != null && cDemContainer.getCurrentCLigneServMdcal() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof CodeBigIntCodFact) {
                codFact = (CodeBigIntCodFact)cUidObject.getObject();
            }
            if (codFact != null) {
                cDemContainer.getCurrentCLigneServMdcal().codFact = codFact;
            }
        }
    }

    private void postLigneServMdcalRole(CUidObject cUidObject, CDemContainer cDemContainer) {
        Integer codRole = null;
        if (cUidObject != null && cDemContainer.getCurrentCLigneServMdcal() != null) {
            Double tempDouble;
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof Double && (tempDouble = (Double)cUidObject.getObject()) != null) {
                codRole = new Integer(tempDouble.intValue());
            }
            if (codRole != null) {
                cDemContainer.getCurrentCLigneServMdcal().codRole = codRole;
            }
        }
    }

    private void postLigneServMdcalDate(CUidObject cUidObject, CDemContainer cDemContainer) {
        String date = null;
        if (cUidObject != null && cDemContainer.getCurrentCLigneServMdcal() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof String) {
                date = (String)cUidObject.getObject();
            }
            if (StringUtils.isNotEmpty(date)) {
                cDemContainer.getCurrentCLigneServMdcal().dateServ = date;
            }
        }
    }

    private void postLigneServMdcal(CUidObject cUidObject, CDemContainer cDemContainer) {
        Integer b = null;
        CLigneTypServMdcal s = null;
        if (cUidObject != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap)) {
                if (cUidObject.getObject() instanceof Double) {
                    Double noLigne = (Double)cUidObject.getObject();
                    if (noLigne != null) {
                        b = new Integer(noLigne.intValue());
                    }
                } else {
                    Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                    s = (CLigneTypServMdcal)gson.fromJson((String)cUidObject.getObject(), CLigneTypServMdcal.class);
                }
            }
            if (b != null) {
                CLigneTypServMdcal currentLigne = cDemContainer.getCurrentDemPaimt().serv.mapTempLigneFact.get(b);
                if (currentLigne == null) {
                    Status status2 = new Status(IStatus.Severity.WARNING, "");
                    CTypeObject to1 = new CTypeObject("mustSetCurrentCLigneServMdcalType", status2);
                    String message1 = new GsonBuilder().create().toJson((Object)to1);
                    HtmlBrowserTools.sendMessageToWebClient((String)cDemContainer.uid, (String)message1);
                } else {
                    cDemContainer.setCurrentValue("currentCLigneServMdcal", currentLigne);
                }
            } else if (s != null) {
                cDemContainer.setCurrentValue("currentCLigneServMdcal", s);
                cDemContainer.getCurrentDemPaimt().serv.mapTempLigneFact.put(new Integer(s.noLigne), s);
            }
        }
    }

    private Object getAllDemPaimtToPrint(CDemContainer cDemContainer) {
        Collection<CDemForListe> lstDem = cDemContainer.getMapCDemForListe().values();
        TreeMap<String, TreeSet<CDemPaimt>> mapDem = new TreeMap<String, TreeSet<CDemPaimt>>();
        for (CDemForListe cDemForListe : lstDem) {
            cDemForListe.demPaimt = null;
            DemPaimt dp = cDemForListe.getLastDemPaimt();
            if (dp == null) continue;
            CDemPaimt cDemPaimt = new CDemPaimt(dp, cDemContainer, false, true);
            this.setDemModifAnnuToDemPaimt(cDemContainer, cDemPaimt, cDemForListe, true);
            DemPaimtRecev paimtRecev = cDemForListe.getDemPaimtRecev(cDemForListe.iLastDemPaimt);
            int iLast = cDemForListe.iLastDemPaimt;
            while (paimtRecev == null && iLast > 0) {
                paimtRecev = cDemForListe.getDemPaimtRecev(--iLast);
            }
            if (paimtRecev != null) {
                cDemPaimt.recev = new CDemPaimtRecev(paimtRecev);
            }
            this.setDemModifAnnuToDemPaimt(cDemContainer, cDemPaimt, cDemForListe, true);
            TreeSet<CDemPaimt> set = (TreeSet<CDemPaimt>)mapDem.get(dp.getDemdr().getIdIntvn());
            if (set == null) {
                set = new TreeSet<CDemPaimt>(this.compCDemPaimt);
                mapDem.put(dp.getDemdr().getIdIntvn(), set);
            }
            set.add(cDemPaimt);
        }
        return mapDem;
    }

    private Object getAllSummaryDemPaimtToPrint(CDemContainer cDemContainer) {
        CSummaryBill[] bills;
        Collection<CDemForListe> lstDem = cDemContainer.getMapCDemForListe().values();
        ArrayList<Long> lstNoRfp = new ArrayList<Long>(lstDem.size());
        TreeMap mapDem = new TreeMap();
        for (CDemForListe cDemForListe : lstDem) {
            if (cDemForListe.getNoRfp() == null) continue;
            lstNoRfp.add(cDemForListe.getNoRfp());
        }
        CSummaryBill[] cSummaryBillArray = bills = SyraAccessorClient.getInstance().getSummarayFromArchiveFacturation(lstNoRfp);
        int n = bills.length;
        int n2 = 0;
        while (n2 < n) {
            TreeSet<CSummaryBill> set;
            CSummaryBill csb = cSummaryBillArray[n2];
            TreeMap<String, TreeSet<CSummaryBill>> mapProf = (TreeMap<String, TreeSet<CSummaryBill>>)mapDem.get(csb.np);
            if (mapProf == null) {
                mapProf = new TreeMap<String, TreeSet<CSummaryBill>>();
                mapDem.put(csb.np, mapProf);
            }
            if ((set = (TreeSet<CSummaryBill>)mapProf.get(String.valueOf(csb.np) + csb.lieu)) == null) {
                set = new TreeSet<CSummaryBill>(this.compCSummaryBill);
                mapProf.put(String.valueOf(csb.np) + csb.lieu, set);
            }
            set.add(csb);
            ++n2;
        }
        return mapDem;
    }

    private void postEtabl(CUidObject cUidObject, CDemContainer cDemContainer) {
        CEtab cEtab = null;
        if (cUidObject != null) {
            CLieu lieu = cDemContainer.getCurrentLieu(null);
            if (cUidObject.getObject() instanceof AbstractMap) {
                lieu.etab = new CEtab();
            } else {
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                lieu.etab = cEtab = (CEtab)gson.fromJson((String)cUidObject.getObject(), CEtab.class);
            }
            cDemContainer.setCurrentValue("currentLieu", lieu);
        }
    }

    private void postLocal(CUidObject cUidObject, CDemContainer cDemContainer) {
        CLocal cLocal = null;
        if (cUidObject != null) {
            CLieu lieu = cDemContainer.getCurrentLieu(null);
            if (cUidObject.getObject() instanceof AbstractMap) {
                lieu.local = new CLocal();
            } else {
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                lieu.local = cLocal = (CLocal)gson.fromJson((String)cUidObject.getObject(), CLocal.class);
            }
            cDemContainer.setCurrentValue("currentLieu", lieu);
        }
    }

    private void postLieuCodPreciLieu(CUidObject cUidObject, CDemContainer cDemContainer) {
        String v = null;
        if (cUidObject != null && cDemContainer.getCurrentDemPaimt() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof String) {
                v = (String)cUidObject.getObject();
            }
            if (v != null && v.trim().length() > 1) {
                v = "0";
            }
            if ("C".equals(cDemContainer.getCurrentDemPaimt().serv.lieu.typLocEtab)) {
                cDemContainer.getCurrentDemPaimt().serv.lieu.etab.codPreciLieu = v;
                cDemContainer.getCurrentLieu(null).etab.codPreciLieu = v;
            } else if ("N".equals(cDemContainer.getCurrentDemPaimt().serv.lieu.typLocEtab)) {
                cDemContainer.getCurrentDemPaimt().serv.lieu.local.codPreciLieu = v;
                cDemContainer.getCurrentLieu(null).local.codPreciLieu = v;
            }
            if (v != null) {
                cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).put("codPreciLieu", v);
            } else {
                cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).removeItem("codPreciLieu");
            }
        }
    }

    private void postLieuCodPreciSectActiv(CUidObject cUidObject, CDemContainer cDemContainer) {
        Integer v = null;
        if (cUidObject != null && cDemContainer.getCurrentDemPaimt() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof Double) {
                v = new Integer(((Double)cUidObject.getObject()).intValue());
            }
            if (v != null) {
                if (cDemContainer.getCurrentDemPaimt().serv.lieu.etab == null) {
                    cDemContainer.getCurrentDemPaimt().serv.lieu.etab = new CEtab();
                }
                cDemContainer.getCurrentDemPaimt().serv.lieu.etab.codPreciSectActiv = v;
                cDemContainer.getCurrentLieu(null).etab.codPreciSectActiv = v;
                cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).put("codPreciSectActiv", v);
            } else {
                if (cDemContainer.getCurrentDemPaimt().serv.lieu.etab != null) {
                    cDemContainer.getCurrentDemPaimt().serv.lieu.etab.codPreciSectActiv = null;
                }
                cDemContainer.getCurrentLieu(null).etab.codPreciSectActiv = null;
                cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).removeItem("codPreciSectActiv");
            }
        }
    }

    private void postLieuSectC(CUidObject cUidObject, CDemContainer cDemContainer) {
        String v = null;
        if (cUidObject != null && cDemContainer.getCurrentDemPaimt() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof String) {
                v = (String)cUidObject.getObject();
            }
            CProfessionnal currentProf = cDemContainer.getCurrentProf();
            CLieu currentLieu = cDemContainer.getCurrentLieu(currentProf);
            if (v != null) {
                CEtab.CValNoSectActiv secteur;
                if (cDemContainer.getCurrentDemPaimt().serv.lieu.etab == null) {
                    cDemContainer.getCurrentDemPaimt().serv.lieu.etab = new CEtab();
                }
                CProfessionnal.Entente ent = CProfessionnal.Entente.NON_DEF;
                if (currentProf != null && currentProf.getType() != null) {
                    ent = CProfessionnal.Entente.valueOf(currentProf.getType());
                }
                String dateDef = cDemContainer.getSyraSettings().getDateDef();
                cDemContainer.getCurrentDemPaimt().serv.lieu.etab.valSect = secteur = this.getValNoSecteur(v, ent, dateDef);
                currentLieu.etab.valSect = secteur;
                cDemContainer.getSyraSettings().setSect(String.valueOf(v) + "-" + ent.value);
            } else if (cDemContainer.getCurrentDemPaimt().serv.lieu.etab != null && currentLieu.etab.valSect != null) {
                currentLieu.etab.valSect = null;
            }
        }
    }

    private void postLieuNoSelectedEtab(CUidObject cUidObject, CDemContainer cDemContainer) {
        String v = null;
        if (cUidObject != null && cDemContainer.getCurrentDemPaimt() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof String) {
                v = (String)cUidObject.getObject();
            }
            if (v != null) {
                if (cDemContainer.getCurrentDemPaimt().serv.lieu.etab == null) {
                    cDemContainer.getCurrentDemPaimt().serv.lieu.etab = new CEtab();
                }
                cDemContainer.getCurrentDemPaimt().serv.lieu.etab.noSelectedEtab = v;
                cDemContainer.getCurrentLieu(null).etab.noSelectedEtab = v;
                cDemContainer.getSyraSettings().setEtab(v);
            }
        }
    }

    private void postLieuCodLocal(CUidObject cUidObject, CDemContainer cDemContainer) {
        String v = null;
        if (cUidObject != null && cDemContainer.getCurrentDemPaimt() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof String) {
                v = (String)cUidObject.getObject();
            }
            if (v != null) {
                if (cDemContainer.getCurrentDemPaimt().serv.lieu.local == null) {
                    cDemContainer.getCurrentDemPaimt().serv.lieu.local = new CLocal();
                }
                cDemContainer.getCurrentDemPaimt().serv.lieu.local.valCodLocal.setCodLocal(v);
                cDemContainer.getSyraSettings().setLocal(v);
            }
        }
    }

    private void postLieuTypLieuGeo(CUidObject cUidObject, CDemContainer cDemContainer) {
        String v = null;
        if (cUidObject != null && cDemContainer.getCurrentDemPaimt() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof String) {
                v = (String)cUidObject.getObject();
            }
            if (v != null) {
                if (cDemContainer.getCurrentDemPaimt().serv.lieu.local == null) {
                    cDemContainer.getCurrentDemPaimt().serv.lieu.local = new CLocal();
                }
                cDemContainer.getCurrentDemPaimt().serv.lieu.local.typLieuGeo = v;
                cDemContainer.getCurrentLieu(null).local.typLieuGeo = v;
                cDemContainer.getSyraSettings().put("typLieuGeo", v);
                cDemContainer.getSyraSettings().save();
            } else if (cDemContainer.getCurrentDemPaimt().serv.lieu.local != null) {
                cDemContainer.getCurrentDemPaimt().serv.lieu.local.typLieuGeo = null;
                cDemContainer.getCurrentLieu(null).local.typLieuGeo = null;
                cDemContainer.getSyraSettings().removeItem("typLieuGeo");
                cDemContainer.getSyraSettings().save();
            }
        }
    }

    private void postLieuTypIdLieuGeo(CUidObject cUidObject, CDemContainer cDemContainer) {
        String v = null;
        if (cUidObject != null && cDemContainer.getCurrentDemPaimt() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof String) {
                v = (String)cUidObject.getObject();
            }
            if (v != null) {
                if (cDemContainer.getCurrentDemPaimt().serv.lieu.local == null) {
                    cDemContainer.getCurrentDemPaimt().serv.lieu.local = new CLocal();
                }
                cDemContainer.getCurrentDemPaimt().serv.lieu.local.typIdLieuGeo = v;
                cDemContainer.getCurrentLieu(null).local.typIdLieuGeo = v;
                cDemContainer.getSyraSettings().put("typIdLieuGeo", v);
                cDemContainer.getSyraSettings().save();
            }
        }
    }

    private void postLieuTypLocEtab(CUidObject cUidObject, CDemContainer cDemContainer) {
        String v = null;
        if (cUidObject != null && cDemContainer.getCurrentDemPaimt() != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap) && cUidObject.getObject() instanceof String) {
                v = (String)cUidObject.getObject();
            }
            if (v != null) {
                cDemContainer.getCurrentDemPaimt().serv.lieu.typLocEtab = v;
                cDemContainer.getCurrentLieu(null).typLocEtab = v;
                cDemContainer.getSyraSettings().setTypLocEtab(v);
            }
        }
    }

    private Object searchPatient(Map<String, String> params) {
        Object[] res = new Object[]{};
        String k = params.get("k");
        String m = params.get("m");
        if (StringUtils.isEmpty((String)k)) {
            return res;
        }
        int len = (k = k.trim().toUpperCase()).length();
        if (len < 5) {
            return new Object[0];
        }
        if (len > 5) {
            len = 5;
        }
        int idx = len == 3 ? 0 : (len == 4 ? 1 : 2);
        boolean isNam = SyraAccessorClient.patNAM3to5[idx].matcher(k.substring(0, len)).matches();
        if ("1".equals(m)) {
            if (len < 5 && isNam) {
                return res;
            }
            res = this.findSimplePatient(k);
        } else if ("2".equals(m)) {
            if (!isNam) {
                return res;
            }
            res = this.findNamFromHistoricFact(k);
        } else if ("3".equals(m)) {
            if (!isNam) {
                return res;
            }
            ArrayListMultimap mapObj = ArrayListMultimap.create();
            Multimap<String, CPatient> mapPatients = this.getAccessor().findMapPatients(k);
            Multimap<String, Archive_dpacte> mapHisto = this.getAccessor().findMapNamFromHistoricFact(k);
            Set keysIdx = mapPatients.keySet();
            for (String kk : keysIdx) {
                mapObj.putAll((Object)kk, (Iterable)mapPatients.get((Object)kk));
                if (!mapHisto.containsKey((Object)kk)) continue;
                mapObj.get((Object)kk).addAll(mapHisto.get((Object)kk));
                mapHisto.removeAll((Object)mapHisto.get((Object)kk));
            }
            Set keysHisto = mapHisto.keySet();
            for (String kk : keysHisto) {
                mapObj.putAll((Object)kk, (Iterable)mapHisto.get((Object)kk));
            }
            Set keysObj = mapObj.keySet();
            ArrayList lstKeyObj = new ArrayList(keysObj);
            Collections.sort(lstKeyObj);
            Object[] patients = new Object[lstKeyObj.size()];
            int i = 0;
            for (String kk : lstKeyObj) {
                int j = 0;
                Collection coll = mapObj.get((Object)kk);
                Object[] arcs = new Object[coll.size()];
                for (Object arc : coll) {
                    arcs[j] = arc;
                    ++j;
                }
                patients[i] = new Object[]{kk, arcs};
                ++i;
            }
            res = patients;
        } else {
            if (len < 5 && isNam) {
                return res;
            }
            res = this.findSimplePatient(k);
            if (((IPatient[])res).length == 0 && isNam) {
                Object[] map = this.findNamFromHistoricFact(k);
                CPatient[] pts = new CPatient[map.length];
                int i = 0;
                Object[] objectArray = map;
                int n = map.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    Object[] oo = (Object[])o;
                    CPatient pt = new CPatient();
                    pt.setHealthInsuranceNumber((String)oo[0]);
                    pt.setLastName("Via archive");
                    pt.setFirstName("Pas de nom");
                    pt.setGender("I");
                    pt.setPatientRecordNumber("");
                    pts[i++] = pt;
                    ++n2;
                }
                res = pts;
            }
        }
        return res;
    }

    private Object getValidNam(Map<String, String> params, CDemContainer cDemContainer) {
        Comparable<Integer> res;
        ValidObject oValid;
        String k = params.get("c");
        boolean ok = ValidNoProfNam.validNam(k, oValid = new ValidObject(""), true);
        if (ok) {
            CPatient currContPt = cDemContainer.getCurrentPatient();
            if (currContPt == null || !k.equals(currContPt.getHealthInsuranceNumber()) || StringUtils.isEmpty((String)currContPt.bds) || StringUtils.isEmpty((String)currContPt.getGender())) {
                currContPt = new CPatient(oValid.getPatientListText());
                cDemContainer.setCurrentValue("currentPatient", currContPt);
                res = currContPt;
            } else {
                res = new Integer(1);
            }
        } else {
            res = new Integer(0);
        }
        return res;
    }

    private void postCurrentValue(CUidObject cUidObject, CDemContainer cDemContainer) {
        if (cUidObject != null) {
            if (cUidObject.getObject() instanceof String) {
                Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Long.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(BigDecimal.class, (Object)new GsonAdapters.EmptyStringToBigDecimalTypeAdapter()).create();
                Object oo = gson.fromJson((String)cUidObject.getObject(), CDemContainer.mapTypes.get(cUidObject.getType()));
                cDemContainer.setCurrentValue(cUidObject.getType(), oo);
            } else {
                cDemContainer.setCurrentValue(cUidObject.getType(), cUidObject.getObject());
            }
        }
    }

    private Object addProfessionnals(CUidObject cUidObject, Object res) {
        CProfessionnal cProf = null;
        if (cUidObject != null) {
            Integer id;
            if (!(cUidObject.getObject() instanceof AbstractMap)) {
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                cProf = (CProfessionnal)gson.fromJson((String)cUidObject.getObject(), CProfessionnal.class);
            }
            if (cProf != null && (id = this.saveProf(cProf)) != null) {
                res = new Object[]{id};
            }
        }
        return res;
    }

    private Object savePatientData(CUidObject cUidObject, CDemContainer cDemContainer, Object res) {
        PatientData patData = null;
        res = new Integer(0);
        if (cUidObject != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap)) {
                Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(LocalDate.class, (Object)new GsonAdapters.LocalDateTypeAdapter()).registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Long.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(BigDecimal.class, (Object)new GsonAdapters.EmptyStringToBigDecimalTypeAdapter()).create();
                patData = (PatientData)gson.fromJson((String)cUidObject.getObject(), PatientData.class);
            }
            if (patData != null) {
                MultiStatus status = this.getAccessor().savePatientData(patData, cDemContainer.getCurrentPatient());
                res = status;
            }
        }
        return res;
    }

    private Object postEditPatient(CUidObject cUidObject, CDemContainer cDemContainer, Object res) {
        CPatient cPat = null;
        if (cUidObject != null) {
            if (!(cUidObject.getObject() instanceof AbstractMap)) {
                Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(LocalDate.class, (Object)new GsonAdapters.LocalDateTypeAdapter()).registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Long.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(BigDecimal.class, (Object)new GsonAdapters.EmptyStringToBigDecimalTypeAdapter()).create();
                cPat = (CPatient)gson.fromJson((String)cUidObject.getObject(), CPatient.class);
            }
            if (cPat != null) {
                this.savePatient(cPat);
                cDemContainer.setCurrentValue("currentPatient", cPat);
                res = cPat.getId();
            }
        }
        return res;
    }

    private Object getRepondant(CDemContainer cDemContainer, String uid) {
        Object[][] rep = new Object[][]{};
        if (cDemContainer.getCurrentPatient().getAdresse() != null) {
            rep = SyraAccessorClient.getInstance().getRepondant(cDemContainer.getCurrentPatient());
        }
        return rep;
    }

    private Object getProfessionals(Map<String, String> params, Object res) {
        CProfessionnal[] billingProfessionals = this.getBillingProfessionals(params);
        if (billingProfessionals != null && billingProfessionals.length == 1) {
            res = billingProfessionals[0];
        }
        return res;
    }

    private Object searchLocal(Map<String, String> params, CDemContainer cDemContainer) {
        String k = params.get("k");
        Integer idAnchorProf = cDemContainer.getCurrentProf().getId();
        CodeDesc[] res = this.findLocalite(idAnchorProf, k);
        return res;
    }

    private void prefCopy(Map<String, String> params) {
        String i = params.get("id");
        String idTo = params.get("idto");
        String type = params.get("t");
        String replace = params.get("r");
        Integer idAnchorProf = null;
        QueryCriteria.ModelType modelType = null;
        try {
            idAnchorProf = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer toIdAnchorProf = null;
        try {
            toIdAnchorProf = Integer.valueOf(idTo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Integer iType = Integer.valueOf(type);
            modelType = QueryCriteria.ModelType.from(iType);
        }
        catch (Exception iType) {
            // empty catch block
        }
        Boolean bRep = Boolean.TRUE;
        try {
            Integer iRep = Integer.valueOf(replace);
            bRep = iRep == 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (idAnchorProf != null && toIdAnchorProf != null && modelType != null) {
            this.copyPrefFromTo(idAnchorProf, toIdAnchorProf, modelType, bRep);
            this.saveAllPrefProf(toIdAnchorProf);
            this.getAccessor().removeMapPrefData(toIdAnchorProf);
        }
    }

    private void prefAutreMod(Map<String, String> params) {
        String i = params.get("id");
        String key = params.get("k");
        String val = params.get("v");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            this.modPrefAutre(id, key, val);
        }
    }

    private Object prefAutre(Map<String, String> params, Object res) {
        String i = params.get("id");
        Integer id = null;
        if (i != null) {
            try {
                id = Integer.valueOf(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        res = id == null ? this.getAutreAllProf() : this.getAutreAll(id);
        return res;
    }

    private void prefSectMod(Map<String, String> params) {
        String i = params.get("id");
        String previous_pref = params.get("pp");
        String new_pref = params.get("np");
        String code = params.get("c");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            this.modPrefSecteurActivite(id, previous_pref, new_pref, code);
        }
    }

    private Object prefSect(Map<String, String> params, Object res) {
        String i = params.get("id");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            res = this.getSecteurActiviteAll(id);
        }
        return res;
    }

    private void prefEtablMod(Map<String, String> params) {
        String i = params.get("id");
        String previous_pref = params.get("pp");
        String new_pref = params.get("np");
        String code = params.get("c");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            this.modPrefEtablissement(id, previous_pref, new_pref, code);
        }
    }

    private Object prefEtabl(Map<String, String> params, Object res) {
        String i = params.get("id");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            res = this.getEtablissementAll(id);
        }
        return res;
    }

    private void prefElmContxMod(Map<String, String> params) {
        String i = params.get("id");
        String previous_pref = params.get("pp");
        String new_pref = params.get("np");
        String code = params.get("c");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            this.modPrefElmContx(id, previous_pref, new_pref, code);
        }
    }

    private Object prefElmContx(Map<String, String> params, Object res) {
        String i = params.get("id");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            res = this.getElmContxAll(id);
        }
        return res;
    }

    private void prefLocalMod(Map<String, String> params) {
        String i = params.get("id");
        String previous_pref = params.get("pp");
        String new_pref = params.get("np");
        String code = params.get("c");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            this.modPrefLocalite(id, previous_pref, new_pref, code);
        }
    }

    private Object prefLocal(Map<String, String> params, Object res) {
        String i = params.get("id");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            res = this.getLocaliteAll(id);
        }
        return res;
    }

    private void prefFactMod(Map<String, String> params) {
        String i = params.get("id");
        String previous_pref = params.get("pp");
        String new_pref = params.get("np");
        String code = params.get("c");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            this.modPrefFacturation(id, previous_pref, new_pref, code);
        }
    }

    private Object prefFact(Map<String, String> params, Object res) {
        String i = params.get("id");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            res = this.getFacturationAll(id);
        }
        return res;
    }

    private void prefDiagMod(Map<String, String> params) {
        String i = params.get("id");
        String previous_pref = params.get("pp");
        String new_pref = params.get("np");
        String code = params.get("c");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            this.modPrefDiagnostic(id, previous_pref, new_pref, code);
        }
    }

    private Object prefDiag(Map<String, String> params, Object res) {
        String i = params.get("id");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            res = this.getDiagnosticAll(id);
        }
        return res;
    }

    private Object prefSaveAll(Map<String, String> params) {
        String i = params.get("id");
        Integer id = null;
        try {
            id = Integer.valueOf(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object res = this.saveAllPrefProf(id);
        return res;
    }

    private void getSetGlobalDefaut(Map<String, String> params) {
        String k = params.get("k");
        String v = params.get("v");
        CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).set(k, (Object)v);
        if ("syra_noAgence".equals(k)) {
            String ag = v.trim();
            if (ag.length() > 5) {
                ag = ag.substring(0, 5);
            }
            GlobalPreference gp = BaseGlobalPreferenceDAO.getInstance().getGlobalPreference();
            gp.setClientCode(ag);
            BaseGlobalPreferenceDAO.getInstance().saveOrUpdate(gp);
        } else if ("syra_userId".equals(k)) {
            FmedxBaseDAO.getInstance().setConfigValue("tipiid", v);
        } else if ("syra_userIdPswd".equals(k)) {
            FmedxBaseDAO.getInstance().setConfigValue("tipimp", v);
        } else if ("envoi_tps_reel".equals(k)) {
            this.setRunnableSendDempPaimt();
            Hashtable<String, String> objG = new Hashtable<String, String>();
            objG.put("envoi_tps_reel", CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).get("envoi_tps_reel"));
            CTypeObject to = new CTypeObject("currGlobalDefaultValueType", objG);
            String message = new GsonBuilder().create().toJson((Object)to);
            HtmlBrowserTools.sendMessageToWebClient(null, (String)message);
        }
    }

    private synchronized void getSetDefaut(Map<String, String> params, CDemContainer cDemContainer, String uid) {
        String k = params.get("k");
        String v = params.get("v");
        System.out.println("call of getSetDefault for <<" + k + ">> to set to <<" + v + ">>");
        try {
            if ("dateDefault".equals(k) || "billListDate".equals(k)) {
                Date ld = DateUtils.parseDate((String)v, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ss"});
                LocalDate localDate = LocalDate.fromTimeInMillisLOCAL((Long)new Long(ld.getTime()));
                if ("dateDefault".equals(k)) {
                    cDemContainer.setCurrentValue("dateDefaut", localDate);
                } else if ("billListDate".equals(k)) {
                    cDemContainer.setCurrentValue("billListDate", localDate);
                }
            } else if ("allowOfysBilling".equals(k)) {
                cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).set(k, v);
                if ("true".equals(v)) {
                    this.activateAllowOfysBilling(uid);
                } else {
                    ((SyraSocket)SyraSocket.getInstances().get(uid)).deleteFileLinkedToSession(".allowOfysBilling");
                }
            } else {
                cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).set(k, v);
                if ("autoSend".equals(k)) {
                    if ("true".equals(v)) {
                        this.runnableSendDemPaimt.addScheduler(uid);
                    } else {
                        this.runnableSendDemPaimt.removeScheduler(uid);
                    }
                }
                if (k.startsWith("profModaPaimt_") && "1".equals(v)) {
                    cDemContainer.setCurrentGroupe(null);
                }
            }
        }
        catch (ParseException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected void activateAllowOfysBilling(String uid) {
        Hashtable<String, Boolean> objG = new Hashtable<String, Boolean>();
        objG.put("allowOfysBilling", Boolean.FALSE);
        CTypeObject to = new CTypeObject("currDefaultValueType", objG);
        String message = new GsonBuilder().create().toJson((Object)to);
        HtmlBrowserTools.sendMessageToWebClient(null, (String)message);
        SyraSocket socket = (SyraSocket)SyraSocket.getInstances().get(uid);
        if (socket != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("uid=" + uid).append("\n");
            sb.append("ip=127.0.0.1").append("\n");
            sb.append("port=" + SyraGlobalSettings.getInstance((String)ConnectionFactory.connectionLabel).get("share_port")).append("\n");
            ((SyraSocket)SyraSocket.getInstances().get(uid)).addFileLinkToSession(".allowOfysBilling", sb.toString());
        }
    }

    private void setCurrentDemForListeVal_dt(Map<String, String> params, CDemContainer cDemContainer) {
        String v = params.get("v");
        Integer vi = null;
        try {
            vi = Integer.valueOf(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vi != null) {
            CDemForListe demForListe = cDemContainer.getCurrentCDemForListe();
            demForListe.setProgressCommunication(0);
            demForListe.setDemType(vi);
            demForListe.setStaRecev(new Integer(0));
            demForListe.setReady(false);
            String errMsg = "";
            demForListe.setErrMessage(errMsg);
            BaseDemForListeDAO.getInstance().saveValue(demForListe.getId(), new String[]{"progress_comm", "dem_type", "sta_recev", "ready"}, (Number[])new Integer[]{new Integer(0), vi, new Integer(0), new Integer(0)}, errMsg);
        }
    }

    private void setCurrentDemForListeVal_prg(Map<String, String> params, CDemContainer cDemContainer) {
        String v = params.get("v");
        Integer vi = null;
        try {
            vi = Integer.valueOf(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vi != null) {
            int newDemType;
            CDemForListe demForListe = cDemContainer.getCurrentCDemForListe();
            demForListe.setProgressCommunication(vi);
            String errMsg = demForListe.getErrMessage();
            if (vi == 0) {
                errMsg = "";
                demForListe.setStaRecev(new Integer(0));
            }
            if ((newDemType = demForListe.getDemType().intValue()) > 3) {
                newDemType -= 3;
            }
            demForListe.setDemType(new Integer(newDemType));
            BaseDemForListeDAO.getInstance().saveValue(demForListe.getId(), new String[]{"progress_comm", "dem_type", "sta_recev"}, (Number[])new Integer[]{vi, new Integer(newDemType), new Integer(0)}, errMsg);
        }
    }

    private void setCurrentDemForListeVal_ready(Map<String, String> params, CDemContainer cDemContainer) {
        String v = params.get("v");
        Integer vi = null;
        try {
            vi = Integer.valueOf(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vi != null) {
            CDemForListe demForListe = cDemContainer.getCurrentCDemForListe();
            boolean ready = vi == 1;
            demForListe.setReady(ready);
            if (demForListe.getId() != null) {
                BaseDemForListeDAO.getInstance().saveIntegerValue(demForListe.getId(), "ready", vi);
            }
        }
    }

    private void setCurrentDemForListeVal_mm(Map<String, String> params, CDemContainer cDemContainer) {
        String v = params.get("v");
        Integer vi = null;
        try {
            vi = Integer.valueOf(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vi != null) {
            CDemForListe demForListe = cDemContainer.getCurrentCDemForListe();
            boolean mm = vi == 1;
            demForListe.setManualMode(mm);
            if (demForListe.getId() != null) {
                BaseDemForListeDAO.getInstance().saveIntegerValue(demForListe.getId(), "manual_mode", vi);
            }
        }
    }

    private void setCurrentDemForListeVal_sr(Map<String, String> params, CDemContainer cDemContainer) {
        String v = params.get("v");
        Integer vi = null;
        try {
            vi = Integer.valueOf(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vi != null) {
            CDemForListe demForListe = cDemContainer.getCurrentCDemForListe();
            demForListe.setStaRecev(vi);
            if (demForListe.getId() != null) {
                BaseDemForListeDAO.getInstance().saveIntegerValue(demForListe.getId(), "sta_recev", vi);
            }
        }
    }

    private void setCurrentDemForListeVal_np(Map<String, String> params, CDemContainer cDemContainer) {
        String v = params.get("v");
        if (v != null) {
            CDemForListe demForListe = cDemContainer.getCurrentCDemForListe();
            demForListe.setNotePers(v);
            if (demForListe.getId() != null) {
                BaseDemForListeDAO.getInstance().saveValue(demForListe.getId(), new String[]{"note_pers"}, (Object[])new String[]{v});
            }
        }
    }

    private void setCurrentDemForListeVal_ii(Map<String, String> params, CDemContainer cDemContainer) {
        String v = params.get("v");
        if (v != null) {
            CDemForListe demForListe = cDemContainer.getCurrentCDemForListe();
            demForListe.setIdIntvn(v);
            if (demForListe.getId() != null) {
                Professionnal prof = BaseProfessionnalDAO.getInstance().getProfTxFromNoProf(v);
                Integer idProf = null;
                if (prof != null) {
                    idProf = prof.getId();
                }
                BaseDemForListeDAO.getInstance().saveValue(demForListe.getId(), new String[]{"id_intvn", "id_prof"}, new Object[]{v, idProf});
                DemAnnu demAnnu = demForListe.getLastDemAnnu();
                if (demAnnu != null) {
                    TypDem.Demdr demdr = new TypDem.Demdr();
                    demdr.setIdIntvn(v);
                    demdr.setTypIdIntvn("1");
                    demAnnu.setDemdr(demdr);
                    demForListe.demAnnu = demAnnu;
                    String arrayStringDp = ConvertJavaToFromArray.ConvertDemAnnu.toArrayString(demAnnu);
                    List<String> list = demForListe.addOrSetDemAnnu(arrayStringDp);
                    demForListe.getDemForListeAndSave(ConvertJavaToFromArray.ArrDemType.DEM_ANNU, list, null, null);
                }
            }
        }
    }

    private Object getContx(Map<String, String> params, CDemContainer cDemContainer) {
        String code = params.get("c").trim();
        String n = params.get("n");
        QueryCriteria.CodNiveau codNiveau = QueryCriteria.CodNiveau.from(n);
        String date = "L".equals(n) ? cDemContainer.getCurrentCLigneServMdcal().dateServ : params.get("d");
        Integer idAnchorProf = cDemContainer.getCurrentProf().getId();
        String repn = this.getElmContxDesc(idAnchorProf, code, date, codNiveau);
        CodeDesc res = new CodeDesc(code, repn);
        return res;
    }

    private Object getFavModel(Map<String, String> params, CDemContainer cDemContainer, Object res) {
        String file = params.get("c").trim();
        CProfessionnal cProfessionnal = null;
        CProfessionnalPrefData pd = null;
        CProfessionnalPrefData pdForId = null;
        PrefProfType ppt = PrefProfType.from((Integer)new Integer(file.substring(0, 1)));
        if (ppt != null) {
            if (this.mapFavModel.containsKey(file)) {
                Integer idp = this.mapFavModel.get(file);
                pdForId = new CProfessionnalPrefData(idp);
            } else {
                DownloadValideur downloadValideur = DownloadValideur.getInstance();
                String favModel = downloadValideur.getFavModel(file);
                if (favModel != null && favModel.length() > 3) {
                    Integer idp = CProfessionnal.getTempId();
                    favModel = favModel.substring(1, favModel.length() - 1);
                    String[] prefs = favModel.split(",");
                    PrefProf prof = new PrefProf();
                    prof.setTypePref(ppt);
                    prof.setPrefName(ppt.name());
                    prof.setPrefs(prefs);
                    pd = new CProfessionnalPrefData(idp);
                    pdForId = new CProfessionnalPrefData(idp);
                    if (PrefProfType.DX.equals((Object)ppt)) {
                        this.accessor.addProfPrefToData(pd, prof, "addPrefDiag", "setIdDx");
                    } else if (PrefProfType.CODES.equals((Object)ppt)) {
                        this.accessor.addProfPrefToData(pd, prof, "addPrefFact", "setIdCode");
                    } else if (PrefProfType.CX.equals((Object)ppt)) {
                        this.accessor.addProfPrefToData(pd, prof, "addPrefElmContx", "setIdCx");
                    } else if (PrefProfType.LOCAL.equals((Object)ppt)) {
                        this.accessor.addProfPrefToData(pd, prof, "addPrefLocal", "setIdLocal");
                    } else if (PrefProfType.ETAB.equals((Object)ppt)) {
                        this.accessor.addProfPrefToData(pd, prof, "addPrefEtabl", "setIdEtab");
                    } else if (PrefProfType.SECT.equals((Object)ppt)) {
                        this.accessor.addProfPrefToData(pd, prof, "addPrefSectActiv", "setIdSect");
                    }
                    Integer ent = new Integer(CProfessionnal.Entente.SPEC.getValue());
                    if (file.contains("_omni")) {
                        ent = new Integer(CProfessionnal.Entente.OMNI.getValue());
                    }
                    cProfessionnal = new CProfessionnal(idp, ent);
                    cProfessionnal.setPrefData(pd);
                    this.getAccessor().mapProf.put(cProfessionnal.getId(), cProfessionnal);
                    this.getAccessor().mapPrefData.put(cProfessionnal.getId(), pd);
                    this.mapFavModel.put(file, idp);
                }
            }
        }
        res = pdForId;
        return res;
    }

    private Object getCodeFacturation(Map<String, String> params, CDemContainer cDemContainer, Object res) {
        String code = params.get("c").trim();
        Object[] oo = this.getCodeFacturation(code, cDemContainer);
        if (oo != null && oo.length > 0 && oo[0] != null && oo instanceof CodeBigIntCodFact[]) {
            CodeBigIntCodFact[] codes = (CodeBigIntCodFact[])oo;
            cDemContainer.getCurrentCLigneServMdcal().codFact = codes[0];
            res = codes[0];
        } else {
            res = new CodeBigIntCodFact[]{};
        }
        return res;
    }

    private Object getSecteur(Map<String, String> params, CDemContainer cDemContainer, String uid, Object res) {
        String code = params.get("c");
        boolean def = "1".equals(params.get("d"));
        CProfessionnal.Entente ent = CProfessionnal.Entente.NON_DEF;
        CProfessionnal currentProf = cDemContainer.getCurrentProf();
        if (currentProf != null && currentProf.getType() != null) {
            ent = CProfessionnal.Entente.valueOf(currentProf.getType());
        }
        String dateDef = cDemContainer.getSyraSettings().getDateDef();
        return this.getValNoSecteur(code, ent, dateDef);
    }

    private Object getEtabl(Map<String, String> params, CDemContainer cDemContainer, String uid, Object res) {
        String code = params.get("c");
        boolean def = "1".equals(params.get("d"));
        Object[] oo = this.getEtablissement(code);
        if (oo != null && oo instanceof InfoEtab.ValEtab[] && uid != null) {
            InfoEtab.ValEtab[] etabs = (InfoEtab.ValEtab[])oo;
            CProfessionnal currentProf = cDemContainer.getCurrentProf();
            CLieu currentLieu = cDemContainer.getCurrentLieu(currentProf);
            CEtab cEtab = currentLieu.etab;
            if (etabs.length == 1) {
                cEtab = new CEtab(code, "0", etabs[0]);
                cEtab.setCodPreciSectActiv(new Integer(0));
                if (def) {
                    currentLieu.etab = cEtab;
                    if (Platform.inDebugMode()) {
                        System.out.println("current LIEU-etab = " + currentLieu);
                    }
                }
            }
            res = cEtab;
        }
        return res;
    }

    private Object getLocal(Map<String, String> params, CDemContainer cDemContainer, String uid, Object res) {
        String code = params.get("c");
        boolean def = "1".equals(params.get("d"));
        Object[] oo = this.getLocalite(code);
        if (oo != null && oo instanceof CodLocal.ValCodLocal[] && uid != null) {
            CProfessionnal currentProf = cDemContainer.getCurrentProf();
            CLieu currentLieu = cDemContainer.getCurrentLieu(currentProf);
            CodLocal.ValCodLocal[] locals = (CodLocal.ValCodLocal[])oo;
            CodLocal.ValCodLocal vLocal = currentLieu.local.valCodLocal;
            if (locals.length > 0) {
                vLocal = locals[0];
                if (def) {
                    currentLieu.local.valCodLocal = vLocal;
                    currentLieu.local.codPreciLieu = "0";
                    if (Platform.inDebugMode()) {
                        System.out.println("current LIEU-local = " + currentLieu);
                    }
                }
                res = vLocal;
            }
        }
        return res;
    }

    private Object getFichiersVersions() {
        long t0 = System.currentTimeMillis();
        Versions version = new Versions();
        List<FichierAideData> lstVersion = version.getFichierVersion();
        FichierAideData[] fichierVersion = new FichierAideData[lstVersion.size()];
        int i = 0;
        while (i < lstVersion.size()) {
            fichierVersion[i] = lstVersion.get(i);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        System.out.println("t1-t0 pour getFichiersVersions: " + (t1 - t0) + " msec");
        FichierAideData[] res = fichierVersion;
        return res;
    }

    public Object newAvailVersionFichiersVersions() {
        boolean needsUpdate = this.checkNewValid();
        Integer res = needsUpdate ? new Integer(1) : new Integer(0);
        return res;
    }

    private void postActivIdMach(CUidObject cUidObject) {
        if (cUidObject != null && cUidObject.getObject() instanceof String) {
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            IdentSyra identB2b = (IdentSyra)gson.fromJson((String)cUidObject.getObject(), IdentSyra.class);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Status status2 = new Status(IStatus.Severity.OK, "");
                    try {
                        status2 = ValidRamq.getInstance().renewIdMach(identB2b.syra_idMach, identB2b.syra_idMachPswd, identB2b.syra_noAgence);
                    }
                    catch (Exception e) {
                        String cause = SyraController.this.getExceptionMessage(e);
                        status2 = new Status(IStatus.Severity.ERROR, "Erreur lors du renouvellement du mot de passe pour [" + identB2b.syra_idMach + "]. " + cause);
                    }
                    CTypeObject to1 = new CTypeObject("renewIdMachPswdType", status2);
                    String message1 = new GsonBuilder().create().toJson((Object)to1);
                    if (status2.isOK()) {
                        IdentSyra data = (IdentSyra)status2.getData();
                        SyraController.this.getIdentSyra().syra_idMachPswd = data.syra_idMachPswd;
                    }
                    for (String kUid : SyraController.this.mapDemContainer.keySet()) {
                        if (kUid.equals("undefined")) continue;
                        HtmlBrowserTools.sendMessageToWebClient((String)kUid, (String)message1);
                    }
                }
            });
        }
    }

    private void postGenericIdMach(CUidObject cUidObject) {
        if (cUidObject != null && cUidObject.getObject() instanceof String) {
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            IdentSyra identB2b = (IdentSyra)gson.fromJson((String)cUidObject.getObject(), IdentSyra.class);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Status status2 = new Status(IStatus.Severity.OK, "");
                    try {
                        status2 = ValidRamq.getInstance().generIdMach(identB2b.syra_userId, identB2b.syra_userIdPswd, identB2b.syra_noAgence);
                    }
                    catch (Exception e) {
                        String cause = SyraController.this.getExceptionMessage(e);
                        status2 = new Status(IStatus.Severity.ERROR, "Erreur lors de la g\u00e9n\u00e9ration d'un id machine pour [" + identB2b.syra_noAgence + "]. " + cause);
                    }
                    CTypeObject to1 = new CTypeObject("generIdMachType", status2);
                    String message1 = new GsonBuilder().create().toJson((Object)to1);
                    if (status2.isOK()) {
                        IdentSyra data = (IdentSyra)status2.getData();
                        SyraController.this.runnableSendDemPaimt.setIdMach(data.syra_idMach);
                        SyraController.this.runnableSendDemPaimt.setIdMachPswd(data.syra_idMachPswd);
                    }
                    for (String kUid : SyraController.this.mapDemContainer.keySet()) {
                        if (kUid.equals("undefined")) continue;
                        HtmlBrowserTools.sendMessageToWebClient((String)kUid, (String)message1);
                    }
                }
            });
        }
    }

    private Object searchContx(Map<String, String> params, CDemContainer cDemContainer) {
        String n = params.get("n");
        String k = params.get("k");
        Integer idAnchorProf = cDemContainer.getCurrentProf().getId();
        QueryCriteria.CodNiveau codNiveau = QueryCriteria.CodNiveau.from(n);
        CodeDesc[] res = this.getElmContx(idAnchorProf, codNiveau, k, cDemContainer);
        return res;
    }

    private Object searchFavModel(Map<String, String> params, CDemContainer cDemContainer) {
        String k = params.get("k").toLowerCase();
        DownloadValideur downloadValideur = DownloadValideur.getInstance();
        Properties favModel = downloadValideur.getFavModel();
        Set<Map.Entry<Object, Object>> entrySet = favModel.entrySet();
        ArrayList<CodeDesc> lstFavs = new ArrayList<CodeDesc>();
        if (".".equals(k)) {
            for (Map.Entry<Object, Object> entry : entrySet) {
                lstFavs.add(new CodeDesc((String)entry.getKey(), (String)entry.getValue()));
            }
        } else {
            String[] kk = k.split("[, /-]");
            for (Map.Entry<Object, Object> entry : entrySet) {
                String v = ((String)entry.getValue()).toLowerCase();
                boolean ok = true;
                String[] stringArray = kk;
                int n = kk.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (!v.contains(s)) {
                        ok = false;
                        break;
                    }
                    ++n2;
                }
                if (!ok) continue;
                lstFavs.add(new CodeDesc((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        Collections.sort(lstFavs, new Comparator<CodeDesc>(){

            @Override
            public int compare(CodeDesc o1, CodeDesc o2) {
                return o1.d.compareTo(o2.d);
            }
        });
        CodeDesc[] favs = new CodeDesc[lstFavs.size()];
        if (favs.length > 0) {
            lstFavs.toArray(favs);
        }
        return favs;
    }

    private Object fichExplNew(Map<String, String> params, CDemContainer cDemContainer) {
        boolean forceUpdateMntPaye = "1".equals(params.get("f"));
        String[] files = new String[]{};
        Status status = new Status(IStatus.Severity.OK);
        SyraGlobalSettings globalSettings = cDemContainer.getSyraglobalsettings();
        String endpoint = "https://www4.prod.ramq.gouv.qc.ca/TIP/OP/OPX_GereEchgInfoPaimt/OPX2_ServEchgLotFichDP_svc/ServEchgLotFichExplnSortant.svc";
        if (Platform.inDebugMode()) {
            endpoint = "https://www4.parte.ramq.gouv.qc.ca/TIP/OP/OPX_GereEchgInfoPaimt/OPX2_ServEchgLotFichDP_svc/ServEchgLotFichExplnSortant.svc";
        }
        EchgLotFichExplnSortantCriteria criteria = new EchgLotFichExplnSortantCriteria(globalSettings.get("syra_idMach"), globalSettings.get("syra_idMachPswd"), globalSettings.get("syra_noAgence"));
        EchgLotFichExplnSortantService sortantService = new EchgLotFichExplnSortantService(PrefixFileLogHandler.create(String.valueOf(LibPlugin.MEDOFFICE_HOME) + "/logs", "EchgLotFichExplnSortant", true), endpoint);
        Transaction<EchgLotFichExplnSortantCriteria, EchgLotFichExplnSortantResult> call = sortantService.demander(criteria);
        String faults = new JoinList("\n", call.getFaults()).toString();
        if (call.getFaults().size() > 0) {
            status = new Status(IStatus.Severity.ERROR, faults);
        } else {
            EchgLotFichExplnSortantResult result = call.getResult();
            List<String> resultFiles = result.getFiles();
            Object[] datas = new Object[4];
            if (resultFiles != null && resultFiles.size() > 0) {
                ArrayList<String> fileDates = new ArrayList<String>(resultFiles.size());
                int i = 0;
                while (i < resultFiles.size()) {
                    fileDates.add(resultFiles.get(i).substring(2, resultFiles.get(i).indexOf(46)));
                    ++i;
                }
                Collections.sort(fileDates, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                });
                files = new String[fileDates.size()];
                files = fileDates.toArray(files);
            }
            if (files.length > 0) {
                String xmlFile = files[0];
                status = (Status)this.loadXmlFileAndReturnData(cDemContainer, resultFiles.get(0), forceUpdateMntPaye);
                if (status.isOK() && status.getData() instanceof Object[]) {
                    Object[] oo = (Object[])status.getData();
                    datas[0] = oo[0];
                    datas[1] = oo[1];
                    datas[2] = xmlFile;
                    datas[3] = files;
                }
            }
            status.setData((Serializable)datas);
        }
        return status;
    }

    private Object searchFichExplDejaObtenu(Map<String, String> params, CDemContainer cDemContainer) {
        String k = params.get("k").toLowerCase();
        File dir = new File(EchgLotFichExplnSortantService.fmedxHomeExplXml);
        String[] files = new String[]{};
        if (dir.exists() && dir.isDirectory()) {
            FilenameFilter fnf = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (".".equals(k)) {
                        return true;
                    }
                    String lowercaseName = name.toLowerCase();
                    return lowercaseName.startsWith("ex" + k) && lowercaseName.endsWith("xml");
                }
            };
            files = dir.list(fnf);
        }
        if (files.length > 0) {
            ArrayList<String> fileDates = new ArrayList<String>(files.length);
            int i = 0;
            while (i < files.length) {
                fileDates.add(files[i].substring(2, files[i].indexOf(46)));
                ++i;
            }
            Collections.sort(fileDates, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            files = new String[fileDates.size()];
            files = fileDates.toArray(files);
        }
        return files;
    }

    private Object getFichExplDejaObtenu(Map<String, String> params, CDemContainer cDemContainer, Object res) {
        String file = params.get("c").trim();
        boolean forceUpdateMntPaye = "1".equals(params.get("f"));
        File dir = new File(EchgLotFichExplnSortantService.fmedxHomeExplXml);
        String[] files = new String[]{};
        if (dir.exists() && dir.isDirectory()) {
            FilenameFilter fnf = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lowercaseName = name.toLowerCase();
                    Matcher matcher = Pattern.compile("(ex" + file + ")([0-9]{0,6})(.xml)").matcher(lowercaseName);
                    boolean foundIt = matcher.find();
                    return foundIt;
                }
            };
            files = dir.list(fnf);
        }
        if (files.length == 1) {
            String xmlFile = files[0];
            res = this.loadXmlFileAndReturnData(cDemContainer, xmlFile, forceUpdateMntPaye);
        }
        return res;
    }

    private Object loadXmlFileAndReturnData(CDemContainer cDemContainer, String xmlFile, boolean forceUpdateMntPaye) {
        String completeFile = String.valueOf(EchgLotFichExplnSortantService.fmedxHomeExplXml) + xmlFile;
        MultiStatus status = new MultiStatus(IStatus.Severity.OK);
        if (!new File(completeFile).exists()) {
            status = new MultiStatus(IStatus.Severity.ERROR, "Fichier " + completeFile + " absent", (Throwable)new Exception());
        } else {
            String[] xmlFiles = new String[]{completeFile};
            FactExplPaimt dx = new FactExplPaimt(cDemContainer.uid, xmlFiles);
            QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.EXPL_PAIMT, null);
            try {
                Calendar cal;
                LocalDate iDatEtaCpt;
                List<String> l = dx.getDataByCriteria(criteria, IBaseXExplPaimtQuery.DataType.BASE_DATA);
                CExplPaimt explPaimt = new CExplPaimt();
                Iterator<String> iterator = l.iterator();
                if (iterator.hasNext()) {
                    String s = iterator.next();
                    String[] b = s.split(":");
                    explPaimt.datCoupPer = b[0];
                    explPaimt.datEtatCpt = b[1];
                    explPaimt.ddPerFact = b[2];
                    explPaimt.dfPerFact = b[3];
                }
                criteria = new QueryCriteria(QueryCriteria.ModelType.EXPL_PAIMT, null);
                List<String> allN = dx.getDataByCriteria(criteria, IBaseXExplPaimtQuery.DataType.ALL_NODE);
                XStream xs = dx.getXstream();
                Object[] allNodes = new Object[allN.size()];
                int iAllNodes = 0;
                Map<Long, CFactExplPmt> nodes = cDemContainer.getMapCurrentExplPaimtAllNodes();
                nodes.clear();
                ArrayList<Long> noRfps = new ArrayList<Long>();
                for (String s : allN) {
                    CProfExplPmt act = dx.geProfExplPmtFromNode(s, xs);
                    allNodes[iAllNodes++] = act;
                    for (CFactExplPmt fact : act.f) {
                        noRfps.add(fact.noRq);
                        nodes.put(fact.noRq, fact);
                    }
                }
                if (explPaimt.datEtatCpt != null && (iDatEtaCpt = LocalDate.fromCalendar((Calendar)(cal = DateUtil.ctod((String)explPaimt.datEtatCpt)))) != null) {
                    List idsToUpdate = new ArrayList<Long>();
                    if (forceUpdateMntPaye) {
                        idsToUpdate.addAll(noRfps);
                    } else {
                        idsToUpdate = BaseDemForListeDAO.getInstance().getNoRqsToUpdate(noRfps, iDatEtaCpt);
                    }
                    if (idsToUpdate != null && !idsToUpdate.isEmpty()) {
                        for (Long noRq : idsToUpdate) {
                            CFactExplPmt pmt = nodes.get(noRq);
                            LocalDate datePmt = pmt.getDatePmt();
                            if (datePmt == null) continue;
                            BaseDemForListeDAO.getInstance().updateFactureFromExplPaimt(noRq, iDatEtaCpt, datePmt, pmt.getTotal());
                        }
                    }
                }
                status.setData((Serializable)new Object[]{explPaimt, allNodes});
            }
            catch (QueryException e) {
                status = new MultiStatus(IStatus.Severity.ERROR, e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                status = new MultiStatus(IStatus.Severity.ERROR, e.getMessage(), (Throwable)e);
            }
        }
        MultiStatus res = status;
        return res;
    }

    private Object searchCodeFacturation(Map<String, String> params, CDemContainer cDemContainer) {
        String k = params.get("k");
        Object[] response = new Object[]{};
        Integer idAnchorProf = cDemContainer.getCurrentProf().getId();
        response = this.getCodesDescFacturation(idAnchorProf, k, cDemContainer);
        return response;
    }

    private Object getDiagnostic(Map<String, String> params, CDemContainer cDemContainer) {
        String k = params.get("c");
        return this.getDiagnostic(k);
    }

    private Object searchDiagnostic(Map<String, String> params, CDemContainer cDemContainer) {
        String k = params.get("k");
        Object[] response = new Object[]{};
        Integer idAnchorProf = cDemContainer.getCurrentProf().getId();
        if (idAnchorProf != null) {
            response = this.searchDiagnostic(idAnchorProf, k);
        }
        return response;
    }

    private Object getActiveMedofficeUser() {
        CUser res = this.getActiveUser();
        return res;
    }

    private void postDemListe(CUidObject cUidObject, CDemContainer cDemContainer) {
        if (cUidObject != null) {
            CUser cUser;
            Gson gson = new GsonBuilder().registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(BigDecimal.class, (Object)new GsonAdapters.EmptyStringToBigDecimalTypeAdapter()).create();
            DemListCriteria criteria = (DemListCriteria)gson.fromJson((String)cUidObject.getObject(), DemListCriteria.class);
            criteria.getLocalDateRange(null, null);
            if (!(criteria.dateRange != null || cDemContainer.getCurrentUser() != null && criteria.user != null && criteria.user.equals(cDemContainer.getCurrentUser().id) || (cUser = SyraAccessorClient.getInstance().getUser(criteria.user)) == null)) {
                cDemContainer.setCurrentValue("currentBillUser", cUser);
            }
            this.sendDemListe(cDemContainer, cUidObject.getUid(), criteria);
        }
    }

    private Object getUsersAndDefaults(String uid, CDemContainer cDemContainer) {
        CUser[] users;
        CUser[] res = users = this.getUsers();
        return res;
    }

    private void sendAllDefaultsToUi(String uid, CDemContainer cDemContainer) {
        Object b;
        SyraGlobalSettings.ValBolDefaut v;
        Object b2;
        int n;
        String dateDef = cDemContainer.getDateDefaut().formatHyphen();
        if (SyraAccessorClient.getInstance().mapProf.isEmpty()) {
            CProfessionnal[] profs;
            CProfessionnal[] cProfessionnalArray = profs = this.getBillingProfessionals(null);
            n = profs.length;
            int n2 = 0;
            while (n2 < n) {
                CProfessionnal cp = cProfessionnalArray[n2];
                this.getAccessor().mapProf.put(cp.getId(), cp);
                ++n2;
            }
        }
        cDemContainer.getCurrentProf();
        cDemContainer.getCurrentGroupe();
        cDemContainer.getCurrentBillUser();
        cDemContainer.getCurrentLieu(null);
        String dateBills = cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).getDateLstBill();
        if (dateBills == null) {
            dateBills = LocalDate.today().formatHyphen();
        }
        Hashtable<String, Object> obj = new Hashtable<String, Object>();
        Object[] objectArray = SyraSettings.BOOL_VALUES;
        int n3 = SyraSettings.BOOL_VALUES.length;
        n = 0;
        while (n < n3) {
            SyraSettings.ValBolDefaut v2 = objectArray[n];
            b2 = cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).getBoolean(v2.k);
            b2 = b2 == null ? (Boolean.TRUE.equals(v2.v) ? Boolean.TRUE : Boolean.FALSE) : b2;
            obj.put(v2.k, b2);
            if ("allowOfysBilling".equals(v2.k) && Boolean.TRUE.equals(b2)) {
                this.activateAllowOfysBilling(uid);
            }
            ++n;
        }
        objectArray = SyraSettings.INT_VALUES;
        n3 = SyraSettings.INT_VALUES.length;
        n = 0;
        while (n < n3) {
            Object v3 = objectArray[n];
            b2 = cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).getInt(((SyraSettings.ValIntDefaut)v3).k);
            Object object = b2 = b2 == null ? ((SyraSettings.ValIntDefaut)v3).v : b2;
            if (b2 != null) {
                obj.put(((SyraSettings.ValIntDefaut)v3).k, b2);
            }
            ++n;
        }
        objectArray = SyraSettings.STRING_VALUES;
        n3 = SyraSettings.STRING_VALUES.length;
        n = 0;
        while (n < n3) {
            Object v4 = objectArray[n];
            b2 = cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).get(((SyraSettings.ValStringDefaut)v4).k);
            Object object = b2 = b2 == null ? ((SyraSettings.ValStringDefaut)v4).v : b2;
            if (b2 != null) {
                obj.put(((SyraSettings.ValStringDefaut)v4).k, b2);
            }
            ++n;
        }
        obj.put("dateDefault", String.valueOf(dateDef) + "T12:00:00");
        obj.put("billListDate", String.valueOf(dateBills) + "T12:00:00");
        CTypeObject to = new CTypeObject("currDefaultType", obj);
        String message = new GsonBuilder().create().toJson((Object)to);
        HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message);
        Hashtable<String, Object> objG = new Hashtable<String, Object>();
        SyraGlobalSettings globalSettings = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
        SyraGlobalSettings.ValBolDefaut[] valBolDefautArray = SyraGlobalSettings.BOOL_VALUES;
        int n4 = SyraGlobalSettings.BOOL_VALUES.length;
        int n5 = 0;
        while (n5 < n4) {
            v = valBolDefautArray[n5];
            b = globalSettings.getBoolean(v.k);
            b = b == null ? (Boolean.TRUE.equals(v.v) ? Boolean.TRUE : Boolean.FALSE) : b;
            objG.put(v.k, b);
            ++n5;
        }
        valBolDefautArray = SyraGlobalSettings.INT_VALUES;
        n4 = SyraGlobalSettings.INT_VALUES.length;
        n5 = 0;
        while (n5 < n4) {
            v = valBolDefautArray[n5];
            b = globalSettings.getInt(v.k);
            Object object = b = b == null ? v.v : b;
            if (b != null) {
                objG.put(v.k, b);
            }
            ++n5;
        }
        if (StringUtils.isEmpty((String)((String)objG.get("syra_noAgence")))) {
            String tipid = FmedxBaseDAO.getInstance().getConfigValue("tipiid").getVar_value().trim();
            String tipmp = FmedxBaseDAO.getInstance().getConfigValue("tipimp").getVar_value().trim();
            GlobalPreference gp = BaseGlobalPreferenceDAO.getInstance().getGlobalPreference();
            String noAgence = "";
            if (gp != null) {
                noAgence = gp.getClientCode();
            } else if (StringUtils.isNotEmpty((String)tipid) && StringUtils.isNotEmpty((String)tipmp)) {
                noAgence = tipid.substring(3);
            }
            globalSettings.set("syra_noAgence", (Object)noAgence);
            globalSettings.set("syra_userId", (Object)tipid);
            globalSettings.set("syra_userIdPswd", (Object)tipmp);
        }
        valBolDefautArray = SyraGlobalSettings.STRING_VALUES;
        int n6 = SyraGlobalSettings.STRING_VALUES.length;
        int n7 = 0;
        while (n7 < n6) {
            v = valBolDefautArray[n7];
            b = globalSettings.get(v.k);
            if (b != null) {
                objG.put(v.k, b);
            }
            ++n7;
        }
        objG.put("INFODATA", new Integer(LibPlugin.isInfodata ? 1 : 0));
        to = new CTypeObject("currGlobalDefaultType", objG);
        message = new GsonBuilder().create().toJson((Object)to);
        HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message);
        if (Boolean.TRUE.equals(cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).getAutoSend())) {
            this.runnableSendDemPaimt.addScheduler(uid);
        } else {
            this.runnableSendDemPaimt.removeScheduler(uid);
        }
        this.setRunnableSendDempPaimt();
    }

    private Object searchReferant(Map<String, String> params) {
        CProfessionnal[] res = this.findProfessionals(params.get("k"));
        return res;
    }

    private Object searchSecteur(Map<String, String> params, CDemContainer cDemContainer) {
        String k = params.get("k");
        Integer idAnchorProf = cDemContainer.getCurrentProf().getId();
        CodeDesc[] res = this.findSecteur(idAnchorProf, k);
        return res;
    }

    private Object searchEtabl(Map<String, String> params, CDemContainer cDemContainer) {
        String k = params.get("k");
        Integer idAnchorProf = cDemContainer.getCurrentProf().getId();
        CodeDesc[] res = this.findEtablissement(idAnchorProf, k);
        return res;
    }

    private Object saveBill(CUidObject cUidObject, CDemContainer cDemContainer) {
        Object response = new Object[]{};
        if (cUidObject != null) {
            String oUid = cUidObject.getUid();
            CDemForListe demForListe = cDemContainer.getCurrentCDemForListe();
            if (cUidObject.getObject() instanceof String) {
                String msgStatus;
                Status s;
                String cause;
                DemPaimt demPaimt;
                Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(LocalDate.class, (Object)new GsonAdapters.LocalDateTypeAdapter()).registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Double.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(BigDecimal.class, (Object)new GsonAdapters.EmptyStringToBigDecimalTypeAdapter()).create();
                if (Platform.inDebugMode()) {
                    System.out.println(cUidObject.getObject());
                }
                CDemPaimt dpFromUi = (CDemPaimt)gson.fromJson((String)cUidObject.getObject(), CDemContainer.mapTypes.get(cUidObject.getType()));
                dpFromUi.demForListe = demForListe;
                CDemPaimt dpFromBackEnd = cDemContainer.getCurrentDemPaimt();
                Integer[] ptInt = null;
                String[] ptString = null;
                if (dpFromUi.serv != null) {
                    if (dpFromUi.serv.lstPatients == null) {
                        dpFromUi.serv.lstPatients = new ArrayList<CPatient>(dpFromBackEnd.serv.mapTempPatients.values());
                    }
                    ArrayList<CPatient> lstPt = new ArrayList<CPatient>();
                    for (CPatient pt : dpFromUi.serv.lstPatients) {
                        if (!StringUtils.isEmpty((String)pt.getHealthInsuranceNumber()) || !StringUtils.isEmpty((String)pt.getIdPersAutre()) || !StringUtils.isEmpty((String)pt.getLastName())) continue;
                        lstPt.add(pt);
                    }
                    dpFromUi.serv.lstPatients.removeAll(lstPt);
                    ptInt = new Integer[dpFromUi.serv.lstPatients.size()];
                    ptString = new String[dpFromUi.serv.lstPatients.size()];
                    int ip = 0;
                    for (CPatient pt : dpFromUi.serv.lstPatients) {
                        ptInt[ip] = pt.getId() == null ? new Integer(-1) : pt.getId();
                        ptString[ip] = CPatient.getIdent(pt);
                        if (pt.lstDx == null) {
                            pt.lstDx = new ArrayList<CodeDesc>();
                            if (pt.lstCTypDiagnMdcal != null) {
                                for (CTypDiagnMdcal cTypDiagnMdcal : pt.lstCTypDiagnMdcal) {
                                    pt.lstDx.add(new CodeDesc(cTypDiagnMdcal.code, null));
                                }
                            }
                        }
                        ++ip;
                    }
                    demForListe.setIdPatients(ptInt);
                    demForListe.setPatientStrings(ptString);
                    if (dpFromUi.serv.lstLigneFact == null) {
                        dpFromUi.serv.lstLigneFact = new ArrayList<CLigneTypServMdcal>(dpFromBackEnd.serv.mapTempLigneFact.values());
                        for (CLigneTypServMdcal lf : dpFromUi.serv.lstLigneFact) {
                            lf.lstElmCx = new ArrayList<CodeDesc>();
                            if (lf.lstTempElmCx != null) {
                                for (CodeDesc codeDesc : lf.lstTempElmCx) {
                                    lf.lstElmCx.add(new CodeDesc(codeDesc.c, null));
                                }
                            }
                            lf.lstLieuEnRef = new ArrayList<CLieu>();
                            if (lf.lstTempLieuEnRef != null) {
                                for (CLieu cLieu : lf.lstTempLieuEnRef) {
                                    CLieu lieuEnRef = null;
                                    if ("C".equals(cLieu.typLocEtab)) {
                                        if (cLieu.etab == null || cLieu.etab.noSelectedEtab == null) continue;
                                        Integer codPresSectAct = cLieu.etab.codPreciSectActiv == null ? new Integer(0) : cLieu.etab.codPreciSectActiv;
                                        lieuEnRef = new CLieu(cLieu.typLocEtab, cLieu.etab.codPreciLieu, codPresSectAct, null, null);
                                    } else if ("N".equals(cLieu.typLocEtab)) {
                                        if (cLieu.local == null || cLieu.local.typIdLieuGeo == null) continue;
                                        lieuEnRef = new CLieu(cLieu.typLocEtab, cLieu.local.codPreciLieu, new Integer(0), cLieu.local.typIdLieuGeo, cLieu.local.typLieuGeo);
                                    }
                                    lf.lstLieuEnRef.add(lieuEnRef);
                                }
                            }
                            lf.lstMesur = new ArrayList<CLigneTypServMdcal.Mesur>();
                            if (lf.lstTempMesur == null) continue;
                            for (CLigneTypServMdcal.Mesur mesur : lf.lstTempMesur) {
                                lf.lstMesur.add(new CLigneTypServMdcal.Mesur(mesur.code, mesur.nom, mesur.unit, mesur.val));
                            }
                        }
                    }
                    for (CLigneTypServMdcal lf : dpFromUi.serv.lstLigneFact) {
                        if ((lf.typProfRef != 1 || !StringUtils.isNotEmpty((String)lf.idProfRefConnu)) && (lf.typProfRef != 2 || !StringUtils.isNotEmpty((String)lf.nomProfRefre))) continue;
                        cDemContainer.typProfRef = lf.typProfRef;
                        cDemContainer.typRefreAutreProf = lf.typRefreAutreProf;
                        cDemContainer.typIdProfRefreConnu = lf.typIdProfRefreConnu;
                        cDemContainer.idProfRefConnu = lf.idProfRefConnu;
                        cDemContainer.codTerriProfRefre = lf.codTerriProfRefre;
                        cDemContainer.typPrfsnProfRefre = lf.typPrfsnProfRefre;
                        cDemContainer.nomProfRefre = lf.nomProfRefre;
                        cDemContainer.preProfRefre = lf.preProfRefre;
                        break;
                    }
                    if (dpFromUi.serv.lstElmCx == null) {
                        dpFromUi.serv.lstElmCx = dpFromBackEnd.serv.lstTempElmCx;
                    }
                    if (dpFromUi.cDemdr != null && StringUtils.isNotEmpty((String)dpFromUi.cDemdr.idIntvn)) {
                        dpFromUi.serv.prof = CObjectUtils.getProf(dpFromUi.cDemdr.idIntvn);
                        if (cDemContainer.getCurrentProf() == null || !cDemContainer.getCurrentProf().getNoProf().equals(dpFromUi.cDemdr.idIntvn)) {
                            cDemContainer.setCurrentValue("currentProf", dpFromUi.serv.prof);
                        }
                    } else {
                        dpFromUi.serv.prof = cDemContainer.getCurrentProf();
                    }
                    dpFromUi.serv.lieu = cDemContainer.getCurrentLieu(null);
                    demForListe.setIdUser(cDemContainer.getCurrentBillUser().id);
                    demForListe.setIdProf(cDemContainer.getCurrentProf().getId());
                    if (demForListe.getIdIntvn() == null || !demForListe.getIdIntvn().equals(dpFromUi.serv.prof.getNoProf())) {
                        this.saveProfInDemForList(cDemContainer, oUid, demForListe);
                    }
                } else if (dpFromUi.depl != null) {
                    if (dpFromUi.cDemdr != null && StringUtils.isNotEmpty((String)dpFromUi.cDemdr.idIntvn)) {
                        dpFromUi.depl.prof = CObjectUtils.getProf(dpFromUi.cDemdr.idIntvn);
                        if (cDemContainer.getCurrentProf() == null || !cDemContainer.getCurrentProf().getNoProf().equals(dpFromUi.cDemdr.idIntvn)) {
                            cDemContainer.setCurrentValue("currentProf", dpFromUi.depl.prof);
                        }
                    } else {
                        dpFromUi.depl.prof = cDemContainer.getCurrentProf();
                    }
                    demForListe.setIdUser(cDemContainer.getCurrentBillUser().id);
                    demForListe.setIdProf(cDemContainer.getCurrentProf().getId());
                    if (demForListe.getIdIntvn() == null || !demForListe.getIdIntvn().equals(dpFromUi.depl.prof.getNoProf())) {
                        this.saveProfInDemForList(cDemContainer, oUid, demForListe);
                    }
                }
                if (dpFromUi.cModaPaimt != null && dpFromUi.cModaPaimt.type != null && dpFromUi.cModaPaimt.type == 2) {
                    if (dpFromUi.cModaPaimt.no != null && dpFromUi.cModaPaimt.no != 0) {
                        if (cDemContainer.getCurrentGroupe() == null || StringUtils.isEmpty((String)cDemContainer.getCurrentGroupe().c) || Integer.parseInt(cDemContainer.getCurrentGroupe().c.trim()) != dpFromUi.cModaPaimt.no) {
                            cDemContainer.setCurrentGroupe(CObjectUtils.getGroupe(StringUtils.padLeft((String)String.valueOf(dpFromUi.cModaPaimt.no), (int)5, (char)'0')));
                        }
                        dpFromUi.cModaPaimt = new CModaPaimt(new Integer(2), dpFromUi.cModaPaimt.no, cDemContainer.getCurrentGroupe());
                    } else {
                        dpFromUi.cModaPaimt = new CModaPaimt(new Integer(1), null, null);
                    }
                }
                dpFromUi.cDemdr = new CDemdr("1", demForListe.getIdIntvn());
                if (dpFromUi.demModif != null) {
                    dpFromUi.demModif.serv = dpFromUi.serv;
                    dpFromUi.demModif.depl = dpFromUi.depl;
                    dpFromUi.demModif.cDemdr = dpFromUi.cDemdr;
                    dpFromUi.demModif.cNoDemExt = dpFromUi.cNoDemExt;
                    dpFromUi.demModif.type = dpFromUi.type;
                    demPaimt = null;
                    try {
                        demPaimt = dpFromUi.convert2Dem(cDemContainer);
                    }
                    catch (ValidReglePlafException e) {
                        cause = e.getMessage();
                        s = new Status(IStatus.Severity.NEED_MORE_INFO, cause);
                        s.setData(e.getMapRPR());
                        CTypeObject cTypeObject = new CTypeObject("validReglePlafBillType", s);
                        msgStatus = new GsonBuilder().create().toJson((Object)cTypeObject);
                        HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)msgStatus);
                        response = new Integer(1);
                    }
                    catch (Exception e) {
                        cause = this.getExceptionMessage(e);
                        s = new Status(IStatus.Severity.ERROR, "Erreur de validation de la sauvegarde: " + cause);
                        CTypeObject cTypeObject = new CTypeObject("saveBillType", s);
                        msgStatus = new GsonBuilder().create().toJson((Object)cTypeObject);
                        HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)msgStatus);
                        response = new Integer(1);
                    }
                    if (demPaimt != null) {
                        new CDemPaimt(demPaimt, cDemContainer, true, false);
                        DemModif demModif = null;
                        try {
                            demModif = dpFromUi.demModif.convert2Dem(cDemContainer);
                        }
                        catch (Exception e) {
                            String cause2 = this.getExceptionMessage(e);
                            Status status = new Status(IStatus.Severity.ERROR, "Erreur de validation de la sauvegarde: " + cause2);
                            CTypeObject statusObject2 = new CTypeObject("saveBillType", status);
                            String msgStatus2 = new GsonBuilder().create().toJson((Object)statusObject2);
                            HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)msgStatus2);
                            Integer n = new Integer(1);
                        }
                        if (demModif != null) {
                            if (demPaimt.getListeFact() != null && demPaimt.getListeFact().getFactBase() != null) {
                                DemModif.FactAModif factAModif = ConvertJavaToFromArray.of.createDemModifFactAModif();
                                TypFact typFact = (TypFact)demPaimt.getListeFact().getFactBase().getValue();
                                factAModif.setFactBase(ConvertJavaToFromArray.of.createFactBase(typFact));
                                demModif.setFactAModif(factAModif);
                            }
                            demForListe.demModif = demModif;
                            String arrayStringDp = ConvertJavaToFromArray.ConvertDemModif.toArrayString(demModif);
                            List<String> list = demForListe.addOrSetDemModif(arrayStringDp);
                            Long l = new Long(System.currentTimeMillis());
                            String mdtString = DateUtil.format((Long)l, (String)"yyyy-MM-dd HH:mm:ss");
                            demForListe.getDemForListeAndSave(ConvertJavaToFromArray.ArrDemType.DEM_MODIF, list, ptInt, ptString);
                            demForListe.setProgressCommunication(CDemForListe.ProgressComm.NO_INFO.getValue());
                            demForListe.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_MODIF.getVal()));
                            demForListe.setStaRecev(new Integer(0));
                            demForListe.setModifiedDateTime(mdtString);
                            demForListe.setErrMessage(null);
                            String[] keys = new String[]{"progress_comm", "dem_type", "sta_recev", "modified_date_time"};
                            Number[] vals = new Number[]{CDemForListe.ProgressComm.NO_INFO.getValInteger(), new Integer(ConvertJavaToFromArray.ArrDemType.DEM_MODIF.getVal()), new Integer(0), l};
                            BaseDemForListeDAO.getInstance().saveValue(demForListe.getId(), keys, vals, "");
                            CDemForListe dflToSend = new CDemForListe(demForListe.getTag());
                            dflToSend.setProgressCommunication(CDemForListe.ProgressComm.NO_INFO.getValue());
                            dflToSend.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_MODIF.getVal()));
                            dflToSend.setStaRecev(new Integer(0));
                            dflToSend.setModifiedDateTime(mdtString);
                            CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                            String message3 = new GsonBuilder().create().toJson((Object)to3);
                            HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)message3);
                            Status s3 = new Status(IStatus.Severity.OK, "Succ\u00e8s");
                            s3.setData((Serializable)new Integer[]{demForListe.getTag(), demForListe.getId()});
                            CTypeObject statusObject3 = new CTypeObject("saveBillType", s3);
                            String msgStatus3 = new GsonBuilder().create().toJson((Object)statusObject3);
                            if (Boolean.TRUE.equals(CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).getBoolean("envoi_tps_reel")) && !this.runnableSendDemPaimtTpsReel.isStop()) {
                                this.runnableSendDemPaimtTpsReel.addDemPaimt(new RunnableSendDemPaimtTpsReel.DemPaimtTpsReel(cDemContainer.uid, cDemContainer, demForListe, msgStatus3));
                            } else {
                                HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)msgStatus3);
                            }
                        } else if (demForListe.getProgressCommunication() != CDemForListe.ProgressComm.NO_INFO.getValue()) {
                            Long mdt = new Long(System.currentTimeMillis());
                            String mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                            demForListe.setProgressCommunication(CDemForListe.ProgressComm.NO_INFO.getValue());
                            demForListe.setModifiedDateTime(mdtString);
                            String[] stringArray = new String[]{"progress_comm", "modified_date_time"};
                            Number[] vals = new Number[]{CDemForListe.ProgressComm.NO_INFO.getValInteger(), mdt};
                            BaseDemForListeDAO.getInstance().saveValue(demForListe.getId(), stringArray, vals, "");
                            CDemForListe dflToSend = new CDemForListe(demForListe.getTag());
                            dflToSend.setProgressCommunication(CDemForListe.ProgressComm.NO_INFO.getValue());
                            dflToSend.setModifiedDateTime(mdtString);
                            CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                            String message3 = new GsonBuilder().create().toJson((Object)to3);
                            HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)message3);
                            Status s4 = new Status(IStatus.Severity.OK, "Succ\u00e8s");
                            s4.setData((Serializable)new Integer[]{demForListe.getTag(), demForListe.getId()});
                            CTypeObject statusObject4 = new CTypeObject("saveBillType", s4);
                            String msgStatus4 = new GsonBuilder().create().toJson((Object)statusObject4);
                            if (Boolean.TRUE.equals(CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).getBoolean("envoi_tps_reel")) && !this.runnableSendDemPaimtTpsReel.isStop()) {
                                this.runnableSendDemPaimtTpsReel.addDemPaimt(new RunnableSendDemPaimtTpsReel.DemPaimtTpsReel(cDemContainer.uid, cDemContainer, demForListe, msgStatus4));
                            } else {
                                HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)msgStatus4);
                            }
                        }
                    }
                } else {
                    demPaimt = null;
                    try {
                        demPaimt = dpFromUi.convert2Dem(cDemContainer);
                    }
                    catch (ValidReglePlafException e) {
                        cause = e.getMessage();
                        s = new Status(IStatus.Severity.NEED_MORE_INFO, cause);
                        s.setData(e.getMapRPR());
                        CTypeObject cTypeObject = new CTypeObject("validReglePlafBillType", s);
                        msgStatus = new GsonBuilder().create().toJson((Object)cTypeObject);
                        HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)msgStatus);
                        response = new Integer(1);
                    }
                    catch (Exception e) {
                        cause = this.getExceptionMessage(e);
                        s = new Status(IStatus.Severity.ERROR, "Erreur de validation de la sauvegarde: " + cause);
                        CTypeObject cTypeObject = new CTypeObject("saveBillType", s);
                        msgStatus = new GsonBuilder().create().toJson((Object)cTypeObject);
                        HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)msgStatus);
                        response = new Integer(1);
                    }
                    if (demPaimt != null) {
                        new CDemPaimt(demPaimt, cDemContainer, true, false);
                        demForListe.demPaimt = demPaimt;
                        String arrayStringDp = ConvertJavaToFromArray.ConvertDemPaimt.toArrayString(demPaimt);
                        List<String> list = demForListe.addOrSetDemPaimt(arrayStringDp);
                        demForListe.getDemForListeAndSave(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT, list, ptInt, ptString);
                        if (demForListe.getProgressCommunication() != CDemForListe.ProgressComm.NO_INFO.getValue()) {
                            Long mdt = new Long(System.currentTimeMillis());
                            String string = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                            demForListe.setProgressCommunication(CDemForListe.ProgressComm.NO_INFO.getValue());
                            demForListe.setModifiedDateTime(string);
                            String[] keys = new String[]{"progress_comm", "modified_date_time"};
                            Number[] vals = new Number[]{CDemForListe.ProgressComm.NO_INFO.getValInteger(), mdt};
                            BaseDemForListeDAO.getInstance().saveValue(demForListe.getId(), keys, vals, "");
                            CDemForListe dflToSend = new CDemForListe(demForListe.getTag());
                            dflToSend.setProgressCommunication(CDemForListe.ProgressComm.NO_INFO.getValue());
                            dflToSend.setModifiedDateTime(string);
                            CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                            String message3 = new GsonBuilder().create().toJson((Object)to3);
                            HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)message3);
                        }
                        s = new Status(IStatus.Severity.OK, "Succ\u00e8s");
                        s.setData((Serializable)new Integer[]{demForListe.getTag(), demForListe.getId()});
                        CTypeObject cTypeObject = new CTypeObject("saveBillType", s);
                        msgStatus = new GsonBuilder().create().toJson((Object)cTypeObject);
                        if (demForListe.getReady() && Boolean.TRUE.equals(CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).getBoolean("envoi_tps_reel")) && !this.runnableSendDemPaimtTpsReel.isStop()) {
                            this.runnableSendDemPaimtTpsReel.addDemPaimt(new RunnableSendDemPaimtTpsReel.DemPaimtTpsReel(cDemContainer.uid, cDemContainer, demForListe, msgStatus));
                        } else {
                            HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)msgStatus);
                        }
                    }
                }
            }
        }
        Object[] res = response;
        return res;
    }

    public String getExceptionMessage(Exception e) {
        String cause = e.getMessage();
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            cause = String.valueOf(cause) + ". Cause: " + e.getCause().getMessage();
        }
        StackTraceElement[] st = null;
        st = e.getStackTrace();
        if (st != null && st.length > 0) {
            cause = String.valueOf(cause) + "<br>" + st[0].toString();
            if (st.length > 1) {
                cause = String.valueOf(cause) + "<br>" + st[1].toString();
            }
        }
        return cause;
    }

    private void saveProfInDemForList(CDemContainer cDemContainer, String oUid, CDemForListe demForListe) {
        demForListe.setIdIntvn(cDemContainer.getCurrentProf().getNoProf());
        Object[] idPrg3 = new Object[]{demForListe.getTag(), demForListe.getIdIntvn()};
        CTypeObject to3 = new CTypeObject("sendDemListeIdIntvnType", idPrg3);
        String message3 = new GsonBuilder().create().toJson((Object)to3);
        HtmlBrowserTools.sendMessageToWebClient((String)oUid, (String)message3);
    }

    private Object postAnnuBill(CUidObject cUidObject, CDemContainer cDemContainer) {
        Object response = new Object[]{};
        if (cUidObject != null && cUidObject.getObject() instanceof String) {
            Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(LocalDate.class, (Object)new GsonAdapters.LocalDateTypeAdapter()).registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).create();
            CDemAnnu oo = (CDemAnnu)gson.fromJson((String)cUidObject.getObject(), CDemAnnu.class);
            CDemForListe demForListe = cDemContainer.getCurrentCDemForListe();
            DemAnnu dem = null;
            try {
                dem = oo.convert2Dem(cDemContainer);
            }
            catch (Exception e) {
                String cause = this.getExceptionMessage(e);
                Status s = new Status(IStatus.Severity.ERROR, "Erreur de validation de la sauvegarde: " + cause);
                CTypeObject statusObject = new CTypeObject("saveBillType", s);
                String msgStatus = new GsonBuilder().create().toJson((Object)statusObject);
                HtmlBrowserTools.sendMessageToWebClient((String)cUidObject.getUid(), (String)msgStatus);
                response = new Integer(1);
            }
            if (dem != null) {
                demForListe.demAnnu = dem;
                String arrayStringDp = ConvertJavaToFromArray.ConvertDemAnnu.toArrayString(dem);
                List<String> list = demForListe.addOrSetDemAnnu(arrayStringDp);
                demForListe.getDemForListeAndSave(ConvertJavaToFromArray.ArrDemType.DEM_ANNU, list, null, null);
                demForListe.setProgressCommunication(0);
                demForListe.setDemType(new Integer(3));
                demForListe.setStaRecev(new Integer(0));
                demForListe.setReady(true);
                demForListe.setErrMessage(null);
                String[] keys = new String[]{"progress_comm", "dem_type", "sta_recev", "ready"};
                Number[] vals = new Integer[]{new Integer(0), new Integer(3), new Integer(0), new Integer(1)};
                BaseDemForListeDAO.getInstance().saveValue(demForListe.getId(), keys, vals, "");
                if (Boolean.TRUE.equals(CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).getBoolean("envoi_tps_reel")) && !this.runnableSendDemPaimtTpsReel.isStop()) {
                    this.runnableSendDemPaimtTpsReel.addDemPaimt(new RunnableSendDemPaimtTpsReel.DemPaimtTpsReel(cDemContainer.uid, cDemContainer, demForListe, null));
                }
            }
        }
        return response;
    }

    private void postRestoreBill(CUidObject cUidObject, CDemContainer cDemContainer) {
        Integer b = null;
        if (cUidObject != null) {
            Double idtag = (Double)cUidObject.getObject();
            if (idtag != null) {
                b = new Integer(idtag.intValue());
            }
            if (b != null) {
                CDemForListe demForListe;
                if (cDemContainer.getMapCDemForListe().containsKey(b) && (demForListe = cDemContainer.getMapCDemForListe().get(b)).getId() != null) {
                    SyraAccessorClient.getInstance().restoreBill(demForListe.getId());
                    demForListe.setIsDeleted(new Integer(0));
                }
                Status s = new Status(IStatus.Severity.OK, "R\u00e9cup\u00e9ration de la facture " + b);
                CTypeObject statusObject = new CTypeObject("restoreBillType", s);
                String msgStatus = new GsonBuilder().create().toJson((Object)statusObject);
                HtmlBrowserTools.sendMessageToWebClient((String)cUidObject.getUid(), (String)msgStatus);
            }
        }
    }

    private void postDeleteBill(CUidObject cUidObject, CDemContainer cDemContainer) {
        Integer b = null;
        if (cUidObject != null) {
            Double idtag = (Double)cUidObject.getObject();
            if (idtag != null) {
                b = new Integer(idtag.intValue());
            }
            if (b != null) {
                CDemForListe demForListe;
                if (cDemContainer.getMapCDemForListe().containsKey(b) && (demForListe = cDemContainer.getMapCDemForListe().get(b)).getId() != null) {
                    SyraAccessorClient.getInstance().deleteBill(demForListe.getId());
                    demForListe.setIsDeleted(new Integer(1));
                }
                Status s = new Status(IStatus.Severity.OK, "Effacement de la facture " + b);
                CTypeObject statusObject = new CTypeObject("deleteBillType", s);
                String msgStatus = new GsonBuilder().create().toJson((Object)statusObject);
                HtmlBrowserTools.sendMessageToWebClient((String)cUidObject.getUid(), (String)msgStatus);
            }
        }
    }

    private Object getLastDateEntree(String uid, CDemContainer cDemContainer, String noEtab) {
        String last = null;
        CPatient pt = cDemContainer.getCurrentPatient();
        if (StringUtils.isNotEmpty((String)pt.getHealthInsuranceNumber())) {
            int[] hh;
            int hashCodeHin = CPatient.getStringToHashCode(pt.getStringForHash(1));
            if (pt.getAge() < 6) {
                int hashCode = CPatient.getStringToHashCode(pt.getStringForHash(0));
                hh = new int[]{hashCodeHin, hashCode};
            } else {
                hh = new int[]{hashCodeHin};
            }
            last = SyraAccessorClient.getInstance().getLastDateEntree(hh, noEtab);
        } else {
            int hashCode = CPatient.getStringToHashCode(pt.getStringForHash(1));
            last = SyraAccessorClient.getInstance().getLastDateEntree(new int[]{hashCode}, noEtab);
        }
        Status res = last == null ? new Status(IStatus.Severity.ERROR, "") : new Status(IStatus.Severity.OK, last);
        return res;
    }

    private Object postHistoricBill(String uid, CDemContainer cDemContainer) {
        Integer res;
        CPatient pt = cDemContainer.getCurrentPatient();
        CArchivedBill[] histFacturation = new CArchivedBill[]{};
        if (pt == null) {
            res = new Integer(0);
        } else if (StringUtils.isNotEmpty((String)pt.getHealthInsuranceNumber())) {
            int[] hh;
            int hashCodeHin = CPatient.getStringToHashCode(pt.getStringForHash(1));
            if (pt.getAge() < 6) {
                String autreStr = pt.getStringForHash(0);
                if (StringUtils.isNotEmpty((String)autreStr)) {
                    int hashCode = CPatient.getStringToHashCode(pt.getStringForHash(0));
                    hh = new int[]{hashCodeHin, hashCode};
                } else {
                    hh = new int[]{hashCodeHin};
                }
            } else {
                hh = new int[]{hashCodeHin};
            }
            histFacturation = SyraAccessorClient.getInstance().getHistoricFacturation(hh);
        } else {
            String stringForHash = pt.getStringForHash(1);
            if (StringUtils.isEmpty((String)stringForHash)) {
                res = new Integer(0);
            } else {
                int hashCode = CPatient.getStringToHashCode(stringForHash);
                histFacturation = SyraAccessorClient.getInstance().getHistoricFacturation(new int[]{hashCode});
            }
        }
        CTypeObject toHxFact = new CTypeObject("histFacturationType", histFacturation);
        String msgHxFact = new GsonBuilder().create().toJson((Object)toHxFact);
        HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)msgHxFact);
        res = new Integer(1);
        return res;
    }

    private Object postPlafBill(String uid, CDemContainer cDemContainer) {
        Integer res;
        CPatient pt = cDemContainer.getCurrentPatient();
        CArchivedBill[] histFacturation = new CArchivedBill[]{};
        HashSet<String> setCodePlaf = new HashSet<String>();
        if (pt == null) {
            res = new Integer(0);
        } else {
            if (StringUtils.isNotEmpty((String)pt.getHealthInsuranceNumber())) {
                int[] hh;
                int hashCodeHin = CPatient.getStringToHashCode(pt.getStringForHash(1));
                if (pt.getAge() < 6) {
                    String autreStr = pt.getStringForHash(0);
                    if (StringUtils.isNotEmpty((String)autreStr)) {
                        int hashCode = CPatient.getStringToHashCode(pt.getStringForHash(0));
                        hh = new int[]{hashCodeHin, hashCode};
                    } else {
                        hh = new int[]{hashCodeHin};
                    }
                } else {
                    hh = new int[]{hashCodeHin};
                }
                histFacturation = SyraAccessorClient.getInstance().getPlafFacturation(hh, setCodePlaf);
            } else {
                String stringForHash = pt.getStringForHash(1);
                if (StringUtils.isEmpty((String)stringForHash)) {
                    res = new Integer(0);
                } else {
                    int hashCode = CPatient.getStringToHashCode(stringForHash);
                    histFacturation = SyraAccessorClient.getInstance().getPlafFacturation(new int[]{hashCode}, setCodePlaf);
                }
            }
            CArchivedBill[] cArchivedBillArray = histFacturation;
            int n = histFacturation.length;
            int n2 = 0;
            while (n2 < n) {
                CArchivedBill cArchivedBill = cArchivedBillArray[n2];
                pt.mmPlafBill.put((Object)cArchivedBill.cod, (Object)cArchivedBill);
                ++n2;
            }
        }
        res = new Integer(1);
        return res;
    }

    private void postBill(CUidObject cUidObject, CDemContainer cDemContainer) {
        Integer b = null;
        if (cUidObject != null) {
            CDemForListe cDFL;
            Double idtag = (Double)cUidObject.getObject();
            if (idtag != null) {
                b = new Integer(idtag.intValue());
            }
            if ((cDFL = cDemContainer.getCDemForListe(b)) != null) {
                cDFL.demPaimt = null;
                DemPaimt dem = cDFL.getLastDemPaimt();
                if (dem != null) {
                    CDemPaimt cDemPaimt = new CDemPaimt(dem, cDemContainer, true, false);
                    DemPaimtRecev paimtRecev = cDFL.getDemPaimtRecev(cDFL.iLastDemPaimt);
                    int iLast = cDFL.iLastDemPaimt;
                    while (paimtRecev == null && iLast > 0) {
                        paimtRecev = cDFL.getDemPaimtRecev(--iLast);
                    }
                    if (paimtRecev != null) {
                        cDemPaimt.recev = new CDemPaimtRecev(paimtRecev);
                    }
                    BigDecimal mntPrel = null;
                    if (cDemPaimt.recev != null && !cDemPaimt.recev.listeFactRecev.isEmpty()) {
                        CDemPaimtRecev.CFactRecev factRecev = cDemPaimt.recev.listeFactRecev.get(0);
                        CProfessionnal prof = CObjectUtils.getProf(cDemPaimt.cDemdr.idIntvn);
                        if (factRecev.idFactRamqRecev != null && factRecev.idFactRamqRecev.noFactRamq != null) {
                            Integer[] setLine;
                            if (factRecev.listeLigneFactRecev != null && !factRecev.listeLigneFactRecev.isEmpty()) {
                                mntPrel = new BigDecimal(0);
                                for (CTypLigneFactRecev ligneFactRecev : factRecev.listeLigneFactRecev) {
                                    mntPrel = mntPrel.add(ligneFactRecev.mntPrel);
                                }
                            }
                            Long noRfp = new Long(factRecev.idFactRamqRecev.noFactRamq.longValue());
                            if (cDemContainer.getMapCurrentExplPaimtAllNodes().containsKey(noRfp)) {
                                cDemPaimt.explPmt = cDemContainer.getMapCurrentExplPaimtAllNodes().get(noRfp);
                                if (cDemPaimt.explPmt != null && !cDemPaimt.explPmt.mapLine.isEmpty()) {
                                    setLine = cDemPaimt.explPmt.mapLine.keySet().toArray(new Integer[0]);
                                    this.createTextFromDetEta(cDemPaimt, factRecev, prof, noRfp, setLine);
                                }
                            } else if (cDemPaimt.serv != null) {
                                if (cDemPaimt.serv.mapTempLigneFact != null && cDemPaimt.serv.mapTempLigneFact.size() > 0) {
                                    cDemPaimt.explPmt = new CFactExplPmt();
                                    setLine = cDemPaimt.serv.mapTempLigneFact.keySet().toArray(new Integer[0]);
                                    this.createTextFromDetEta(cDemPaimt, factRecev, prof, noRfp, setLine);
                                }
                            } else if (cDemPaimt.depl != null) {
                                setLine = new HashSet();
                                if (cDemPaimt.depl.mapTempForfaDepla != null && cDemPaimt.depl.mapTempForfaDepla.size() > 0) {
                                    setLine.addAll(cDemPaimt.depl.mapTempForfaDepla.keySet());
                                }
                                if (cDemPaimt.depl.mapTempFraisSej != null && cDemPaimt.depl.mapTempFraisSej.size() > 0) {
                                    setLine.addAll(cDemPaimt.depl.mapTempFraisSej.keySet());
                                }
                                if (cDemPaimt.depl.mapTempFraisTranp != null && cDemPaimt.depl.mapTempFraisTranp.size() > 0) {
                                    setLine.addAll(cDemPaimt.depl.mapTempFraisTranp.keySet());
                                }
                                if (cDemPaimt.depl.mapTempTempsDepla != null && cDemPaimt.depl.mapTempTempsDepla.size() > 0) {
                                    setLine.addAll(cDemPaimt.depl.mapTempTempsDepla.keySet());
                                }
                                if (setLine.size() > 0) {
                                    cDemPaimt.explPmt = new CFactExplPmt();
                                    Integer[] newSet = setLine.toArray(new Integer[0]);
                                    this.createTextFromDetEta(cDemPaimt, factRecev, prof, noRfp, newSet);
                                }
                            }
                            if (cDemPaimt.explPmt != null && cDemPaimt.explPmt.mapLine.isEmpty()) {
                                cDemPaimt.explPmt = null;
                            }
                        }
                    }
                    try {
                        CProfessionnal activeProf = null;
                        if (cDemPaimt.serv != null && cDemPaimt.serv.prof != null) {
                            activeProf = cDemPaimt.serv.prof;
                        } else if (cDemPaimt.depl != null && cDemPaimt.depl.prof != null) {
                            activeProf = cDemPaimt.depl.prof;
                        }
                        if (activeProf != null && !cDFL.getIdIntvn().equals(activeProf.getNoProf())) {
                            this.saveProfInDemForList(cDemContainer, cUidObject.getUid(), cDFL);
                        }
                    }
                    catch (Exception e) {
                        String cause = this.getExceptionMessage(e);
                        logger.log(Level.SEVERE, "Erreur lors de la correction de activeProf: " + cause, e);
                    }
                    this.setDemModifAnnuToDemPaimt(cDemContainer, cDemPaimt, cDFL, false);
                    CTypeObject toDemPaimt = new CTypeObject("currDemPaimtType", cDemPaimt);
                    String msgDemPaimtType = new GsonBuilder().create().toJson((Object)toDemPaimt);
                    HtmlBrowserTools.sendMessageToWebClient((String)cUidObject.getUid(), (String)msgDemPaimtType);
                } else {
                    DemPaimtRecev demPaimtRecev = cDFL.getLastDemPaimtRecev();
                    if (demPaimtRecev != null) {
                        CDemPaimt cDemPaimt = new CDemPaimt();
                        cDemPaimt.recev = new CDemPaimtRecev(demPaimtRecev);
                        DemAnnu demAnnu = cDFL.getLastDemAnnu();
                        if (demAnnu != null) {
                            cDemPaimt.demAnnu = new CDemAnnu(demAnnu, cDemContainer, false, false);
                            DemAnnuRecev demAnnuRecev = cDFL.getLastDemAnnuRecev();
                            if (demAnnuRecev != null) {
                                cDemPaimt.demAnnu.recev = new CDemAnnuRecev(demAnnuRecev);
                            }
                        }
                        CTypeObject toDemPaimt = new CTypeObject("currDemPaimtType", cDemPaimt);
                        String msgDemPaimtType = new GsonBuilder().create().toJson((Object)toDemPaimt);
                        HtmlBrowserTools.sendMessageToWebClient((String)cUidObject.getUid(), (String)msgDemPaimtType);
                    }
                }
            }
        }
    }

    private void createTextFromDetEta(CDemPaimt cDemPaimt, CDemPaimtRecev.CFactRecev factRecev, CProfessionnal prof, Long noRfp, Integer[] setLine) {
        List lstEtDetAll = BaseEt_detDAO.getInstance().findFiltered(new String[]{"noRfp"}, new Object[]{noRfp}, BaseEt_detDAO.getInstance().getMostRecentEtatCptOrder());
        if (lstEtDetAll != null && lstEtDetAll.size() > 0) {
            String dateEc = ((Et_det)lstEtDetAll.get(0)).getDt_mddte().substring(0, 8);
            ArrayList<Et_det> lstEtDetDateLast = new ArrayList<Et_det>();
            ArrayList<Et_det> lstEtDetDateOthers = new ArrayList<Et_det>();
            for (Et_det etdt : lstEtDetAll) {
                if (dateEc.equals(etdt.getDt_mddte().substring(0, 8))) {
                    lstEtDetDateLast.add(etdt);
                    continue;
                }
                lstEtDetDateOthers.add(etdt);
            }
            if (lstEtDetDateOthers.size() > 0) {
                for (Et_det etdt : lstEtDetDateOthers) {
                    HashMap<Object, Object> mapLine;
                    String dtEta = etdt.getDt_mddte().substring(0, 8);
                    if (cDemPaimt.explPmt.mapECLine.containsKey(dtEta)) {
                        mapLine = cDemPaimt.explPmt.mapECLine.get(dtEta);
                    } else {
                        mapLine = new HashMap();
                        cDemPaimt.explPmt.mapECLine.put(dtEta, mapLine);
                    }
                    Integer noLigne = etdt.getNoLigne() == null ? new Integer(0) : etdt.getNoLigne();
                    CFactExplPmt.CLigneFactPmt ligneFactPmtOther = new CFactExplPmt.CLigneFactPmt();
                    ligneFactPmtOther.no = noLigne;
                    this.getExplPmtAndMntDiff(null, prof, ligneFactPmtOther, etdt);
                    mapLine.put(noLigne, ligneFactPmtOther);
                }
            }
            if (lstEtDetDateLast.size() == 1 && (((Et_det)lstEtDetDateLast.get(0)).getNoLigne() == null || ((Et_det)lstEtDetDateLast.get(0)).getNoLigne() == 0)) {
                CFactExplPmt.CLigneFactPmt ligneFactPmt = new CFactExplPmt.CLigneFactPmt();
                ligneFactPmt.no = new Integer(0);
                this.getExplPmtAndMntDiff(null, prof, ligneFactPmt, (Et_det)lstEtDetDateLast.get(0));
                cDemPaimt.explPmt.mapLine.put(new Integer(ligneFactPmt.no + 100), ligneFactPmt);
            } else if (lstEtDetDateLast.size() > 0) {
                Integer[] integerArray = setLine;
                int n = setLine.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer ii = integerArray[n2];
                    CFactExplPmt.CLigneFactPmt ligneFactPmt = new CFactExplPmt.CLigneFactPmt();
                    ligneFactPmt.no = ii = ii > 99 ? new Integer(ii - 100) : ii;
                    this.getExplPmtAndMntDiff(factRecev, prof, ligneFactPmt, lstEtDetDateLast);
                    cDemPaimt.explPmt.mapLine.put(new Integer(ligneFactPmt.no + 100), ligneFactPmt);
                    ++n2;
                }
            }
        }
    }

    private void getExplPmtAndMntDiff(CDemPaimtRecev.CFactRecev factRecev, CProfessionnal prof, CFactExplPmt.CLigneFactPmt ligneFactPmt, Et_det etDet) {
        StringBuilder sbDatEta = new StringBuilder();
        StringBuilder sbCodes = new StringBuilder();
        CProfessionnal.Entente entente = CProfessionnal.Entente.valueOf(prof.getType());
        String[] codeExpls = etDet.getCodeExpl();
        String dateEta = DateUtil.dtoc((Calendar)etDet.getDt_dtetat());
        String titreEC = "<h4 style='text-align: center;'>Etat de compte du : " + dateEta + "</h4>";
        if (etDet.getNoLigne() == null || etDet.getNoLigne() == 0) {
            ligneFactPmt.no = new Integer(0);
            BigDecimal bigDecimal = ligneFactPmt.mnt = etDet.getDt_mont() == null ? new BigDecimal(0) : new BigDecimal(etDet.getDt_mont().trim());
            if (etDet.getCodeExpl() != null && etDet.getCodeExpl().length > 0) {
                this.setErrMsgFromCodExplDetEta(sbDatEta, sbCodes, entente, codeExpls, dateEta);
            }
        } else if (etDet.getNoLigne().intValue() == ligneFactPmt.no.intValue()) {
            if (StringUtils.isNotEmpty((String)etDet.getMntNv())) {
                ligneFactPmt.ajs = new BigDecimal(etDet.getDt_mont().trim());
                ligneFactPmt.hasMntDiff = new Boolean(!etDet.getMntNv().equals(etDet.getMntAnt()));
            } else {
                ligneFactPmt.mnt = new BigDecimal(etDet.getDt_mont().trim());
            }
            if (etDet.getCodeExpl() != null && etDet.getCodeExpl().length > 0) {
                this.setErrMsgFromCodExplDetEta(sbDatEta, sbCodes, entente, codeExpls, dateEta);
            }
            if (etDet.getNoSeq() != null) {
                this.setMsgFromRef(sbDatEta, etDet);
            }
        }
        if (ligneFactPmt.dp == null && (ligneFactPmt.ajs != null || ligneFactPmt.mnt != null)) {
            ligneFactPmt.codeExpl = String.valueOf(titreEC) + sbDatEta.toString();
            String string = ligneFactPmt.codes = sbCodes.length() == 0 ? "" : String.valueOf(sbCodes.toString()) + ")";
            if (factRecev != null && factRecev.listeLigneFactRecev != null && !factRecev.listeLigneFactRecev.isEmpty()) {
                for (CTypLigneFactRecev lfr : factRecev.listeLigneFactRecev) {
                    if (Integer.parseInt(lfr.noLigneFact) != ligneFactPmt.no || ligneFactPmt.mnt == null || ligneFactPmt.mnt.doubleValue() < 0.02 || !(ligneFactPmt.mnt.subtract(lfr.mntPrel).doubleValue() > 0.04)) continue;
                    ligneFactPmt.hasMntDiff = Boolean.TRUE;
                    break;
                }
            }
        }
    }

    private void getExplPmtAndMntDiff(CDemPaimtRecev.CFactRecev factRecev, CProfessionnal prof, CFactExplPmt.CLigneFactPmt ligneFactPmt, List<Et_det> lstEtDet) {
        StringBuilder sbDatEta = new StringBuilder();
        StringBuilder sbCodes = new StringBuilder();
        String titreEC = "";
        for (Et_det etDet : lstEtDet) {
            CProfessionnal.Entente entente = CProfessionnal.Entente.valueOf(prof.getType());
            String[] codeExpls = etDet.getCodeExpl();
            String dateEta = DateUtil.dtoc((Calendar)etDet.getDt_dtetat());
            titreEC = "<h4 style='text-align: center;'>Etat de compte du : " + dateEta + "</h4>";
            if (etDet.getNoLigne() == null || etDet.getNoLigne() == 0) {
                ligneFactPmt.no = new Integer(0);
                ligneFactPmt.mnt = new BigDecimal(etDet.getDt_mont().trim());
                if (etDet.getCodeExpl() == null || etDet.getCodeExpl().length <= 0) continue;
                this.setErrMsgFromCodExplDetEta(sbDatEta, sbCodes, entente, codeExpls, dateEta);
                continue;
            }
            if (etDet.getNoLigne().intValue() != ligneFactPmt.no.intValue()) continue;
            if (StringUtils.isNotEmpty((String)etDet.getMntNv())) {
                ligneFactPmt.ajs = new BigDecimal(etDet.getDt_mont().trim());
                ligneFactPmt.hasMntDiff = new Boolean(!etDet.getMntNv().equals(etDet.getMntAnt()));
            } else {
                ligneFactPmt.mnt = new BigDecimal(etDet.getDt_mont().trim());
            }
            if (etDet.getCodeExpl() != null && etDet.getCodeExpl().length > 0) {
                this.setErrMsgFromCodExplDetEta(sbDatEta, sbCodes, entente, codeExpls, dateEta);
            }
            if (etDet.getNoSeq() == null) continue;
            this.setMsgFromRef(sbDatEta, etDet);
        }
        if (ligneFactPmt.dp == null && (ligneFactPmt.ajs != null || ligneFactPmt.mnt != null)) {
            ligneFactPmt.codeExpl = String.valueOf(titreEC) + sbDatEta.toString();
            String string = ligneFactPmt.codes = sbCodes.length() == 0 ? "" : String.valueOf(sbCodes.toString()) + ")";
            if (factRecev != null && factRecev.listeLigneFactRecev != null && !factRecev.listeLigneFactRecev.isEmpty()) {
                for (CTypLigneFactRecev lfr : factRecev.listeLigneFactRecev) {
                    if (Integer.parseInt(lfr.noLigneFact) != ligneFactPmt.no || ligneFactPmt.mnt == null || ligneFactPmt.mnt.doubleValue() < 0.02 || !(ligneFactPmt.mnt.subtract(lfr.mntPrel).doubleValue() > 0.04)) continue;
                    ligneFactPmt.hasMntDiff = Boolean.TRUE;
                    break;
                }
            }
        }
    }

    protected void setMsgFromRef(StringBuilder sbDatEta, Et_det etDet) {
        int refSeq = etDet.getNoSeq();
        List refEtDet = BaseEt_detDAO.getInstance().findFiltered(new String[]{"dt_mddte", "dtType", "noSeq", "dt_datrec"}, new Object[]{etDet.getDt_mddte(), new Integer(21), new Integer(++refSeq), "00000000"});
        while (!refEtDet.isEmpty()) {
            for (Et_det etdet : refEtDet) {
                sbDatEta.append("<span style='white-space: nowrap !important;display: inline-block !important;'><label>R\u00e9f. no RQ:</label>" + etdet.getNoRfp());
                if (etDet.getNoLigne() != null) {
                    sbDatEta.append("<label>Ligne:</label>" + etdet.getNoLigne());
                }
                if (etDet.getDt_acte() != null) {
                    sbDatEta.append("<label>Code fact.:</label>" + etdet.getDt_acte());
                }
                sbDatEta.append("</span>");
            }
            refEtDet = BaseEt_detDAO.getInstance().findFiltered(new String[]{"dt_mddte", "dtType", "noSeq", "dt_datrec"}, new Object[]{etDet.getDt_mddte(), new Integer(21), new Integer(++refSeq), "00000000"});
        }
    }

    protected void setErrMsgFromCodExplDetEta(StringBuilder sbDatEta, StringBuilder sbCodes, CProfessionnal.Entente entente, String[] codeExpls, String dateEta) {
        MsgExpl dx = new MsgExpl();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.MSG_EXPL, new Integer(entente.value), null, codeExpls, null, null, dateEta, null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        sbDatEta.append("<table class='table'><thead><tr><th>Code</th><th>Description</th></tr></thead><tbody>");
        try {
            List<String> lstMessage = dx.getDataByCriteria(criteria, IBaseXQuery.DataType.CODE_DESCR);
            for (String expl : lstMessage) {
                String[] codExpl = expl.split(":");
                sbCodes.append(sbCodes.length() == 0 ? "(" + codExpl[0] : ", " + codExpl[0]);
                sbDatEta.append("<tr><td style='text-align: left;'>" + codExpl[0] + "</td>");
                sbDatEta.append("<td style='text-align: left;" + (codExpl[1].length() < 100 ? "white-space: nowrap;display: inline-block;" : "") + "'>" + codExpl[1] + "</td></tr>");
            }
        }
        catch (IOException | QueryException e) {
            e.printStackTrace();
        }
        sbDatEta.append("</tbody></table>");
    }

    private void setDemModifAnnuToDemPaimt(CDemContainer cDemContainer, CDemPaimt cDemPaimt, CDemForListe cDFL, boolean forPrint) {
        if (ConvertJavaToFromArray.ArrDemType.DEM_MODIF.getVal() == cDFL.getDemType().intValue() || ConvertJavaToFromArray.ArrDemType.DEM_MODIF_RECEV.getVal() == cDFL.getDemType().intValue()) {
            DemModif demModif = cDFL.getLastDemModif();
            cDemPaimt.demModif = new CDemModif(demModif, cDemContainer, true, forPrint);
            cDemPaimt.lastAcceptedDemModif = null;
            int iLastDemModRecAccepted = cDFL.iLastDemModif;
            int iLastDemModRec = cDFL.iLastDemModif;
            DemModifRecev lastModifRecevAccepted = cDFL.getDemModifRecev(iLastDemModRecAccepted);
            DemModifRecev modifRecev = cDFL.getDemModifRecev(iLastDemModRec);
            BigInteger lastJeton = null;
            if (lastModifRecevAccepted != null && lastModifRecevAccepted.getStaRecev() != 1) {
                lastModifRecevAccepted = null;
                while (iLastDemModRecAccepted > 0) {
                    if ((lastModifRecevAccepted = cDFL.getDemModifRecev(--iLastDemModRecAccepted)) != null && lastModifRecevAccepted.getStaRecev() == 1) break;
                    lastModifRecevAccepted = null;
                }
            }
            if (lastModifRecevAccepted != null && lastModifRecevAccepted.getFactRecev() != null && lastModifRecevAccepted.getFactRecev().getIdFactRamqRecev() != null) {
                lastJeton = lastModifRecevAccepted.getFactRecev().getIdFactRamqRecev().getJetonComm();
            }
            if (--iLastDemModRec > 0 && modifRecev == null) {
                modifRecev = cDFL.getDemModifRecev(--iLastDemModRec);
            }
            if (modifRecev != null) {
                if (cDFL.getStaRecev() == 0) {
                    cDemPaimt.demModif.recev = new CDemModifRecev(modifRecev);
                    cDemPaimt.serv = cDemPaimt.demModif.serv;
                } else if (cDFL.getStaRecev() == 1) {
                    DemModif lastAcceptedDemModif = null;
                    if (lastModifRecevAccepted != null) {
                        lastAcceptedDemModif = cDFL.getDemModif(iLastDemModRecAccepted);
                    }
                    if (lastAcceptedDemModif != null) {
                        cDemPaimt.lastAcceptedDemModif = new CDemModif(lastAcceptedDemModif, cDemContainer, true, forPrint);
                        cDemPaimt.lastAcceptedDemModif.recev = new CDemModifRecev(lastModifRecevAccepted);
                    } else if (ConvertJavaToFromArray.ArrDemType.DEM_MODIF_RECEV.getVal() == cDFL.getDemType().intValue()) {
                        cDFL.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT_RECEV.getVal()));
                        String[] fields = new String[]{"dem_type"};
                        Number[] vals = new Integer[]{new Integer(cDFL.getDemType())};
                        BaseDemForListeDAO.getInstance().saveValue(cDFL.getId(), fields, vals, null);
                        CDemForListe dflToSend = new CDemForListe(cDFL.getTag());
                        dflToSend.setDemType(cDFL.getDemType());
                        CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                        String message3 = new GsonBuilder().create().toJson((Object)to3);
                        HtmlBrowserTools.sendMessageToWebClient((String)cDemContainer.uid, (String)message3);
                    }
                } else if (cDFL.getStaRecev() == 2) {
                    cDemPaimt.demModif.recev = new CDemModifRecev(modifRecev);
                    cDemPaimt.serv = cDemPaimt.demModif.serv;
                }
                if (lastJeton != null) {
                    cDemPaimt.demModif.idFact.jetonComm = lastJeton;
                }
            }
            if (cDemPaimt.lastAcceptedDemModif != null) {
                cDemPaimt.serv = cDemPaimt.lastAcceptedDemModif.serv;
                cDemPaimt.recev = new CDemPaimtRecev();
                CDemPaimtRecev.CFactRecev fr = new CDemPaimtRecev.CFactRecev();
                fr.idFactRamqRecev = cDemPaimt.lastAcceptedDemModif.recev.factRecev.idFactRamqRecev;
                fr.noFactExt = cDemPaimt.lastAcceptedDemModif.recev.noDemExt;
                fr.staRecev = cDemPaimt.lastAcceptedDemModif.recev.staRecev;
                fr.listeMsgExplRecev = cDemPaimt.lastAcceptedDemModif.recev.factRecev.listeMsgExplRecev;
                fr.listeLigneFactRecev = cDemPaimt.lastAcceptedDemModif.recev.factRecev.listeLigneFactRecev;
                cDemPaimt.recev.listeFactRecev.add(fr);
                cDemPaimt.recev.listeMsgExplRecev = cDemPaimt.lastAcceptedDemModif.recev.listeMsgExplRecev;
                cDemPaimt.recev.noDemExt = cDemPaimt.lastAcceptedDemModif.recev.noDemExt;
                cDemPaimt.recev.staRecev = cDemPaimt.lastAcceptedDemModif.recev.staRecev;
                cDemPaimt.depl = cDemPaimt.lastAcceptedDemModif.depl;
            }
            cDemPaimt.demModif.serv = null;
            cDemPaimt.demModif.depl = null;
        } else if (ConvertJavaToFromArray.ArrDemType.DEM_ANNU.getVal() == cDFL.getDemType().intValue() || ConvertJavaToFromArray.ArrDemType.DEM_ANNU_RECEV.getVal() == cDFL.getDemType().intValue()) {
            DemAnnu demAnnu = cDFL.getLastDemAnnu();
            cDemPaimt.demAnnu = new CDemAnnu(demAnnu, cDemContainer, true, forPrint);
            DemAnnuRecev AnnuRecev = cDFL.getDemAnnuRecev(cDFL.iLastDemAnnu);
            if (AnnuRecev != null) {
                cDemPaimt.demAnnu.recev = new CDemAnnuRecev(AnnuRecev);
            }
        }
    }

    public Status updateFichiersVersions(CDemContainer cDemContainer, String uid) {
        return DownloadValideur.getInstance().doUpdate(uid);
    }

    protected boolean checkNewValid() {
        return DownloadValideur.getInstance().checkIfNewValid();
    }

    private Object deleteEtabIdInscrData(CUidObject cUidObject, CDemContainer cDemContainer) {
        Status status = new Status(IStatus.Severity.OK, "load Etabl id inscription...");
        try {
            if (cUidObject.getObject() instanceof String) {
                Calendar ctod;
                Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(LocalDate.class, (Object)new GsonAdapters.LocalDateTypeAdapter()).registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).create();
                CGmf g = (CGmf)gson.fromJson((String)cUidObject.getObject(), CGmf.class);
                Gmf gmf = new Gmf();
                gmf.setId(g.id);
                gmf.tag = g.tag;
                gmf.setNoEtablGMF(g.noEtabl);
                gmf.setNoGMF(g.noGmf);
                gmf.setIdUserGMF(g.idUser);
                gmf.setIdMachineGMF(g.idMach);
                gmf.setPasswordMachineGMF(g.pswd);
                if (StringUtils.isNotEmpty((String)g.dateModPswd) && (ctod = DateUtil.ctod((String)g.dateModPswd)) != null) {
                    gmf.setDateModifPasswordGMF(new Long(ctod.getTimeInMillis()));
                }
                GmfPlugin.getDefault().deleteGmf(gmf);
            }
        }
        catch (Exception e) {
            String cause = this.getExceptionMessage(e);
            return new Status(IStatus.Severity.ERROR, "Erreur dans loadGMF: " + cause);
        }
        return status;
    }

    private Object updatePasswordB2b(CUidObject cUidObject, CDemContainer cDemContainer) {
        Status status = new Status(IStatus.Severity.OK, "updatePasswordB2b...");
        try {
            if (cUidObject.getObject() instanceof String) {
                Calendar ctod;
                Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(LocalDate.class, (Object)new GsonAdapters.LocalDateTypeAdapter()).registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).create();
                CGmf g = (CGmf)gson.fromJson((String)cUidObject.getObject(), CGmf.class);
                Gmf gmf = new Gmf();
                gmf.setId(g.id);
                gmf.tag = g.tag;
                gmf.setNoEtablGMF(g.noEtabl);
                gmf.setNoGMF(g.noGmf);
                gmf.setIdUserGMF(g.idUser);
                gmf.setIdMachineGMF(g.idMach);
                gmf.setPasswordMachineGMF(g.pswd);
                if (StringUtils.isNotEmpty((String)g.dateModPswd) && (ctod = DateUtil.ctod((String)g.dateModPswd)) != null) {
                    gmf.setDateModifPasswordGMF(new Long(ctod.getTimeInMillis()));
                }
                InscriptionB2bMethods inscr = new InscriptionB2bMethods(gmf, cUidObject.getUid(), this);
                status = inscr.updatePasswordB2b();
            }
        }
        catch (Exception e) {
            String cause = this.getExceptionMessage(e);
            return new Status(IStatus.Severity.ERROR, "Erreur dans updatePasswordB2b: " + cause);
        }
        return status;
    }

    private Object saveEtabIdInscrData(CUidObject cUidObject, CDemContainer cDemContainer) {
        Status status = new Status(IStatus.Severity.OK, "load Etabl id inscription...");
        try {
            if (cUidObject.getObject() instanceof String) {
                Calendar ctod;
                Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(LocalDate.class, (Object)new GsonAdapters.LocalDateTypeAdapter()).registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).create();
                CGmf g = (CGmf)gson.fromJson((String)cUidObject.getObject(), CGmf.class);
                Gmf gmf = new Gmf();
                gmf.setId(g.id);
                gmf.tag = g.tag;
                gmf.setNoEtablGMF(g.noEtabl);
                gmf.setNoGMF(g.noGmf);
                gmf.setIdUserGMF(g.idUser);
                gmf.setIdMachineGMF(g.idMach);
                gmf.setPasswordMachineGMF(g.pswd);
                if (StringUtils.isNotEmpty((String)g.dateModPswd) && (ctod = DateUtil.ctod((String)g.dateModPswd)) != null) {
                    gmf.setDateModifPasswordGMF(new Long(ctod.getTimeInMillis()));
                }
                GmfPlugin.getDefault().saveGmf(gmf);
            }
        }
        catch (Exception e) {
            String cause = this.getExceptionMessage(e);
            return new Status(IStatus.Severity.ERROR, "Erreur dans loadGMF: " + cause);
        }
        return status;
    }

    private Object getEtabIdInscrData(CDemContainer cDemContainer, String uid) {
        Status status = new Status(IStatus.Severity.OK, "load Etabl id inscription...");
        try {
            List list = GmfPlugin.getDefault().reloadGmf();
            ArrayList<CGmf> lstGmf = new ArrayList<CGmf>(list.size());
            for (Gmf gmf : list) {
                CGmf g = new CGmf();
                g.id = gmf.getId();
                g.tag = gmf.getId();
                g.idUser = gmf.getIdUserGMF();
                g.idMach = gmf.getIdMachineGMF();
                g.noGmf = gmf.getNoGMF();
                g.noEtabl = gmf.getNoEtablGMF();
                g.pswd = gmf.getPasswordMachineGMF();
                g.dateModPswd = gmf.getDateModifPasswordGMF() == null ? "" : LocalDate.fromTimeInMillis((long)gmf.getDateModifPasswordGMF()).formatHyphen();
                lstGmf.add(g);
            }
            status.setData(lstGmf);
        }
        catch (Exception e) {
            String cause = this.getExceptionMessage(e);
            return new Status(IStatus.Severity.ERROR, "Erreur dans loadGMF: " + cause);
        }
        return status;
    }

    private Object getNewEtabIdInscr(CDemContainer cDemContainer, String uid) {
        Status status = new Status(IStatus.Severity.OK, "new Etabl id inscription...");
        try {
            Gmf gmf = new Gmf();
            BaseGmfDAO.getInstance().save(gmf);
            CGmf g = new CGmf();
            g.id = gmf.getId();
            g.tag = gmf.getId();
            status.setData((Serializable)g);
        }
        catch (Exception e) {
            String cause = this.getExceptionMessage(e);
            return new Status(IStatus.Severity.ERROR, "Erreur dans getNewEtabIdInscr: " + cause);
        }
        return status;
    }

    private Object getB2bData(CDemContainer cDemContainer, String uid) {
        if (cDemContainer.getCurrentPatient() != null && cDemContainer.getCurrentPatient().getId() != null) {
            B2bSituSant b2bSitu;
            CPatient currPatient = cDemContainer.getCurrentPatient();
            Patient patient = BasePatientDAO.getInstance().get(currPatient.getId());
            PatientData ptData = new PatientData(cDemContainer);
            if (patient.getResident() != null && patient.getResident().getId() != null) {
                ptData.resident = CObjectUtils.getCProfFromIProf((IProfessionnal)patient.getResident());
            }
            String dateDef = null;
            dateDef = cDemContainer.getDateDefaut() != null ? cDemContainer.getDateDefaut().formatHyphen() : LocalDate.today().formatHyphen();
            (ptData.b2bPatientData = new B2bPatientData()).ddi = patient.getDateInscription() == null ? dateDef : DateUtil.dtoc((long)patient.getDateInscription());
            ptData.b2bPatientData.dfi = patient.getDateFinInscription() == null ? null : DateUtil.dtoc((Calendar)patient.getDateFinInscriptionCalendar());
            ptData.b2bPatientData.fld = patient.getFollowUpLocationDate() == null ? dateDef : DateUtil.dtoc((long)patient.getFollowUpLocationDate());
            CLieu lieu = null;
            String lieuSuiv = patient.getLieuSuivi();
            if (StringUtils.isNotEmpty((String)lieuSuiv)) {
                String[] l = lieuSuiv.split("~");
                if ("C".equals(l[0])) {
                    if (l.length == 2 && StringUtils.isNotEmpty((String)l[1])) {
                        lieu = new CLieu(true);
                        lieu.typLocEtab = l[0];
                        lieu.etab = new CEtab(l[1], "0");
                        lieu.etab.codPreciSectActiv = new Integer(0);
                        lieu.etab.valEtab = null;
                        lieu.etab.valSect = null;
                        lieu.local = null;
                    }
                } else if ("N".equals(l[0])) {
                    if (l.length == 3 && StringUtils.isNotEmpty((String)l[2])) {
                        lieu = new CLieu(true);
                        lieu.typLocEtab = l[0];
                        lieu.local = new CLocal(l[2], null, l[1], null);
                        lieu.etab = null;
                    }
                } else {
                    Integer codEtab = null;
                    try {
                        codEtab = Integer.getInteger(lieuSuiv);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (codEtab != null) {
                        if (codEtab >= 60000 && codEtab < 70000) {
                            lieu = new CLieu(true);
                            lieu.local = new CLocal(lieuSuiv, null, "3", null);
                            lieu.typLocEtab = "N";
                            lieu.etab = null;
                        } else {
                            lieu = new CLieu(true);
                            lieu.etab.codPreciSectActiv = new Integer(0);
                            lieu.etab.valEtab = CObjectUtils.getEtab(lieuSuiv);
                            lieu.typLocEtab = "C";
                            lieu.etab.valSect = null;
                            lieu.local = null;
                        }
                    }
                }
            }
            if (lieu == null) {
                lieu = cDemContainer.getCurrentLieu(cDemContainer.getCurrentProf());
                String ll = "";
                if ("C".equals(lieu.typLocEtab)) {
                    ll = "C~" + lieu.etab.noSelectedEtab;
                } else if ("N".equals(lieu.typLocEtab) && lieu.local.typIdLieuGeo.equals("3") && lieu.local != null && lieu.local.valCodLocal != null) {
                    ll = "N~3~" + lieu.local.valCodLocal.getCodLocal();
                }
                patient.setLieuSuivi(ll);
                BasePatientDAO.getInstance().update(patient);
            }
            ptData.b2bPatientData.setLieuSuiv(lieu);
            if (patient.getPatientRepresentant() != null && patient.getPatientRepresentant().getId() != null) {
                Patient ptRep = patient.getPatientRepresentant();
                CPatient p = new CPatient();
                p.setHealthInsuranceNumber(ptRep.getHealthInsuranceNumber());
                p.setPatientRecordNumber(ptRep.getPatientRecordNumber());
                p.setFirstName(ptRep.getFirstName());
                p.setLastName(ptRep.getLastName());
                if (ptRep.getBirthDate() != null) {
                    p.bds = LocalDate.fromCalendar((Calendar)ptRep.getBirthDate()).formatHyphen();
                }
                p.setGender(ptRep.getGender());
                p.setId(ptRep.getId());
                ptData.representant = p;
                ptData.representantType = patient.getPatientRepresentantType();
            }
            ptData.b2bPatientData.endReason = patient.getCodeRaisonStatut() == null ? new Integer(0) : patient.getCodeRaisonStatut();
            ptData.b2bPatientData.status = patient.getIsInscritGMF() == null ? new Integer(0) : patient.getIsInscritGMF();
            Integer n = ptData.b2bPatientData.category = patient.getCategory() == null ? new Integer(0) : new Integer(patient.getCategory().getValue());
            if (patient.getDisabilityCode1() != null && !"00000".equals(patient.getDisabilityCode1().getCode())) {
                b2bSitu = new B2bSituSant();
                b2bSitu.c = patient.getDisabilityCode1().getCode2chifres();
                if (patient.getDisabilityDate() != null) {
                    b2bSitu.dd = DateUtil.dtoc((Calendar)patient.getDisabilityDate());
                }
                ptData.b2bPatientData.situSant.add(b2bSitu);
            } else {
                b2bSitu = new B2bSituSant();
                b2bSitu.c = "00";
                ptData.b2bPatientData.situSant.add(b2bSitu);
            }
            if (patient.getDisabilityCode2() != null && !"00000".equals(patient.getDisabilityCode2().getCode())) {
                b2bSitu = new B2bSituSant();
                b2bSitu.c = patient.getDisabilityCode2().getCode2chifres();
                if (patient.getDisabilityDate2() != null) {
                    b2bSitu.dd = DateUtil.dtoc((long)patient.getDisabilityDate2());
                }
                ptData.b2bPatientData.situSant.add(b2bSitu);
            } else {
                b2bSitu = new B2bSituSant();
                b2bSitu.c = "00";
                ptData.b2bPatientData.situSant.add(b2bSitu);
            }
            if (patient.getDisabilityCode3() != null && !"00000".equals(patient.getDisabilityCode3().getCode())) {
                b2bSitu = new B2bSituSant();
                b2bSitu.c = patient.getDisabilityCode3().getCode2chifres();
                if (patient.getDisabilityDate3() != null) {
                    b2bSitu.dd = DateUtil.dtoc((long)patient.getDisabilityDate3());
                }
                ptData.b2bPatientData.situSant.add(b2bSitu);
            } else {
                b2bSitu = new B2bSituSant();
                b2bSitu.c = "00";
                ptData.b2bPatientData.situSant.add(b2bSitu);
            }
            currPatient.setPtData(ptData);
            return ptData;
        }
        return new Integer(1);
    }

    private Object transmettreInscription(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.transmettreInscription(false, ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans transmettreInscription: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object cesserInscription(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.cesserInscription(ptd.b2bPatientData.questions, StatusReasonCode.fromCode((int)ptd.b2bPatientData.endReason), Calendar.getInstance());
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans cesserInscription: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object supprimerInscription(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.supprimerInscription(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans supprimerInscription: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object changeDate(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.changeDate(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans changeDate: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object sendModVuln(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.sendModVuln(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans sendModVuln: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object ajouterLieuSuivi(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.ajouterLieuSuivi(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans ajouterLieuSuivi: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object modifRepres(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.modifierRepres(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans modifRepres: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object corrigerLieuSuivi(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.corrigerLieuSuivi(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans corrigerLieuSuivi: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object modifierResident(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.modifierResident(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans modifierResident: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object supprimerLieuSuivi(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.supprimerLieuSuivi(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans supprimerLieuSuivi: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object supprimerRepres(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[2];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.supprimerRepres(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans supprimerRepres: " + e.getMessage() + (e.getCause() == null ? "" : e.getCause().getMessage())));
        }
        return status;
    }

    private Object supprimerResident(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Object[] objs = new Object[3];
                Status st = this.getPatientDataAndGmfFromUidObject(cUidObject, objs);
                if (!IStatus.Severity.OK.equals((Object)st.getSeverity())) {
                    status.add((IStatus)st);
                    return status;
                }
                if (objs[1] != null && objs[1] instanceof Gmf) {
                    PatientData ptd = (PatientData)objs[0];
                    Gmf gmf = (Gmf)objs[1];
                    InscriptionB2bMethods inscr = new InscriptionB2bMethods(ptd, gmf, cUidObject.getUid(), this);
                    status = inscr.supprimerResident(ptd.b2bPatientData.questions);
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu n'est pas pr\u00e9sent dans la liste des identifiants d'inscription."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans supprimerResident: " + InscriptionB2bMethods.getStringFromException(e)));
        }
        return status;
    }

    private Object getB2bInscr(CUidObject cUidObject, CDemContainer cDemContainer) {
        MultiStatus status = new MultiStatus();
        try {
            if (cUidObject.getObject() instanceof String) {
                Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(LocalDate.class, (Object)new GsonAdapters.LocalDateTypeAdapter()).registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).create();
                B2bGetInscr getInscr = (B2bGetInscr)gson.fromJson((String)cUidObject.getObject(), B2bGetInscr.class);
                if (StringUtils.isNotEmpty((String)getInscr.noEtab) && !getInscr.getProfs().isEmpty()) {
                    Gmf gmf = GmfPlugin.getDefault().getGmf(false, getInscr.noEtab);
                    if (gmf != null) {
                        InscriptionB2bMethods inscr = new InscriptionB2bMethods(gmf, cUidObject.getUid(), this);
                        status = inscr.getInscription(getInscr.getProfs());
                    } else {
                        status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le num\u00e9ro d'\u00e9tablissement <" + getInscr.noEtab + "> n'est pas dans la liste des identifiants d'inscription."));
                    }
                } else {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "Absencew du noEtab ou liste de prof. est vide."));
                }
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "L'objet n'est pas une cha\u00eene de caract\u00e8re..."));
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans getB2bInscr: " + InscriptionB2bMethods.getStringFromException(e)));
        }
        return status;
    }

    private Object searchFichInscrClient(Map<String, String> params, CDemContainer cDemContainer) {
        String k = params.get("k").toLowerCase();
        String[] searchString = k != null ? k.trim().split("[ ,/-]") : null;
        File dir = new File(fmedxHomeInscrClient);
        String[] files = new String[]{};
        if (dir.exists() && dir.isDirectory() && searchString != null) {
            FilenameFilter fnf = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lowercaseName = name.toLowerCase();
                    Matcher matcher = Pattern.compile("(ic)([0-9]{5})(-)([0-9]{0,12})(.json)").matcher(lowercaseName);
                    boolean foundIt = matcher.find();
                    if (foundIt) {
                        String[] stringArray = searchString;
                        int n = searchString.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string = stringArray[n2];
                            if (".".equals(string)) {
                                return true;
                            }
                            if (!lowercaseName.contains(string)) {
                                return false;
                            }
                            ++n2;
                        }
                    }
                    return foundIt;
                }
            };
            files = dir.list(fnf);
        }
        if (files.length > 0) {
            ArrayList<String> fileDates = new ArrayList<String>(files.length);
            int i = 0;
            while (i < files.length) {
                fileDates.add(files[i].substring(2, files[i].indexOf(46)));
                ++i;
            }
            Collections.sort(fileDates, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            files = new String[fileDates.size()];
            files = fileDates.toArray(files);
        }
        return files;
    }

    private Object getFichierInscrClient(Map<String, String> params, CDemContainer cDemContainer, Object res) {
        String code = params.get("c");
        if (StringUtils.isNotEmpty((String)code)) {
            File dir = new File(fmedxHomeInscrClient);
            String[] files = new String[]{};
            if (dir.exists() && dir.isDirectory()) {
                FilenameFilter fnf = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String lowercaseName = name.toLowerCase();
                        Matcher matcher = Pattern.compile("(ic" + code + ")(.json)").matcher(lowercaseName);
                        boolean foundIt = matcher.find();
                        return foundIt;
                    }
                };
                files = dir.list(fnf);
            }
            if (files.length == 1) {
                Status s;
                try {
                    String fileAsString = FileUtil.readFileAsString((File)new File(String.valueOf(fmedxHomeInscrClient) + files[0]));
                    s = new Status(IStatus.Severity.OK);
                    s.setData((Serializable)((Object)fileAsString));
                }
                catch (IOException e) {
                    s = new Status(IStatus.Severity.ERROR, InscriptionB2bMethods.getStringFromException(e));
                }
                res = s;
            }
        }
        return res;
    }

    private Status getPatientDataAndGmfFromUidObject(CUidObject cUidObject, Object[] objs) {
        Status status = null;
        Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(LocalDate.class, (Object)new GsonAdapters.LocalDateTypeAdapter()).registerTypeAdapter(Integer.TYPE, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new GsonAdapters.EmptyStringToNumberTypeAdapter()).create();
        PatientData pt = (PatientData)gson.fromJson((String)cUidObject.getObject(), PatientData.class);
        objs[0] = pt;
        if (pt != null && pt.b2bPatientData != null && pt.b2bPatientData.lieuSuiv != null) {
            String noEtabl = null;
            if ("C".equals(pt.b2bPatientData.lieuSuiv.typLocEtab) && pt.b2bPatientData.lieuSuiv.etab != null && StringUtils.isNotEmpty((String)pt.b2bPatientData.lieuSuiv.etab.noSelectedEtab)) {
                noEtabl = pt.b2bPatientData.lieuSuiv.etab.noSelectedEtab;
            } else if ("N".equals(pt.b2bPatientData.lieuSuiv.typLocEtab) && pt.b2bPatientData.lieuSuiv.local != null && pt.b2bPatientData.lieuSuiv.local.valCodLocal != null && StringUtils.isNotEmpty((String)pt.b2bPatientData.lieuSuiv.local.valCodLocal.getCodLocal())) {
                noEtabl = pt.b2bPatientData.lieuSuiv.local.valCodLocal.getCodLocal();
            }
            if (noEtabl != null) {
                Gmf gmf = GmfPlugin.getDefault().getGmf(false, noEtabl);
                if (gmf != null) {
                    objs[1] = gmf;
                    status = new Status(IStatus.Severity.OK);
                } else {
                    status = new Status(IStatus.Severity.WARNING, "Le num\u00e9ro d'\u00e9tablissement <" + noEtabl + "> n'est pas dans la liste des identifiants d'inscription.");
                }
            } else {
                status = new Status(IStatus.Severity.WARNING, "Absence du code du lieu");
            }
        } else {
            status = new Status(IStatus.Severity.WARNING, "Absence du lieu");
        }
        return status;
    }

    public void sendDemListe(CDemContainer cDemContainer, String uid, DemListCriteria criteria) {
        List<CDemForListe> demListe = this.getDemListe(criteria);
        cDemContainer.getMapCDemForListe().clear();
        if (demListe.isEmpty() && Boolean.TRUE.equals(criteria.autoAddMissingBill) && criteria.noRfp != null) {
            CDemForListe demForListe = new CDemForListe(null, CDemContainer.getTagInteger(), cDemContainer.getCurrentUser().id, null, null);
            demForListe.setNoRfp(criteria.noRfp);
            CProfessionnal currentProf = cDemContainer.getCurrentProf();
            if (currentProf != null) {
                demForListe.setIdProf(cDemContainer.getCurrentProf().getId());
                demForListe.setIdIntvn(cDemContainer.getCurrentProf().getNoProf());
            }
            demForListe.setManualMode(true);
            demForListe.setReady(true);
            demForListe.setIsDeleted(new Integer(0));
            demForListe.setProgressCommunication(CDemForListe.ProgressComm.NO_INFO.getValue());
            demForListe.setStaRecev(new Integer(1));
            demForListe.setErrMessage(null);
            demForListe.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT_RECEV.getVal()));
            IdFactRamqRecev idfr = new IdFactRamqRecev();
            idfr.setNoFactRamq(BigInteger.valueOf(criteria.noRfp));
            DemPaimtRecev.ListeFactRecev.FactRecev fr = new DemPaimtRecev.ListeFactRecev.FactRecev();
            fr.setIdFactRamqRecev(idfr);
            fr.setStaRecev(1);
            DemPaimtRecev.ListeFactRecev lstFr = new DemPaimtRecev.ListeFactRecev();
            lstFr.getFactRecev().add(fr);
            demForListe.demPaimtRecev = new DemPaimtRecev();
            demForListe.demPaimtRecev.setStaRecev(1);
            demForListe.demPaimtRecev.setListeFactRecev(lstFr);
            String arrayStringDp = ConvertJavaToFromArray.ConvertDemPaimtRecev.toArrayString(demForListe.demPaimtRecev);
            ArrayList<String> demPaimtRecevArr = new ArrayList<String>();
            demPaimtRecevArr.add(arrayStringDp);
            demForListe.getDemForListeAndSave(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT_RECEV, demPaimtRecevArr, null, null);
            demListe.add(demForListe);
        }
        for (CDemForListe cdl : demListe) {
            cDemContainer.getMapCDemForListe().put(cdl.getTag(), cdl);
        }
        CDemForListe[] demLst = new CDemForListe[demListe.size()];
        demLst = demListe.toArray(demLst);
        CTypeObject to2 = new CTypeObject("currDemListeType", demLst);
        String message2 = new GsonBuilder().create().toJson((Object)to2);
        HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message2);
    }

    private List<CDemForListe> getDemListe(DemListCriteria criteria) {
        return this.getAccessor().getDemListe(criteria);
    }

    public IdentSyra getIdentSyra() {
        return this.identSyra;
    }
}

