/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.controller;

import ca.infodata.controls.DateUtil;
import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.dossier.hibernate.base.BaseDemForListeDAO;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.syra.SyraAccessorClient;
import ca.infodata.syra.controller.SyraController;
import ca.infodata.syra.models.CDemAnnuRecev;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CDemForListe;
import ca.infodata.syra.models.CDemModifRecev;
import ca.infodata.syra.models.CDemPaimtRecev;
import ca.infodata.syra.models.CTypeObject;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.infodata.syra.util.ValidRamq;
import ca.qc.gouv.ramq.rfp.DemAnnu;
import ca.qc.gouv.ramq.rfp.DemModif;
import ca.qc.gouv.ramq.rfp.DemModifRecev;
import ca.qc.gouv.ramq.rfp.DemPaimt;
import ca.qc.gouv.ramq.rfp.ObjectFactory;
import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class RunnableSendDP
implements Runnable {
    protected static final String envoiProgOff = "<br><p style='text-align: center'><strong>* * * L'envoi progressif a \u00e9t\u00e9 d\u00e9sactiv\u00e9. * * *</strong></p";
    private boolean stop = true;
    protected final SyraController syraController;

    public RunnableSendDP(SyraController sc) {
        this.syraController = sc;
        SyraGlobalSettings globalSettings = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
        sc.getIdentSyra().syra_userId = globalSettings.get("syra_userId");
        sc.getIdentSyra().syra_idMach = globalSettings.get("syra_idMach");
        sc.getIdentSyra().syra_idMachPswd = globalSettings.get("syra_idMachPswd");
    }

    public void setIdMach(String idm) {
        this.syraController.getIdentSyra().syra_idMach = idm;
    }

    public void setIdMachPswd(String pswd) {
        this.syraController.getIdentSyra().syra_idMachPswd = pswd;
    }

    public final boolean isStop() {
        return this.stop;
    }

    public final void setStop(boolean stop) {
        this.stop = stop;
    }

    public static <T extends Comparable<? super T>> List<T> asReverseSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list, Collections.reverseOrder());
        return list;
    }

    protected void sendBill(String uid, CDemContainer cDemContainer, CDemForListe dfl) {
        String[] fields = new String[6];
        Number[] vals = new Number[6];
        CDemForListe dflToSend = new CDemForListe(dfl.getTag());
        int dt = dfl.getDemType();
        if (dt == ConvertJavaToFromArray.ArrDemType.DEM_PAIMT.getVal()) {
            String mdtString;
            Long mdt;
            dfl.demPaimt = null;
            DemPaimt dp = dfl.getLastDemPaimt();
            dp.setLogclFact(ConvertJavaToFromArray.getLoglFact());
            CDemForListe.ProgressComm prg = CDemForListe.ProgressComm.IN_PROGRESS;
            dfl.setProgressCommunication(prg.getValue());
            dflToSend.setProgressCommunication(prg.getValue());
            CTypeObject to1 = new CTypeObject("sendDemListePrgType", dflToSend);
            String message1 = new GsonBuilder().create().toJson((Object)to1);
            HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message1);
            Status status2 = new Status(IStatus.Severity.OK, "");
            boolean comm_success = false;
            boolean hasException = false;
            try {
                status2 = ValidRamq.getInstance().sendDemPaimt(this.syraController.getIdentSyra().syra_idMach, this.syraController.getIdentSyra().syra_idMachPswd, dfl, dp);
                if (status2.isOK()) {
                    comm_success = true;
                }
            }
            catch (Exception e) {
                hasException = true;
                this.analyse(e, uid, cDemContainer);
                String cause = e.getMessage();
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    cause = String.valueOf(cause) + "<br>Cause: " + e.getCause().getMessage();
                }
                prg = CDemForListe.ProgressComm.DONE_ERROR;
                mdt = new Long(System.currentTimeMillis());
                mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                dfl.setModifiedDateTime(mdtString);
                fields[0] = "progress_comm";
                vals[0] = prg.getValInteger();
                fields[1] = "dem_type";
                vals[1] = new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT.getVal());
                fields[2] = "sta_recev";
                vals[2] = new Integer(0);
                fields[3] = "hon_totaux";
                vals[3] = new BigDecimal(0);
                fields[4] = "modified_date_time";
                vals[4] = mdt;
                BaseDemForListeDAO.getInstance().saveValue(dfl.getId(), fields, vals, cause);
                dflToSend.setProgressCommunication(prg.getValue());
                dflToSend.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT.getVal()));
                dflToSend.setModifiedDateTime(mdtString);
                dflToSend.setErrMessage(cause);
                CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                String message3 = new GsonBuilder().create().toJson((Object)to3);
                HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message3);
            }
            if (!hasException) {
                if (comm_success) {
                    prg = CDemForListe.ProgressComm.DONE_SUCCESS;
                    fields[0] = "progress_comm";
                    vals[0] = prg.getValInteger();
                    fields[1] = "dem_type";
                    vals[1] = new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT_RECEV.getVal());
                    int statRecev = 0;
                    Long noRfp = null;
                    if (status2.getData() != null) {
                        CDemPaimtRecev result = (CDemPaimtRecev)status2.getData();
                        if (result.staRecev == 2) {
                            statRecev = 2;
                        } else if (result.staRecev == 1) {
                            statRecev = 1;
                            for (CDemPaimtRecev.CFactRecev fr : result.listeFactRecev) {
                                if (noRfp == null && fr.idFactRamqRecev != null && fr.idFactRamqRecev.noFactRamq != null) {
                                    noRfp = new Long(fr.idFactRamqRecev.noFactRamq.longValue());
                                }
                                if (fr.staRecev != 2) continue;
                                statRecev |= 2;
                            }
                        }
                        dfl.setStaRecev(new Integer(statRecev));
                    }
                    BigDecimal total = new BigDecimal(0);
                    try {
                        total = SyraAccessorClient.getInstance().archiveDp(dp, dfl, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    dfl.setMntPrel(total);
                    fields[2] = "sta_recev";
                    vals[2] = new Integer(statRecev);
                    fields[3] = "hon_totaux";
                    vals[3] = total;
                    mdt = new Long(System.currentTimeMillis());
                    mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                    dfl.setModifiedDateTime(mdtString);
                    fields[4] = "modified_date_time";
                    vals[4] = mdt;
                    if (noRfp != null) {
                        fields[5] = "no_rfp";
                        vals[5] = noRfp;
                        dfl.setNoRfp(noRfp);
                    }
                    BaseDemForListeDAO.getInstance().saveValue(dfl.getId(), fields, vals, "");
                    dflToSend.setProgressCommunication(prg.getValue());
                    dflToSend.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT_RECEV.getVal()));
                    dflToSend.setStaRecev(new Integer(statRecev));
                    dflToSend.setMntPrel(total);
                    dflToSend.setNoRfp(noRfp);
                    dflToSend.setModifiedDateTime(mdtString);
                    CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                    String message3 = new GsonBuilder().create().toJson((Object)to3);
                    HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message3);
                } else {
                    this.analyse(status2.getException(), uid, cDemContainer);
                    prg = CDemForListe.ProgressComm.DONE_ERROR;
                    fields[0] = "progress_comm";
                    vals[0] = prg.getValInteger();
                    fields[1] = "dem_type";
                    vals[1] = new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT.getVal());
                    fields[2] = "sta_recev";
                    vals[2] = new Integer(0);
                    fields[3] = "hon_totaux";
                    vals[3] = new BigDecimal(0);
                    mdt = new Long(System.currentTimeMillis());
                    mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                    dfl.setModifiedDateTime(mdtString);
                    fields[4] = "modified_date_time";
                    vals[4] = mdt;
                    BaseDemForListeDAO.getInstance().saveValue(dfl.getId(), fields, vals, status2.getMessage());
                    dflToSend.setProgressCommunication(prg.getValue());
                    dflToSend.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_PAIMT.getVal()));
                    dflToSend.setModifiedDateTime(mdtString);
                    dflToSend.setErrMessage(status2.getMessage());
                    CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                    String message3 = new GsonBuilder().create().toJson((Object)to3);
                    HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message3);
                    this.analyseErrMsg(uid, cDemContainer, status2.getMessage());
                }
            }
        } else if (dt == ConvertJavaToFromArray.ArrDemType.DEM_MODIF.getVal()) {
            String mdtString;
            Long mdt;
            DemPaimt lastDemPaimt = dfl.getLastDemPaimt();
            dfl.demModif = null;
            DemModif dp = dfl.getLastDemModif();
            int iLastDemModRec = dfl.iLastDemModif;
            System.out.println("iLastDemModRec=" + iLastDemModRec);
            DemModifRecev modifRecev = null;
            while (iLastDemModRec >= 0) {
                if ((modifRecev = dfl.getDemModifRecev(iLastDemModRec--)) != null && modifRecev.getFactRecev() != null && modifRecev.getFactRecev().getIdFactRamqRecev() != null && modifRecev.getFactRecev().getIdFactRamqRecev().getJetonComm() != null && modifRecev.getFactRecev().getIdFactRamqRecev().getJetonComm().longValue() > 0L) break;
                modifRecev = null;
            }
            if (modifRecev != null && modifRecev.getFactRecev() != null && modifRecev.getFactRecev().getIdFactRamqRecev() != null && modifRecev.getFactRecev().getIdFactRamqRecev().getJetonComm() != null) {
                ObjectFactory of = new ObjectFactory();
                dp.getIdFactRamq().setJetonComm(of.createIdFactRamqJetonComm(modifRecev.getFactRecev().getIdFactRamqRecev().getJetonComm()));
            }
            dp.setLogclFact(ConvertJavaToFromArray.getLoglFact());
            CDemForListe.ProgressComm prg = CDemForListe.ProgressComm.IN_PROGRESS;
            dfl.setProgressCommunication(prg.getValue());
            dflToSend.setProgressCommunication(prg.getValue());
            CTypeObject to1 = new CTypeObject("sendDemListePrgType", dflToSend);
            String message1 = new GsonBuilder().create().toJson((Object)to1);
            HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message1);
            Status status2 = new Status(IStatus.Severity.OK, "");
            boolean comm_success = false;
            boolean hasException = false;
            try {
                status2 = ValidRamq.getInstance().sendDemModi(this.syraController.getIdentSyra().syra_idMach, this.syraController.getIdentSyra().syra_idMachPswd, dfl, dp);
                if (status2.isOK()) {
                    comm_success = true;
                }
            }
            catch (Exception e) {
                hasException = true;
                this.analyse(e, uid, cDemContainer);
                String cause = e.getMessage();
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    cause = String.valueOf(cause) + "<br>Cause: " + e.getCause().getMessage();
                }
                prg = CDemForListe.ProgressComm.DONE_ERROR;
                fields[0] = "progress_comm";
                vals[0] = prg.getValInteger();
                mdt = new Long(System.currentTimeMillis());
                mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                dfl.setModifiedDateTime(mdtString);
                fields[1] = "modified_date_time";
                vals[1] = mdt;
                BaseDemForListeDAO.getInstance().saveValue(dfl.getId(), fields, vals, cause);
                dflToSend.setProgressCommunication(prg.getValue());
                dflToSend.setModifiedDateTime(mdtString);
                dflToSend.setErrMessage(cause);
                CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                String message3 = new GsonBuilder().create().toJson((Object)to3);
                HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message3);
            }
            if (!hasException) {
                if (comm_success) {
                    prg = CDemForListe.ProgressComm.DONE_SUCCESS;
                    fields[0] = "progress_comm";
                    vals[0] = prg.getValInteger();
                    fields[1] = "dem_type";
                    vals[1] = new Integer(ConvertJavaToFromArray.ArrDemType.DEM_MODIF_RECEV.getVal());
                    int statRecev = 0;
                    if (status2.getData() != null) {
                        CDemModifRecev result = (CDemModifRecev)status2.getData();
                        if (result.staRecev == 2) {
                            statRecev = 2;
                        } else if (result.staRecev == 1) {
                            statRecev = 1;
                        }
                        dfl.setStaRecev(new Integer(statRecev));
                    }
                    fields[2] = "sta_recev";
                    vals[2] = new Integer(statRecev);
                    mdt = new Long(System.currentTimeMillis());
                    mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                    dfl.setModifiedDateTime(mdtString);
                    fields[3] = "modified_date_time";
                    vals[3] = mdt;
                    if (statRecev == 1) {
                        BigDecimal total = new BigDecimal(0);
                        try {
                            total = SyraAccessorClient.getInstance().archiveDp(dp, dfl, lastDemPaimt);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        fields[4] = "hon_totaux";
                        vals[4] = total;
                        dfl.setMntPrel(total);
                    }
                    BaseDemForListeDAO.getInstance().saveValue(dfl.getId(), fields, vals, "");
                    dflToSend.setProgressCommunication(prg.getValue());
                    dflToSend.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_MODIF_RECEV.getVal()));
                    dflToSend.setStaRecev(new Integer(statRecev));
                    dflToSend.setMntPrel(dfl.getMntPrel());
                    dflToSend.setModifiedDateTime(mdtString);
                    CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                    String message3 = new GsonBuilder().create().toJson((Object)to3);
                    HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message3);
                } else {
                    this.analyse(status2.getException(), uid, cDemContainer);
                    prg = CDemForListe.ProgressComm.DONE_ERROR;
                    fields[0] = "progress_comm";
                    vals[0] = prg.getValInteger();
                    mdt = new Long(System.currentTimeMillis());
                    mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                    dfl.setModifiedDateTime(mdtString);
                    fields[1] = "modified_date_time";
                    vals[1] = mdt;
                    BaseDemForListeDAO.getInstance().saveValue(dfl.getId(), fields, vals, status2.getMessage());
                    dflToSend.setProgressCommunication(prg.getValue());
                    dflToSend.setModifiedDateTime(mdtString);
                    dflToSend.setErrMessage(status2.getMessage());
                    CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                    String message3 = new GsonBuilder().create().toJson((Object)to3);
                    HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message3);
                    this.analyseErrMsg(uid, cDemContainer, status2.getMessage());
                }
            }
        } else if (dt == ConvertJavaToFromArray.ArrDemType.DEM_ANNU.getVal()) {
            String mdtString;
            Long mdt;
            DemAnnu dem = dfl.getLastDemAnnu();
            dem.setLogclFact(ConvertJavaToFromArray.getLoglFact());
            CDemForListe.ProgressComm prg = CDemForListe.ProgressComm.IN_PROGRESS;
            dfl.setProgressCommunication(prg.getValue());
            dflToSend.setProgressCommunication(prg.getValue());
            CTypeObject to1 = new CTypeObject("sendDemListePrgType", dflToSend);
            String message1 = new GsonBuilder().create().toJson((Object)to1);
            HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message1);
            Status status2 = new Status(IStatus.Severity.OK, "");
            boolean comm_success = false;
            boolean hasException = false;
            try {
                status2 = ValidRamq.getInstance().sendDemAnnu(this.syraController.getIdentSyra().syra_idMach, this.syraController.getIdentSyra().syra_idMachPswd, dfl, dem);
                if (status2.isOK()) {
                    comm_success = true;
                }
            }
            catch (Exception e) {
                hasException = true;
                this.analyse(e, uid, cDemContainer);
                String cause = e.getMessage();
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    cause = String.valueOf(cause) + "<br>Cause: " + e.getCause().getMessage();
                }
                prg = CDemForListe.ProgressComm.DONE_ERROR;
                fields[0] = "progress_comm";
                vals[0] = prg.getValInteger();
                mdt = new Long(System.currentTimeMillis());
                mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                dfl.setModifiedDateTime(mdtString);
                fields[1] = "modified_date_time";
                vals[1] = mdt;
                BaseDemForListeDAO.getInstance().saveValue(dfl.getId(), fields, vals, status2.getMessage());
                dflToSend.setProgressCommunication(prg.getValue());
                dflToSend.setModifiedDateTime(mdtString);
                dflToSend.setErrMessage(cause);
                CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                String message3 = new GsonBuilder().create().toJson((Object)to3);
                HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message3);
            }
            if (!hasException) {
                if (comm_success) {
                    prg = CDemForListe.ProgressComm.DONE_SUCCESS;
                    fields[0] = "progress_comm";
                    vals[0] = prg.getValInteger();
                    fields[1] = "dem_type";
                    vals[1] = new Integer(ConvertJavaToFromArray.ArrDemType.DEM_ANNU_RECEV.getVal());
                    int staRecev = 1;
                    if (status2.getData() != null) {
                        CDemAnnuRecev result = (CDemAnnuRecev)status2.getData();
                        staRecev = result.staRecev;
                        dfl.setStaRecev(new Integer(staRecev));
                    }
                    fields[2] = "sta_recev";
                    vals[2] = new Integer(staRecev);
                    mdt = new Long(System.currentTimeMillis());
                    mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                    dfl.setModifiedDateTime(mdtString);
                    fields[3] = "modified_date_time";
                    vals[3] = mdt;
                    if (staRecev == 1) {
                        BigDecimal total = new BigDecimal(0);
                        try {
                            total = SyraAccessorClient.getInstance().archiveDp(dem, dfl, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        fields[4] = "hon_totaux";
                        vals[4] = total;
                        dfl.setMntPrel(total);
                    }
                    BaseDemForListeDAO.getInstance().saveValue(dfl.getId(), fields, vals, "");
                    dflToSend.setProgressCommunication(prg.getValue());
                    dflToSend.setDemType(new Integer(ConvertJavaToFromArray.ArrDemType.DEM_ANNU_RECEV.getVal()));
                    dflToSend.setStaRecev(new Integer(staRecev));
                    dflToSend.setMntPrel(dfl.getMntPrel());
                    dflToSend.setModifiedDateTime(mdtString);
                    CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                    String message3 = new GsonBuilder().create().toJson((Object)to3);
                    HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message3);
                } else {
                    this.analyse(status2.getException(), uid, cDemContainer);
                    prg = CDemForListe.ProgressComm.DONE_ERROR;
                    fields[0] = "progress_comm";
                    vals[0] = prg.getValInteger();
                    mdt = new Long(System.currentTimeMillis());
                    mdtString = DateUtil.format((Long)mdt, (String)"yyyy-MM-dd HH:mm:ss");
                    dfl.setModifiedDateTime(mdtString);
                    fields[1] = "modified_date_time";
                    vals[1] = mdt;
                    BaseDemForListeDAO.getInstance().saveValue(dfl.getId(), fields, vals, status2.getMessage());
                    dflToSend.setProgressCommunication(prg.getValue());
                    dflToSend.setModifiedDateTime(mdtString);
                    dflToSend.setErrMessage(status2.getMessage());
                    CTypeObject to3 = new CTypeObject("sendDemListePrgType", dflToSend);
                    String message3 = new GsonBuilder().create().toJson((Object)to3);
                    HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message3);
                    this.analyseErrMsg(uid, cDemContainer, status2.getMessage());
                }
            }
        }
    }

    private void analyseErrMsg(String uid, CDemContainer cDemContainer, String msg) {
        if (msg.contains("401:")) {
            this.deactivateAutoSend(uid, cDemContainer);
            String errMsg = "Erreur lors de l'envoi en raison d'un probl\u00e8me d'identification avec le serveur de la RAMQ. Veuillez v\u00e9rifier vos identifiants et leur validit\u00e9 sur le site de la RAMQ, ou appeler la RAMQ pour r\u00e9activer vos identifiants. Voir le guide Syra-Med pour des instructions suppl\u00e9mentaires.<br><p style='text-align: center'><strong>* * * L'envoi progressif a \u00e9t\u00e9 d\u00e9sactiv\u00e9. * * *</strong></p";
            this.sendErrMessage(uid, errMsg);
        } else if (msg.contains("UnknownHostException")) {
            this.deactivateAutoSend(uid, cDemContainer);
            String errMsg = "Erreur lors de l'envoi en raison d'un probl\u00e8me d'acc\u00e8s au serveur de la RAMQ (v\u00e9rifiez votre lien Internet).<br><p style='text-align: center'><strong>* * * L'envoi progressif a \u00e9t\u00e9 d\u00e9sactiv\u00e9. * * *</strong></p";
            this.sendErrMessage(uid, errMsg);
        } else if (msg.contains("indisponible") || msg.contains("maintenance") || msg.contains("SocketTimeoutException")) {
            this.deactivateAutoSend(uid, cDemContainer);
            String errMsg = "Erreur lors de l'envoi: serveur de la RAMQ indisponible ou en maintenance.<br><p style='text-align: center'><strong>* * * L'envoi progressif a \u00e9t\u00e9 d\u00e9sactiv\u00e9. * * *</strong></p";
            this.sendErrMessage(uid, errMsg);
        } else if (msg.contains("Une erreur impr")) {
            this.deactivateAutoSend(uid, cDemContainer);
            String errMsg = "Erreur lors de l'envoi au serveur de la RAMQ: " + msg + envoiProgOff;
            this.sendErrMessage(uid, errMsg);
        } else {
            this.sendErrMessage(uid, msg);
        }
    }

    protected void sendErrMessage(String uid, String errMsg) {
        Status status2 = new Status(IStatus.Severity.ERROR, errMsg);
        CTypeObject to2 = new CTypeObject("sendErreurMessageType", status2);
        String message2 = new GsonBuilder().create().toJson((Object)to2);
        HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message2);
    }

    protected void deactivateAutoSend(String uid, CDemContainer cDemContainer) {
        cDemContainer.getSyraSettings(ConnectionFactory.connectionLabel).setAutoSend(Boolean.FALSE);
        Status status2 = new Status(IStatus.Severity.ERROR, "set autosend off");
        CTypeObject to1 = new CTypeObject("sendAutoSendOffType", status2);
        String message1 = new GsonBuilder().create().toJson((Object)to1);
        HtmlBrowserTools.sendMessageToWebClient(null, (String)message1);
    }

    protected void analyse(Throwable e, String uid, CDemContainer cDemContainer) {
        if (e != null && e.getCause() != null && StringUtils.isNotEmpty((CharSequence)e.getCause().getMessage())) {
            String msg = e.getCause().getMessage();
            if (msg.contains("401:")) {
                this.deactivateAutoSend(uid, cDemContainer);
                String errMsg = "Erreur lors de l'envoi en raison d'un probl\u00e8me d'identification avec le serveur de la RAMQ.<br><p style='text-align: center'><strong>* * * L'envoi progressif a \u00e9t\u00e9 d\u00e9sactiv\u00e9. * * *</strong></p";
                this.sendErrMessage(uid, errMsg);
            } else if (msg.contains("UnknownHostException")) {
                this.deactivateAutoSend(uid, cDemContainer);
                String errMsg = "Erreur lors de l'envoi en raison d'un probl\u00e8me d'acc\u00e8s au serveur de la RAMQ (v\u00e9rifiez votre lien Internet).<br><p style='text-align: center'><strong>* * * L'envoi progressif a \u00e9t\u00e9 d\u00e9sactiv\u00e9. * * *</strong></p";
                this.sendErrMessage(uid, errMsg);
            } else if (msg.contains("indisponible") || msg.contains("maintenance") || msg.contains("SocketTimeoutException")) {
                this.deactivateAutoSend(uid, cDemContainer);
                String errMsg = "Erreur lors de l'envoi: serveur de la RAMQ indisponible ou en maintenance.<br><p style='text-align: center'><strong>* * * L'envoi progressif a \u00e9t\u00e9 d\u00e9sactiv\u00e9. * * *</strong></p";
                this.sendErrMessage(uid, errMsg);
            }
        }
    }
}

