/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra;

import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.sonar.BrowserSonar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class SyraEditor
extends EditorPart {
    protected static final Logger logger = Logger.getLogger(SyraEditor.class.getName());
    private Browser browser;
    private BrowserSonar dispatch;

    public BrowserSonar getDispatch() {
        return this.dispatch;
    }

    public void setDispatch(BrowserSonar dispatch) {
        this.dispatch = dispatch;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ((Browser)e.widget).close();
            }
        });
        this.dispatch = new BrowserSonar(this.browser);
        this.browser.setUrl(HtmlBrowserTools.getUrl((String)"/syra/index"));
        parent.setLayout((Layout)new FillLayout());
        new OpenPdfExternFunction(this.browser);
        new OpenHelpFunction(this.browser);
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    protected class OpenHelpFunction
    extends BrowserFunction {
        OpenHelpFunction(Browser browser) {
            super(browser, "openHelp");
        }

        public Object function(Object[] arguments) {
            String str = null;
            try {
                str = (String)arguments[0];
                Program.launch((String)str, (String)str);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to open external help: " + str, e);
            }
            return null;
        }
    }

    protected class OpenPdfExternFunction
    extends BrowserFunction {
        OpenPdfExternFunction(Browser browser) {
            super(browser, "openPdfExternSurEncap");
        }

        public Object function(Object[] arguments) {
            block7: {
                String hId = "report" + System.currentTimeMillis();
                try {
                    Object[] pict = (Object[])arguments[0];
                    if (pict.length <= 30) break block7;
                    byte[] p = new byte[4];
                    int i = 0;
                    while (i < 4) {
                        p[i] = (byte)((Double)pict[i]).intValue();
                        ++i;
                    }
                    String pdf = new String(p);
                    if (!pdf.startsWith("%PDF")) break block7;
                    byte[] picture = new byte[pict.length];
                    int i2 = 0;
                    while (i2 < pict.length) {
                        picture[i2] = (byte)((Double)pict[i2]).intValue();
                        ++i2;
                    }
                    String pdfFileName = String.valueOf(LibPlugin.getFMEDX_HOME()) + hId + ".pdf";
                    File pdfFile = new File(pdfFileName);
                    if (!pdfFile.exists()) {
                        try {
                            FileOutputStream fos = new FileOutputStream(pdfFile);
                            fos.write(picture);
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    Program.launch((String)pdfFileName);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to open external pdf", e);
                }
            }
            return null;
        }
    }
}

