var dirty = false;
var loadedInformation = {eformLoadedFlag: false, metaSaved: [], autoFill: [], saved: []};
document.onkeyup = setDirty;
document.onmousedown = setDirty;
var readOnly = false;
var onReadOnly = [];


function setLoaded(metaInfo, autoInfo, alreadyInfo) {
//	alert(metaInfo);
//	alert(autoInfo);
//	alert(alreadyInfo);
	if (typeof (JSON) != 'undefined') {
		var arr = new Array();
		try {
			var list = $.parseJSON(metaInfo);
			if (list != null && (typeof(list) == typeof([]) || typeof(list) == typeof(arr)) ){
				loadedInformation.metaSaved = list;
			}
		} catch(e){ alert("A: "+e.message)}
		try {
			var list = $.parseJSON(autoInfo);
			if (list != null && (typeof(list) == typeof([]) || typeof(list) == typeof(arr)) ){
				loadedInformation.autoFill = list;
			}
		} catch(e){ alert("B: "+e.message)}
		try {
			var list = $.parseJSON(alreadyInfo);
			if (list != null && (typeof(list) == typeof([]) || typeof(list) == typeof(arr)) ){
				loadedInformation.saved = list;
			}
		} catch(e){ alert("C: "+e.message)}
		
		if (typeof (_onReady) == 'function') {
			_onReady();
		}
	} else {
		setTimeout(function() {
			setLoaded(metaInfo, autoInfo, alreadyInfo);
		},500);
	}
}


function setDirty() {
	dirty = true;
}

function getResumeValueInfodataCall() {
	if(typeof(getResumeValue) == typeof(Function)) {
		return getResumeValue();
	} else {
		return "";
	}
}
function refreshGeneratedInputValue() {
	if(typeof(refeshInputValue) == typeof(Function)) {
		refeshInputValue();
	}
}
function listFormInputs() {
	refreshGeneratedInputValue();
	var i = 0;
	var params = [];
	$("form input, form textarea, form select").each(function() {
		if (typeof($(this).attr("id")) !== 'undefined') {
			params[i] = $(this).attr("id");
		} else {
			params[i] = $(this).attr("name");
		}
		i++;

		if ($(this).attr("type") == "checkbox") {
			if ($(this).prop("checked") == "checked")
				params[i] = "true";
			else
				params[i] = "false";
		} else
			params[i] = $(this).val();
		i++;
	});
	return params;
}

function setReadonly(b) {
	readOnly = b;
	var elements = document.forms[0].elements;
	for ( var i = 0; i < document.forms.length; i++) {
		for ( var j = 0; j < document.forms[i].elements.length; j++) {
			var e = document.forms[i].elements[j];
			if (e != null) {
				if (e["type"] == "text" || e["type"] == "textarea") {
					e.readOnly = b;
				} else if (e["type"] == "checkbox" || e["type"] == "radio") {
					e.disabled = b;
				} else if (e["type"] == "button" && e["value"] != "Imprimer" && e["value"] != "Print") {
					e.disabled = b;
				} else if (e["type"] == "reset") {
					e.disabled = b;
				} else if (e["type"] == "submit") {
					e.disabled = b;
				} else if (e["type"] == "select-one") {
					if (b) {
						e.disabled = "disabled";
					} else {
						e.disabled = null;
					}
				}
			}
		}
	}
	
	for (var i = 0; i < onReadOnly.length; i++) {
		setTimeout(onReadOnly[i],10);
	}
}

function setVariables(table) {
	for (var i =0; i < table.length; i++) {
		findAndSet(table[i].key, table[i].value);
	}
}

function findAndSet(key, value) {
	var input = findInput(key);
	if ( input != null) {
		setInput(input, value);
	} 
}

function findInput(key) {
	for (var i = 0; i < document.forms.length; i++) {
		var input = document.forms[i].elements[key];
		if ( typeof input !== 'undefined') {
			return input;
		}
	}
	return null;
}
function log(st) {
	var d = $("<div>");
	$("#log").append(d.text(st));
}
function setInput(input, data) {
	
	input = $(input);
	if (input.attr("type") == "checkbox") {
		if (data == "true")
			input.prop("checked", true);
		else
			input.prop("checked", false);
	} else {
		input.val(data);
	}
}

function setVariable(id, data) {
	if ($("[id='" + id + "']").size() > 0) {
		if ($("[id='" + id + "']").attr("type") == "checkbox") {
			if (data == "true")
				$("[id='" + id + "']").prop("checked", true);
			else
				$("[id='" + id + "']").prop("checked", false);
		} else {
			$("[id='" + id + "']").val(data);
		}
	} else if ($("[name='" + id + "']").size() > 0) {
		if ($("[name='" + id + "']").attr("type") == "checkbox") {
			if (data == "true") {
				$("[name='" + id + "']").prop("checked", true);
			} else {
				$("[name='" + id + "']").prop("checked", false);
			}
		} else {
			$("[name='" + id + "']").val(data);
		}
	}
}


/**
 * 
 * 
 * Classe LinkList
 * 
 * 
 */

function LinkList() {
	this.first = null;
	this.size = 0;
	
	this.currentCell = null;
	this.currentIndex = -1;
	
	this.add = function(data) {
		var cell = new _Cell();
		cell.data = data;
		
		if (this.first == null) {
			this.first = cell;
			this.size = 1;
		} else {
			var actCell = this.first;
			while (actCell.next != null) {
				actCell = actCell.next;
			}
			
			actCell.next = cell;
			this.size++;
		}
	}
	
	this.get = function(index) {
		if (index >= this.size || index < 0) {
			return null;
		}
		
		if ( index < this.currentIndex || this.currentCell == null) {
			this.currentCell = this.first;
			this.currentIndex = 0;
		}
		
		while (this.currentIndex < index) {
			this.currentIndex ++;
			this.currentCell = this.currentCell.next;
		}
		
		return this.currentCell.data;
	}
	
	this.remove = function( index) {
		if (index < this.size && index >= 0) {
			this.currentCell = this.first;
			this.currentIndex = 0;
			
			var cell = null;
			if (index == 0) {
				cell = this.first;
				this.currentCell = this.first.next;
				this.first = this.first.next;
				this.size--;
			} else {
				while (this.currentIndex < index-1) {
					this.currentCell = this.currentCell.next;
					this.currentIndex++;
				}
				
				cell = this.currentCell.next;
				this.currentCell.next = this.currentCell.next.next;
				this.size--;
			}
		
			return cell == null?null: cell.data;
		}
		return null;
	}
	
	this.showInConsole = function() {
		var str = "LinkList:[";
		var cell = this.first;
		while (cell != null) {
			str += cell.data+",";
			cell = cell.next;
		}
		
		str += "]";
		console.info(str);
	}
}

function _Cell() {
	this.next = null;
	this.data = null;
}

$(document).ready(function() {
	$(".search-btn").each( function() {
		makeItSearchButton($(this));
	});
	// singInPlace();
	
/*	$(".date-pick").each( function() {
		makeItDatePicker($(this));
	});*/
});

function makeItDatePicker(element) {
	element.attr("disabled", false);
	element.datepicker();
}

function makeItSearchButton(element) {
	var span = $("<span></span>");
	var span2 = $("<span></span>");
	var div = $("<div></div>");
	div.addClass("btn-search-text");
	span.addClass("ui-icon").addClass("ui-icon-search").addClass("btn-search");
	span2.addClass("btn-search-text");
	element.append(span).append(div).append(span2).addClass("btn-search");
}

function searchProfessionnal(idProfNo, idProfName) {
	searchProf(idProfNo, idProfName);
}
function searchPatientName(idPatNo, idPatName) {
	searchPatient(idPatNo, idPatName);
}


function singInPlace() {
	
	var p = $("<p>");
	var p2 = $("<p>");
	var start = $("<span>");
	start.addClass('print-by').addClass("signPart");
	start.attr("id","INFODATA_SINGPART_PRINT_BY");
	var hour = $("<span>");
	hour.addClass('hour').addClass("signPart");
	hour.attr("id","INFODATA_SINGPART_HOUR");
	var sign = $("<span>");
	sign.addClass('sign').addClass("signPart");
	sign.attr("id","INFODATA_SINGPART_SING");

	var signDiv = $("#INFODATA_SINGPART");
	var isAlreadyPlace = signDiv.size();
	if (isAlreadyPlace == 0){
		signDiv = $("<div>");
		signDiv.attr("id","INFODATA_SINGPART");
	}
	
	var date = new Date();
	hour.text(" - "+date.getFullYear()+"/"+(date.getMonth()+1)+"/"+date.getDate()+" - "+(date.getHours()+1)+":"+date.getMinutes()+":"+date.getSeconds());
	
	start.text(_INFODATA_SINGPART_MSG_PRINT_BY+" ");
	sign.text(_INFODATA_SINGPART_USERNAME);
	p2.text(_INFODATA_SINGPART_MSG_CONFI);
	
	p.append(start).append(sign).append(hour);
	signDiv.append(p).append(p2);

	if (isAlreadyPlace == 0) {
		$("body").append(signDiv);
		singPositionInAbsolute();
	}
}

function singPositionInAbsolute() {
	var maxButPos = 0;
	$(document.body).find("*").each( function()
	{
		if ( $(this).position().top + $(this).height() > maxButPos)
			maxButPos = $(this).position().top + $(this).height();
	});
	$("#INFODATA_SINGPART").css("position","absolute")
							.css("width", "100%")
							.css("top", (maxButPos+10)+"px");	
}


var OfysMetaData = {};

(function(metaDataBuilder) {

	var ALERT_IF_NO_CONSOLE = false;
	var metaDatas = [];
	
	/**
	 * EVERY METADATA MUST HAVE A UNIQUE ID
	 */
	

	metaDataBuilder.buildCustomMeasure = function(id, code, name, value, unit, interval, note, flags) {
		if (!validType.valid(
				[
				 	{	value: id, accept: [validType.STRING], nullable : false	},
				 	{	value: code, accept: [validType.STRING], nullable : false	},
				 	{	value: name, accept: [validType.STRING], nullable : false	},
				 	{	value: value, accept: [validType.STRING, validType.NUMBER], nullable : false	},
				 	{	value: unit, accept: [validType.STRING], nullable : true	},
				 	{	value: interval, accept: [validType.STRING], nullable : true	},
				 	{	value: note, accept: [validType.STRING], nullable : true	},
				 	{	value: flags, accept: [validType.STRING], nullable : true	}
				]
		)) {
			return false;
		}
		
		metaDatas.push(7);
		metaDatas.push(TYPE.CUSTOM_MEASURE);
		metaDatas.push(id);
		metaDatas.push(code);
		metaDatas.push(name);
		metaDatas.push(value);
		metaDatas.push(unit);
		metaDatas.push(interval);
		metaDatas.push(note);
		metaDatas.push(flags);
		
		return true;
	}
	
	metaDataBuilder.buildAllergy = function(id, reaction, note, isSolved, severity, sinceDateL, solveDateL) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: reaction, accept: [validType.STRING], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	},
				 {	value: isSolved, accept: [validType.BOOLEAN], nullable : true	},
				 {	value: severity, accept: [validType.NUMBER], nullable : true	},
				 {	value: sinceDateL, accept: [validType.NUMBER], nullable : true	},
				 {	value: solveDateL, accept: [validType.NUMBER], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(6);
		metaDatas.push(TYPE.ALLERGY);
		metaDatas.push(id);
		metaDatas.push(reaction);
		metaDatas.push(note);
		metaDatas.push(isSolved);
		metaDatas.push(severity);
		metaDatas.push(sinceDateL);
		metaDatas.push(solveDateL);
		
		return true;
	}
	
	metaDataBuilder.buildConslutation = function(id, idProf, note, destination, severity, profSpeciality, items) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: idProf, accept: [validType.NUMBER], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	},
				 {	value: destination, accept: [validType.STRING], nullable : true	},
				 {	value: severity, accept: [validType.NUMBER], nullable : true	},
				 {	value: profSpeciality, accept: [validType.NUMBER], nullable : true	},
				 {	value: items, accept: [validType.STRING], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(6);
		metaDatas.push(TYPE.CONSULTATION);
		metaDatas.push(id);
		metaDatas.push(idProf);
		metaDatas.push(note);
		metaDatas.push(destination);
		metaDatas.push(severity);
		metaDatas.push(profSpeciality);
		metaDatas.push(items); /* VALIDATE WITH REGEX */
		
		return true;
	}
	
	metaDataBuilder.buildDiagnostic = function(id, diagCode, diagCodeType, note, isSolved, severity, sinceDate, solvedDate) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: diagCode, accept: [validType.STRING], nullable : false	},
				 {	value: diagCodeType, accept: [validType.STRING], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	},
				 {	value: isSolved, accept: [validType.BOOLEAN], nullable : true	},
				 {	value: severity, accept: [validType.NUMBER], nullable : true	},
				 {	value: sinceDate, accept: [validType.NUMBER], nullable : true	},
				 {	value: solvedDate, accept: [validType.NUMBER], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(7);
		metaDatas.push(TYPE.DIAGNOSTIC);
		metaDatas.push(id);
		metaDatas.push(diagCode);
		metaDatas.push(diagCodeType);
		metaDatas.push(note);
		metaDatas.push(isSolved);
		metaDatas.push(severity);
		metaDatas.push(sinceDate);
		metaDatas.push(solvedDate);
		
		return true;
	}
	
	metaDataBuilder.buildProblem = function(id, diagCode, diagCodeType, note, isSolved, severity, sinceDate, solvedDate) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: diagCode, accept: [validType.STRING], nullable : false	},
				 {	value: diagCodeType, accept: [validType.STRING], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	},
				 {	value: isSolved, accept: [validType.BOOLEAN], nullable : true	},
				 {	value: severity, accept: [validType.NUMBER], nullable : true	},
				 {	value: sinceDate, accept: [validType.NUMBER], nullable : true	},
				 {	value: solvedDate, accept: [validType.NUMBER], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(7);
		metaDatas.push(TYPE.PROBLEM);
		metaDatas.push(id);
		metaDatas.push(diagCode);
		metaDatas.push(diagCodeType);
		metaDatas.push(note);
		metaDatas.push(isSolved);
		metaDatas.push(severity);
		metaDatas.push(sinceDate);
		metaDatas.push(solvedDate);
		
		return true;
	}
	
	metaDataBuilder.buildImmunization = function(id, name, diagCode, note, vaccDate) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: name, accept: [validType.STRING], nullable : false	},
				 {	value: diagCode, accept: [validType.STRING], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	},
				 {	value: vaccDate, accept: [validType.NUMBER], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(4);
		metaDatas.push(TYPE.IMMUNIZATION);
		metaDatas.push(id);
		metaDatas.push(name);
		metaDatas.push(diagCode);
		metaDatas.push(note);
		metaDatas.push(vaccDate);
		
		return true;
	}
	
	metaDataBuilder.buildIntervention = function(id, diagCode, note, vaccDate) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: diagCode, accept: [validType.STRING], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : false	},
				 {	value: vaccDate, accept: [validType.NUMBER], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(3);
		metaDatas.push(TYPE.INTERVENTION);
		metaDatas.push(id);
		metaDatas.push(diagCode);
		metaDatas.push(note);
		metaDatas.push(vaccDate);
		
		return true;
	}
	
	metaDataBuilder.buildLifeHabit = function(id, type, frequency, note) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: type, accept: [validType.NUMBER], nullable : false	},
				 {	value: frequency, accept: [validType.NUMBER], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(3);
		metaDatas.push(TYPE.LIFE_HABIT);
		metaDatas.push(id);
		metaDatas.push(type);
		metaDatas.push(frequency);
		metaDatas.push(note);
		
		return true;
	}
	
	metaDataBuilder.buildPrevent = function(id, type, note, preventDate, actionType, sugLevel) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: type, accept: [validType.NUMBER], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : false	},
				 {	value: preventDate, accept: [validType.NUMBER], nullable : false	},
				 {	value: actionType, accept: [validType.NUMBER], nullable : false	},
				 {	value: sugLevel, accept: [validType.NUMBER], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(5);
		metaDatas.push(TYPE.PREVENT);
		metaDatas.push(id);
		metaDatas.push(type);
		metaDatas.push(note);
		metaDatas.push(preventDate);
		metaDatas.push(actionType);
		metaDatas.push(sugLevel);
		
		return true;
	}
	
	metaDataBuilder.buildBloodPressure = function(id, diastolic, systolic, pulse, timeVitalSign, note) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: diastolic, accept: [validType.NUMBER], nullable : false	},
				 {	value: systolic, accept: [validType.NUMBER], nullable : false	},
				 {	value: pulse, accept: [validType.NUMBER], nullable : false	},
				 {	value: timeVitalSign, accept: [validType.NUMBER], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(5);
		metaDatas.push(TYPE.BLOOD_PRESSURE);
		metaDatas.push(id);
		metaDatas.push(diastolic);
		metaDatas.push(systolic);
		metaDatas.push(pulse);
		metaDatas.push(timeVitalSign);
		metaDatas.push(note);
		
		return true;
	}
	
	metaDataBuilder.buildBodyTemperature = function(id, bodyTemp, bodyTempType, timeVitalSign, note) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: bodyTemp, accept: [validType.NUMBER], nullable : false	},
				 {	value: bodyTempType, accept: [validType.NUMBER], nullable : false	},
				 {	value: timeVitalSign, accept: [validType.NUMBER], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(4);
		metaDatas.push(TYPE.BODY_TEMPERATURE);
		metaDatas.push(id);
		metaDatas.push(bodyTemp);
		metaDatas.push(bodyTempType);
		metaDatas.push(timeVitalSign);
		metaDatas.push(note);
		
		return true;
	}
	
	metaDataBuilder.buildFrequency = function(id, respiration, timeVitalSign, note) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: respiration, accept: [validType.NUMBER], nullable : false	},
				 {	value: timeVitalSign, accept: [validType.NUMBER], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(3);
		metaDatas.push(TYPE.FREQUENCY);
		metaDatas.push(id);
		metaDatas.push(respiration);
		metaDatas.push(timeVitalSign);
		metaDatas.push(note);
		
		return true;
	}
	
	metaDataBuilder.buildMeasurement = function(id, headCirc, height, waistMeasurement, weight, note, date) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: headCirc, accept: [validType.NUMBER], nullable : false	},
				 {	value: height, accept: [validType.NUMBER], nullable : false	},
				 {	value: waistMeasurement, accept: [validType.NUMBER], nullable : false	},
				 {	value: weight, accept: [validType.NUMBER], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	},
				 {	value: date, accept: [validType.NUMBER], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(6);
		metaDatas.push(TYPE.MEASUREMENT);
		metaDatas.push(id);
		metaDatas.push(headCirc);
		metaDatas.push(height);
		metaDatas.push(waistMeasurement);
		metaDatas.push(weight);
		metaDatas.push(note);
		metaDatas.push(date);
		
		return true;
	}
	
	metaDataBuilder.buildPhysicalExamination = function(id, note) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : false	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(1);
		metaDatas.push(TYPE.PHYSICAL_EXAMINATION);
		metaDatas.push(id);
		metaDatas.push(note);
		
		return true;
	}
	
	metaDataBuilder.buildIntolerance = function(id, reaction, note, isSolved, severity, sinceDate, solvedDate) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: reaction, accept: [validType.STRING], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : true	},
				 {	value: isSolved, accept: [validType.BOOLEAN], nullable : true	},
				 {	value: severity, accept: [validType.NUMBER], nullable : true	},
				 {	value: sinceDate, accept: [validType.NUMBER], nullable : true	},
				 {	value: solvedDate, accept: [validType.NUMBER], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(6);
		metaDatas.push(TYPE.INTOLERANCE);
		metaDatas.push(id);
		metaDatas.push(reaction);
		metaDatas.push(note);
		metaDatas.push(isSolved);
		metaDatas.push(severity);
		metaDatas.push(sinceDate);
		metaDatas.push(solvedDate);
		
		return true;
	}
	
	metaDataBuilder.buildRappel = function(id, note, isResolved, recallDate) {
		if (!validType.valid(
				[
				 {	value: id, accept: [validType.STRING], nullable : false	},
				 {	value: note, accept: [validType.STRING], nullable : false	},
				 {	value: isResolved, accept: [validType.BOOLEAN], nullable : true	},
				 {	value: recallDate, accept: [validType.NUMBER], nullable : true	}
				 ]
		)) {
			return false;
		}
		
		metaDatas.push(3);
		metaDatas.push(TYPE.RAPPEL);
		metaDatas.push(id);
		metaDatas.push(note);
		metaDatas.push(isResolved);
		metaDatas.push(recallDate);
		
		return true;
	}
	

	
	metaDataBuilder.reset = function() {
		metaDatas = [];
	}
	
	
	metaDataBuilder.setAlert = function(mustAlert) {
		ALERT_IF_NO_CONSOLE = mustAlert;
	}
	
	metaDataBuilder.getData = function() {
		return metaDatas;
	}

	var TYPE = {}
//	TYPE.LABO = 0;
	TYPE.CUSTOM_MEASURE = 1;
	TYPE.ALLERGY = 2;
	TYPE.CONSULTATION = 3;
	TYPE.DIAGNOSTIC = 4;
	TYPE.IMMUNIZATION = 5;
	TYPE.INTERVENTION = 6;
	TYPE.LIFE_HABIT = 7;
	TYPE.PREVENT = 8;
	TYPE.BLOOD_PRESSURE = 9;
	TYPE.BODY_TEMPERATURE = 10;
	TYPE.FREQUENCY = 11;
	TYPE.MEASUREMENT = 12;
	TYPE.PHYSICAL_EXAMINATION = 13;
	TYPE.INTOLERANCE = 14;
	TYPE.RAPPEL = 15;
	TYPE.PROBLEM = 16;
	
	var validType = {};
	validType.BOOLEAN = 'boolean';
	validType.STRING = 'string';
	validType.NUMBER = 'number';
	
	validType.valid = function(datas) {
		/*
		 * datas = [
		 * 	{	value: value,
		 * 		accept: [validType, ...],
		 * 		nullable : true|false
		 * 	}, ...
		 * ]
		 */
		var status = new validType.Status();
		
		for (var i = 0; i < datas.length; i++) {
			var data = datas[i];
			var accepted = data.nullable && (typeof(data.value) == 'undefined' || data.value == null);
			
			var j = 0;
			var types = "";
			while (!accepted && j < data.accept.length) {
				if (typeof(data.value) == data.accept[j]) {
					accepted = true;
				} else {
					types += types.length==0?data.accept[j]:", "+data.accept[j];
				}
				j++;
			}
			
			if (!accepted) {
				types = "Type de '"+data.value+"' est "+typeof(data.value)+" et ne fait pas parti de "+types;
				log(types);
				status.add(new validType.Status(types));
			}
		}
		
		return status;
	}
	validType.Status = function(errMsg) {
		this.errMsg = errMsg;
		this.subStatus = [];
		
		this.add = function(status) {
			this.subStatus.push(status);
		}
		
		this.isOkiToProceed = function() {
			if (typeof(this.errMsg) == 'undefined' || this.errMsg == null) {
				for( var i = 0; i < this.subStatus.length; i++) {
					if ( !this.subStatus[i].isOkiToProceed() ) {
						return false;
					}
				}
				return true;
			}
			return false;
		}
	}
	var VT = validType;
	
	function log(msg, e) {
		if (typeof(console) != 'unefined' && console.log) {
			console.log(msg, e);
		} else if (ALERT_IF_NO_CONSOLE) {
			var str = msg+"\n";
			if (e && e.message) {
				str += e.message;
			} else {
				str += e;
			}
			alert(str);
		}
	}
})(OfysMetaData)


function ofys_get_metadata() {
	if (typeof(_getMetaData) == typeof(Function) ) {
		var arr = _getMetaData();
//		alert(typeof(arr));
		if (typeof(arr) == typeof([]) ) {
			return arr;
		}
	}
	
	return null;
}
