/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.dossier.XClientEnvironment;
import ca.infodata.dossier.hibernate.login.GlobalPreference;
import ca.infodata.dossier.lib.FileUtil;
import ca.infodata.ofys.ui.browser.sonar.ComponentLoader;
import ca.infodata.ofys.ui.browser.sonar.IComponent;
import ca.infodata.ofys.ui.browser.sonar.IRenderEngine;
import ca.infodata.ofys.ui.browser.sonar.SimpleRythmDateFormatter;
import ca.infodata.ofys.ui.browser.sonar.SonarTemplateResourceLoader;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rythmengine.RythmEngine;
import org.rythmengine.extension.IFormatter;

public class RythmRenderEngine
implements IRenderEngine {
    private static final Logger logger = Logger.getLogger(RythmRenderEngine.class.getName());
    private String location;
    private RythmEngine engine;
    private SonarTemplateResourceLoader sonarTemplateResourceLoader = new SonarTemplateResourceLoader();

    public RythmRenderEngine() {
        this.init();
    }

    private RythmEngine engine() {
        if (this.engine == null) {
            this.init();
        }
        return this.engine;
    }

    private void init() {
        if (this.location == null || this.location.equals("")) {
            return;
        }
        if (this.engine != null) {
            throw new IllegalStateException("Rythm is already initialized");
        }
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("feature.transform.enabled", true);
        conf.put("home.template.dir", this.location);
        conf.put("resource.loader.impls", (Object)this.sonarTemplateResourceLoader);
        if (GlobalPreference.getClientEnvironnement() == XClientEnvironment.TEST) {
            conf.put("rythm.engine.mode", "dev");
        }
        this.engine = new RythmEngine(conf);
        this.engine.registerFormatter(new IFormatter[]{new SimpleRythmDateFormatter()});
    }

    @Override
    public void setRoot(ComponentLoader cloader) {
        if (cloader.getComponentPath() == null) {
            return;
        }
        this.sonarTemplateResourceLoader.setCloader(cloader);
        this.location = cloader.getComponentPath();
        try {
            URI home = new URI(cloader.getComponentPath());
            if (!this.engine().conf().templateHome().contains(home)) {
                this.engine().conf().templateHome().add(home);
            }
        }
        catch (URISyntaxException e1) {
            logger.log(Level.SEVERE, "Invalide home path", e1);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public String getPartialView(IComponent view) {
        return this.StringToFile(view.getId(), this.getViewPartialContent(view));
    }

    @Override
    public String getView(IComponent view) {
        return this.StringToFile(String.valueOf(view.getId()) + view.getSkinPath().substring(view.getSkinPath().lastIndexOf(46)), this.getViewContent(view));
    }

    @Override
    public String getViewPartialContent(IComponent view) {
        try {
            if (view.getSkin() == null || view.getSkin().isEmpty()) {
                return this.renderViewToString(view.getSkinPath(), view.getData());
            }
            return view.getSkin();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getViewContent(IComponent view) {
        String res = this.getViewPartialContent(view);
        return res;
    }

    @Override
    public String renderViewToString(String viewName, Object data) {
        if (viewName == null || viewName.isEmpty()) {
            throw new IllegalArgumentException("Invalide view path. Cannot evaluate empty path name.");
        }
        String viewContent = "";
        String templatepath = this.getFullName(viewName);
        if (templatepath != null && !templatepath.isEmpty()) {
            try {
                viewContent = this.engine().render(this.getFullName(viewName), new Object[]{data});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return viewContent;
    }

    @Override
    public String parseString(String template, Object data) {
        template = this.engine().renderString(template, new Object[]{data});
        return template;
    }

    private String StringToFile(String fileName, String content) {
        File viewFile = FileUtil.saveToTemp((String)fileName, (String)content);
        return viewFile.getAbsolutePath();
    }

    private String getFullName(String viewName) {
        if (this.location == null || this.location.equals("")) {
            throw new IllegalArgumentException("Invalide file location. The home folder for the file " + viewName + " is not valide.");
        }
        if (viewName == null || viewName.equals("")) {
            throw new NullPointerException("Invalide template file reference.");
        }
        return String.valueOf(this.location) + viewName;
    }

    @Override
    public void dispose() {
        if (this.engine != null) {
            this.clearTemplates(this.engine().conf().tmpDir());
            this.engine().shutdown();
            this.engine = null;
        }
    }

    public boolean deleteFile(File fileToDelete) {
        try {
            return fileToDelete.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void deleteFolderFiles(File folder) {
        try {
            File[] fa;
            if (!folder.isDirectory()) {
                this.deleteFile(folder);
            } else if (!folder.getName().startsWith(".") && (fa = folder.listFiles()) != null) {
                File[] fileArray = folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.deleteFolderFiles(file);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not clear rhythm template files", e);
        }
    }

    public void clearTemplates(File ... paths) {
        File[] fileArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.deleteFolderFiles(file);
            ++n2;
        }
    }

    @Override
    public void stop() {
    }
}

