/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class HtmlBrowser {
    private static ConcurrentHashMap<Number, HtmlBrowser> mapRenderer = new ConcurrentHashMap();
    protected List<File> lstCreatedFiles = new ArrayList<File>();
    protected int browserHeight = -1;

    public static void addToCreatedFiles(File f, Number key) {
        HtmlBrowser browser = HtmlBrowser.getOrCreateHtmlBrowser(key);
        browser.addToCreatedFiles(f);
    }

    public static void disposeCreatedFiles(Integer key) {
        HtmlBrowser.getOrCreateHtmlBrowser(key).disposeCreatedFiles();
    }

    public static HtmlBrowser getOrCreateHtmlBrowser(Number key) {
        HtmlBrowser newValue = new HtmlBrowser();
        HtmlBrowser existingValue = mapRenderer.putIfAbsent(key, newValue);
        if (existingValue == null) {
            return newValue;
        }
        return existingValue;
    }

    public static void remove(Number key) {
        mapRenderer.remove(key);
    }

    public void addToCreatedFiles(File f) {
        if (f != null) {
            this.lstCreatedFiles.add(f);
        }
    }

    public void disposeCreatedFiles() {
        for (File f : this.lstCreatedFiles) {
            if (!f.exists()) continue;
            f.delete();
        }
    }

    public int getBrowserHeight() {
        return this.browserHeight;
    }

    public void setBrowserHeight(int browserHeight) {
        this.browserHeight = browserHeight;
    }
}

