/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.TestConnectionUtility;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ViewICPropsDialog
extends Dialog
implements IShellProvider {
    private Group group;
    private Label nameLabel;
    private Label nameText;
    private Label hostLabel;
    private Label hostText;
    private Label pathLabel;
    private Label pathText;
    private Label portLabel;
    private Label portText;
    private Label urlLabel;
    private Label urlValue;
    private Label enabledLabel;
    private Label enabledValue;
    private Label connectedLabel;
    Point shellSize;
    Point shellLocation;
    private String infoCenterName = "";
    private String selectedName = "";
    private String selectedHost = "";
    private String selectedPort = "";
    private String selectedPath = "";
    private boolean selectedEnabled;
    Color connectedColor;

    public ViewICPropsDialog(Shell parentShell, String infoCenterName) {
        super(parentShell);
        this.infoCenterName = infoCenterName;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createGroup(parent);
        this.createConnectedSection(parent);
        this.buttonBar = this.createButtonBar(parent);
        this.shellSize = this.getInitialSize();
        Button okButton = this.getButton(0);
        okButton.setVisible(true);
        okButton.setSize(this.shellSize.x + 100, this.shellSize.y);
        okButton.setText(Messages.ViewICPropsDialog_6);
        this.setButtonLayoutData(okButton);
        Button cancelButton = this.getButton(1);
        cancelButton.setText(Messages.ViewICPropsDialog_7);
        cancelButton.setSize(this.shellSize.x - 50, this.shellSize.y);
        this.setButtonLayoutData(cancelButton);
        return composite;
    }

    public void initializeBounds() {
        this.shellSize = this.getInitialSize();
        this.shellLocation = this.getInitialLocation(this.shellSize);
        this.getShell().setBounds(this.shellLocation.x, this.shellLocation.y, this.shellSize.x + 180, this.shellSize.y - 40);
        this.getShell().setText(NLS.bind((String)Messages.ViewICPropsDialog_8, (Object)this.infoCenterName));
    }

    private void createGroup(Composite parent) {
        this.group = new Group(parent, 0);
        this.group.setText(Messages.ViewICPropsDialog_9);
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createNameSection((Composite)this.group);
        this.createHostSection((Composite)this.group);
        this.createPathSection((Composite)this.group);
        this.createPortSection((Composite)this.group);
        this.createURLValidateSection((Composite)this.group);
        this.createEnabledSection((Composite)this.group);
    }

    private void createNameSection(Composite parent) {
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText(Messages.ViewICPropsDialog_10);
        this.nameText = new Label(parent, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.setText(this.selectedName);
    }

    private void createHostSection(Composite parent) {
        this.hostLabel = new Label(parent, 0);
        this.hostLabel.setText(Messages.ViewICPropsDialog_11);
        this.hostText = new Label(parent, 2048);
        this.hostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hostText.setText(this.selectedHost);
    }

    private void createPathSection(Composite parent) {
        this.pathLabel = new Label(parent, 0);
        this.pathLabel.setText(Messages.ViewICPropsDialog_12);
        this.pathText = new Label(parent, 2048);
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathText.setText(this.selectedPath);
    }

    private void createPortSection(Composite parent) {
        this.portLabel = new Label(parent, 0);
        this.portLabel.setText(Messages.ViewICPropsDialog_13);
        this.portText = new Label(parent, 0);
        this.portText.setText(this.selectedPort);
    }

    private void createURLValidateSection(Composite parent) {
        this.urlLabel = new Label(parent, 0);
        this.urlLabel.setText("URL: ");
        this.urlValue = new Label(parent, 0);
        if (this.selectedPort.equals("80")) {
            this.urlValue.setText("http://" + this.selectedHost + this.selectedPath);
        } else {
            this.urlValue.setText("http://" + this.selectedHost + ":" + this.selectedPort + this.selectedPath);
        }
    }

    private void createEnabledSection(Composite parent) {
        this.enabledLabel = new Label(parent, 0);
        this.enabledLabel.setText(Messages.ViewICPropsDialog_19);
        this.enabledValue = new Label(parent, 0);
        if (this.selectedEnabled) {
            this.enabledValue.setText(Messages.ViewICPropsDialog_20);
        } else {
            this.enabledValue.setText(Messages.ViewICPropsDialog_21);
        }
    }

    private void createConnectedSection(Composite parent) {
        this.connectedLabel = new Label(parent, 0);
        this.connectedLabel.setText("");
        this.connectedLabel.setVisible(false);
        this.connectedLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void setTextValues(String icName, String host, String port, String path, boolean isEnabled) {
        this.selectedName = icName;
        this.selectedHost = host;
        this.selectedPort = port;
        this.selectedPath = path;
        this.selectedEnabled = isEnabled;
    }

    public void okPressed() {
        boolean isConnection = TestConnectionUtility.testConnection(this.selectedHost, this.selectedPort, this.selectedPath);
        if (isConnection) {
            this.connectedLabel.setText(Messages.ViewICPropsDialog_23);
            Display thisDisplay = this.getShell().getDisplay();
            this.connectedColor = thisDisplay.getSystemColor(6);
            this.connectedLabel.setForeground(this.connectedColor);
        } else {
            this.connectedLabel.setText(Messages.ViewICPropsDialog_24);
            Display thisDisplay = this.getShell().getDisplay();
            this.connectedColor = thisDisplay.getSystemColor(3);
            this.connectedLabel.setForeground(this.connectedColor);
        }
        this.connectedLabel.setVisible(true);
    }

    public void cancelPressed() {
        this.setReturnCode(0);
        if (this.connectedColor != null) {
            this.connectedColor.dispose();
        }
        this.close();
    }
}

