/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.persistence.util;

import org.apache.pdfbox.cos.COSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSObjectKey
implements Comparable<COSObjectKey> {
    private long number;
    private long generation;

    public COSObjectKey(COSObject object) {
        this(object.getObjectNumber().longValue(), object.getGenerationNumber().longValue());
    }

    public COSObjectKey(long num, long gen) {
        this.setNumber(num);
        this.setGeneration(gen);
    }

    public boolean equals(Object obj) {
        return obj instanceof COSObjectKey && ((COSObjectKey)obj).getNumber() == this.getNumber() && ((COSObjectKey)obj).getGeneration() == this.getGeneration();
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getNumber() {
        return this.number;
    }

    public int hashCode() {
        return (int)(this.number + this.generation);
    }

    public void setGeneration(long newGeneration) {
        this.generation = newGeneration;
    }

    public void setNumber(long newNumber) {
        this.number = newNumber;
    }

    public String toString() {
        return "" + this.getNumber() + " " + this.getGeneration() + " R";
    }

    @Override
    public int compareTo(COSObjectKey other) {
        if (this.getNumber() < other.getNumber()) {
            return -1;
        }
        if (this.getNumber() > other.getNumber()) {
            return 1;
        }
        if (this.getGeneration() < other.getGeneration()) {
            return -1;
        }
        if (this.getGeneration() > other.getGeneration()) {
            return 1;
        }
        return 0;
    }
}

