/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config;

import ca.infodata.launcher.util.LogHandler;
import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.AbstractCommand;
import ca.infodata.launcher3.config.Config;
import ca.infodata.launcher3.config.LauncherLogFormatter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LauncherLogger {
    private static final String baseLogPath = "ca.infodata.ofys.launcher.log";
    private static final Logger logger = Logger.getLogger(LauncherLogger.class.getName());
    private static LauncherLogger instance;
    private Logger root = Logger.getLogger("");
    public File logFolder;

    public static LauncherLogger getInstance() {
        if (instance == null) {
            instance = new LauncherLogger();
        }
        return instance;
    }

    private LauncherLogger() {
    }

    public void init() throws Exception {
        File vp;
        String valPath;
        this.root.setLevel(Level.INFO);
        AbstractCommand cmdPath = Config.getInstance().getCommand("-sysout-path");
        File path = null;
        if (cmdPath != null && (valPath = cmdPath.getParameter(0)) != null && Config.isFolderHasRight((vp = new File(valPath)).getParentFile())) {
            path = vp;
        }
        if (path == null) {
            path = File.createTempFile(baseLogPath, ".txt");
        }
        this.logFolder = path.getParentFile();
        LogManager.getLogManager().reset();
        FileHandler fileHandler = new FileHandler(path.getAbsolutePath(), 0, 999, false);
        fileHandler.setLevel(Level.ALL);
        fileHandler.setFormatter(new LauncherLogFormatter());
        this.root.addHandler(fileHandler);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new LauncherLogFormatter());
        this.root.addHandler(consoleHandler);
        this.log(" --> Log path: " + path.getAbsolutePath() + "  <--");
    }

    public void log(String msg) {
        this.log(Level.INFO, msg, null);
    }

    public void log(Level lvl, String msg) {
        this.log(lvl, msg, null);
    }

    public void log(Level lvl, Throwable err) {
        this.log(lvl, null, err);
    }

    public void log(Level lvl, String msg, Throwable err) {
        this.root.log(lvl, msg, err);
    }

    public void flush() {
        this.log(Level.INFO, "FLUSH STREAM ");
        String allLogs = this.concatSysout();
        Logger root = Logger.getLogger("");
        root.setLevel(Level.INFO);
        LogHandler logHandler = new LogHandler("http://www.infodata.ca/");
        logHandler.setLevel(Level.WARNING);
        root.addHandler(logHandler);
        ArrayList<LogRecord> logRecords = new ArrayList<LogRecord>();
        String[] logs = allLogs.split("\n");
        LogConcat cumul = new LogConcat();
        String[] stringArray = logs;
        int n = logs.length;
        int n2 = 0;
        while (n2 < n) {
            String log = stringArray[n2];
            if (log.startsWith("<" + Level.WARNING.getLocalizedName() + ">")) {
                if (cumul.isReadyToFlush()) {
                    logRecords.add(new LogRecord(cumul.level, cumul.log));
                }
                cumul = new LogConcat();
                cumul.level = Level.WARNING;
                cumul.append(log.substring(("<" + cumul.level.getLocalizedName() + ">").length()));
            } else if (log.startsWith("<" + Level.SEVERE.getLocalizedName() + ">")) {
                if (cumul.isReadyToFlush()) {
                    logRecords.add(new LogRecord(cumul.level, cumul.log));
                }
                cumul = new LogConcat();
                cumul.level = Level.SEVERE;
                cumul.append(log.substring(("<" + Level.SEVERE.getLocalizedName() + ">").length()));
            } else if (log.startsWith("<" + Level.INFO.getLocalizedName() + ">")) {
                if (cumul.isReadyToFlush()) {
                    logRecords.add(new LogRecord(cumul.level, cumul.log));
                }
                cumul = new LogConcat();
                cumul.level = Level.INFO;
                cumul.append(log.substring(("<" + Level.INFO.getLocalizedName() + ">").length()));
            } else {
                cumul.append("\n" + log);
            }
            ++n2;
        }
        if (cumul.isReadyToFlush()) {
            logRecords.add(new LogRecord(cumul.level, cumul.log));
        }
        logHandler.setBuffer(logRecords);
        logHandler.flush();
    }

    public String concatSysout() {
        StringBuilder sb = new StringBuilder();
        try {
            File tempFolder = this.logFolder;
            System.out.flush();
            System.out.close();
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }));
            System.setErr(System.out);
            if (tempFolder.exists()) {
                File[] allFiles = tempFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(LauncherLogger.baseLogPath);
                    }
                });
                Arrays.sort(allFiles, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return (int)(o1.lastModified() - o2.lastModified());
                    }
                });
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().startsWith(baseLogPath)) {
                        sb.append(Util.readFile(f));
                        f.deleteOnExit();
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private class LogConcat {
        Level level;
        String log;

        private LogConcat() {
        }

        public void append(String s) {
            this.log = this.log == null ? s : String.valueOf(this.log) + s;
        }

        public boolean isReadyToFlush() {
            return this.level != null && this.log != null && this.log.length() > 0;
        }
    }
}

