/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class LauncherLogFormatter
extends Formatter {
    private static final String SESSION = "!SESSION";
    private static final String MESSAGE = "!MESSAGE";
    private static final String LINE_SEPARATOR = "\n";
    private SimpleDateFormat simpleDateFormat;
    private SimpleFormatter logFormatter = new SimpleFormatter();

    public LauncherLogFormatter() {
        this.simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SS");
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder b = new StringBuilder(2000);
        b.append("<" + record.getLevel().getLocalizedName() + ">");
        if (record.getThrown() != null) {
            b.append(LINE_SEPARATOR);
            b.append(this.formatThrowable(record.getThrown()));
        } else {
            b.append(record.getMessage());
        }
        b.append(LINE_SEPARATOR);
        return b.toString();
    }

    private String formatThrowable(Throwable err) {
        if (err == null) {
            return "";
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            err.printStackTrace(pw);
            pw.close();
            return sw.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String formatParameters(LogRecord record) {
        Object[] parameters = record.getParameters();
        if (parameters != null && parameters.length > 0) {
            StringBuilder b = new StringBuilder(parameters.length * 50);
            Object[] objectArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object p = objectArray[n2];
                try {
                    b.append(String.valueOf(p));
                    b.append(LINE_SEPARATOR);
                }
                catch (Exception e) {
                    b.append("Failed to print parameters");
                    b.append(LINE_SEPARATOR);
                }
                ++n2;
            }
            return b.toString();
        }
        return "";
    }
}

