/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config;

import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.Config;
import ca.infodata.launcher3.config.LauncherLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileDiff {
    private String ajustPath;
    private String subPath;
    private List<FileWrap> files;
    private List<String> mustNotBeDeleted;

    public FileDiff(String ajustPath, String subPath, String[][] filesSubPathMd5Size, List<String> mustNotBeDeleted) {
        this.ajustPath = ajustPath;
        this.subPath = subPath;
        this.files = new ArrayList<FileWrap>();
        this.mustNotBeDeleted = mustNotBeDeleted;
        if (this.mustNotBeDeleted == null) {
            this.mustNotBeDeleted = new ArrayList<String>();
        }
        String[][] stringArray = filesSubPathMd5Size;
        int n = filesSubPathMd5Size.length;
        int n2 = 0;
        while (n2 < n) {
            String[] str = stringArray[n2];
            FileWrap fw = new FileWrap();
            fw.relPath = str[0].replace("\\", "/");
            fw.targetMd5 = str[1];
            fw.targetSize = Long.valueOf(str[2]);
            this.files.add(fw);
            ++n2;
        }
    }

    public void doTheDiff() throws Exception {
        LauncherLogger log = LauncherLogger.getInstance();
        log.log("Do the diff...");
        File localBaseFolder = this.ajustPath == null ? Config.getInstance().installFolder : new File(Config.getInstance().installFolder, this.ajustPath);
        File localBaseSubFolder = this.subPath == null ? localBaseFolder : new File(localBaseFolder, this.subPath);
        List<File> localFiles = Util.listFilesFromDirectoryRecursive(localBaseSubFolder);
        log.log(" Check to the diff of " + localFiles.size() + " files...");
        for (FileWrap fw : this.files) {
            File lf = null;
            int i = 0;
            i = 0;
            while (i < localFiles.size()) {
                String distPath;
                File f = localFiles.get(i);
                String locPath = f.getAbsolutePath().substring(localBaseFolder.getAbsolutePath().length() + 1).replace("\\", "/");
                if (locPath.equals(distPath = fw.relPath)) {
                    lf = f;
                    break;
                }
                ++i;
            }
            log.log("  -Distant file:" + fw.relPath + " / local file: " + lf);
            if (lf != null) {
                fw.localFile = lf;
                String md5 = Util.computeMd5(fw.localFile);
                if (md5.equals(fw.targetMd5)) {
                    fw.status = FileWrapStatus.OKI;
                } else {
                    log.log("   * MD5 dif: " + fw.localFile.getName());
                    fw.status = FileWrapStatus.TO_UPDATE;
                }
                String lo = "   *Removing " + i + ", " + (Object)((Object)fw.status) + ", " + lf.getName() + ". List size " + localFiles.size() + " to ";
                localFiles.remove(i);
                lo = String.valueOf(lo) + localFiles.size();
                log.log(lo);
                continue;
            }
            log.log("   * Missing file: " + fw.relPath);
            fw.status = FileWrapStatus.DOWNLOAD;
            fw.localFile = new File(localBaseFolder, fw.relPath);
        }
        log.log("   -Filter files to delete");
        for (File f : localFiles) {
            boolean mustBeSkipped = false;
            for (String s : this.mustNotBeDeleted) {
                if (f.getName() == null || !f.getName().toLowerCase().startsWith(s.toLowerCase()) && !f.getAbsolutePath().toLowerCase().startsWith(new File(localBaseSubFolder, s).getAbsolutePath().toLowerCase())) continue;
                mustBeSkipped = true;
                break;
            }
            if (!mustBeSkipped) {
                log.log("   * File to delete: " + f);
                FileWrap fw = new FileWrap();
                fw.localFile = f;
                fw.status = FileWrapStatus.TO_DELETED;
                this.files.add(fw);
                continue;
            }
            log.log("   * File skip deleting: " + f);
        }
    }

    public List<FileWrap> getToDeleteFiles() {
        return this.getFileByStatus(FileWrapStatus.TO_DELETED);
    }

    public List<FileWrap> getToUpdateFiles() {
        return this.getFileByStatus(FileWrapStatus.TO_UPDATE);
    }

    public List<FileWrap> getToDownloadFiles() {
        return this.getFileByStatus(FileWrapStatus.DOWNLOAD);
    }

    public List<FileWrap> getOkiFile() {
        return this.getFileByStatus(FileWrapStatus.OKI);
    }

    public List<FileWrap> getFileByStatus(FileWrapStatus status) {
        ArrayList<FileWrap> list = new ArrayList<FileWrap>();
        for (FileWrap fw : this.files) {
            if (!status.equals((Object)fw.status)) continue;
            list.add(fw);
        }
        return list;
    }

    public String toString() {
        return "DiffFile [toDownload=" + this.getToDownloadFiles().size() + ", toUpdate=" + this.getToUpdateFiles().size() + ", toDelete=" + this.getToDeleteFiles().size() + ", oki=" + this.getOkiFile().size() + "]";
    }

    public class FileWrap {
        public String relPath;
        public File localFile;
        public long targetSize;
        public String targetMd5;
        public String localMd5;
        public FileWrapStatus status = FileWrapStatus.NOTCHECKED;
    }

    private static enum FileWrapStatus {
        NOTCHECKED,
        DOWNLOAD,
        TO_UPDATE,
        TO_DELETED,
        OKI;

    }
}

