/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config;

import ca.infodata.launcher.util.SyncProgressMonitor;
import ca.infodata.launcher.util.Unzip;
import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.AbstractCommand;
import ca.infodata.launcher3.config.ConfigFileManager;
import ca.infodata.launcher3.config.FileDiff;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.config.command.BuildBatCommand;
import ca.infodata.launcher3.config.command.BuildProxyCommand;
import ca.infodata.launcher3.config.command.ChangeLanguageCommand;
import ca.infodata.launcher3.config.command.CheckVersionCommand;
import ca.infodata.launcher3.config.command.CheckVersionCommand2;
import ca.infodata.launcher3.config.command.CreateShortCutCommand;
import ca.infodata.launcher3.config.command.FlushBinCommand;
import ca.infodata.launcher3.config.command.HelpCommand;
import ca.infodata.launcher3.config.command.HelpCommand2;
import ca.infodata.launcher3.config.command.KnowInstallCommand;
import ca.infodata.launcher3.config.command.LaunchCommand;
import ca.infodata.launcher3.config.command.NeedNormalStreamCommand;
import ca.infodata.launcher3.config.command.NoFlushCommand;
import ca.infodata.launcher3.config.command.NoShortCutCommand;
import ca.infodata.launcher3.config.command.SkipValidationCommand;
import ca.infodata.launcher3.config.command.UpdateLauncherCommand;
import ca.infodata.launcher3.config.command.UpdateLauncherRetroCommand;
import ca.infodata.launcher3.config.command.WaitCommand;
import ca.infodata.launcher3.downlaod.CancelException;
import ca.infodata.launcher3.downlaod.Download;
import ca.infodata.launcher3.downlaod.DownloadSite;
import ca.infodata.launcher3.downlaod.SiteProvider;
import ca.infodata.launcher3.downlaod.ValidatedDownload;
import ca.infodata.launcher3.exception.NoMoreDownloadProdiderException;
import ca.infodata.launcher3.exception.NotToSendException;
import ca.infodata.launcher3.exception.PopupInformationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class CopyOfConfig {
    public static final String JAR_NAME = "MedoLauncher.jar";
    public static final String JAR_NAME_EXT = "launcher/MedoLauncher.jar";
    public static final String LANG_PROP_KEY = "osgi.nl";
    private static CopyOfConfig instance;
    private static boolean haveBeenInit;
    public static List<AbstractCommand> commandsRegister;
    private List<AbstractCommand> commands = new ArrayList<AbstractCommand>();
    private LauncherLogger logger;
    public Properties medoProperties = new Properties();
    public Properties proxyProperties;
    public File installFolder;
    public SiteProvider medoSiteProvider;
    public SiteProvider launcherSiteProvider;
    public ConfigFileManager configFileManager;
    public FileDiff medoDiff;
    public FileDiff launcherDiff;

    static {
        haveBeenInit = false;
    }

    public static CopyOfConfig getInstance() {
        return instance;
    }

    public static CopyOfConfig init(String[] args) throws Exception {
        if (haveBeenInit) {
            throw new Exception("Config have already been instanciated.");
        }
        commandsRegister = new ArrayList<AbstractCommand>();
        commandsRegister.add(new HelpCommand());
        commandsRegister.add(new HelpCommand2());
        commandsRegister.add(new ChangeLanguageCommand());
        commandsRegister.add(new BuildBatCommand());
        commandsRegister.add(new BuildProxyCommand());
        commandsRegister.add(new CreateShortCutCommand());
        commandsRegister.add(new KnowInstallCommand());
        commandsRegister.add(new CheckVersionCommand());
        commandsRegister.add(new CheckVersionCommand2());
        commandsRegister.add(new WaitCommand());
        commandsRegister.add(new UpdateLauncherCommand());
        commandsRegister.add(new UpdateLauncherRetroCommand());
        commandsRegister.add(new NoFlushCommand());
        commandsRegister.add(new NeedNormalStreamCommand());
        commandsRegister.add(new SkipValidationCommand());
        commandsRegister.add(new FlushBinCommand());
        commandsRegister.add(new LaunchCommand());
        commandsRegister.add(new NoShortCutCommand());
        instance = new CopyOfConfig(args);
        instance.finishInit();
        return CopyOfConfig.getInstance();
    }

    private CopyOfConfig(String[] args) throws Exception {
        this.logger = LauncherLogger.getInstance();
        this.listCommands(args);
    }

    private void finishInit() throws Exception {
        this.logger.init();
        this.logger.log("---- Parameter used for the launcher ----");
        for (AbstractCommand ac : this.commands) {
            this.logger.log(ac.toString());
        }
        this.initGeneralConfig();
        this.initInstallFolder();
        this.initLanguage();
        this.initProxyInfo();
        this.initProvider();
        this.configFileManager = new ConfigFileManager(new File(this.installFolder, "medoffice"));
        this.configFileManager.setConfigPropFromFoundFiles();
        this.configFileManager.logConfigFiles();
    }

    private void initProvider() throws Exception {
        String op;
        LauncherLogger.getInstance().log("Init download site providers...");
        String[] ops = this.medoProperties.getProperty("medo.download").split(";");
        this.medoProperties.remove("medo.download");
        ArrayList<DownloadSite> ds = new ArrayList<DownloadSite>();
        String[] stringArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            op = stringArray[n2];
            ds.add(new DownloadSite(op));
            LauncherLogger.getInstance().log("  Medoffice site: " + op);
            ++n2;
        }
        this.medoSiteProvider = new SiteProvider(ds);
        ops = this.medoProperties.getProperty("launcher.download").split(";");
        this.medoProperties.remove("launcher.download");
        ds = new ArrayList();
        stringArray = ops;
        n = ops.length;
        n2 = 0;
        while (n2 < n) {
            op = stringArray[n2];
            ds.add(new DownloadSite(op));
            LauncherLogger.getInstance().log("  Launcher site: " + op);
            ++n2;
        }
        this.launcherSiteProvider = new SiteProvider(ds);
    }

    private void initLanguage() {
        File lgFile = new File(this.installFolder, "medoffice/medoffice.lang");
        String lg = "fr_ca";
        if (lgFile.exists()) {
            lg = Util.readFile(lgFile);
        }
        this.medoProperties.put(LANG_PROP_KEY, lg);
        LauncherLogger.getInstance().log("->Choosen langage: " + lg);
    }

    private void initProxyInfo() throws Exception {
        File lgFile = new File(this.installFolder, "medoffice/proxy.prop");
        LauncherLogger.getInstance().log("->Check for proxy... (" + lgFile.getAbsolutePath() + ")");
        if (lgFile.exists()) {
            this.proxyProperties = new Properties();
            LauncherLogger.getInstance().log("\tProxy exist : loading properties.  If nothing happen after, remove the proxy file.");
            Properties p = new Properties();
            FileInputStream sras = new FileInputStream(lgFile);
            p.load(sras);
            this.proxyProperties.putAll((Map<?, ?>)p);
            for (Map.Entry<Object, Object> set : p.entrySet()) {
                if (set.getValue() == null || ((String)set.getValue()).trim().length() <= 0) continue;
                System.setProperty((String)set.getKey(), (String)set.getValue());
            }
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                this.logger.log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initInstallFolder() throws Exception {
        this.logger.log("Init Install Folder");
        if (this.medoProperties.containsKey("gmf-install")) {
            this.logger.log("It's a gmf install.");
            File f = new File("C://infodata/");
            if (!this.isMedofficeInstallThere(f)) {
                this.logger.log("Medoffice is not install.");
                if (!CopyOfConfig.isFolderHasRight(f)) {
                    throw new PopupInformationException("Vous avez lanc\u00e9 Medoffice en mode 'GMF'.  Cette op\u00e9ration \u00e0 \u00e9chou\u00e9e.  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur le dossier 'C://infodata/' .  Veuillez contacter votre CSA.");
                }
                this.installFolder = f;
            } else {
                this.logger.log("Medoffice is install.");
                if (!CopyOfConfig.isFolderHasRight(f)) throw new PopupInformationException("Medoffice est install\u00e9 dans " + f + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez Medoffice.");
                this.installFolder = f;
            }
        } else {
            this.logger.log("It's a normal (user profile) install.");
            String homePath = Util.isWindows() ? System.getenv().get("USERPROFILE") : System.getProperty("user.home");
            boolean canBeJH = false;
            File homeMedoFile = new File(homePath);
            if (this.isMedofficeInstallThere(homeMedoFile)) {
                this.logger.log("Medo is install.");
                if (!CopyOfConfig.isFolderHasRight(homeMedoFile)) throw new PopupInformationException("Medoffice est install\u00e9 dans " + homeMedoFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez Medoffice.");
                this.installFolder = homeMedoFile;
            } else {
                this.logger.log("Medoffice is not install.");
                if (CopyOfConfig.isFolderHasRight(homeMedoFile)) {
                    this.logger.log("K");
                    canBeJH = true;
                }
            }
            boolean canBeWH = false;
            File wMedoFile = null;
            if (this.installFolder == null && Util.isWindows()) {
                this.logger.log("On windows, check for the other home file.");
                wMedoFile = new File(System.getProperty("user.home"));
                if (this.isMedofficeInstallThere(wMedoFile)) {
                    this.logger.log("Medoffice is install.");
                    if (!wMedoFile.exists() || !CopyOfConfig.isFolderHasRight(wMedoFile)) throw new PopupInformationException("Medoffice est install\u00e9 dans " + wMedoFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez Medoffice.");
                    this.installFolder = wMedoFile;
                } else if (!canBeJH) {
                    this.logger.log("Medoffice is not install.");
                    if (wMedoFile.exists() && CopyOfConfig.isFolderHasRight(wMedoFile)) {
                        canBeWH = true;
                    }
                }
            }
            if (this.installFolder == null) {
                this.logger.log("Medoffice is definitively not install, so we gonna look what is the best way to install.");
                if (canBeJH) {
                    this.installFolder = homeMedoFile;
                } else {
                    if (!canBeWH) throw new PopupInformationException("Vous avez tentez de lancer Medoffice dans votre r\u00e9pertoire utilisateur (" + homeMedoFile.getAbsolutePath() + (wMedoFile == null ? "" : ", " + wMedoFile.getAbsolutePath()) + ").  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur votre dossier.  Veuillez contacter votre CSA. ");
                    this.installFolder = wMedoFile;
                }
            }
        }
        if (!this.installFolder.exists()) {
            this.logger.log("Install folder '" + this.installFolder.getAbsolutePath() + "' doesn't exist. We gonna create it.");
            this.installFolder.mkdirs();
        }
        this.logger.log("Dossier d'installation : " + this.installFolder.getAbsolutePath() + " : " + this.installFolder.isDirectory());
    }

    public static boolean isFolderHasRight(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            String tt;
            File fTest = new File(folder, "accesTestFile");
            Util.saveToFile(fTest, "test");
            if (fTest.exists() && "test".equals(tt = Util.readFile(fTest))) {
                fTest.delete();
                if (!fTest.exists()) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isMedofficeInstallThere(File folder) {
        File vFile = new File(folder, "medoffice/version.txt");
        this.logger.log("Is Medoffice installed here? " + vFile.exists() + " : " + vFile.getAbsolutePath());
        return vFile.exists();
    }

    public AbstractCommand getCommand(String command) {
        for (AbstractCommand ac : this.commands) {
            if (!ac.getCommandName().equals(command)) continue;
            return ac;
        }
        return null;
    }

    private void initGeneralConfig() throws Exception {
        this.logger.log("---- Init Medoffice launch config ----");
        Properties p = new Properties();
        InputStream sras = this.getClass().getClassLoader().getResourceAsStream("ca/infodata/launcher3/ressources/config.properties");
        p.load(sras);
        this.medoProperties.putAll((Map<?, ?>)p);
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            this.logger.log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
        }
    }

    private void listCommands(String[] args) throws NotToSendException {
        int index = 0;
        while (index < args.length) {
            String sA = args[index];
            AbstractCommand ac = null;
            for (AbstractCommand act : commandsRegister) {
                if (!act.getCommandName().equals(sA)) continue;
                ac = act;
                break;
            }
            if (ac == null) {
                throw new NotToSendException("No commands exist for '" + sA + "'.  User -h or -help.");
            }
            ArrayList<String> params = new ArrayList<String>();
            while (index + 1 + params.size() < args.length) {
                String param = args[index + 1 + params.size()];
                if (!ac.isValidParameter(param)) break;
                System.out.println("add param '" + param + "' to " + ac.getCommandName());
                params.add(param);
            }
            index += params.size() + 1;
            ac.setParameters(params);
            this.commands.add(ac);
        }
    }

    public String[][] readIndexFile(SiteProvider urlProvider, String relPath) throws Exception {
        String[][] r = null;
        urlProvider.reset();
        boolean isDonwloaded = false;
        while (!isDonwloaded) {
            DownloadSite site = urlProvider.getSite();
            if (site == null) {
                throw new NoMoreDownloadProdiderException("Impossible de lire le fichier " + relPath + ".  Aucun site de t\u00e9l\u00e9chargement r\u00e9pond.");
            }
            try {
                String line;
                URL remoteIndex = new URL(site.url, relPath);
                this.logger.log("Read index of : " + remoteIndex);
                ArrayList<String[]> li = new ArrayList<String[]>();
                InputStream is = remoteIndex.openStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                while ((line = in.readLine()) != null) {
                    String[] rr = new String[3];
                    this.logger.log("REMOTE FILE : " + line);
                    rr[0] = line;
                    rr[1] = in.readLine();
                    rr[2] = in.readLine();
                    li.add(rr);
                }
                String[][] rrr = new String[li.size()][3];
                int i = 0;
                while (i < li.size()) {
                    rrr[i] = (String[])li.get(i);
                    ++i;
                }
                r = rrr;
                isDonwloaded = true;
            }
            catch (Exception e) {
                urlProvider.failed();
            }
        }
        return r;
    }

    public void setMedoFilesDif() throws Exception {
        String[][] r = this.readIndexFile(this.medoSiteProvider, "Medoffice.txt");
        ArrayList<String> skipDeleting = new ArrayList<String>();
        skipDeleting.add(".DS");
        skipDeleting.add(".ds");
        skipDeleting.add("appIcon.ico");
        skipDeleting.add("appIcon.icns");
        skipDeleting.add("backup");
        skipDeleting.add("configuration");
        skipDeleting.add("DatabaseInfos.xml");
        skipDeleting.add("DatabaseInfo.xml");
        skipDeleting.add("installFlag.medoffice");
        skipDeleting.add("instance");
        skipDeleting.add("launcher");
        skipDeleting.add("latestver.txt");
        skipDeleting.add("Medoffic");
        skipDeleting.add("medoffic");
        skipDeleting.add("MED-Office.app");
        skipDeleting.add("medoffice.bat");
        skipDeleting.add("medoffice.lang");
        skipDeleting.add("medoffice.proxy");
        skipDeleting.add("MedofficeApp.zip");
        skipDeleting.add("patient_record");
        skipDeleting.add("shortcut.vbs");
        skipDeleting.add("no-short");
        skipDeleting.add("temp");
        skipDeleting.add("proxy.prop");
        skipDeleting.add("urlserver.info");
        skipDeleting.add("validata");
        skipDeleting.add("validdata");
        skipDeleting.add("version.txt");
        FileDiff fd = new FileDiff("/medoffice/", null, r, skipDeleting);
        fd.doTheDiff();
        this.medoDiff = fd;
    }

    public void setLauncherFilesDif() throws Exception {
        String[][] r = this.readIndexFile(this.launcherSiteProvider, "launcher.txt");
        FileDiff fd = new FileDiff("/medoffice/", "/launcher", r, null);
        fd.doTheDiff();
        this.launcherDiff = fd;
    }

    public void installMedo(SyncProgressMonitor monitor) throws Exception {
        this.sync(this.medoDiff, monitor, this.medoSiteProvider);
        this.tryToOldIcon();
        this.createShortCut();
        this.configFileManager.tryToFlushAllConfigs();
        this.tryToFlushBinFiles();
    }

    public void tryToFlushBinFiles() throws PopupInformationException {
        this.logger.log("-- tryToFlushBinFiles --");
        File medHome = new File(System.getProperty("user.home"));
        medHome = new File(medHome, ".medoffice");
        this.logger.log("JAVA.HOME DIR TO CHECKED: " + medHome.getAbsolutePath() + " : " + medHome.exists());
        if (!medHome.exists() && Util.isWindows()) {
            medHome = new File(System.getenv().get("USERPROFILE"));
            medHome = new File(medHome, ".medoffice");
            this.logger.log("Not in java.home, we are in windows: try with: " + medHome.getAbsolutePath() + " : " + medHome.exists());
        }
        if (!medHome.exists()) {
            this.logger.log(Level.WARNING, "Dossier '.medoffice' introuvable.");
        } else {
            File[] files;
            boolean haveBeenDelete = true;
            File[] fileArray = files = medHome.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.endsWith(".bin");
                }
            });
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                boolean del = f.delete();
                this.logger.log("Try to delete " + f.getAbsolutePath() + " : " + del);
                haveBeenDelete = haveBeenDelete && del;
                ++n2;
            }
            if (!haveBeenDelete) {
                throw new PopupInformationException("L'installateur n'est pas parvenu \u00e0 supprimer les fichier '*.bin' du dossier '.medoffice' pour compl\u00e9ter la mise-\u00e0-jour.  Il se pourrait que vous rencontriez des probl\u00e8mes en utilisant Med-Office.  Contactez-nous pour tout probl\u00e8me.\n\nVous pouvez relancer Med-Office.");
            }
        }
    }

    public void tryToOldIcon() throws PopupInformationException {
        this.logger.log("-- tryToFlushBinFiles --");
        File medHome = new File(System.getProperty("user.home"));
        if (Util.isWindows()) {
            medHome = new File(medHome, "Desktop/MED-Office.lnk");
            this.logger.log("JAVA.HOME DIR TO CHECKED: " + medHome.getAbsolutePath() + " : " + medHome.exists());
            if (!medHome.exists() && Util.isWindows()) {
                medHome = new File(System.getenv().get("USERPROFILE"));
                medHome = new File(medHome, "Desktop/MED-Office.lnk");
                this.logger.log("Not in java.home, we are in windows: try with: " + medHome.getAbsolutePath() + " : " + medHome.exists());
            }
            if (!medHome.exists()) {
                this.logger.log(Level.WARNING, "Dossier 'Desktop/MED-Office.lnk' introuvable.");
            } else if (medHome.delete()) {
                this.logger.log(String.valueOf(medHome.getAbsolutePath()) + " have been deleted...");
            } else {
                this.logger.log(Level.WARNING, "Unable to delete " + medHome.getAbsolutePath() + ". Gonna try to delete on exist.");
                medHome.deleteOnExit();
            }
        } else if (Util.isMac()) {
            if ((medHome = new File(medHome, "Desktop/Medoffice.app")).exists()) {
                if (medHome.delete()) {
                    this.logger.log(String.valueOf(medHome.getAbsolutePath()) + " have been deleted...");
                } else if (medHome.renameTo(new File(medHome.getParentFile(), "MED-Office.app"))) {
                    this.logger.log(String.valueOf(medHome.getAbsolutePath()) + " have been renamed...");
                } else {
                    this.logger.log(Level.WARNING, "Unable to delete " + medHome.getAbsolutePath() + ". Gonna try to delete on exist.");
                    medHome.deleteOnExit();
                }
            } else {
                this.logger.log(Level.WARNING, "Can't find the " + medHome.getAbsolutePath() + "!!!!");
            }
        }
    }

    public void saveLangageFile() {
        File lgFile = new File(this.installFolder, "medoffice/medoffice.lang");
        boolean mustSave = false;
        if (lgFile.exists()) {
            String lg = Util.readFile(lgFile);
            if (!lg.equals(this.medoProperties.get(LANG_PROP_KEY))) {
                mustSave = true;
                lgFile.delete();
            }
        } else {
            mustSave = true;
        }
        if (mustSave) {
            Util.saveToFile(lgFile, (String)this.medoProperties.get(LANG_PROP_KEY));
        }
        LauncherLogger.getInstance().log("->Save new choosen langage: " + this.medoProperties.get(LANG_PROP_KEY));
    }

    public void installLauncher(SyncProgressMonitor monitor) throws Exception {
        this.sync(this.launcherDiff, monitor, this.launcherSiteProvider);
    }

    private void sync(FileDiff diff, SyncProgressMonitor monitor, SiteProvider siteProvider) throws Exception {
        if (diff == null) {
            throw new NullPointerException("diff");
        }
        ArrayList<File> failedToDelete = new ArrayList<File>();
        monitor.setCurrentTask("Initialisation...");
        File bFolder = new File(this.installFolder, "medoffice");
        if (!bFolder.exists()) {
            bFolder.mkdirs();
        }
        monitor.setCurrentTask("Pr\u00e9paration du dossier d'installation...");
        for (FileDiff.FileWrap fw : diff.getToDeleteFiles()) {
            if (fw.localFile.delete()) continue;
            failedToDelete.add(fw.localFile);
        }
        for (FileDiff.FileWrap fw : diff.getToUpdateFiles()) {
            if (fw.localFile.delete()) continue;
            failedToDelete.add(fw.localFile);
        }
        monitor.setCurrentTask("T\u00e9l\u00e9chargement de ...");
        monitor.setTotalFiles(diff.getToDownloadFiles().size() + diff.getToUpdateFiles().size());
        long totalBytes = 0L;
        for (FileDiff.FileWrap f : diff.getToDownloadFiles()) {
            totalBytes += f.targetSize;
        }
        for (FileDiff.FileWrap f : diff.getToUpdateFiles()) {
            totalBytes += f.targetSize;
        }
        monitor.setTotalBytes(totalBytes);
        ArrayList<FileDiff.FileWrap> toDownload = new ArrayList<FileDiff.FileWrap>();
        toDownload.addAll(diff.getToDownloadFiles());
        toDownload.addAll(diff.getToUpdateFiles());
        siteProvider.reset();
        for (FileDiff.FileWrap file : toDownload) {
            File localFile = new File(bFolder, file.relPath);
            this.downloadFile(localFile, file, monitor, siteProvider);
        }
        monitor.setCurrentFile(null);
        monitor.setCurrentFileTotalBytes(null);
        monitor.setCurrentFileWorkedBytes(null);
        monitor.setCurrentTask("Finalisation...");
        monitor.setCancelable(false);
        monitor.setDone();
    }

    public void downloadFile(File localFile, FileDiff.FileWrap file, SyncProgressMonitor monitor, SiteProvider siteProvider) throws Exception {
        monitor.setCurrentFile(file.relPath);
        boolean downloaded = false;
        while (!downloaded) {
            boolean failed;
            DownloadSite site = siteProvider.getSite();
            if (site == null) {
                throw new NoMoreDownloadProdiderException("Impossible de lire le fichier " + file.relPath + ".  Aucun site de t\u00e9l\u00e9chargement r\u00e9pond.");
            }
            URL url = new URL(site.url, "medoffice/" + file.relPath.replace("\\", "/"));
            this.logger.log("  upload " + url + "\t to " + localFile);
            ValidatedDownload download = new ValidatedDownload(url, localFile);
            download.setMonitor(monitor);
            download.setMd5(file.targetMd5);
            download.run();
            boolean bl = failed = download.getStatus() != Download.STATUS.COMPLETE;
            if (failed) {
                this.logger.log(Level.WARNING, "Unable to download with status " + (Object)((Object)download.getStatus()) + " : " + url + " to " + localFile);
                siteProvider.failed();
            } else {
                downloaded = true;
            }
            this.checkCanceledOrPaused(monitor);
        }
        monitor.workedFiles(1);
        monitor.workedBytes(file.targetSize);
        this.checkCanceledOrPaused(monitor);
    }

    private void checkCanceledOrPaused(SyncProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            this.doCancel();
        }
        while (monitor.isPaused()) {
            Util.sleep(1000L);
            if (!monitor.isCanceled()) continue;
            this.doCancel();
        }
    }

    private void doCancel() throws Exception {
        throw new CancelException();
    }

    public void createShortCut() throws Exception {
        this.logger.log(Level.INFO, "####################");
        this.logger.log(Level.INFO, "---->create shortcut");
        this.logger.log(Level.INFO, "####################");
        File avoidShortcutFile = new File(this.installFolder, "Ofys/no-shortcut.flag");
        if (avoidShortcutFile.exists()) {
            this.logger.log(Level.INFO, "\tNo shortcut flag found : wont create the shortcut.");
        } else {
            File localFileDirectory = new File(this.installFolder, "/medoffice");
            String localPathDirectory = localFileDirectory.getAbsolutePath();
            if (Util.isWindows()) {
                String vbs = " Dim WSHShell\n Set WSHShell = _\n    WScript.CreateObject(\"WScript.Shell\")\n Dim MyShortcut, MyDesktop, DesktopPath\n ' Read desktop path using WshSpecialFolders object\n DesktopPath = _\n    WSHShell.SpecialFolders(\"Desktop\")\n ' Create a shortcut object on the desktop\n Set MyShortcut = _\n    WSHShell.CreateShortcut( _\n    DesktopPath & \"\\MED\u00adOffice.lnk\")\n ' Set shortcut object properties and save it\n MyShortcut.TargetPath = _\n    WSHShell.ExpandEnvironmentStrings( _\n    \"\"\"" + localPathDirectory + "\\launcher\\" + JAR_NAME + "\"\"\")\n" + " MyShortcut.WorkingDirectory = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"" + localPathDirectory + "\\medoffice\")\n" + " MyShortcut.WindowStyle = 4\n" + " MyShortcut.IconLocation = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"" + localPathDirectory + "\\appIcon.ico\")\n" + " MyShortcut.Save\n";
                File f = new File(this.installFolder, "shortcut.vbs");
                Util.saveToFile(f, vbs);
                this.logger.log(Level.INFO, "---->createShortCut Windows");
                try {
                    String cmd = "wscript \"" + f.getAbsolutePath() + "\"";
                    this.logger.log("CMD :" + cmd);
                    Process proc = Runtime.getRuntime().exec(cmd);
                    proc.waitFor();
                    f.deleteOnExit();
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, e);
                }
            } else {
                this.logger.log(Level.INFO, "---->createShortCut Mac");
                File fAppZip = new File(localFileDirectory, "MedofficeApp.zip");
                if (fAppZip.exists()) {
                    Unzip.unzip(fAppZip, localFileDirectory);
                }
                File fApp = new File(localFileDirectory, "MED-Office.app");
                File desktopFile = new File(String.valueOf(System.getProperty("user.home", "")) + "/Desktop");
                this.logger.log(Level.INFO, "From " + fApp + " to " + desktopFile);
                if (fApp.exists() && desktopFile.exists()) {
                    try {
                        File macosxFolder;
                        this.logger.log(Level.INFO, "COPY");
                        Util.copyDirectory(fApp, new File(desktopFile, "MED-Office.app"));
                        this.logger.log(Level.INFO, "AJUST RIGHTS");
                        String[] cmd1 = new String[]{"chmod", "-R", "777", fApp.getAbsolutePath()};
                        String[] cmd2 = new String[]{"chmod", "-R", "777", new File(desktopFile, "MED-Office.app").getAbsolutePath()};
                        this.logger.log(Level.INFO, "CMD1 :" + CopyOfConfig.getStringOfTableCmd(cmd1));
                        Process proc = Runtime.getRuntime().exec(cmd1);
                        proc.waitFor();
                        this.logger.log(Level.INFO, "CMD2 :" + CopyOfConfig.getStringOfTableCmd(cmd2));
                        Process proc2 = Runtime.getRuntime().exec(cmd2);
                        proc2.waitFor();
                        File olPathFile = new File(desktopFile, "MED-Office.app/Contents/Resources/script");
                        if (olPathFile.exists()) {
                            String contains = Util.readFile(olPathFile);
                            contains = contains.replace("PATH_OFYS_LAUNCHER", String.valueOf(localFileDirectory.getAbsolutePath()) + "/" + JAR_NAME_EXT);
                            Util.saveToFile(olPathFile, contains);
                        }
                        if ((macosxFolder = new File(localFileDirectory, "__MACOSX")).exists()) {
                            String[] cmd3 = new String[]{"chmod", "-R", "777", macosxFolder.getAbsolutePath()};
                            this.logger.log(Level.INFO, "CMD3 :" + CopyOfConfig.getStringOfTableCmd(cmd3));
                            Process proc3 = Runtime.getRuntime().exec(cmd3);
                            proc3.waitFor();
                            Util.deleteDirectory(macosxFolder);
                        }
                        this.logger.log(Level.INFO, "DELETE");
                        Util.deleteFile(fApp);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.INFO, e);
                    }
                } else {
                    this.logger.log(Level.SEVERE, "Impossible de d\u00e9compresser " + fAppZip.getAbsolutePath() + ":" + fAppZip.exists() + "/" + fApp.exists() + "/" + desktopFile.exists());
                    throw new Exception("Impossible de d\u00e9compresser " + fAppZip.getAbsolutePath() + ".");
                }
            }
        }
    }

    private static String getStringOfTableCmd(String[] t) {
        String s = "";
        String[] stringArray = t;
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            s = String.valueOf(s) + " " + ss;
            ++n2;
        }
        return s;
    }
}

