/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.web;

import ca.infodata.launcher.util.LogHandler;
import ca.infodata.launcher.web.Args;
import ca.infodata.launcher.web.LauncherCaller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LauncherApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    private static final String appletInfo = "Lanceur Ofys,  Logiciels INFO-DATA inc., \u00a9 Tout droits r\u00e9serv\u00e9s.";
    private long initTime;
    private JButton btnLaunch;
    private static final String LANCER_OFYS = "Lancer Ofys";
    private static final String VEUILLEZ_RECHARGER_LA_PAGE = "Veuillez recharger la page";
    private LogHandler logHandler;

    @Override
    public void init() {
        System.out.println("CLASS LOADER: " + this.getClass().getClassLoader().toString());
        this.initTime = System.currentTimeMillis();
        Logger root = Logger.getLogger("");
        root.setLevel(Level.INFO);
        this.logHandler = new LogHandler("http://www.infodata.ca/");
        root.addHandler(this.logHandler);
        this.btnLaunch = new JButton(LANCER_OFYS);
        this.add(this.btnLaunch);
        this.setSize(125, 50);
        final Args args = new Args();
        this.btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LauncherApplet.this.isAppletUpToDate()) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            LauncherCaller.mains(args.toArgs());
                            LauncherApplet.this.logHandler.flush();
                            LauncherApplet.this.destroy();
                        }
                    }, "launcher");
                    thread.setDaemon(false);
                    thread.start();
                    LauncherApplet.this.btnLaunch.setEnabled(false);
                    LauncherApplet.this.btnLaunch.setText(LauncherApplet.VEUILLEZ_RECHARGER_LA_PAGE);
                }
            }
        });
    }

    private boolean isAppletUpToDate() {
        long current = System.currentTimeMillis();
        if (current - this.initTime > TimeUnit.HOURS.toMillis(1L)) {
            JOptionPane.showMessageDialog(this, "Cet applet a expir\u00e9. Veuillez recharger la page.");
            return false;
        }
        return true;
    }

    @Override
    public String getAppletInfo() {
        return appletInfo;
    }

    @Override
    public void start() {
        super.start();
        this.initTime = System.currentTimeMillis();
        this.logHandler.flush();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LauncherApplet.this.btnLaunch.setText(LauncherApplet.LANCER_OFYS);
                LauncherApplet.this.btnLaunch.setEnabled(true);
            }
        });
    }

    @Override
    public void destroy() {
        System.out.println("DESTROY!");
        this.logHandler.flush();
        super.destroy();
    }
}

