/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher;

import ca.infodata.launcher.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Formatter;

public class CopyOfMake {
    private static MessageDigest digest;

    public static void main(String[] args) throws Exception {
        File root;
        if (args == null || args.length == 0) {
            args = new String[]{"H:\\users\\njoly\\testfolder\\test"};
        }
        if (args == null || args.length == 0) {
            System.err.println("missing argument root folder");
            System.exit(1);
        }
        if (!(root = new File(args[0])).isDirectory()) {
            System.err.println("root folder " + root + " must be a writeable directory");
            System.exit(1);
        }
        digest = MessageDigest.getInstance("MD5");
        CopyOfMake.createIndexFile(root);
        System.out.println("done");
    }

    private static void createIndexFile(File folder) throws Exception {
        File launcherTxt = new File(folder, "launcher.txt");
        if (launcherTxt.exists()) {
            Util.deleteFile(launcherTxt);
        }
        FileWriter writer = new FileWriter(launcherTxt);
        CopyOfMake.listFileRecursiveToIndex(writer, "", folder);
    }

    private static void listFileRecursiveToIndex(FileWriter writer, String relativePath, File root) throws Exception {
        File[] files = root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith(".md5") && !name.equals("index.txt");
            }
        });
        CopyOfMake.orderFile("ofys.version", files);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                CopyOfMake.listFileRecursiveToIndex(writer, relativePath, file);
            } else {
                String path = file.getAbsolutePath().replace(String.valueOf(relativePath) + File.separator, "");
                writer.write(path);
                writer.write("\r\n");
                writer.write(CopyOfMake.computeMd5(digest, file));
                writer.write("\r\n");
                writer.write(String.valueOf(file.length()));
                writer.write("\r\n");
                writer.flush();
            }
            ++n2;
        }
    }

    private static void orderFile(String lastFile, File[] files) {
        int index = -1;
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.getName().equals(lastFile)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            File last = files[index];
            int i2 = index;
            while (i2 < files.length - 1) {
                files[i2] = files[i2 + 1];
                ++i2;
            }
            files[files.length - 1] = last;
        }
    }

    private static String computeMd5(MessageDigest mD5Digest, File file) throws Exception {
        byte[] b = CopyOfMake.readFileAsBytes(file);
        mD5Digest.reset();
        mD5Digest.update(b);
        return CopyOfMake.bytesToHexString(mD5Digest.digest());
    }

    private static byte[] readFileAsBytes(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        return sb.toString();
    }
}

