/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.downlaod;

import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.downlaod.Download;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValidatedDownload
extends Download {
    private static final Logger logger = Logger.getLogger(ValidatedDownload.class.getName());
    private String md5;
    private int md5RetryCount = 0;
    private int maxMd5RetryCount = 2;

    public ValidatedDownload(URL from, File target) {
        super(from, target);
    }

    @Override
    public void run() {
        super.runNio();
        if (this.getStatus() == Download.STATUS.COMPLETE) {
            try {
                String targetMd5;
                if (this.md5 != null && !(targetMd5 = Util.computeMd5(this.getTarget())).equals(this.md5)) {
                    ++this.md5RetryCount;
                    if (this.md5RetryCount < this.maxMd5RetryCount) {
                        this.getMonitor().setMessage("Erreur. fichier corrompu. Essai " + this.md5RetryCount);
                        Util.deleteFile(this.getTarget());
                        this.run();
                    } else {
                        Util.deleteFile(this.getTarget());
                        this.setStatus(Download.STATUS.ERROR);
                        this.getMonitor().setMessage("Erreur. fichier corrompu. Abandon");
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to compute md5 of target file");
                this.setStatus(Download.STATUS.ERROR);
            }
        }
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }
}

