/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.downlaod;

import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.downlaod.DownloadSite;
import java.util.List;
import java.util.logging.Level;

public class SiteProvider {
    private List<DownloadSite> sites;
    private int actualSiteIndex;

    public SiteProvider(List<DownloadSite> sites) {
        this.sites = sites;
        this.actualSiteIndex = 0;
    }

    public DownloadSite getSite() {
        if (this.actualSiteIndex < this.sites.size()) {
            return this.sites.get(this.actualSiteIndex);
        }
        return null;
    }

    public DownloadSite failed() {
        DownloadSite site = this.getSite();
        if (site != null) {
            ++site.failedTry;
            LauncherLogger.getInstance().log(Level.WARNING, "Le site " + site.url + " ne r\u00c3\u00a9pond pas (" + site.failedTry + ").");
            if (site.failedTry >= site.maxFailed) {
                ++this.actualSiteIndex;
                LauncherLogger.getInstance().log(Level.WARNING, "Le site " + site.url + " ne r\u00c3\u00a9pond plus.");
            }
        }
        return this.getSite();
    }

    public void reset() {
        this.actualSiteIndex = 0;
        for (DownloadSite site : this.sites) {
            site.failedTry = 0;
        }
    }
}

