/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.downlaod;

import ca.infodata.launcher.util.SyncProgressMonitor;
import ca.infodata.launcher3.config.LauncherLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class DownloadProgressDialog
extends SyncProgressMonitor {
    private JDialog dialog;
    private JLabel label;
    private JProgressBar bar;
    private JButton btnCancel;
    private JButton btnClose;
    private boolean needClosedButton;

    public DownloadProgressDialog() {
        this.setNeedClosedButton(false);
        this.dialog = new JDialog(null, "Mise-\u00e0-jour en cours...", Dialog.ModalityType.MODELESS);
        this.label = new JLabel();
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        this.btnCancel = new JButton("Annuler");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadProgressDialog.this.setPaused(true);
                int r = JOptionPane.showOptionDialog(DownloadProgressDialog.this.dialog, "\u00cates-vous certains de vouloir annuler le t\u00e9l\u00e9chargement de MED-Office.  Celui-ci est n\u00e9cessaire au bon fonctionnement de MED-Office.", "Question", 0, 3, null, new Object[]{"Oui", "Non"}, "Non");
                if (r == 0) {
                    DownloadProgressDialog.this.setMessage("L'utilisateur \u00e0 annul\u00e9");
                    DownloadProgressDialog.this.setCanceled();
                } else {
                    DownloadProgressDialog.this.setPaused(false);
                }
            }
        });
        this.btnClose = new JButton("Terminer");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadProgressDialog.this.needClosedButton = false;
            }
        });
        this.btnClose.setVisible(false);
        JPanel panel = new JPanel();
        this.dialog.setContentPane(panel);
        BorderLayout layout = new BorderLayout();
        layout.setVgap(2);
        this.dialog.setLayout(layout);
        panel.add((Component)this.label, "North");
        panel.add((Component)this.bar, "Center");
        panel.add((Component)this.btnCancel, "South");
        panel.add((Component)this.btnClose, "East");
        this.dialog.setSize(500, 150);
        this.dialog.setDefaultCloseOperation(0);
    }

    public void setDialogTitleUpdate() {
        this.dialog.setTitle("Mise-\u00e0-jour en cours...");
    }

    public void setDialogTitleInstall() {
        this.dialog.setTitle("Installation en cours...");
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    @Override
    public void update() {
        String barText;
        int worked;
        int total;
        String text = "<html>";
        if (this.getCurrentTask() != null) {
            text = String.valueOf(text) + this.getCurrentTask();
        }
        text = this.getCurrentFile() != null ? String.valueOf(text) + "<br>" + this.getCurrentFile() : String.valueOf(text) + "<br>";
        text = this.getCurrentFileTotalBytes() != null && this.getCurrentFileWorkedBytes() != null ? String.valueOf(text) + "<br>" + this.getCurrentFileWorkedBytes() / 1024L + " / " + this.getCurrentFileTotalBytes() / 1024L + " K" : String.valueOf(text) + "<br>";
        text = this.getMessage() != null ? String.valueOf(text) + "<br><font color='red'>" + this.getMessage() + "</font>" : String.valueOf(text) + "<br>";
        final String text2 = text = String.valueOf(text) + "<html>";
        if (this.getTotalBytes() != null) {
            int speed;
            total = (int)(this.getTotalBytes() / 1024L);
            worked = this.getWorkedBytes() != null ? (int)(this.getWorkedBytes() / 1024L) : 0;
            barText = String.valueOf(worked) + " / " + total + " K";
            if (this.getDownloadSpeed() != null && (speed = (int)(this.getDownloadSpeed() / 1024L)) > 0) {
                barText = String.valueOf(barText) + "  ( " + speed + " K / seconde )";
            }
        } else if (this.getTotalFiles() != null) {
            total = this.getTotalFiles();
            worked = this.getWorkedFiles() != null ? this.getWorkedFiles() : 0;
            barText = String.valueOf(worked) + " / " + total + " fichiers";
        } else {
            total = 0;
            worked = 0;
            barText = "";
        }
        final String barText2 = barText;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.label.setText(text2);
                this.bar.setMinimum(0);
                this.bar.setMaximum(total);
                this.bar.setValue(worked);
                this.bar.setString(barText);
                this.btnCancel.setEnabled(this.isCancelable());
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DownloadProgressDialog.this.label.setText(text2);
                        DownloadProgressDialog.this.bar.setMinimum(0);
                        DownloadProgressDialog.this.bar.setMaximum(total);
                        DownloadProgressDialog.this.bar.setValue(worked);
                        DownloadProgressDialog.this.bar.setString(barText2);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDone() {
        super.setDone();
        try {
            this.dialog.remove(this.btnCancel);
            this.btnCancel.setVisible(false);
            this.dialog.remove(this.bar);
            this.dialog.add((Component)this.btnClose, "South");
            this.btnClose.setVisible(true);
            String text = "<html>Pour finaliser la mise-\u00e0-jour, fermez toutes les instances de MED-Office et r\u00e9ouvrez MED-Office.";
            text = String.valueOf(text) + "<br/>T\u00e9l\u00e9chargement termin\u00e9!</html>";
            this.label.setText(text);
            this.dialog.setSize(500, 100);
            this.dialog.toFront();
            this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.dialog.setAlwaysOnTop(true);
            while (this.needClosedButton) {
                Thread.sleep(1000L);
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialog.this.dialog.setVisible(false);
                }
            });
        }
        catch (Exception e) {
            LauncherLogger.getInstance().log(Level.SEVERE, e);
        }
    }

    @Override
    public void setCanceled() {
        super.setCanceled();
        this.getDialog().setVisible(false);
    }

    @Override
    public void setPaused(boolean b) {
        super.setPaused(b);
    }

    public boolean isNeedClosedButton() {
        return this.needClosedButton;
    }

    public void setNeedClosedButton(boolean needClosedButton) {
        this.needClosedButton = needClosedButton;
    }
}

