/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3;

import ca.infodata.launcher.util.StreamGobbler;
import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.AbstractCommand;
import ca.infodata.launcher3.config.Config;
import ca.infodata.launcher3.config.FileDiff;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.downlaod.CancelException;
import ca.infodata.launcher3.downlaod.DownloadProgressDialog;
import ca.infodata.launcher3.downlaod.SiteProvider;
import ca.infodata.launcher3.exception.NoMoreDownloadProdiderException;
import ca.infodata.launcher3.exception.NotToSendException;
import ca.infodata.launcher3.exception.PopupInformationException;
import ca.infodata.launcher3.exception.PopupInformationWithQuestionException;
import ca.infodata.launcher3.exception.QuietException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MedoLauncher {
    public static final String LAUNCHER_VERSION = "3.2.0";
    public static final String CONFIG_FILE = "ca/infodata/launcher3/ressources/config.properties";
    public static JFrame frame;
    public static Config config;
    public static LauncherLogger log;
    private static final DownloadProgressDialog[] monitor;

    static {
        monitor = new DownloadProgressDialog[1];
    }

    public static void main(String[] args) {
        block34: {
            log = LauncherLogger.getInstance();
            try {
                config = Config.init(args);
            }
            catch (Exception e) {
                try {
                    log.init();
                    log.log(Level.SEVERE, e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            try {
                try {
                    log.log("List arguments: ");
                    String[] stringArray = args;
                    int n = args.length;
                    int e1 = 0;
                    while (e1 < n) {
                        String s = stringArray[e1];
                        log.log("  " + s);
                        ++e1;
                    }
                    MedoLauncher.findCommandAndExcute("-wait");
                    MedoLauncher.findCommandAndExcute("-create-shortcut");
                    MedoLauncher.findCommandAndExcute("-build-proxy");
                    MedoLauncher.findCommandAndExcute("-know-install");
                    MedoLauncher.findCommandAndExcute("-help");
                    MedoLauncher.findCommandAndExcute("-h");
                    MedoLauncher.findCommandAndExcute("-change-langage");
                    MedoLauncher.findCommandAndExcute("-flush-bin");
                    MedoLauncher.findCommandAndExcute("-launch-direct");
                    MedoLauncher.findCommandAndExcute("-no-shortcut");
                    if (MedoLauncher.haveCommand("-check-version") || MedoLauncher.haveCommand("-versioninfo")) {
                        MedoLauncher.checkVersion();
                        break block34;
                    }
                    if (MedoLauncher.haveCommand("-skip-validation") || MedoLauncher.haveCommand("-launch-direct")) {
                        MedoLauncher.startFrame();
                        MedoLauncher.launchMedoffice();
                        break block34;
                    }
                    MedoLauncher.startFrame();
                    if (MedoLauncher.haveCommand("-update-launcher") || MedoLauncher.haveCommand("-updatelaunchercopy")) {
                        MedoLauncher.updateLauncher();
                    } else {
                        MedoLauncher.cleanUpdateFolder();
                    }
                    MedoLauncher.checkLauncher();
                    if (!MedoLauncher.isInstallValid()) {
                        log.log("Installation is not valid.  Update/install Medoffice.");
                        MedoLauncher.installMedoffice();
                        MedoLauncher.isInstallValid(true);
                        MedoLauncher.launchMedoffice();
                        break block34;
                    }
                    MedoLauncher.launchMedoffice();
                }
                catch (Exception ex) {
                    if (ex instanceof NotToSendException) {
                        log.log(Level.INFO, "Something gone wrong... but it's not so important:", ex);
                    } else if (ex instanceof PopupInformationWithQuestionException) {
                        log.log(Level.SEVERE, ex);
                        Object[] choices = new String[]{"Lancer Medoffice", "Annuler"};
                        int response = JOptionPane.showOptionDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Med-Office", 1, -1, null, choices, "Annuler");
                        if (response == 0) {
                            try {
                                log.log(Level.WARNING, "Va quand meme tenter de lancer Med-Office");
                                MedoLauncher.launchMedoffice();
                            }
                            catch (Exception exception) {}
                        }
                    } else if (ex instanceof PopupInformationException) {
                        log.log(Level.SEVERE, ex);
                        JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Med-Office", 0);
                    } else if (ex instanceof QuietException) {
                        log.log(Level.SEVERE, ex);
                    } else if (ex instanceof CancelException) {
                        log.log(Level.WARNING, "CANCEL THE DONWLOAD", ex);
                    } else {
                        log.log(Level.SEVERE, ex);
                        JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Med-Office", 0);
                    }
                    if (MedoLauncher.haveCommand("-no-flush")) {
                        log.log("Log are in " + MedoLauncher.log.logFolder.getAbsolutePath());
                    } else {
                        log.flush();
                    }
                    if (frame != null) {
                        frame.dispose();
                    }
                }
            }
            finally {
                if (MedoLauncher.haveCommand("-no-flush")) {
                    log.log("Log are in " + MedoLauncher.log.logFolder.getAbsolutePath());
                } else {
                    log.flush();
                }
                if (frame != null) {
                    frame.dispose();
                }
            }
        }
    }

    private static void cleanUpdateFolder() throws Exception {
        File f2;
        File f = new File(Config.getInstance().installFolder, "medoffice/temp/");
        if (f.exists() && !Util.deleteDirectory(f)) {
            log.log(Level.WARNING, "Unable to remove temporary launcher in " + f.getAbsolutePath());
        }
        if ((f2 = new File(Config.getInstance().installFolder, "medoffice/update/")).exists() && !Util.deleteDirectory(f2)) {
            log.log(Level.WARNING, "Unable to remove temporary launcher in " + f2.getAbsolutePath());
        }
    }

    private static void updateLauncher() throws Exception {
        Config config = Config.getInstance();
        String sPath = System.getProperty("java.class.path");
        File oFile = new File(sPath);
        File dFile = new File(config.installFolder, "/medoffice/launcher/" + "MedoLauncher.jar");
        if (dFile.exists() && !dFile.delete() || !oFile.exists()) {
            log.log(Level.WARNING, "Failed to delete at first attemp " + dFile.getAbsolutePath() + " (" + dFile.exists() + ") or does not exist (" + oFile.exists() + ") " + oFile.getAbsolutePath());
            Thread.sleep(3000L);
            if (dFile.exists() && !dFile.delete() || !oFile.exists()) {
                log.log(Level.SEVERE, "Failed to delete " + dFile.getAbsolutePath() + " (" + dFile.exists() + ") or does not exist (" + oFile.exists() + ") " + oFile.getAbsolutePath());
                throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur Med-Office.");
            }
        }
        oFile.deleteOnExit();
        if (!Util.copyFile(oFile, dFile)) {
            log.log(Level.SEVERE, "Failed to copy " + oFile.getAbsolutePath() + " to " + dFile.getAbsolutePath());
            throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur Med-Office.");
        }
        if (!dFile.exists()) {
            log.log(Level.SEVERE, "Failed to copy somehow " + oFile.getAbsolutePath() + " to " + dFile.getAbsolutePath());
            throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur Med-Office.");
        }
        log.log(String.valueOf(dFile.getAbsolutePath()) + " is now existing!");
    }

    private static void checkLauncher() throws Exception {
        boolean isOki = false;
        boolean hasCheckValid = false;
        File launcher = new File(Config.getInstance().installFolder, "medoffice/launcher/" + "MedoLauncher.jar");
        log.log("--> Check if launcher is valid (" + launcher.getAbsolutePath() + ")");
        if (launcher.exists()) {
            hasCheckValid = true;
            if (MedoLauncher.isLauncherValid()) {
                isOki = true;
            }
        }
        log.log("launcher is oki? " + isOki);
        log.log("launcher is checked? " + hasCheckValid);
        if (!isOki) {
            if (!hasCheckValid) {
                MedoLauncher.isLauncherValid();
            }
            if (launcher.exists() && !launcher.delete()) {
                MedoLauncher.downloadAndRelaunchLauncher();
            }
            MedoLauncher.installLauncher();
        }
    }

    public static void launchMedoffice() throws Exception {
        Config config = Config.getInstance();
        config.saveLangageFile();
        File medoDir = new File(config.installFolder, "medoffice");
        log.log("Lancement de Med-Office");
        MedoLauncher.checkJavaVersion();
        String options = "";
        boolean isMac64Only = false;
        if (Util.isWindows()) {
            options = String.valueOf(options) + "-Xms256m -Xmx896m";
        } else if (Util.isMac()) {
            log.log(Level.INFO, "IT'S A MAC");
            options = String.valueOf(options) + " -XstartOnFirstThread -Xms256m -Xmx896m -XX:MaxPermSize=256m -Xdock:icon=\"" + medoDir + "/appIcon.icns\" -Dorg.eclipse.swt.internal.carbon.smallFonts";
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("osgi.instance.area", medoDir + "/instance");
        env.put("osgi.configuration.area", medoDir + config.configFileManager.configFileName);
        env.put("osgi.user.area", medoDir + "/user");
        env.put("osgi.sharedConfiguration.area", medoDir + "/shared");
        env.put("eclipse.ee.install.verify", "true");
        env.put("osgi.clean", "true");
        env.put("osgi.bundles", "org.eclipse.equinox.common@2:start,org.eclipse.update.configurator@3:start,org.eclipse.core.runtime@start");
        env.put("eclipse.product", "ca.infodata.intro.product");
        env.put("osgi.splashPath", "platform:/base/plugins/ca.infodata.intro");
        env.put("eclipse.application", "ca.infodata.intro.IntroApplication");
        config.medoProperties.putAll((Map<?, ?>)env);
        ArrayList<String> classpath = new ArrayList<String>();
        String launcherJar = Util.findFileRecursive2(medoDir, "org.eclipse.equinox.launcher_1.2.0.v20110502.jar");
        classpath.add(launcherJar);
        StringBuilder commandBuilder = new StringBuilder(1000);
        if (!isMac64Only) {
            commandBuilder.append("java");
        }
        commandBuilder.append(" ").append(options);
        for (Map.Entry<Object, Object> e : config.medoProperties.entrySet()) {
            commandBuilder.append(" -D").append(e.getKey()).append("=\"").append(e.getValue()).append("\"");
        }
        commandBuilder.append(" -classpath \"");
        for (String cp : classpath) {
            commandBuilder.append(cp).append(";");
        }
        commandBuilder.deleteCharAt(commandBuilder.length() - 1);
        commandBuilder.append("\" ");
        String launcherClass = "org.eclipse.equinox.launcher.Main";
        commandBuilder.append(" ").append(launcherClass).append(" ");
        commandBuilder.append(" -showsplash ");
        String command = commandBuilder.toString();
        log.log(Level.INFO, "----- > LAUNCH MEDOFFICE WITH < ---------");
        log.log(Level.INFO, "applicationDir=" + medoDir.getAbsolutePath());
        log.log(Level.INFO, "command=" + command);
        if (Util.isMac()) {
            if (MedoLauncher.haveCommand("-build-bat")) {
                File bat = new File(medoDir, "/medoffice.sh");
                Util.saveToFile(bat, command);
            }
            File file = File.createTempFile("launch", "sh");
            String script = "cd \"" + medoDir.getAbsolutePath() + "\"\n" + command.toString() + "\n";
            Util.saveToFile(file, script);
            file.setExecutable(true);
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", file.getAbsolutePath()});
            if (MedoLauncher.haveCommand("-build-bat")) {
                File fSh = new File(medoDir, "launch.sh");
                Util.saveToFile(fSh, script);
            }
        } else {
            if (MedoLauncher.haveCommand("-build-bat")) {
                File bat = new File(medoDir, "/medoffice.bat");
                Util.saveToFile(bat, command);
            }
            Process proc = Runtime.getRuntime().exec(command, null, medoDir);
        }
        log.log(Level.INFO, "----- > LAUNCH MEDOFFICE WITH < ---------");
    }

    public static void installMedoffice() throws Exception {
        Exception ex;
        block6: {
            final boolean isInstall = Config.getInstance().isMedofficeInstallThere(Config.getInstance().installFolder);
            MedoLauncher.checkAndFlagDownloading();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialog d = new DownloadProgressDialog();
                    if (!isInstall) {
                        d.setDialogTitleInstall();
                    }
                    monitor[0] = d;
                    d.getDialog().setLocationRelativeTo(null);
                    d.getDialog().setAlwaysOnTop(true);
                    d.getDialog().setVisible(true);
                }
            });
            ex = null;
            try {
                try {
                    Config.getInstance().installMedo(monitor[0]);
                }
                catch (Exception e) {
                    ex = e;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            monitor[0].getDialog().dispose();
                        }
                    });
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void checkAndFlagDownloading() throws Exception {
        Config config = Config.getInstance();
        File flagFile = new File(config.installFolder, "medoffice/installFlag.medoffice");
        if (flagFile.exists()) {
            String contain = Util.readFile(flagFile);
            long flagTime = Long.parseLong(contain);
            long diff = System.currentTimeMillis() - flagTime;
            if (diff < 120000L) {
                log.log(Level.SEVERE, "Try to launch twice the install!");
                throw new PopupInformationException("Une autre instance du lanceur est d\u00e9j\u00e0 en train d'installer ou de mettre \u00e0 jour Med-Office.");
            }
            Util.saveToFile(flagFile, "" + System.currentTimeMillis());
            flagFile.deleteOnExit();
        } else {
            Util.saveToFile(flagFile, "" + System.currentTimeMillis());
            flagFile.deleteOnExit();
        }
    }

    public static void installLauncher() throws Exception {
        Exception ex;
        block6: {
            log.log("-->Install launcher");
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialog d = new DownloadProgressDialog();
                    d.setDialogTitleInstall();
                    monitor[0] = d;
                    d.getDialog().setLocationRelativeTo(null);
                    d.getDialog().setAlwaysOnTop(true);
                    d.getDialog().setVisible(true);
                }
            });
            ex = null;
            try {
                try {
                    Config.getInstance().installLauncher(monitor[0]);
                }
                catch (Exception e) {
                    ex = e;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            monitor[0].getDialog().dispose();
                        }
                    });
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void downloadAndRelaunchLauncher() throws Exception {
        log.log("-- Will relauncher from somewhere else to be able to install launcher.");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DownloadProgressDialog d;
                monitor[0] = d = new DownloadProgressDialog();
                d.getDialog().setLocationRelativeTo(null);
                d.getDialog().setAlwaysOnTop(true);
                d.getDialog().setVisible(true);
            }
        });
        Exception ex = null;
        try {
            try {
                Config config = Config.getInstance();
                SiteProvider provider = config.launcherSiteProvider;
                List<FileDiff.FileWrap> toDownloadFiles = config.launcherDiff.getToDownloadFiles();
                toDownloadFiles.addAll(config.launcherDiff.getToUpdateFiles());
                if (toDownloadFiles.isEmpty()) {
                    throw new QuietException("We are in process to download launcher for update and there is no file in launcherDiff.. Something gone wrong!");
                }
                FileDiff.FileWrap fw = toDownloadFiles.get(0);
                provider.reset();
                File fi = new File(new File(config.installFolder, "medoffice/temp"), fw.relPath);
                log.log("Will relaunch from " + fi.getAbsolutePath());
                if (fi.exists() && !fi.delete()) {
                    throw new QuietException("Unable to delete " + fi.getAbsolutePath() + " before downloading launcher there...");
                }
                config.downloadFile(fi, fw, monitor[0], provider);
                String cmd = "java -jar " + fi.getName() + " -wait -update-launcher";
                Runtime.getRuntime().exec(cmd, null, fi.getParentFile());
                throw new NotToSendException("Relaunching to update...");
            }
            catch (Exception e) {
                ex = e;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        monitor[0].getDialog().dispose();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        if (ex != null) {
            throw ex;
        }
    }

    private static boolean isInstallValid() throws Exception {
        return MedoLauncher.isInstallValid(false);
    }

    private static boolean isInstallValid(boolean throwErrorOnFalse) throws Exception {
        Config config;
        block9: {
            log.log(" -- IsInstallValid --");
            config = Config.getInstance();
            config.setMedoFilesDif();
            log.log("to del: " + config.medoDiff.getToDeleteFiles().size());
            log.log("to update: " + config.medoDiff.getToUpdateFiles().size());
            log.log("to download: " + config.medoDiff.getToDownloadFiles().size());
            if (config.medoDiff.getToDeleteFiles().size() != 0 || config.medoDiff.getToUpdateFiles().size() != 0 || config.medoDiff.getToDownloadFiles().size() != 0) break block9;
            return true;
        }
        try {
            if (throwErrorOnFalse) {
                String files = "L'installation ou la mise-\u00e0-jour de Med-Office a \u00e9chou\u00e9.\n\n\u00c0 supprimer (" + config.medoDiff.getToDeleteFiles().size() + ":\n";
                for (FileDiff.FileWrap f : config.medoDiff.getToDeleteFiles()) {
                    files = String.valueOf(files) + "\t" + (f.localFile == null ? "" : f.localFile.getName()) + "\n";
                }
                files = String.valueOf(files) + "\u00c0 mettre \u00e0 jour (" + config.medoDiff.getToUpdateFiles().size() + "):\n";
                for (FileDiff.FileWrap f : config.medoDiff.getToUpdateFiles()) {
                    files = String.valueOf(files) + "\t" + (f.localFile == null ? "" : f.localFile.getName()) + "\n";
                }
                files = String.valueOf(files) + "\u00c0 mettre \u00e0 t\u00e9l\u00e9charger (" + config.medoDiff.getToDownloadFiles().size() + "):\n";
                for (FileDiff.FileWrap f : config.medoDiff.getToDownloadFiles()) {
                    files = String.valueOf(files) + "\t" + (f.localFile == null ? "" : f.localFile.getName()) + "\n";
                }
                log.log(Level.SEVERE, "Installation is still not valid after update/install ofys.\n" + files);
                throw new PopupInformationException(files);
            }
        }
        catch (NoMoreDownloadProdiderException e) {
            boolean mustContinue = true;
            if (mustContinue) {
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return false;
    }

    private static boolean isLauncherValid() throws Exception {
        Config config = Config.getInstance();
        try {
            config.setLauncherFilesDif();
            if (config.launcherDiff.getToDeleteFiles().size() == 0 && config.launcherDiff.getToUpdateFiles().size() == 0 && config.launcherDiff.getToDownloadFiles().size() == 0) {
                return true;
            }
        }
        catch (NoMoreDownloadProdiderException e) {
            boolean mustContinue = true;
            if (mustContinue) {
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        log.log("Diff is : " + config.launcherDiff);
        return false;
    }

    private static boolean haveCommand(String command) {
        return config.getCommand(command) != null;
    }

    private static void findCommandAndExcute(String command) throws Exception {
        AbstractCommand c = config.getCommand(command);
        if (c != null) {
            log.log("Execute command '" + c + "'");
            c.execute();
        }
    }

    private static void startFrame() {
        frame = new JFrame("D\u00e9marrage de Med-Office...");
        frame.setUndecorated(true);
        final ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource("ca/infodata/launcher3/ressources/logo.png"));
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                g.drawImage(icon.getImage(), 0, 0, null);
                super.paintComponent(g);
            }
        };
        panel.setOpaque(false);
        Dimension sDm = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dDm = new Dimension(500, 330);
        int x = sDm.width / 2 - dDm.width / 2;
        int y = sDm.height / 2 - dDm.height / 2;
        frame.add(panel);
        frame.setBounds(x, y, dDm.width, dDm.height);
        frame.setVisible(true);
    }

    private static void checkVersion() throws Exception {
        boolean isNotOki = !MedoLauncher.isInstallValid();
        System.out.println("VERSION_CHECK_START");
        System.out.println("newVersionAvailable=" + isNotOki);
        System.out.println("mustUpdateNow=" + isNotOki);
        System.out.println("VERSION_CHECK_END");
        throw new NotToSendException("Checked-Version");
    }

    private static void checkJavaVersion() throws Exception {
        if (Util.isMac()) {
            Process vCheck = Runtime.getRuntime().exec("java -version");
            StreamGobbler sg = new StreamGobbler(vCheck.getInputStream(), vCheck.getErrorStream());
            sg.run();
            vCheck.waitFor();
            String versionOutput = sg.streamInString;
            log.log(Level.INFO, "cmd line : java -version: \n" + versionOutput);
            if (versionOutput.contains("\"1.6")) {
                log.log(Level.INFO, "User have a bad version of java and must install java 1.7");
                JOptionPane.showMessageDialog(null, "Vous avez pr\u00e9sentement Java 1.6 qui est utilis\u00e9 pour lancer MED-Office. \nVous devez installer Java 1.7 ( http://www.medoffice.ca/download.html ).\n\nApr\u00e8s l'installation de de Java 1.7, relancer MED-Office.");
                throw new QuietException("This user have to update his Java");
            }
            log.log(Level.INFO, "User have a good version of java.");
        }
    }
}

