/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.download;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class UrlUtil {
    private static final Logger logger = Logger.getLogger(UrlUtil.class.getName());
    private static HostnameVerifier initialDefaultHostnameVerifier;
    private static SSLSocketFactory initialDefaultSSLSocketFactory;

    public static void configureHttpsTrustStore() {
        System.setProperty("jsse.enableSNIExtension", "false");
        try {
            InputStream fis = UrlUtil.class.getClassLoader().getResourceAsStream("ca/infodata/launcher3/download/certificates/truststore.jks");
            KeyStore trustStore = KeyStore.getInstance("JKS", "SUN");
            trustStore.load(fis, "infodata".toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, tmf.getTrustManagers(), new SecureRandom());
            SSLSocketFactory factory = context.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(factory);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to trustAllHttpsServerCertificate", ex);
        }
    }

    public static void trustAllHttpsServerCertificate() {
        try {
            if (initialDefaultSSLSocketFactory == null) {
                initialDefaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            }
            if (initialDefaultHostnameVerifier == null) {
                initialDefaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            }
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new AllowAllTrustManager()}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(factory);
            HttpsURLConnection.setDefaultHostnameVerifier(new IgnoreHostNameVerifier());
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to trustAllHttpsServerCertificate", ex);
        }
    }

    private static class IgnoreHostNameVerifier
    implements HostnameVerifier {
        private IgnoreHostNameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class AllowAllTrustManager
    implements X509TrustManager,
    TrustManager {
        private AllowAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

