/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config.command;

import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.Config;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.config.command.AbstractCommand;
import ca.infodata.launcher3.exception.NotToSendException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class KnowInstallCommand
extends AbstractCommand {
    @Override
    public String getCommandName() {
        return "-know-install";
    }

    @Override
    public int getMaxParameter() {
        return 0;
    }

    @Override
    public boolean isValidParameter(String value) {
        return false;
    }

    @Override
    public void execute(Config config) throws Exception {
        LauncherLogger log = LauncherLogger.getInstance(null);
        log.log(Level.SEVERE, "--Installation information--");
        log.log(Level.INFO, "-----------------------------------------------");
        log.log(Level.INFO, "--  know-install  ---");
        log.log(Level.INFO, "-----------------------------------------------");
        log.log(Level.INFO, "-- List of file in install path --");
        String pathInfo = "";
        for (String s : Util.listFileRecursiveFromDirectory(new File(config.getInstallFolder(), "Ofys"))) {
            pathInfo = pathInfo + s + "\n";
        }
        log.log(Level.INFO, pathInfo);
        log.log(Level.INFO, "-- JVM memory usage --");
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        log.log(Level.INFO, "free memory: " + format.format(freeMemory / 1024L));
        log.log(Level.INFO, "allocated memory: " + format.format(allocatedMemory / 1024L));
        log.log(Level.INFO, "max memory: " + format.format(maxMemory / 1024L));
        log.log(Level.INFO, "total free memory: " + format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L));
        if (Util.isWindows()) {
            log.log(Level.INFO, "-- List active task --");
            try {
                String line;
                Process p = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\tasklist.exe");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    log.log(Level.INFO, line);
                }
                input.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        Properties env = System.getProperties();
        log.log("--JAVA SYSTEM ENVIRONMENTS KEYS--");
        for (Object key : env.keySet()) {
            log.log(KnowInstallCommand.regulateStringLength((String)key) + "\t:\t" + env.get(key));
        }
        log.log("\n\n");
        Map<String, String> env2 = System.getenv();
        log.log("--SYSTEM ENVIRONMENTS KEYS--");
        for (String key : env2.keySet()) {
            log.log(KnowInstallCommand.regulateStringLength(key) + "\t:\t" + env.get(key));
        }
        throw new NotToSendException("Command -know-install executed.");
    }

    @Override
    public String getHelpDescription() {
        return "Show environment basic datas and running states.";
    }

    @Override
    public Map<String, String> getHelpParameters() {
        return new HashMap<String, String>();
    }

    private static String regulateStringLength(String orig) {
        return KnowInstallCommand.regulateStringLength(orig, 30);
    }

    private static String regulateStringLength(String orig, int length) {
        while (orig.length() < length) {
            orig = orig + " ";
        }
        return orig;
    }
}

