/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LauncherLogFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = "\n";

    @Override
    public String format(LogRecord record) {
        StringBuilder b = new StringBuilder(2000);
        b.append("<" + record.getLevel().getLocalizedName() + ">");
        if (record.getThrown() != null) {
            b.append(LINE_SEPARATOR);
            b.append(this.formatThrowable(record.getThrown()));
        } else {
            b.append(record.getMessage());
        }
        b.append(LINE_SEPARATOR);
        return b.toString();
    }

    private String formatThrowable(Throwable err) {
        if (err == null) {
            return "";
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            err.printStackTrace(pw);
            pw.close();
            return sw.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

