/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3;

import ca.infodata.launcher3.config.Config;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.download.CancelException;
import ca.infodata.launcher3.exception.NotToSendException;
import ca.infodata.launcher3.exception.PopupInformationException;
import ca.infodata.launcher3.exception.PopupInformationWithQuestionException;
import ca.infodata.launcher3.exception.QuietException;
import java.util.logging.Level;
import javax.swing.JOptionPane;

public class OfysLauncherTest
extends Config {
    protected OfysLauncherTest() throws Exception {
        super("ofystest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        logger = LauncherLogger.getInstance(null);
        Exception errToDiffer = null;
        try {
            config = Config.getInstance("ofystest", args);
            LauncherLogger.setConfig(config);
        }
        catch (Exception e) {
            try {
                errToDiffer = e;
                logger.init();
                logger.log(Level.SEVERE, e);
            }
            catch (Exception e1) {
                errToDiffer = e1;
                e1.printStackTrace();
            }
        }
        try {
            if (errToDiffer != null) {
                throw errToDiffer;
            }
            logger.log("List arguments: ");
            for (String s : args) {
                logger.log("  " + s);
            }
            OfysLauncherTest.findCommandAndExcute("-wait");
            OfysLauncherTest.findCommandAndExcute("-create-shortcut");
            OfysLauncherTest.findCommandAndExcute("-build-proxy");
            OfysLauncherTest.findCommandAndExcute("-know-install");
            OfysLauncherTest.findCommandAndExcute("-help");
            OfysLauncherTest.findCommandAndExcute("-h");
            OfysLauncherTest.findCommandAndExcute("-change-langage");
            OfysLauncherTest.findCommandAndExcute("-launch-direct");
            OfysLauncherTest.findCommandAndExcute("-no-shortcut");
            OfysLauncherTest.findCommandAndExcute("-update-ofys");
            if (OfysLauncherTest.haveCommand("-check-version") || OfysLauncherTest.haveCommand("-versioninfo")) {
                OfysLauncherTest.checkVersion();
            } else if (OfysLauncherTest.haveCommand("-skip-validation") || OfysLauncherTest.haveCommand("-launch-direct")) {
                OfysLauncherTest.startFrame();
                OfysLauncherTest.launchOfys();
            } else {
                OfysLauncherTest.startFrame();
                if (OfysLauncherTest.haveCommand("-update-launcher") || OfysLauncherTest.haveCommand("-updatelaunchercopy")) {
                    OfysLauncherTest.updateLauncher();
                } else {
                    OfysLauncherTest.cleanUpdateFolder();
                }
                OfysLauncherTest.checkLauncher();
                if (!OfysLauncherTest.isInstallValid()) {
                    logger.log("Installation is not valid.  Update/install ofys.");
                    OfysLauncherTest.installOfys();
                    OfysLauncherTest.isInstallValid(true);
                    OfysLauncherTest.launchOfys();
                } else {
                    OfysLauncherTest.launchOfys();
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof NotToSendException) {
                logger.log(Level.INFO, "Something gone wrong... but it's not so important:", ex);
            } else if (ex instanceof PopupInformationWithQuestionException) {
                logger.log(Level.SEVERE, ex);
                Object[] choices = new String[]{"Lancer Ofys", "Annuler"};
                int response = JOptionPane.showOptionDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Ofys", 1, -1, null, choices, "Annuler");
                if (response == 0) {
                    try {
                        logger.log(Level.WARNING, "Va quand meme tenter de lancer ofys");
                        OfysLauncherTest.launchOfys();
                    }
                    catch (Exception exception) {}
                }
            } else if (ex instanceof PopupInformationException) {
                logger.log(Level.SEVERE, ex);
                JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Ofys", 0);
            } else if (ex instanceof QuietException) {
                logger.log(Level.SEVERE, ex);
            } else if (ex instanceof CancelException) {
                logger.log(Level.WARNING, "CANCEL THE DONWLOAD", ex);
            } else {
                logger.log(Level.SEVERE, ex);
                JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Ofys", 0);
            }
        }
        finally {
            if (OfysLauncherTest.haveCommand("-no-flush")) {
                logger.log("Log are in " + OfysLauncherTest.logger.logFolder.getAbsolutePath());
            } else {
                logger.flush();
            }
            if (frame != null) {
                frame.dispose();
            }
        }
    }
}

