/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3;

import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.Config;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.download.CancelException;
import ca.infodata.launcher3.download.DownloadProgressDialog;
import ca.infodata.launcher3.exception.NotToSendException;
import ca.infodata.launcher3.exception.PopupInformationException;
import ca.infodata.launcher3.exception.PopupInformationWithQuestionException;
import ca.infodata.launcher3.exception.QuietException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JOptionPane;

public class OfysLauncher
extends Config {
    private static final DownloadProgressDialog[] monitor = new DownloadProgressDialog[1];

    protected OfysLauncher() throws Exception {
        super("ofys");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        logger = LauncherLogger.getInstance(null);
        Exception errToDiffer = null;
        try {
            config = Config.getInstance("ofys", args);
            LauncherLogger.setConfig(config);
        }
        catch (Exception e) {
            try {
                errToDiffer = e;
                logger.init();
                logger.log(Level.SEVERE, e);
            }
            catch (Exception e1) {
                errToDiffer = e1;
                e1.printStackTrace();
            }
        }
        try {
            if (errToDiffer != null) {
                throw errToDiffer;
            }
            logger.log("List arguments: ");
            for (String s : args) {
                logger.log("  " + s);
            }
            OfysLauncher.findCommandAndExcute("-wait");
            OfysLauncher.findCommandAndExcute("-create-shortcut");
            OfysLauncher.findCommandAndExcute("-build-proxy");
            OfysLauncher.findCommandAndExcute("-know-install");
            OfysLauncher.findCommandAndExcute("-help");
            OfysLauncher.findCommandAndExcute("-h");
            OfysLauncher.findCommandAndExcute("-change-langage");
            OfysLauncher.findCommandAndExcute("-launch-direct");
            OfysLauncher.findCommandAndExcute("-no-shortcut");
            OfysLauncher.findCommandAndExcute("-update-ofys");
            if (OfysLauncher.haveCommand("-check-version") || OfysLauncher.haveCommand("-versioninfo")) {
                OfysLauncher.checkVersion();
            } else if (OfysLauncher.haveCommand("-skip-validation") || OfysLauncher.haveCommand("-launch-direct")) {
                OfysLauncher.startFrame();
                OfysLauncher.launchOfys();
            } else {
                OfysLauncher.startFrame();
                if (OfysLauncher.haveCommand("-update-launcher") || OfysLauncher.haveCommand("-updatelaunchercopy")) {
                    OfysLauncher.updateLauncher();
                } else {
                    OfysLauncher.cleanUpdateFolder();
                }
                OfysLauncher.checkLauncher();
                if (!OfysLauncher.isInstallValid()) {
                    logger.log("Installation is not valid.  Update/install ofys.");
                    OfysLauncher.installOfys();
                    OfysLauncher.isInstallValid(true);
                    OfysLauncher.launchOfys();
                } else {
                    OfysLauncher.launchOfys();
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof NotToSendException) {
                logger.log(Level.INFO, "Something gone wrong... but it's not so important:", ex);
            } else if (ex instanceof PopupInformationWithQuestionException) {
                logger.log(Level.SEVERE, ex);
                Object[] choices = new String[]{"Lancer Ofys", "Annuler"};
                int response = JOptionPane.showOptionDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Ofys", 1, -1, null, choices, "Annuler");
                if (response == 0) {
                    try {
                        logger.log(Level.WARNING, "Va quand meme tenter de lancer ofys");
                        OfysLauncher.launchOfys();
                    }
                    catch (Exception exception) {}
                }
            } else if (ex instanceof PopupInformationException) {
                logger.log(Level.SEVERE, ex);
                JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Ofys", 0);
            } else if (ex instanceof QuietException) {
                logger.log(Level.SEVERE, ex);
            } else if (ex instanceof CancelException) {
                logger.log(Level.WARNING, "CANCEL THE DONWLOAD", ex);
            } else {
                logger.log(Level.SEVERE, ex);
                JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Ofys", 0);
            }
        }
        finally {
            if (OfysLauncher.haveCommand("-no-flush")) {
                logger.log("Log are in " + OfysLauncher.logger.logFolder.getAbsolutePath());
            } else {
                logger.flush();
            }
            if (frame != null) {
                frame.dispose();
            }
        }
    }

    public static void launchOfys() throws Exception {
        Process proc;
        File bat;
        config.saveLangageFile();
        File ofysDir = config.getRootFolder();
        logger.log("Lancement d'Ofys");
        String options = "";
        String javaExe = "java.exe";
        String binFolder = "";
        String[] searchJavaFolder = null;
        if (Util.isWindows()) {
            options = options + "-Xms256m -Xmx896m";
            searchJavaFolder = new String[]{"C:/Program Files/Zulu", "C:/Program Files/Java", "C:/Program Files (x86)/Java"};
            binFolder = "/bin/";
        } else if (Util.isMac()) {
            options = options + " -XstartOnFirstThread -Xms256m -Xmx896m -XX:MaxPermSize=256m -Xdock:icon=\"" + ofysDir + "/Ofys/appIcon.icns\" -Dorg.eclipse.swt.internal.carbon.smallFonts";
            searchJavaFolder = new String[]{"/Library/Java/JavaVirtualMachines"};
            binFolder = "/Contents/Home/bin/";
            javaExe = "java";
        }
        if (searchJavaFolder == null) {
            logger.log(Level.SEVERE, "----- > searchJavaFolder is null (is not windows nor mac!) < ---------");
            return;
        }
        boolean foundIt = false;
        for (void var9_11 : searchJavaFolder) {
            logger.log(Level.INFO, "Looking for Java in: " + (String)var9_11);
            Iterator file = new File((String)var9_11);
            if (((File)((Object)file)).isDirectory()) {
                File[] fileArray = ((File)((Object)file)).listFiles();
                ArrayList<File> lstFiles = new ArrayList<File>();
                lstFiles.addAll(Arrays.asList(fileArray));
                lstFiles.sort(new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        if (o1.lastModified() > o2.lastModified()) {
                            return -1;
                        }
                        if (o1.lastModified() < o2.lastModified()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                for (File ff : lstFiles) {
                    String f = ff.getName();
                    logger.log(Level.INFO, "Java found:" + f);
                    if (f.indexOf("zulu-8") <= -1 && f.indexOf("1.8.0") <= -1 || !new File(javaExe = (String)var9_11 + "/" + f + binFolder + javaExe).exists()) continue;
                    foundIt = true;
                    logger.log(Level.INFO, "Java selected: " + javaExe);
                    javaExe = "\"" + javaExe + "\"";
                    break;
                }
            }
            if (foundIt) break;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("osgi.bundles", "javax.annotation@1:start,javax.annotation-api@1:start,org.eclipse.equinox.ds@1:start,org.eclipse.osgi.services@1:start,org.eclipse.osgi.util@1:start,org.apache.felix.scr@1:start,javax.ws.rs.jsr311-api@-1:start,com.sun.jersey.core@1:start,com.sun.jersey.client@1:start,com.sun.jersey.contribs.jersey-apache-client4@1:start,org.eclipse.equinox.common@2:start,org.eclipse.osgi@-1:start,org.eclipse.update.configurator@3:start,org.eclipse.core.runtime@start");
        env.put("osgi.clean", "true");
        env.put("osgi.configuration.area", ofysDir + OfysLauncher.config.getConfigFileManager().configFileName);
        env.put("osgi.instance.area", ofysDir + "/instance");
        env.put("osgi.sharedConfiguration.area", ofysDir + "/shared");
        env.put("osgi.user.area", ofysDir + "/user");
        env.put("eclipse.ee.install.verify", "true");
        env.put("eclipse.product", "ca.infodata.ofys.ui.intro.product");
        env.put("osgi.splashPath", "platform:/base/plugins/ca.infodata.ofys.ui.intro");
        config.getOfysProperties().putAll((Map<?, ?>)env);
        ArrayList<String> classpath = new ArrayList<String>();
        String launcherJar = Util.findFileNoVersionRecursive2(ofysDir, "org.eclipse.equinox.launcher_");
        classpath.add(launcherJar);
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append(javaExe);
        stringBuilder.append(" ").append(options);
        for (Map.Entry entry : config.getOfysProperties().entrySet()) {
            stringBuilder.append(" -D").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        stringBuilder.append(" -classpath \"");
        for (String string : classpath) {
            if (string == null || "null".equals(string)) continue;
            stringBuilder.append(string).append(";");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("\" ");
        String launcherClass = "org.eclipse.equinox.launcher.Main";
        stringBuilder.append(" ").append(launcherClass).append(" ");
        stringBuilder.append(" -name Ofys -persistState false -clearPersistedState");
        if (Util.isWindows()) {
            stringBuilder.append(" -showsplash");
        } else if (Util.isMac()) {
            stringBuilder.append(" -nosplash");
        }
        String string = stringBuilder.toString();
        logger.log(Level.INFO, "----- > LAUNCH OFYS WITH < ---------");
        logger.log(Level.INFO, "applicationDir=" + ofysDir.getAbsolutePath());
        logger.log(Level.INFO, "command=" + string);
        if (Util.isMac()) {
            if (OfysLauncher.haveCommand("-build-bat")) {
                bat = new File(ofysDir, "/ofys.sh");
                Util.saveToFile(bat, string);
            }
            File file = File.createTempFile("launch", "sh");
            String script = "cd \"" + ofysDir.getAbsolutePath() + "\"\n" + string.toString() + "\n";
            Util.saveToFile(file, script);
            file.setExecutable(true);
            proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", file.getAbsolutePath()});
        } else {
            if (OfysLauncher.haveCommand("-build-bat")) {
                bat = new File(ofysDir, "/ofys.bat");
                Util.saveToFile(bat, string);
            }
            proc = Runtime.getRuntime().exec(string, null, ofysDir);
        }
        logger.log(Level.INFO, "----- > LAUNCH OFYS WITH < ---------");
    }
}

