/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.util;

import ca.infodata.launcher3.config.LauncherLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Unzip {
    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static final void unzip(File fileToUnzip, File goToFile) {
        if (fileToUnzip == null || !fileToUnzip.exists() || !goToFile.exists()) {
            System.err.println("## Usage: Unzip zipfile or not existing :" + fileToUnzip);
            return;
        }
        try {
            ZipFile zipFile = new ZipFile(fileToUnzip);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    LauncherLogger.getInstance(null).log(Level.INFO, "Extracting directory: " + entry.getName());
                    LauncherLogger.getInstance(null).log(Level.INFO, "\t\t\t" + new File(goToFile, entry.getName()));
                    new File(goToFile, entry.getName()).mkdir();
                    continue;
                }
                LauncherLogger.getInstance(null).log(Level.INFO, "Extracting file: " + entry.getName());
                Unzip.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(goToFile.getAbsoluteFile() + "/" + entry.getName())));
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            LauncherLogger.getInstance(null).log(Level.SEVERE, "Unhandled exception:", ioe);
            return;
        }
    }
}

