/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.download;

import ca.infodata.launcher.util.SyncProgressMonitor;
import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.download.STATUS;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Observable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class StringDownload
extends Observable
implements Runnable {
    private static final int MAX_BUFFER_SIZE = 1024;
    private static final int MAX_RETRY = 3;
    private static final int TIME_BEFORE_RETRY = 1000;
    private URL from;
    private String description;
    private int numberOfRetry;
    private STATUS status;
    private long downloaded;
    private int size;
    private ByteArrayOutputStream outputStream;
    private String contentEncoding;
    private SyncProgressMonitor monitor;

    public StringDownload(URL url, String description) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.from = url;
        this.description = description;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.setStatus(STATUS.UNDEFINED);
        InputStream stream = null;
        SyncProgressMonitor monitor = this.getMonitor();
        try {
            try {
                monitor.setCurrentFile(this.description);
                monitor.setCurrentFileTotalBytes(null);
                monitor.setCurrentFileWorkedBytes(null);
                monitor.setDownloadSpeed(null);
                LauncherLogger.getInstance().log(Level.INFO, "will download from " + this.from + " to memory");
                this.downloaded = 0L;
                this.setStatus(STATUS.CONNECTING);
                HttpURLConnection connection = (HttpURLConnection)this.from.openConnection();
                connection.setDefaultUseCaches(false);
                connection.setUseCaches(false);
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode / 100 != 2) {
                    LauncherLogger.getInstance().log(Level.WARNING, String.valueOf(responseCode) + " connection.getResponseCode() / 100 != 2");
                    this.setStatus(STATUS.ERROR);
                    if (this.numberOfRetry < 3) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++this.numberOfRetry;
                        monitor.setMessage("Erreur " + responseCode + ". Essai " + this.numberOfRetry);
                        this.run();
                    } else {
                        monitor.setMessage("Erreur " + responseCode + ". Abandon");
                    }
                }
                this.size = connection.getContentLength();
                if (this.size < 1) {
                    LauncherLogger.getInstance().log(Level.WARNING, "size < 1");
                    this.setStatus(STATUS.ERROR);
                    if (this.numberOfRetry < 3) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++this.numberOfRetry;
                        monitor.setMessage("Erreur size < 1. Essai " + this.numberOfRetry);
                        this.run();
                    } else {
                        monitor.setMessage("Erreur size < 1. Abandon");
                    }
                }
                if (this.outputStream == null) {
                    this.outputStream = new ByteArrayOutputStream(this.size);
                } else {
                    this.outputStream.reset();
                }
                this.contentEncoding = connection.getContentEncoding();
                if (this.contentEncoding == null) {
                    this.contentEncoding = "UTF-8";
                }
                monitor.setCurrentFileTotalBytes(Long.valueOf(this.size));
                monitor.setCurrentFileWorkedBytes(this.downloaded);
                LauncherLogger.getInstance().log(Level.INFO, "content length to download=" + this.size);
                stream = connection.getInputStream();
                LauncherLogger.getInstance().log(Level.INFO, "downloading");
                this.setStatus(STATUS.DOWNLOADING);
                long start = System.nanoTime();
                while (this.getStatus() == STATUS.DOWNLOADING) {
                    if (monitor.isCanceled()) {
                        this.setStatus(STATUS.CANCEL);
                        return;
                    } else {
                        byte[] buffer = (long)this.size - this.downloaded > 1024L ? new byte[1024] : new byte[(int)((long)this.size - this.downloaded)];
                        int read = stream.read(buffer);
                        int readTry = -1;
                        while (read == -1) {
                            if (monitor.isCanceled()) {
                                this.setStatus(STATUS.CANCEL);
                                break;
                            }
                            if (this.downloaded < (long)this.size && readTry < 3) {
                                Thread.sleep(500L);
                                monitor.setMessage("Erreur -1. Essai " + ++readTry);
                                read = stream.read(buffer);
                                continue;
                            }
                            read = -100;
                            monitor.setMessage("Erreur -100. Abandon");
                            break;
                        }
                        if (read == -100) {
                            LauncherLogger.getInstance().log(Level.WARNING, "read == -1 ; buffer.length = " + buffer.length);
                            this.setStatus(STATUS.ERROR);
                            return;
                        } else {
                            this.outputStream.write(buffer, 0, read);
                            this.downloaded += (long)read;
                            monitor.setCurrentFileWorkedBytes(this.downloaded);
                            long end = System.nanoTime();
                            long speed = TimeUnit.SECONDS.toNanos(1L) * this.downloaded / (end - start);
                            monitor.setDownloadSpeed(speed);
                            this.stateChanged();
                            if (this.downloaded < (long)this.size) continue;
                            monitor.setCurrentFileWorkedBytes(Long.valueOf(this.size));
                            this.setStatus(STATUS.COMPLETE);
                        }
                    }
                    return;
                }
                return;
            }
            catch (SocketTimeoutException e) {
                monitor.setMessage("La connection n'a pas pu s'\u00e9tablir dans un d\u00e9lai de 10 secondes ou moins");
                LauncherLogger.getInstance().log(Level.SEVERE, "Failed to download file from url " + this.from, e);
                if (stream == null) return;
                try {
                    stream.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (Exception e) {
                monitor.setMessage(Util.formatException(e));
                LauncherLogger.getInstance().log(Level.SEVERE, "Failed to download file from url " + this.from, e);
                if (stream == null) return;
                try {
                    stream.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getString() throws Exception {
        if (this.getStatus() == STATUS.COMPLETE) {
            return this.outputStream == null ? null : this.outputStream.toString(this.contentEncoding);
        }
        return null;
    }

    public byte[] getBytes() {
        if (this.getStatus() == STATUS.COMPLETE) {
            return this.outputStream.toByteArray();
        }
        return null;
    }

    private void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    public URL getFrom() {
        return this.from;
    }

    public STATUS getStatus() {
        return this.status;
    }

    protected void setStatus(STATUS status) {
        this.status = status;
        this.stateChanged();
    }

    public void setMonitor(SyncProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public SyncProgressMonitor getMonitor() {
        return this.monitor;
    }
}

