/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config;

import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.LauncherLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;

public class ConfigFileManager {
    private ArrayList<File> configFiles = new ArrayList();
    private File installFile;
    public String configFileName;

    public ConfigFileManager(File installFile) {
        this.installFile = installFile;
        this.configFileName = "/configuration";
    }

    private void findConfigFiles() {
        File[] files = this.installFile.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory() && f.getName().startsWith("configuration")) {
                    this.configFiles.add(f);
                }
                ++n2;
            }
        }
    }

    public void setConfigPropFromFoundFiles() {
        this.findConfigFiles();
        File f = this.getMustRecentConfigFolder();
        if (f != null) {
            this.configFileName = "/" + f.getName();
        }
    }

    private File getMustRecentConfigFolder() {
        File f = null;
        for (File ff : this.configFiles) {
            if (f != null && f.lastModified() >= ff.lastModified()) continue;
            f = ff;
        }
        return f;
    }

    public int getNumberOfFile() {
        return this.configFiles.size();
    }

    public void tryToFlushAllConfigs() throws Exception {
        boolean allDelete = true;
        for (File ff : this.configFiles) {
            boolean delF = Util.deleteDirectory(ff);
            LauncherLogger.getInstance().log(Level.INFO, "Try to delete config file '" + ff.getName() + "' : " + delF);
            boolean bl = allDelete = allDelete && delF;
        }
        this.configFileName = allDelete ? "/configuration" : "/configuration" + Util.randFileSuffix(5);
    }

    public void tryToFlushAllConfigsButNotLast() throws Exception {
        File f = this.getMustRecentConfigFolder();
        boolean allDelete = true;
        for (File ff : this.configFiles) {
            if (ff == f) continue;
            boolean delF = Util.deleteDirectory(ff);
            LauncherLogger.getInstance().log(Level.INFO, "Try to delete config file '" + ff.getName() + "' : " + delF);
            boolean bl = allDelete = allDelete && delF;
        }
        if (!allDelete) {
            LauncherLogger.getInstance().log(Level.SEVERE, new Exception("Unable to delete old unused folder"));
        }
    }

    public void logConfigFiles() {
        LauncherLogger.getInstance().log(Level.INFO, "List of Ofys config folders:");
        for (File ff : this.configFiles) {
            LauncherLogger.getInstance().log(Level.INFO, "\t-" + ff.getName());
        }
    }
}

