/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3;

import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.Config;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.config.Version;
import ca.infodata.launcher3.config.VersionDiff;
import ca.infodata.launcher3.config.command.AbstractCommand;
import ca.infodata.launcher3.download.CancelException;
import ca.infodata.launcher3.download.DownloadProgressDialog;
import ca.infodata.launcher3.download.Resource;
import ca.infodata.launcher3.exception.NoMoreDownloadProdiderException;
import ca.infodata.launcher3.exception.NotToSendException;
import ca.infodata.launcher3.exception.PopupInformationException;
import ca.infodata.launcher3.exception.PopupInformationWithQuestionException;
import ca.infodata.launcher3.exception.QuietException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class OfysLauncher {
    public static final String LAUNCHER_VERSION = "4.3";
    public static final String CONFIG_FILE = "ca/infodata/launcher3/ressources/config.properties";
    public static JFrame frame;
    public static Config config;
    public static LauncherLogger log;
    private static final DownloadProgressDialog[] monitor;

    static {
        monitor = new DownloadProgressDialog[1];
    }

    public static void main(String[] args) {
        block35: {
            log = LauncherLogger.getInstance();
            Exception errToDiffer = null;
            try {
                config = Config.init(args);
            }
            catch (Exception e) {
                try {
                    errToDiffer = e;
                    log.init();
                    log.log(Level.SEVERE, e);
                }
                catch (Exception e1) {
                    errToDiffer = e1;
                    e1.printStackTrace();
                }
            }
            try {
                try {
                    if (errToDiffer != null) {
                        throw errToDiffer;
                    }
                    log.log("List arguments: ");
                    String[] stringArray = args;
                    int n = args.length;
                    int e1 = 0;
                    while (e1 < n) {
                        String s = stringArray[e1];
                        log.log("  " + s);
                        ++e1;
                    }
                    OfysLauncher.findCommandAndExcute("-wait");
                    OfysLauncher.findCommandAndExcute("-create-shortcut");
                    OfysLauncher.findCommandAndExcute("-build-proxy");
                    OfysLauncher.findCommandAndExcute("-know-install");
                    OfysLauncher.findCommandAndExcute("-help");
                    OfysLauncher.findCommandAndExcute("-h");
                    OfysLauncher.findCommandAndExcute("-change-langage");
                    OfysLauncher.findCommandAndExcute("-launch-direc");
                    OfysLauncher.findCommandAndExcute("-no-shortcut");
                    OfysLauncher.findCommandAndExcute("-update-ofys");
                    if (OfysLauncher.haveCommand("-check-version") || OfysLauncher.haveCommand("-versioninfo")) {
                        OfysLauncher.checkVersion();
                        break block35;
                    }
                    if (OfysLauncher.haveCommand("-skip-validation") || OfysLauncher.haveCommand("-launch-direct")) {
                        OfysLauncher.startFrame();
                        OfysLauncher.launchOfys();
                        break block35;
                    }
                    OfysLauncher.startFrame();
                    if (OfysLauncher.haveCommand("-update-launcher") || OfysLauncher.haveCommand("-updatelaunchercopy")) {
                        OfysLauncher.updateLauncher();
                    } else {
                        OfysLauncher.cleanUpdateFolder();
                    }
                    OfysLauncher.checkLauncher();
                    if (!OfysLauncher.isInstallValid()) {
                        log.log("Installation is not valid.  Update/install ofys.");
                        OfysLauncher.installOfys();
                        OfysLauncher.isInstallValid(true);
                        OfysLauncher.launchOfys();
                        break block35;
                    }
                    OfysLauncher.launchOfys();
                }
                catch (Exception ex) {
                    if (ex instanceof NotToSendException) {
                        log.log(Level.INFO, "Something gone wrong... but it's not so important:", ex);
                    } else if (ex instanceof PopupInformationWithQuestionException) {
                        log.log(Level.SEVERE, ex);
                        Object[] choices = new String[]{"Lancer Ofys", "Annuler"};
                        int response = JOptionPane.showOptionDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Ofys", 1, -1, null, choices, "Annuler");
                        if (response == 0) {
                            try {
                                log.log(Level.WARNING, "Va quand meme tenter de lancer ofys");
                                OfysLauncher.launchOfys();
                            }
                            catch (Exception exception) {}
                        }
                    } else if (ex instanceof PopupInformationException) {
                        log.log(Level.SEVERE, ex);
                        JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Ofys", 0);
                    } else if (ex instanceof QuietException) {
                        log.log(Level.SEVERE, ex);
                    } else if (ex instanceof CancelException) {
                        log.log(Level.WARNING, "CANCEL THE DONWLOAD", ex);
                    } else {
                        log.log(Level.SEVERE, ex);
                        JOptionPane.showMessageDialog(null, "Un probl\u00e8me est survenu:\n" + ex.getMessage(), "Lancement Ofys", 0);
                    }
                    if (OfysLauncher.haveCommand("-no-flush")) {
                        log.log("Log are in " + OfysLauncher.log.logFolder.getAbsolutePath());
                    } else {
                        log.flush();
                    }
                    if (frame != null) {
                        frame.dispose();
                    }
                }
            }
            finally {
                if (OfysLauncher.haveCommand("-no-flush")) {
                    log.log("Log are in " + OfysLauncher.log.logFolder.getAbsolutePath());
                } else {
                    log.flush();
                }
                if (frame != null) {
                    frame.dispose();
                }
            }
        }
    }

    private static void cleanUpdateFolder() throws Exception {
        File f2;
        File f = Config.getInstance().updateFolder;
        if (f.exists() && !Util.deleteDirectory(f)) {
            log.log(Level.WARNING, "Unable to remove temporary launcher in " + f.getAbsolutePath());
        }
        if ((f2 = Config.getInstance().oldUpdateFolder).exists() && !Util.deleteDirectory(f2)) {
            log.log(Level.WARNING, "Unable to remove temporary launcher in " + f2.getAbsolutePath());
        }
    }

    private static void updateLauncher() throws Exception {
        Config config = Config.getInstance();
        String sPath = System.getProperty("java.class.path");
        File oFile = new File(sPath);
        File dFile = new File(config.launcherFolder, "OfysLauncher.jar");
        if (dFile.exists() && !dFile.delete() || !oFile.exists()) {
            log.log(Level.WARNING, "Failed to delete at first attemp " + dFile.getAbsolutePath() + " (" + dFile.exists() + ") or does not exist (" + oFile.exists() + ") " + oFile.getAbsolutePath());
            Thread.sleep(3000L);
            if (dFile.exists() && !dFile.delete() || !oFile.exists()) {
                log.log(Level.SEVERE, "Failed to delete " + dFile.getAbsolutePath() + " (" + dFile.exists() + ") or does not exist (" + oFile.exists() + ") " + oFile.getAbsolutePath());
                throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur Ofys.");
            }
        }
        oFile.deleteOnExit();
        if (!Util.copyFile(oFile, dFile)) {
            log.log(Level.SEVERE, "Failed to copy " + oFile.getAbsolutePath() + " to " + dFile.getAbsolutePath());
            throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur Ofys.");
        }
        if (!dFile.exists()) {
            log.log(Level.SEVERE, "Failed to copy somehow " + oFile.getAbsolutePath() + " to " + dFile.getAbsolutePath());
            throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur Ofys.");
        }
        log.log(String.valueOf(dFile.getAbsolutePath()) + " is now existing!");
    }

    private static void checkLauncher() throws Exception {
        boolean isOki = false;
        boolean hasCheckValid = false;
        File launcher = new File(Config.getInstance().launcherFolder, "OfysLauncher.jar");
        log.log("--> Check if launcher is valid (" + launcher.getAbsolutePath() + ")");
        if (launcher.exists()) {
            hasCheckValid = true;
            if (OfysLauncher.isLauncherValid()) {
                isOki = true;
            }
        }
        log.log("launcher is oki? " + isOki);
        log.log("launcher is checked? " + hasCheckValid);
        if (!isOki) {
            if (!hasCheckValid) {
                OfysLauncher.isLauncherValid();
            }
            if (launcher.exists() && !launcher.delete()) {
                OfysLauncher.downloadAndRelaunchLauncher();
            }
            OfysLauncher.installLauncher();
        }
    }

    public static void launchOfys() throws Exception {
        Config config = Config.getInstance();
        config.saveLangageFile();
        File ofysDir = config.rootFolder;
        log.log("Lancement d'Ofys");
        String options = "";
        if (Util.isWindows()) {
            options = String.valueOf(options) + "-Xms256m -Xmx896m";
        } else if (Util.isMac()) {
            options = String.valueOf(options) + "-XstartOnFirstThread -Xms256m -Xmx896m -XX:MaxPermSize=256m -Xdock:icon=\"" + ofysDir + "/Ofys/appIcon.icns\" -Dorg.eclipse.swt.internal.carbon.smallFonts";
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("osgi.instance.area", ofysDir + "/instance");
        env.put("osgi.configuration.area", ofysDir + config.configFileManager.configFileName);
        env.put("osgi.user.area", ofysDir + "/user");
        env.put("osgi.sharedConfiguration.area", ofysDir + "/shared");
        env.put("eclipse.ee.install.verify", "true");
        env.put("osgi.clean", "true");
        env.put("osgi.bundles", "org.eclipse.equinox.ds@1:start,org.eclipse.osgi.services@1:start,org.eclipse.osgi.util@1:start,org.apache.felix.scr@1:start,javax.ws.rs.jsr311-api@-1:start,com.sun.jersey.core@1:start,com.sun.jersey.client@1:start,com.sun.jersey.contribs.jersey-apache-client4@1:start,org.eclipse.equinox.common@2:start,org.eclipse.osgi@-1:start,org.eclipse.update.configurator@3:start,org.eclipse.core.runtime@start");
        env.put("eclipse.product", "ca.infodata.ofys.ui.intro.product");
        env.put("osgi.splashPath", "platform:/base/plugins/ca.infodata.ofys.ui.intro");
        config.ofysProperties.putAll((Map<?, ?>)env);
        ArrayList<String> classpath = new ArrayList<String>();
        String launcherJar = Util.findFileRecursive2(ofysDir, "org.eclipse.equinox.launcher_".toLowerCase());
        if (launcherJar == null) {
            classpath.add("Ofys/plugins/org.eclipse.equinox.launcher_1.4.0.v20161219-1356.jar");
        } else {
            classpath.add(launcherJar);
        }
        StringBuilder commandBuilder = new StringBuilder(1000);
        commandBuilder.append("java");
        commandBuilder.append(" ").append(options);
        if (Util.isJava9()) {
            commandBuilder.append(" --add-modules=ALL-SYSTEM");
        }
        for (Map.Entry<Object, Object> e : config.ofysProperties.entrySet()) {
            commandBuilder.append(" -D").append(e.getKey()).append("=\"").append(e.getValue()).append("\"");
        }
        commandBuilder.append(" -classpath \"");
        for (String cp : classpath) {
            if (cp == null || "null".equals(cp)) continue;
            commandBuilder.append(cp).append(";");
        }
        commandBuilder.deleteCharAt(commandBuilder.length() - 1);
        commandBuilder.append("\" ");
        String launcherClass = "org.eclipse.equinox.launcher.Main";
        commandBuilder.append(" ").append(launcherClass);
        commandBuilder.append(" -name Ofys");
        commandBuilder.append(" -persistState false");
        commandBuilder.append(" -clearPersistedState");
        commandBuilder.append(" -showsplash");
        String command = commandBuilder.toString();
        log.log(Level.INFO, "----- > LAUNCH OFYS WITH < ---------");
        log.log(Level.INFO, "applicationDir=" + ofysDir.getAbsolutePath());
        log.log(Level.INFO, "command=" + command);
        if (Util.isMac()) {
            if (OfysLauncher.haveCommand("-build-bat")) {
                File bat = new File(ofysDir, "/ofys.sh");
                Util.saveToFile(bat, command);
            }
            File file = File.createTempFile("launch", "sh");
            String script = "cd \"" + ofysDir.getAbsolutePath() + "\"\n" + command.toString() + "\n";
            Util.saveToFile(file, script);
            file.setExecutable(true);
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", file.getAbsolutePath()});
        } else {
            if (OfysLauncher.haveCommand("-build-bat")) {
                File bat = new File(ofysDir, "/ofys.bat");
                Util.saveToFile(bat, command);
            }
            Process proc = Runtime.getRuntime().exec(command, null, ofysDir);
        }
        log.log(Level.INFO, "----- > LAUNCH OFYS WITH < ---------");
    }

    public static void installOfys() throws Exception {
        Exception ex;
        block11: {
            final boolean isInstall = Config.getInstance().isOfysInstallThere(Config.getInstance().installFolder);
            OfysLauncher.checkAndFlagDownloading();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialog d = new DownloadProgressDialog();
                    if (!isInstall) {
                        d.setDialogTitleInstall();
                    }
                    monitor[0] = d;
                    d.getDialog().setLocationRelativeTo(null);
                    d.getDialog().setAlwaysOnTop(true);
                    d.getDialog().setVisible(true);
                }
            });
            ex = null;
            try {
                try {
                    List<Version> versions = Config.getInstance().getOfysRemoteVersions();
                    Version version = null;
                    if (Config.getInstance().updateOfysCommand) {
                        version = versions.get(versions.size() - 1);
                    } else {
                        String installedVersionName = Config.getInstance().readInstalledOfysDotVersion();
                        if (installedVersionName != null) {
                            for (Version version2 : versions) {
                                if (!installedVersionName.equals(version2.name)) continue;
                                version = version2;
                                break;
                            }
                        }
                        if (version == null) {
                            version = versions.get(versions.size() - 1);
                        }
                    }
                    Config.getInstance().installOfys(monitor[0], version);
                }
                catch (Exception e) {
                    ex = e;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            monitor[0].getDialog().dispose();
                        }
                    });
                    break block11;
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void checkAndFlagDownloading() throws Exception {
        Config config = Config.getInstance();
        File flagFile = new File(config.rootFolder, "installFlag.ofys");
        if (flagFile.exists()) {
            String contain = Util.readFile(flagFile);
            long flagTime = Long.parseLong(contain);
            long diff = System.currentTimeMillis() - flagTime;
            if (diff < 120000L) {
                log.log(Level.SEVERE, "Try to launch twice the install!");
                throw new PopupInformationException("Une autre instance du lanceur est d\u00e9j\u00e0 en train d'installer ou de mettre \u00e0 jour Ofys.");
            }
            Util.saveToFile(flagFile, "" + System.currentTimeMillis());
            flagFile.deleteOnExit();
        } else {
            Util.saveToFile(flagFile, "" + System.currentTimeMillis());
            flagFile.deleteOnExit();
        }
    }

    public static void installLauncher() throws Exception {
        Exception ex;
        block6: {
            log.log("-->Install launcher");
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialog d = new DownloadProgressDialog();
                    d.setDialogTitleInstall();
                    monitor[0] = d;
                    d.getDialog().setLocationRelativeTo(null);
                    d.getDialog().setAlwaysOnTop(true);
                    d.getDialog().setVisible(true);
                }
            });
            ex = null;
            try {
                try {
                    Config.getInstance().installLauncher(monitor[0]);
                }
                catch (Exception e) {
                    ex = e;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            monitor[0].getDialog().dispose();
                        }
                    });
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void downloadAndRelaunchLauncher() throws Exception {
        log.log("-- Will relauncher from somewhere else to be able to install launcher.");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DownloadProgressDialog d;
                monitor[0] = d = new DownloadProgressDialog();
                d.getDialog().setLocationRelativeTo(null);
                d.getDialog().setAlwaysOnTop(true);
                d.getDialog().setVisible(true);
            }
        });
        Exception ex = null;
        try {
            try {
                Config config = Config.getInstance();
                Version local = config.getLauncherInstalledVersion();
                Version localTemp = config.getLauncherTempInstalledVersion();
                Version remote = config.getLauncherRemoteVersion();
                if (new VersionDiff(local, remote).noDiff()) {
                    throw new QuietException("We are in process to download launcher for update and there is no file in launcherDiff.. Something gone wrong!");
                }
                log.log("Will relaunch from " + localTemp.root.getAbsolutePath());
                VersionDiff diff = new VersionDiff(localTemp, remote);
                diff.setDeleteAllDownloadAll();
                config.sync(diff, config.launcherSiteProvider, monitor[0]);
                File jar = Util.findFileRecursive(localTemp.root, "OfysLauncher.jar");
                if (jar == null) {
                    throw new QuietException("Unable to find OfysLauncher.jar file in root " + localTemp.root);
                }
                String cmd = "java -jar " + jar.getName() + " -wait -update-launcher";
                Runtime.getRuntime().exec(cmd, null, jar.getParentFile());
                throw new NotToSendException("Relaunching to update...");
            }
            catch (Exception e) {
                ex = e;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        monitor[0].getDialog().dispose();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        if (ex != null) {
            throw ex;
        }
    }

    private static boolean isInstallValid() throws Exception {
        return OfysLauncher.isInstallValid(false);
    }

    private static boolean isInstallValid(boolean throwErrorOnFalse) throws Exception {
        ArrayList<VersionDiff> diffs;
        block14: {
            Config config = Config.getInstance();
            Version installedVersion = config.getOfysInstalledVersion();
            List<Version> versions = config.getOfysRemoteVersions();
            diffs = new ArrayList<VersionDiff>();
            boolean valid = false;
            if (config.updateOfysCommand) {
                Version version = versions.get(versions.size() - 1);
                VersionDiff diff = new VersionDiff(installedVersion, version);
                diffs.add(diff);
                valid = diff.noDiff();
                if (valid) {
                    log.log("installed version found valid with " + version);
                } else {
                    log.log("installed version diff with " + diff);
                }
            } else {
                Iterator<Version> iterator = versions.iterator();
                while (!valid && iterator.hasNext()) {
                    Version version = iterator.next();
                    VersionDiff diff = new VersionDiff(installedVersion, version);
                    diffs.add(diff);
                    if (diff.noDiff()) {
                        valid = true;
                        log.log("installed version found valid with " + version);
                        continue;
                    }
                    log.log("installed version diff with " + diff);
                }
            }
            if (!valid) break block14;
            return true;
        }
        try {
            if (throwErrorOnFalse) {
                VersionDiff versionComparator = (VersionDiff)diffs.get(0);
                String files = "L'installation ou la mise-\u00e0-jour de Ofys a \u00e9chou\u00e9.\n\n\u00c0 supprimer (" + versionComparator.toDelete.size() + ":\n";
                for (Resource f : versionComparator.toDelete) {
                    files = String.valueOf(files) + "\t" + (f.getPath() == null ? "" : f.getPath()) + "\n";
                }
                files = String.valueOf(files) + "\u00c0 mettre \u00e0 t\u00e9l\u00e9charger (" + versionComparator.toDownload.size() + "):\n";
                for (Resource f : versionComparator.toDownload) {
                    files = String.valueOf(files) + "\t" + (f.getPath() == null ? "" : f.getPath()) + "\n";
                }
                log.log(Level.SEVERE, "Installation is still not valid after update/install ofys.\n" + files);
                throw new PopupInformationException(files);
            }
        }
        catch (NoMoreDownloadProdiderException e) {
            boolean mustContinue;
            boolean bl = mustContinue = JOptionPane.showOptionDialog(null, "Il est impossible de valider votre installation de Ofys.  Il se pourrait que vous ne soyez pas \u00e0 jour et que vous ayez rencontriez des erreurs.\nD\u00e9sirez vous quand m\u00eame lancer votre application?", "Probl\u00e8me de connectivit\u00e9", 0, 3, null, new Object[]{"Oui", "Non"}, "Non") == 0;
            if (mustContinue) {
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return false;
    }

    private static boolean isLauncherValid() throws Exception {
        Config config = Config.getInstance();
        try {
            Version local = config.getLauncherInstalledVersion();
            Version remote = config.getLauncherRemoteVersion();
            VersionDiff diff = new VersionDiff(local, remote);
            log.log("Diff is : " + diff);
            return diff.noDiff();
        }
        catch (NoMoreDownloadProdiderException e) {
            boolean mustContinue = true;
            if (mustContinue) {
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static boolean haveCommand(String command) {
        return config.getCommand(command) != null;
    }

    private static void findCommandAndExcute(String command) throws Exception {
        AbstractCommand c = config.getCommand(command);
        if (c != null) {
            log.log("Execute command '" + c + "'");
            c.execute();
        }
    }

    private static void startFrame() {
        frame = new JFrame("D\u00e9marrage d'Ofys...");
        frame.setUndecorated(true);
        ImageIcon icon2 = null;
        try {
            icon2 = new ImageIcon(ClassLoader.getSystemResource("ca/infodata/launcher3/ressources/logo.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        final ImageIcon icon = icon2;
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                if (icon != null) {
                    g.drawImage(icon.getImage(), 0, 0, null);
                }
                super.paintComponent(g);
            }
        };
        panel.setOpaque(false);
        Dimension sDm = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dDm = new Dimension(369, 186);
        int x = sDm.width / 2 - dDm.width / 2;
        int y = sDm.height / 2 - dDm.height / 2;
        frame.add(panel);
        frame.setBounds(x, y, dDm.width, dDm.height);
        frame.setVisible(true);
    }

    private static void checkVersion() throws Exception {
        boolean mustUpdateNow;
        try {
            mustUpdateNow = !OfysLauncher.isInstallValid();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error in checkVersion.mustUpdateNow check", e);
            mustUpdateNow = true;
        }
        boolean newVersionAvailable = false;
        System.out.println("VERSION_CHECK_START");
        System.out.println("newVersionAvailable=" + newVersionAvailable);
        System.out.println("mustUpdateNow=" + mustUpdateNow);
        System.out.println("VERSION_CHECK_END");
        throw new NotToSendException("Checked-Version");
    }
}

