/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.util;

import ca.infodata.launcher.util.ByteSerialiser;
import ca.infodata.launcher3.config.Config;
import ca.infodata.stats2.MedoLogApp;
import ca.infodata.stats2.client.WSClientMedoLogPut;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogHandler
extends Handler {
    private static final Logger logger = Logger.getLogger(LogHandler.class.getName());
    private static final int medoLogApplicationId = 9;
    private static final String medoLogApplicationPassword = "infodata";
    private static final int medoLogApplicationProvider = 1;
    private ArrayList<LogRecord> buffer;
    private WSClientMedoLogPut ws;
    private String medoStatsServerUrl;
    private boolean doLog = false;
    private boolean isClosed;
    private AtomicInteger logId;
    private static final String LINE_SEPARATOR = "\n";

    public LogHandler(String medoStatsServerUrl) {
        this.medoStatsServerUrl = medoStatsServerUrl;
        if (medoStatsServerUrl == null) {
            throw new NullPointerException("medoStatsServerUrl");
        }
        this.buffer = new ArrayList();
        this.ws = WSClientMedoLogPut.getInstance(medoStatsServerUrl);
        this.isClosed = false;
        this.logId = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SecurityException {
        this.ws = null;
        ArrayList<LogRecord> arrayList = this.buffer;
        synchronized (arrayList) {
            this.buffer.clear();
        }
        this.medoStatsServerUrl = null;
        this.isClosed = true;
    }

    @Override
    public void flush() {
        System.out.println("LogHandler.flush() START");
        try {
            this.doLog = false;
            this.sendLogsToWebService();
        }
        catch (Exception e) {
            this.doLog = true;
            e.printStackTrace();
        }
        this.doLog = true;
        System.out.println("LogHandler.flush() END");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            ArrayList<LogRecord> arrayList = this.buffer;
            synchronized (arrayList) {
                this.buffer.add(record);
            }
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (this.isClosed || !this.doLog || record == null) {
            return false;
        }
        String loggerName = record.getLoggerName();
        if (logger.getName().equals(loggerName)) {
            return false;
        }
        return super.isLoggable(record);
    }

    private void getWarningHeader(StringBuilder builder, ArrayList<LogRecord> log, ArrayList<Integer> wLogIds) {
        if (wLogIds.size() > 0) {
            builder.append("\n------------- " + wLogIds.size() + " warnings ---------------");
            for (Integer id : wLogIds) {
                builder.append("\n[" + id + "]\t");
                builder.append(log.get(id).getMessage());
            }
        }
    }

    private void getSevereHeader(StringBuilder builder, ArrayList<LogRecord> log, ArrayList<Integer> wLogIds) {
        if (wLogIds.size() > 0) {
            builder.append("\n------------- " + wLogIds.size() + " severes ---------------");
            for (Integer id : wLogIds) {
                builder.append("\n[" + id + "]\t");
                builder.append(log.get(id).getMessage());
            }
        }
    }

    private void addLogToSB(StringBuilder builder, LogRecord log, int id) {
        builder.append("\n[");
        builder.append(log.getLevel().getName().substring(0, 1).toUpperCase());
        builder.append(" " + id + "]\t");
        builder.append(log.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLogsToWebService() {
        block21: {
            ArrayList<LogRecord> logs;
            ArrayList<LogRecord> arrayList = this.buffer;
            synchronized (arrayList) {
                logs = new ArrayList<LogRecord>(this.buffer);
            }
            ArrayList<Integer> wLogIds = new ArrayList<Integer>();
            ArrayList<Integer> sLogIds = new ArrayList<Integer>();
            for (int i = 0; i < logs.size(); ++i) {
                LogRecord log = logs.get(i);
                if (log.getLevel().intValue() >= Level.SEVERE.intValue()) {
                    sLogIds.add(i);
                    continue;
                }
                if (log.getLevel().intValue() < Level.WARNING.intValue()) continue;
                wLogIds.add(i);
            }
            if (wLogIds.size() + sLogIds.size() == 0) {
                ArrayList<LogRecord> i = this.buffer;
                synchronized (i) {
                    this.buffer.clear();
                }
                return;
            }
            StringBuilder builder = new StringBuilder(2000);
            builder.append("THERE ARE " + sLogIds.size() + " SEVERES AND " + wLogIds.size() + " WARNINGS.\n\n");
            this.getSevereHeader(builder, logs, sLogIds);
            this.getWarningHeader(builder, logs, wLogIds);
            builder.append(LINE_SEPARATOR);
            builder.append("-----------------------------------------------------------------");
            builder.append(LINE_SEPARATOR);
            builder.append("-----------------------------------------------------------------");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            for (int i = 0; i < logs.size(); ++i) {
                LogRecord log = logs.get(i);
                this.addLogToSB(builder, log, i);
            }
            builder.append(LINE_SEPARATOR);
            builder.append("-----------------------------------------------------------------");
            builder.append(LINE_SEPARATOR);
            builder.append("-----------------------------------------------------------------");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append(LogHandler.getContext());
            String text = builder.toString();
            if (!logs.isEmpty()) {
                try {
                    int id = this.logId.addAndGet(1);
                    MedoLogApp mlog = new MedoLogApp();
                    mlog.setIdApplication(9);
                    mlog.setIdLevel(Level.SEVERE.intValue());
                    mlog.setId(id);
                    mlog.setIpPoste("unknown");
                    mlog.setLogDate(System.currentTimeMillis());
                    mlog.setLogTexte("[OFYS LAUNCHER] Log no : " + mlog.getId());
                    mlog.setNomPoste("unknown");
                    mlog.setNomUtilisateur(System.getProperty("user.name"));
                    mlog.setNumeroClient("unknown");
                    String version = "4.3 - ";
                    try {
                        version = version + Config.getInstance().ofysProperties.getProperty("launcher-version");
                    }
                    catch (Exception e) {
                        version = version + "?";
                    }
                    mlog.setVersionMedo(version);
                    mlog.setLogTextZip(ByteSerialiser.serialize(text));
                    try {
                        System.out.println("Sending log " + id);
                        Boolean result = this.ws.addMedoLogProvApp(1, medoLogApplicationPassword, mlog);
                        if (Boolean.TRUE.equals(result)) {
                            ArrayList<LogRecord> arrayList2 = this.buffer;
                            synchronized (arrayList2) {
                                this.buffer.clear();
                                break block21;
                            }
                        }
                        logger.log(Level.WARNING, "Failed to send log MedoStats server (" + this.medoStatsServerUrl + ") \n" + mlog.toString());
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Failed to send log MedoStats server (" + this.medoStatsServerUrl + ") \n" + mlog.toString(), e);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to convert logRecord to MedoLog : \n" + text, e);
                }
            }
        }
    }

    private static String getContext() {
        StringBuilder sb = new StringBuilder(1000);
        try {
            sb.append(LINE_SEPARATOR);
            sb.append("System.Properties");
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                sb.append(LINE_SEPARATOR).append(entry.getKey()).append(" = ").append(entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        try {
            sb.append(LINE_SEPARATOR);
            sb.append("System.Env");
            for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
                sb.append(LINE_SEPARATOR).append((String)entry.getKey()).append(" = ").append((String)entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void setBuffer(ArrayList<LogRecord> buffer) {
        this.buffer = new ArrayList<LogRecord>(buffer);
    }
}

