/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.stats2.client;

import ca.infodata.stats2.MedoLogApp;
import ca.infodata.stats2.client.ByteSerialiser;
import ca.infodata.stats2.client.MedoStatsLogFormatter;
import ca.infodata.stats2.client.WSClientMedoLogPut;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class MedoStatsLogHandler
extends Handler {
    private static final Logger logger = Logger.getLogger(MedoStatsLogHandler.class.getName());
    private String hostname = "";
    private String username = "";
    private String version = "";
    private String clientcode = "";
    private Integer provider_id = new Integer(1);
    private Integer application_id = new Integer(1);
    private String provider_pswd = "infodata";
    private String title = "";
    private boolean isClosed;
    private SimpleFormatter failsafeFormatter;
    private boolean doLog;
    private final WSClientMedoLogPut service;

    public MedoStatsLogHandler(String url) {
        if (url == null) {
            url = "http://www.infodata.ca/";
        }
        this.isClosed = false;
        this.service = WSClientMedoLogPut.getInstance(url);
        this.failsafeFormatter = new SimpleFormatter();
        this.setFormatter(new MedoStatsLogFormatter());
    }

    public MedoStatsLogHandler(String url, Integer provId, String provPwsd, Integer appId) {
        if (url == null) {
            url = "http://www.infodata.ca:8080/";
        }
        this.provider_id = provId;
        this.provider_pswd = provPwsd;
        this.application_id = appId;
        this.isClosed = false;
        this.service = WSClientMedoLogPut.getInstance(url);
        this.failsafeFormatter = new SimpleFormatter();
        this.setFormatter(new MedoStatsLogFormatter());
    }

    public void setTitle(String title) {
        this.title = title == null ? "" : title;
    }

    public void setClientcode(String clientcode) {
        this.clientcode = clientcode == null ? "" : clientcode;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname == null ? "" : hostname;
    }

    public void setUsername(String username) {
        this.username = username == null ? "" : username;
    }

    public void setVersion(String version) {
        this.version = version == null ? "" : version;
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isClosed && this.isLoggable(record)) {
            this.sendLogToWebService(record);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.isClosed = true;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (!this.doLog || record == null) {
            return false;
        }
        String loggerName = record.getLoggerName();
        if (loggerName.equals(logger.getName())) {
            return false;
        }
        return super.isLoggable(record);
    }

    private void sendLogToWebService(LogRecord log) {
        this.doLog = false;
        try {
            String text = this.getFormatter().format(log);
            MedoLogApp mlog = new MedoLogApp();
            mlog.setId(Long.valueOf(log.getSequenceNumber()).intValue());
            mlog.setIpPoste("no ip");
            mlog.setLogDate(log.getMillis());
            mlog.setLogTexte(this.title + "\n Log no : " + mlog.getId());
            mlog.setLogTextZip(ByteSerialiser.serialize(text));
            mlog.setNomPoste(this.hostname);
            mlog.setNomUtilisateur(this.username);
            mlog.setNumeroClient(this.clientcode);
            mlog.setVersionMedo(this.version);
            mlog.setIdApplication(this.application_id);
            mlog.setIdProvider(this.provider_id);
            try {
                logger.info("Sending log to MedoStats server. Log no : " + mlog.getId());
                Boolean result = this.service.addMedoLogProvApp(this.provider_id, this.provider_pswd, mlog);
                if (!Boolean.TRUE.equals(result)) {
                    logger.log(Level.SEVERE, "Failed to send log MedoStats server " + MedoStatsLogHandler.formatMedoLog(mlog) + ". Server returned " + result);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to send log MedoStats server " + MedoStatsLogHandler.formatMedoLog(mlog), e);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to convert logRecord to MedoLog : \n" + this.failsafeFormatter.format(log), e);
        }
        this.doLog = true;
    }

    private static String formatMedoLog(MedoLogApp log) {
        if (log == null) {
            return "null";
        }
        return String.format("MedoLog [id=%s, date=%s, ip=%s, host=%s, user=%s, client=%s, version=%s, text=%s, textZip=%s", log.getId(), log.getLogDate(), log.getIpPoste(), log.getNomPoste(), log.getNomUtilisateur(), log.getNumeroClient(), log.getVersionMedo(), log.getLogTexte(), ByteSerialiser.deserialize(log.getLogTextZip()));
    }
}

