/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.download;

import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.download.DownloadSite;
import ca.infodata.launcher3.download.Resource;
import ca.infodata.launcher3.download.ResourceDownload;
import ca.infodata.launcher3.download.STATUS;
import ca.infodata.launcher3.exception.NoMoreDownloadProdiderException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class MultiSiteResourceDownload
extends ResourceDownload {
    private ArrayList<DownloadSite> reference;
    private ArrayList<DownloadSite> sites;
    private static int currentSiteIndex = 0;

    public MultiSiteResourceDownload(List<DownloadSite> sites) {
        this.reference = new ArrayList<DownloadSite>(sites);
        this.sites = new ArrayList<DownloadSite>(sites);
    }

    public String downloadString(Resource resource) throws NoMoreDownloadProdiderException {
        this.reset();
        String data = null;
        DownloadSite site = this.getSite();
        while (data == null && site != null) {
            try {
                Object e = super.downloadString(site, resource);
                if (e instanceof String) {
                    data = (String)e;
                } else if (e == STATUS.CANCEL) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (data != null) continue;
            this.siteFailed();
            site = this.getSite();
        }
        if (data == null && site == null) {
            throw new NoMoreDownloadProdiderException("Impossible de lire le fichier " + resource.getPath() + ".  Aucun site de t\u00e9l\u00e9chargement ne r\u00e9pond.");
        }
        return data;
    }

    public File downloadFile(Resource resource) throws NoMoreDownloadProdiderException {
        this.reset();
        File data = null;
        DownloadSite site = this.getSite();
        while (data == null && site != null) {
            try {
                Object e = super.downloadFile(site, resource);
                if (e instanceof File) {
                    data = (File)e;
                } else if (e == STATUS.CANCEL) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (data != null) continue;
            this.siteFailed();
            site = this.getSite();
        }
        if (data == null && site == null) {
            throw new NoMoreDownloadProdiderException("Impossible de lire le fichier " + resource.getPath() + ".  Aucun site de t\u00e9l\u00e9chargement ne r\u00e9pond.");
        }
        return data;
    }

    private void reset() {
        this.sites.clear();
        this.sites.addAll(this.reference);
        for (DownloadSite site : this.sites) {
            site.reset();
        }
    }

    private DownloadSite getSite() {
        int size = this.sites.size();
        if (size == 0) {
            return null;
        }
        if (currentSiteIndex >= size) {
            currentSiteIndex = 0;
        }
        return this.sites.get(currentSiteIndex);
    }

    private void siteFailed() {
        DownloadSite site = this.getSite();
        if (site != null) {
            int failed = site.failed();
            LauncherLogger.getInstance(null).log(Level.WARNING, "Le site " + site.url.getPath() + " ne r\u00e9pond pas (" + failed + ").");
            if (site.giveUp()) {
                ++currentSiteIndex;
                LauncherLogger.getInstance(null).log(Level.WARNING, "Le site " + site.url.getPath() + " ne r\u00e9pond plus.");
            }
        }
    }
}

